/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="CustomResourceSubresourceScale defines how to serve the scale subresource for CustomResources.")
public class V1beta1CustomResourceSubresourceScale {
    @SerializedName(value="labelSelectorPath")
    private String labelSelectorPath = null;
    @SerializedName(value="specReplicasPath")
    private String specReplicasPath = null;
    @SerializedName(value="statusReplicasPath")
    private String statusReplicasPath = null;

    public V1beta1CustomResourceSubresourceScale labelSelectorPath(String labelSelectorPath) {
        this.labelSelectorPath = labelSelectorPath;
        return this;
    }

    @ApiModelProperty(value="LabelSelectorPath defines the JSON path inside of a CustomResource that corresponds to Scale.Status.Selector. Only JSON paths without the array notation are allowed. Must be a JSON Path under .status. Must be set to work with HPA. If there is no value under the given path in the CustomResource, the status label selector value in the /scale subresource will default to the empty string.")
    public String getLabelSelectorPath() {
        return this.labelSelectorPath;
    }

    public void setLabelSelectorPath(String labelSelectorPath) {
        this.labelSelectorPath = labelSelectorPath;
    }

    public V1beta1CustomResourceSubresourceScale specReplicasPath(String specReplicasPath) {
        this.specReplicasPath = specReplicasPath;
        return this;
    }

    @ApiModelProperty(required=true, value="SpecReplicasPath defines the JSON path inside of a CustomResource that corresponds to Scale.Spec.Replicas. Only JSON paths without the array notation are allowed. Must be a JSON Path under .spec. If there is no value under the given path in the CustomResource, the /scale subresource will return an error on GET.")
    public String getSpecReplicasPath() {
        return this.specReplicasPath;
    }

    public void setSpecReplicasPath(String specReplicasPath) {
        this.specReplicasPath = specReplicasPath;
    }

    public V1beta1CustomResourceSubresourceScale statusReplicasPath(String statusReplicasPath) {
        this.statusReplicasPath = statusReplicasPath;
        return this;
    }

    @ApiModelProperty(required=true, value="StatusReplicasPath defines the JSON path inside of a CustomResource that corresponds to Scale.Status.Replicas. Only JSON paths without the array notation are allowed. Must be a JSON Path under .status. If there is no value under the given path in the CustomResource, the status replica value in the /scale subresource will default to 0.")
    public String getStatusReplicasPath() {
        return this.statusReplicasPath;
    }

    public void setStatusReplicasPath(String statusReplicasPath) {
        this.statusReplicasPath = statusReplicasPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1CustomResourceSubresourceScale v1beta1CustomResourceSubresourceScale = (V1beta1CustomResourceSubresourceScale)o;
        return Objects.equals(this.labelSelectorPath, v1beta1CustomResourceSubresourceScale.labelSelectorPath) && Objects.equals(this.specReplicasPath, v1beta1CustomResourceSubresourceScale.specReplicasPath) && Objects.equals(this.statusReplicasPath, v1beta1CustomResourceSubresourceScale.statusReplicasPath);
    }

    public int hashCode() {
        return Objects.hash(this.labelSelectorPath, this.specReplicasPath, this.statusReplicasPath);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1CustomResourceSubresourceScale {\n");
        sb.append("    labelSelectorPath: ").append(this.toIndentedString(this.labelSelectorPath)).append("\n");
        sb.append("    specReplicasPath: ").append(this.toIndentedString(this.specReplicasPath)).append("\n");
        sb.append("    statusReplicasPath: ").append(this.toIndentedString(this.statusReplicasPath)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

