/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Subject contains a reference to the object or user identities a role binding applies to.  This can either hold a direct API object reference, or a value for non-objects such as user and group names.")
public class V1Subject {
    @SerializedName(value="apiGroup")
    private String apiGroup = null;
    @SerializedName(value="kind")
    private String kind = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="namespace")
    private String namespace = null;

    public V1Subject apiGroup(String apiGroup) {
        this.apiGroup = apiGroup;
        return this;
    }

    @ApiModelProperty(value="APIGroup holds the API group of the referenced subject. Defaults to \"\" for ServiceAccount subjects. Defaults to \"rbac.authorization.k8s.io\" for User and Group subjects.")
    public String getApiGroup() {
        return this.apiGroup;
    }

    public void setApiGroup(String apiGroup) {
        this.apiGroup = apiGroup;
    }

    public V1Subject kind(String kind) {
        this.kind = kind;
        return this;
    }

    @ApiModelProperty(required=true, value="Kind of object being referenced. Values defined by this API group are \"User\", \"Group\", and \"ServiceAccount\". If the Authorizer does not recognized the kind value, the Authorizer should report an error.")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1Subject name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the object being referenced.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1Subject namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @ApiModelProperty(value="Namespace of the referenced object.  If the object kind is non-namespace, such as \"User\" or \"Group\", and this value is not empty the Authorizer should report an error.")
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1Subject v1Subject = (V1Subject)o;
        return Objects.equals(this.apiGroup, v1Subject.apiGroup) && Objects.equals(this.kind, v1Subject.kind) && Objects.equals(this.name, v1Subject.name) && Objects.equals(this.namespace, v1Subject.namespace);
    }

    public int hashCode() {
        return Objects.hash(this.apiGroup, this.kind, this.name, this.namespace);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1Subject {\n");
        sb.append("    apiGroup: ").append(this.toIndentedString(this.apiGroup)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

