/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="ResourceAttributes includes the authorization attributes available for resource requests to the Authorizer interface")
public class V1ResourceAttributes {
    @SerializedName(value="group")
    private String group = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="namespace")
    private String namespace = null;
    @SerializedName(value="resource")
    private String resource = null;
    @SerializedName(value="subresource")
    private String subresource = null;
    @SerializedName(value="verb")
    private String verb = null;
    @SerializedName(value="version")
    private String version = null;

    public V1ResourceAttributes group(String group) {
        this.group = group;
        return this;
    }

    @ApiModelProperty(value="Group is the API Group of the Resource.  \"*\" means all.")
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public V1ResourceAttributes name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Name is the name of the resource being requested for a \"get\" or deleted for a \"delete\". \"\" (empty) means all.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1ResourceAttributes namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @ApiModelProperty(value="Namespace is the namespace of the action being requested.  Currently, there is no distinction between no namespace and all namespaces \"\" (empty) is defaulted for LocalSubjectAccessReviews \"\" (empty) is empty for cluster-scoped resources \"\" (empty) means \"all\" for namespace scoped resources from a SubjectAccessReview or SelfSubjectAccessReview")
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public V1ResourceAttributes resource(String resource) {
        this.resource = resource;
        return this;
    }

    @ApiModelProperty(value="Resource is one of the existing resource types.  \"*\" means all.")
    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public V1ResourceAttributes subresource(String subresource) {
        this.subresource = subresource;
        return this;
    }

    @ApiModelProperty(value="Subresource is one of the existing resource types.  \"\" means none.")
    public String getSubresource() {
        return this.subresource;
    }

    public void setSubresource(String subresource) {
        this.subresource = subresource;
    }

    public V1ResourceAttributes verb(String verb) {
        this.verb = verb;
        return this;
    }

    @ApiModelProperty(value="Verb is a kubernetes resource API verb, like: get, list, watch, create, update, delete, proxy.  \"*\" means all.")
    public String getVerb() {
        return this.verb;
    }

    public void setVerb(String verb) {
        this.verb = verb;
    }

    public V1ResourceAttributes version(String version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(value="Version is the API Version of the Resource.  \"*\" means all.")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ResourceAttributes v1ResourceAttributes = (V1ResourceAttributes)o;
        return Objects.equals(this.group, v1ResourceAttributes.group) && Objects.equals(this.name, v1ResourceAttributes.name) && Objects.equals(this.namespace, v1ResourceAttributes.namespace) && Objects.equals(this.resource, v1ResourceAttributes.resource) && Objects.equals(this.subresource, v1ResourceAttributes.subresource) && Objects.equals(this.verb, v1ResourceAttributes.verb) && Objects.equals(this.version, v1ResourceAttributes.version);
    }

    public int hashCode() {
        return Objects.hash(this.group, this.name, this.namespace, this.resource, this.subresource, this.verb, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ResourceAttributes {\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resource)).append("\n");
        sb.append("    subresource: ").append(this.toIndentedString(this.subresource)).append("\n");
        sb.append("    verb: ").append(this.toIndentedString(this.verb)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

