/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1APIResource;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="APIResourceList is a list of APIResource, it is used to expose the name of the resources supported in a specific group and version, and if the resource is namespaced.")
public class V1APIResourceList {
    @SerializedName(value="apiVersion")
    private String apiVersion = null;
    @SerializedName(value="groupVersion")
    private String groupVersion = null;
    @SerializedName(value="kind")
    private String kind = null;
    @SerializedName(value="resources")
    private List<V1APIResource> resources = new ArrayList<V1APIResource>();

    public V1APIResourceList apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1APIResourceList groupVersion(String groupVersion) {
        this.groupVersion = groupVersion;
        return this;
    }

    @ApiModelProperty(required=true, value="groupVersion is the group and version this APIResourceList is for.")
    public String getGroupVersion() {
        return this.groupVersion;
    }

    public void setGroupVersion(String groupVersion) {
        this.groupVersion = groupVersion;
    }

    public V1APIResourceList kind(String kind) {
        this.kind = kind;
        return this;
    }

    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1APIResourceList resources(List<V1APIResource> resources) {
        this.resources = resources;
        return this;
    }

    public V1APIResourceList addResourcesItem(V1APIResource resourcesItem) {
        this.resources.add(resourcesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="resources contains the name of the resources and if they are namespaced.")
    public List<V1APIResource> getResources() {
        return this.resources;
    }

    public void setResources(List<V1APIResource> resources) {
        this.resources = resources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1APIResourceList v1APIResourceList = (V1APIResourceList)o;
        return Objects.equals(this.apiVersion, v1APIResourceList.apiVersion) && Objects.equals(this.groupVersion, v1APIResourceList.groupVersion) && Objects.equals(this.kind, v1APIResourceList.kind) && Objects.equals(this.resources, v1APIResourceList.resources);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.groupVersion, this.kind, this.resources);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1APIResourceList {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    groupVersion: ").append(this.toIndentedString(this.groupVersion)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

