package com.hyphenate.chat.adapter;

public interface EMAThreadManagerListenerInterface {
    /**
     * \brief Thread 被修改的通知事件
     * @param event
     */
    void onThreadNameUpdated(EMAThreadInfo event);

    /**
     * \brief Callback user when user is kicked out from a Thread or the Thread is destroyed.
     * @param event
     * @param reason See {@link com.hyphenate.chat.adapter.EMAThreadInfo.LeaveReason}
     */
    void onLeaveThread(EMAThreadInfo event, int reason);

    /**
     * \brief Thread 加入新成员事件
     * @param event
     */
    void onMemberJoined(EMAThreadInfo event);

    /**
     * \brief Thread 成员主动退出事件
     * @param event
     */
    void onMemberExited(EMAThreadInfo event);

    /**
     * \brief Thread 变化通知
     * @param event
     */
    void onThreadNotifyChange(EMAThreadInfo event);
}
