package com.hyphenate.chat;

import com.hyphenate.chat.adapter.EMAMessageReactionOperation;

/**
 * \~chinese
 * 消息 Reaction 操作实体类，有如下属性：
 *
 *  userId：Reaction 操作者。
 *  reaction：发生变化的 Reaction。
 *  operation：操作消息 Reaction 的行为。详见 {@link Operation}。
 *
 * \~english
 * The message reaction operations entity class, which has the following attributes:
 *
 *  userId: The id of the user operating the Reaction
 *  reaction: The changed Reaction.
 *  operation: The behavior of the action message Reaction. See {@link Operation}.
 */
public class EMMessageReactionOperation extends EMBase<EMAMessageReactionOperation> {

    public EMMessageReactionOperation(EMAMessageReactionOperation operation) {
        emaObject = operation;
    }

    /**
     * \~chinese
     * 获取 Reaction 的操作者 ID。
     * @return 操作者 ID。
     *
     * \~english
     * Gets the Reaction Operator.
     * @return The reaction operator.
     */
    public String getUserId() {
        return emaObject.getUserId();
    }

    /**
     * \~chinese
     * 获取发生变化的 Reaction。
     * @return Reaction。
     *
     * \~english
     * Gets the changed Reaction.
     * @return The Reaction.
     */
    public String getReaction() {
        return emaObject.getReaction();
    }

    /**
     * \~chinese
     * 获取对 Reaction 的操作（{@link Operation})。
     * @return Reaction。
     *
     * \~english
     * Gets the Reaction Operation. See {@link Operation}.
     * @return The Reaction.
     */
    public Operation getOperation() {
        int operation = emaObject.getOperation();
        if(operation == 0) {
            return Operation.REMOVE;
        }
        return Operation.ADD;
    }

    /**
     * \~chinese
     * Reaction 的操作行为。
     *
     * \~english
     * Reaction operations.
     */
    public enum Operation {
        REMOVE, ADD
    }
}
