package com.hyphenate.chat;

/**
 * \~chinese
 * 创建群组时的属性配置。
 *
 * \~english
 * Group property options to be configured during group creation.
 */
public class EMGroupOptions {

    /**
     * \~chinese
     * 群组的最大成员数。
     *
     * \~english
     * The maximum number of members in a group.
     */
    public int maxUsers = 200;

    /**
     * \~chinese
     * 群组类型，参考 {@link com.hyphenate.chat.EMGroupManager.EMGroupStyle}。
     *
     * \~english
     * The group style. See {@link com.hyphenate.chat.EMGroupManager.EMGroupStyle}.
     */
    public EMGroupManager.EMGroupStyle style = EMGroupManager.EMGroupStyle.EMGroupStylePrivateOnlyOwnerInvite;

    /**
     * \~chinese
     * 邀请用户进群是否需要对方同意。
     *
     * 收到邀请是否自动入群取决于两个设置：创建群组时设置 inviteNeedConfirm 以及通过 {@link EMOptions#setAutoAcceptGroupInvitation(boolean)} 确定是否自动接受加群邀请。
     * 具体使用如下：
     * （1）如果 inviteNeedConfirm 设置为 'false'，在服务端直接加受邀人进群，
     * 与受邀人对 {@link EMOptions#setAutoAcceptGroupInvitation(boolean)} 的设置无关。
     * (2) 如果 inviteNeedConfirm 设置为 'true'，是否自动入群取决于被邀请人对 {@link EMOptions#setAutoAcceptGroupInvitation(boolean)} 的设置。
     * {@link EMOptions#setAutoAcceptGroupInvitation(boolean)} 为 SDK 级别操作，设置为 'true' 时，受邀人收到入群邀请后，SDK 在内部调用同意入群的 API，
     * 自动接受邀请入群；
     * 若设置为 'false'，即非自动同意其邀请，用户可以选择接受邀请进群，也可选择拒绝邀请。
     *
     * \~english
     * This option defines whether to ask for content when inviting a user to join a group.
     * Whether automatically acceting the invitation to join a group depends on two settings: inviteNeedConfirm, an option during group creation,
     * and {@link EMOptions#setAutoAcceptGroupInvitation(boolean)} which determines whether to automatically accept an invitation to join the group.
     * There are two cases:
     * (1) If inviteNeedConfirm is set to 'false', adds the invitee directly to the group on the server side 
     * regardless of the setting of {@link EMOptions#setAutoAcceptGroupInvitation(boolean)}.
     * 
     * (2) If inviteNeedConfirm is set to 'true', the user automatically joins a group or decides whether to join, depending on the setting of {@link EMOptions#setAutoAcceptGroupInvitation(boolean)}.
     * {@link EMOptions#setAutoAcceptGroupInvitation(boolean)} is an SDK-level operation. If it is set to true,
     * SDK calls the API for agreeing to join the group to automatically accept the joining invitation.
     * If inviteNeedConfirm is set to false, SDK does not automatically accept its invitation,
     * but the user decides to accept or reject the invitation.
     */
    public boolean inviteNeedConfirm = false;

    /**
     * \~chinese
     * 群组详情扩展，可以采用 JSON 格式，以包含更多群信息。
     *
     * \~english
     * Group detail extensions which can be in the JSON format to contain more group information.
     */
    public String extField;
}