/************************************************************
  *  * EaseMob CONFIDENTIAL 
  * __________________ 
  * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
  *  
  * NOTICE: All information contained herein is, and remains 
  * the property of EaseMob Technologies.
  * Dissemination of this information or reproduction of this material 
  * is strictly forbidden unless prior written permission is obtained
  * from EaseMob Technologies.
  */
package com.hyphenate.chat;

import java.io.Serializable;

/**
 * \~chinese
 * 群组的基本信息, 用于获取公开群的列表。
 * @see EMGroupManager#getPublicGroupsFromServer(int, String)
 *
 * \~english
 * The basic group information, which is used when getting the public group list.
 * @see EMGroupManager#getPublicGroupsFromServer(int, String)
 */
public class EMGroupInfo implements Serializable{

	private static final long serialVersionUID = -2004486389398310700L;
	private String groupId;
	private String groupName;
	
	/**
	 * \~chinese
	 * 构造函数。
	 * @param groupId	群组 ID。
	 * @param groupName	群组名称。
	 *
	 * \~english
	 * The constructor of EMGroupInfo.

	 * @param groupId	The group ID.
	 * @param groupName	The group name.
	 */
	public EMGroupInfo(String groupId, String groupName) {
		this.groupId = groupId;
		this.groupName = groupName;
	}

	/**
	 * \~chinese
	 * 获取群组 ID。
	 * @return 群组 ID。
	 *
	 * \~english
	 * Gets the group ID.
	 * @return  The group ID.
	 */
	public String getGroupId() {
		return groupId;
	}

	/**
	 * \~chinese
	 * 设置群组 ID。
	 * @param groupId 群组 ID。
	 *
	 * \~english
	 * Sets the group ID.
	 * @param groupId  The group ID.
	 */
	public void setGroupId(String groupId) {
		this.groupId = groupId;
	}

	/**
	 * \~chinese
	 * 获取群组名称。
	 * @return 群组名称。
	 *
	 * \~english
	 * Gets the group name.
	 * @return  The group name.
	 */
	public String getGroupName() {
		return groupName;
	}

	/**
	 * \~chinese
	 * 设置群组名称。
	 * @param groupName 群组名称。
	 *
	 * \~english
	 * Sets the group name.
	 * @param groupName  The group name.
	 */
	public void setGroupName(String groupName) {
		this.groupName = groupName;
	}
	
	@Override
	public String toString() {
		return groupName;
	}
}
