/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate;

import com.hyphenate.chat.EMLoginExtensionInfo;

/**
 * \~chinese
 * 即时通讯状态连接监听器。
 * 
 * 如果遇到弱网掉线情况，应用收到 onDisconnected，此时不需要处理重连操作，SDK 在底层自动处理重连。
 * 
 * 回调函数只有 onConnected 和 onDisconnected 无需考虑连接中，断开中一类的中间状态。
 * 
 * 注意：应用不要在这两个回调函数中更新界面，这两个线程属于工作线程，直接更新界面会导致界面的并发错误。也不要在这两个回调函数中
 * 做大量的耗时操作，这可能会影响其他监听器处理连接事件。
 *
 * 示例代码如下：
 *     注册连接监听器：
 *     ```java
 *     EMClient.getInstance().addConnectionListener(mConnectionListener);
 *     ```
 * 
 *     移除连接监听器：
 *     ```java
 *     EMClient.getInstance().removeConnectionListener(mConnectionListener);
 *     ```
 * 
 * \~english
 * The chat connection listener.
 * 
 * Under unstable network conditions, the app receives the onDisconnected callback. In this case, you don't need to reconnect manually as the chat SDK will handle it automatically.
 * 
 * There are two callback methods for connection: onConnected, onDisconnected.
 * 
 * Note: We recommend you not to update the UI based on the two methods, because they are called on the worker thread. If you update the UI in the methods, other UI errors might occur.
 * Also remember not to make the two methods do a lot of time-consuming work, which might invoke other listeners to handle this connection event.
 *
 *     Adds a connection listener:
 *     ```java
 *     EMClient.getInstance().addConnectionListener(mConnectionListener);
 *     ```
 * 
 *     Removes a connection listener:
 *     ```java
 *     EMClient.getInstance().removeConnectionListener(mConnectionListener);
 *     ```
 *
 */
public interface EMConnectionListener {
    /**
     * \~chinese
     * 成功连接到 chat 服务器时触发。
     *
     * \~english
     * Occurs when the SDK connects to the chat server successfully.
     */
    void onConnected();

    /**
     * \~chinese
     * SDK 与 chat 服务器断开连接时触发。
     * 
     * 注意断开连接时底层不一定会 logout。
     * 
     * 常见错误如下：
     * 
     * {@link EMError#USER_REMOVED}，{@link EMError#USER_LOGIN_ANOTHER_DEVICE}，
     * {@link EMError#SERVER_SERVICE_RESTRICTED}，{@link EMError#USER_KICKED_BY_CHANGE_PASSWORD}及
     * {@link EMError#USER_KICKED_BY_OTHER_DEVICE}
     *
     * \~english
     * Occurs when the SDK disconnects from the chat server.
     * 
     * Note that the logout may not be performed at the bottom level when the SDK is disconnected.
     * 
     * Common errors are as follows: 
     * {@link EMError#USER_REMOVED},{@link EMError#USER_LOGIN_ANOTHER_DEVICE},
     * {@link EMError#SERVER_SERVICE_RESTRICTED},{@link EMError#USER_KICKED_BY_CHANGE_PASSWORD} and
     * {@link EMError#USER_KICKED_BY_OTHER_DEVICE}
     */
    void onDisconnected(final int errorCode);

    /**
     * \~chinese
     * token 已过期时触发。
     * 
     * 常见错误为 {@link EMError#TOKEN_EXPIRED}。
     *
     * \~english
     * Occurs when the token has expired.
     * 
     * The common error is {@link EMError#TOKEN_EXPIRED}.
     */

    default void onTokenExpired(){}

    /**
     * \~chinese
     * token 即将过期时触发。
     * 
     * 常见错误为 {@link EMError#TOKEN_WILL_EXPIRE}。
     *
     * \~english
     * Occurs when the token is about to expire.
     * 
     * The common error is {@link EMError#TOKEN_WILL_EXPIRE}.
     */
    default void onTokenWillExpire(){}

    /**
     *\~chinese
     * SDK 退出登录时触发。
     * 
     * 常见错误如下：
     * 
     * {@link EMError#USER_LOGIN_ANOTHER_DEVICE}，{@link EMError#USER_REMOVED}，
     * {@link EMError#USER_BIND_ANOTHER_DEVICE}，{@link EMError#SERVER_SERVICE_RESTRICTED}，
     * {@link EMError#USER_LOGIN_TOO_MANY_DEVICES}，{@link EMError#USER_KICKED_BY_CHANGE_PASSWORD}，
     * {@link EMError#USER_KICKED_BY_OTHER_DEVICE}
     *
     * @deprecated 使用 {@link EMConnectionListener#onLogout(int, String)} 替代。
     *
     * \~english
     * Occurs when the UNDERLYING SDK logs out.
     * 
     * Common errors are as follows:
     * 
     * {@link EMError#USER_LOGIN_ANOTHER_DEVICE}，{@link EMError#USER_REMOVED}，
     * {@link EMError#USER_BIND_ANOTHER_DEVICE}，{@link EMError#SERVER_SERVICE_RESTRICTED}，
     * {@link EMError#USER_LOGIN_TOO_MANY_DEVICES}，{@link EMError#USER_KICKED_BY_CHANGE_PASSWORD}，
     * {@link EMError#USER_KICKED_BY_OTHER_DEVICE}
     * @param errorCode
     *
     * @deprecated use {@link EMConnectionListener#onLogout(int, String)} instead。
     */
    @Deprecated
    default void onLogout(final int errorCode){}
    /**
     *\~chinese
     * SDK 退出登录时触发。
     *
     * @param errorCode 错误码。
     * 
     * 常见错误如下：
     * 
     * {@link EMError#USER_LOGIN_ANOTHER_DEVICE}，{@link EMError#USER_REMOVED}，
     * {@link EMError#USER_BIND_ANOTHER_DEVICE}，{@link EMError#SERVER_SERVICE_RESTRICTED}，{@link EMError#USER_DEVICE_CHANGED}，
     * {@link EMError#USER_LOGIN_TOO_MANY_DEVICES}，{@link EMError#USER_KICKED_BY_CHANGE_PASSWORD}，
     * {@link EMError#USER_KICKED_BY_OTHER_DEVICE}，{@link EMError#APP_ACTIVE_NUMBER_REACH_LIMITATION}
     *
     * @param info 错误扩展信息。
     * 
     * 当 errorCode 为 {@link EMError#USER_LOGIN_ANOTHER_DEVICE} 时，info 是将当前设备踢出/挤下线的自定义设备名称，若设备没有自定义设备名称时默认回调设备型号，例如 HUAWEICOL-AL10。其他错误码场景下 info 为空。
     *
     *
     * \~english
     * Occurs when the UNDERLYING SDK logs out.
     *
     * @param errorCode The error code.
     * 
     * Common errors are as follows:
     * 
     * {@link EMError#USER_LOGIN_ANOTHER_DEVICE}，{@link EMError#USER_REMOVED}，
     * {@link EMError#USER_BIND_ANOTHER_DEVICE}，{@link EMError#SERVER_SERVICE_RESTRICTED}，
     * {@link EMError#USER_LOGIN_TOO_MANY_DEVICES}，{@link EMError#USER_KICKED_BY_CHANGE_PASSWORD}，
     * {@link EMError#USER_KICKED_BY_OTHER_DEVICE}
     *
     * @param info The error extension information.
     *  
     * If `errorCode` is {@link EMError#USER_LOGIN_ANOTHER_DEVICE}, `info` is the user-defined name of the device that kicks the current device offline.
     * If the device does not have a custom name, the device model is indicated in the callback by default. In the case of other errors, `info` is empty.
     */
    @Deprecated
    default void onLogout(final int errorCode,String info){
        onLogout(errorCode);
    }

    /**
     *\~chinese
     * SDK 退出登录时触发。
     *
     * 常见错误如下：
     *
     * {@link EMError#USER_LOGIN_ANOTHER_DEVICE}，{@link EMError#USER_REMOVED}，
     * {@link EMError#USER_BIND_ANOTHER_DEVICE}，{@link EMError#SERVER_SERVICE_RESTRICTED}，{@link EMError#USER_DEVICE_CHANGED}，
     * {@link EMError#USER_LOGIN_TOO_MANY_DEVICES}，{@link EMError#USER_KICKED_BY_CHANGE_PASSWORD}，
     * {@link EMError#USER_KICKED_BY_OTHER_DEVICE}，{@link EMError#APP_ACTIVE_NUMBER_REACH_LIMITATION}
     *
     * @param info 登录扩展信息对象，包含 info.deviceExt 和 info.deviceInfo 参数。
     * 
     * 当 errorCode 为 {@link EMError#USER_LOGIN_ANOTHER_DEVICE} 时：
     * - info.deviceExt 是将当前设备踢下线的新设备的扩展信息。其他错误码场景下，info.deviceExt 为空。    
     * - info.deviceInfo 是将当前设备踢下线的自定义设备名称。若设备没有自定义设备名称时默认回调设备型号，例如 HUAWEICOL-AL10。其他错误码场景下 deviceInfo 为空。
     * 
     * @param errorCode 错误码。
     *
     * 
     *
     *
     * \~english
     * Occurs when the UNDERLYING SDK logs out.
     *
     * Common errors are as follows:
     *
     * {@link EMError#USER_LOGIN_ANOTHER_DEVICE}，{@link EMError#USER_REMOVED}，
     * {@link EMError#USER_BIND_ANOTHER_DEVICE}，{@link EMError#SERVER_SERVICE_RESTRICTED}，
     * {@link EMError#USER_LOGIN_TOO_MANY_DEVICES}，{@link EMError#USER_KICKED_BY_CHANGE_PASSWORD}，
     * {@link EMError#USER_KICKED_BY_OTHER_DEVICE}
     *
     * @param info The login extension information Object that contains two parameters: info.deviceExt and info.deviceInfo.
     * 
     * If `errorCode` is {@link EMError#USER_LOGIN_ANOTHER_DEVICE}:
     * - info.deviceExt: The custom extension information of the device that kicks the current device offline. In other scenarios, info.deviceExt is empty.
     * - info.deviceInfo: The user-defined name of the device that kicks the current device offline.
     * If the device does not have a custom name, the device model is indicated in the callback by default. In the case of other errors, `deviceInfo` is empty.
     * 
     * @param errorCode The error code.
     *
     
     */
    default void onLogout(final int errorCode,EMLoginExtensionInfo info){
        onLogout(errorCode,info.getDeviceInfo());
    }
    /**
     * \~chinese
     * 开始从服务器拉取离线消息时触发。
     *
     * \~english
     * Occurs when the SDK starts pulling offline messages from the server.
     *
     */
    default void onOfflineMessageSyncStart(){}

    /**
     * \~chinese
     * 从服务器拉取离线消息结束时触发。
     *
     * \~english
     *  Occurs when the SDK finishes pulling offline messages from the server.
     */
    default void onOfflineMessageSyncFinish(){}

}