/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMContact;
import com.hyphenate.chat.adapter.EMAConnectionListener;
import com.hyphenate.chat.adapter.EMAREncryptUtils;
import com.hyphenate.chat.adapter.EMASessionManager;
import com.hyphenate.util.DeviceUuidFactory;
import com.hyphenate.util.EMLog;
import java.util.Timer;
import java.util.TimerTask;

class EMSessionManager {
    private static final String TAG = "Session";
    private static final String PREF_KEY_LOGIN_USER = "easemob.chat.loginuser";
    private static final String PREF_KEY_LOGIN_PWD = "easemob.chat.loginpwd";
    private static final String PREF_KEY_LOGIN_TOKEN = "easemob.chat.login.token";
    private static final String PREF_KEY_LOGIN_WITH_TOKEN = "easemob.chat.login_with_token";
    private static final String PREF_KEY_LOGIN_PWD_GCM = "easemob.chat.loginpwd.gcm";
    private static final String PREF_KEY_LOGIN_TOKEN_GCM = "easemob.chat.login.token.gcm";
    private static final String PREF_KEY_TOKEN_TIMESTAMP = "easemob.chat.token_timestamp";
    private static final String PREF_KEY_TOKEN_AVAILABLE_PERIOD = "easemob.chat.token_available_period";
    private static EMSessionManager instance = new EMSessionManager();
    private Context appContext = null;
    public EMContact currentUser = null;
    private String lastLoginUser = null;
    private String lastLoginPwd = null;
    private String lastLoginToken = null;
    private String tokenTimeStamp = null;
    private long tokenAvailablePeriod = 0L;
    private Timer timer;
    EMClient mClient;
    EMASessionManager mSessionManager;
    private EMAREncryptUtils encryptUtils;

    EMSessionManager() {
    }

    static synchronized EMSessionManager getInstance() {
        EMSessionManager eMSessionManager = instance;
        if (eMSessionManager.appContext == null) {
            eMSessionManager.appContext = EMClient.getInstance().getContext();
        }
        return instance;
    }

    /*
     * WARNING - void declaration
     */
    void init(EMClient client, EMASessionManager sessionManager) {
        EMAREncryptUtils eMAREncryptUtils;
        void var2_2;
        void var1_1;
        EMSessionManager eMSessionManager = this_;
        eMSessionManager.mClient = var1_1;
        eMSessionManager.mSessionManager = var2_2;
        EMAREncryptUtils this_ = eMAREncryptUtils;
        eMAREncryptUtils = new EMAREncryptUtils();
        eMSessionManager.encryptUtils = this_;
    }

    String getLastLoginUser() {
        if (this.lastLoginUser == null) {
            this.lastLoginUser = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext).getString(PREF_KEY_LOGIN_USER, "");
            this.currentUser = new EMContact(this.lastLoginUser);
        }
        return this.lastLoginUser;
    }

    /*
     * WARNING - void declaration
     */
    void setLastLoginUser(String username) {
        void var1_1;
        if (username == null) {
            return;
        }
        this.currentUser = new EMContact((String)var1_1);
        this.lastLoginUser = var1_1;
        SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext).edit();
        editor.putString(PREF_KEY_LOGIN_USER, (String)var1_1);
        editor.commit();
    }

    String getLastLoginPwd() {
        if (this.lastLoginPwd == null) {
            Object object = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
            String string = object.getString(PREF_KEY_LOGIN_PWD_GCM, "");
            if (TextUtils.isEmpty((CharSequence)string)) {
                if (TextUtils.isEmpty((CharSequence)(object = object.getString(PREF_KEY_LOGIN_PWD, "")))) {
                    this.lastLoginPwd = "";
                    return "";
                }
                try {
                    this.lastLoginPwd = this.mSessionManager.decrypt((String)object);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return this.lastLoginPwd;
            }
            try {
                EMSessionManager eMSessionManager = this;
                eMSessionManager.lastLoginPwd = eMSessionManager.decryptData(eMSessionManager.getSecretKey(false), string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.lastLoginPwd;
    }

    /*
     * WARNING - void declaration
     */
    void setLastLoginPwd(String pwd) {
        void var1_1;
        if (pwd == null) {
            return;
        }
        this.lastLoginPwd = var1_1;
        SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext).edit();
        SharedPreferences.Editor editor2 = editor;
        EMSessionManager eMSessionManager = this;
        editor.putString(PREF_KEY_LOGIN_PWD_GCM, eMSessionManager.encryptData(eMSessionManager.getSecretKey(true), (String)var1_1));
        try {
            editor2.commit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    String getLastLoginToken() {
        if (this.lastLoginToken == null) {
            Object object = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
            String string = object.getString(PREF_KEY_LOGIN_TOKEN_GCM, "");
            if (TextUtils.isEmpty((CharSequence)string)) {
                if (TextUtils.isEmpty((CharSequence)(object = object.getString(PREF_KEY_LOGIN_TOKEN, "")))) {
                    this.lastLoginToken = "";
                    return "";
                }
                try {
                    this.lastLoginToken = this.mSessionManager.decrypt((String)object);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return this.lastLoginToken;
            }
            try {
                EMSessionManager eMSessionManager = this;
                eMSessionManager.lastLoginToken = eMSessionManager.decryptData(eMSessionManager.getSecretKey(false), string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.lastLoginToken;
    }

    /*
     * WARNING - void declaration
     */
    void setLastLoginToken(String token) {
        void var1_1;
        if (token == null) {
            return;
        }
        this.lastLoginToken = var1_1;
        SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext).edit();
        SharedPreferences.Editor editor2 = editor;
        EMSessionManager eMSessionManager = this;
        editor.putString(PREF_KEY_LOGIN_TOKEN_GCM, eMSessionManager.encryptData(eMSessionManager.getSecretKey(true), (String)var1_1));
        try {
            editor2.commit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void clearLastLoginUser() {
        EMSessionManager eMSessionManager = this_;
        eMSessionManager.lastLoginUser = "";
        EMContact eMContact = eMSessionManager.currentUser;
        eMContact.username = "";
        eMContact.remark = "";
        SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences((Context)eMSessionManager.appContext).edit();
        SharedPreferences.Editor editor2 = editor;
        SharedPreferences.Editor editor3 = editor;
        EMSessionManager eMSessionManager2 = this_;
        String this_ = PREF_KEY_LOGIN_USER;
        editor2.putString(this_, eMSessionManager2.lastLoginUser);
        try {
            editor3.commit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void clearLastLoginPwd() {
        ((EMSessionManager)this_).lastLoginPwd = "";
        SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences((Context)((EMSessionManager)this_).appContext).edit();
        SharedPreferences.Editor editor2 = editor;
        EMSessionManager eMSessionManager = this_;
        EMSessionManager eMSessionManager2 = this_;
        Object this_ = PREF_KEY_LOGIN_PWD;
        editor2.putString((String)this_, eMSessionManager2.lastLoginPwd);
        this_ = PREF_KEY_LOGIN_PWD_GCM;
        editor.putString((String)this_, eMSessionManager.lastLoginPwd);
        try {
            editor.commit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void clearLastLoginToken() {
        ((EMSessionManager)this_).lastLoginToken = "";
        SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences((Context)((EMSessionManager)this_).appContext).edit();
        SharedPreferences.Editor editor2 = editor;
        EMSessionManager eMSessionManager = this_;
        EMSessionManager eMSessionManager2 = this_;
        Object this_ = PREF_KEY_LOGIN_TOKEN;
        editor2.putString((String)this_, eMSessionManager2.lastLoginToken);
        this_ = PREF_KEY_LOGIN_TOKEN_GCM;
        editor.putString((String)this_, eMSessionManager.lastLoginToken);
        try {
            editor.commit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    boolean isLastLoginWithToken() {
        return PreferenceManager.getDefaultSharedPreferences((Context)this.appContext).getBoolean(PREF_KEY_LOGIN_WITH_TOKEN, false);
    }

    /*
     * WARNING - void declaration
     */
    void setLastLoginWithToken(boolean loginWithToken) {
        void var1_1;
        SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext).edit();
        editor.putBoolean(PREF_KEY_LOGIN_WITH_TOKEN, (boolean)var1_1);
        editor.commit();
    }

    public String getLoginUserName() {
        return this.currentUser.username;
    }

    /*
     * WARNING - void declaration
     */
    synchronized String encryptData(byte[] key, String data) {
        void var2_2;
        void var1_1;
        EMSessionManager eMSessionManager = this;
        eMSessionManager.encryptUtils.initAESgcm((byte[])var1_1);
        return eMSessionManager.encryptUtils.aesGcmEncrypt((String)var2_2, 1);
    }

    /*
     * WARNING - void declaration
     */
    String decryptData(byte[] key, String encryptData) {
        void var1_1;
        void var2_2;
        return this.encryptUtils.aesGcmDecrypt((String)var2_2, (byte[])var1_1, 1);
    }

    String getTokenTimeStamp() {
        if (this.tokenTimeStamp == null) {
            this.tokenTimeStamp = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext).getString(PREF_KEY_TOKEN_TIMESTAMP, "");
        }
        return this.tokenTimeStamp;
    }

    /*
     * WARNING - void declaration
     */
    void setLoginWithTokenData(boolean isLoginWithToken, String timeStamp, long period) {
        void var2_3;
        void var3_4;
        block7: {
            void var1_1;
            if (timeStamp == null || var3_4 < 0L) break block7;
            ((EMSessionManager)((Object)string)).tokenTimeStamp = var2_3;
            ((EMSessionManager)((Object)string)).tokenAvailablePeriod = var3_4;
            SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences((Context)((EMSessionManager)((Object)string)).appContext).edit();
            EMSessionManager eMSessionManager = string;
            SharedPreferences.Editor editor2 = editor;
            editor.putBoolean(PREF_KEY_LOGIN_WITH_TOKEN, (boolean)var1_1);
            editor2.putString(PREF_KEY_TOKEN_TIMESTAMP, (String)var2_3);
            String string = PREF_KEY_TOKEN_AVAILABLE_PERIOD;
            long l = eMSessionManager.tokenAvailablePeriod;
            editor.putLong(string, l);
            try {
                editor.commit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        }
        EMLog.e(TAG, "setLoginWithTokenData, timeStamp =" + (String)var2_3 + ", period=" + (long)var3_4);
    }

    long getTokenAvailablePeriod() {
        if (this.tokenAvailablePeriod == 0L) {
            this.tokenAvailablePeriod = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext).getLong(PREF_KEY_TOKEN_AVAILABLE_PERIOD, 0L);
        }
        return this.tokenAvailablePeriod;
    }

    /*
     * WARNING - void declaration
     */
    synchronized void checkTokenAvailability(EMAConnectionListener connectionListener) {
        void var1_1;
        String string = this.getTokenTimeStamp();
        if (!TextUtils.isEmpty((CharSequence)string) && var1_1 != null) {
            long l = Long.valueOf(string) - System.currentTimeMillis();
            EMLog.d(TAG, "checkTokenAvailability, delay=" + l);
            if (l <= 0L) {
                var1_1.onTokenNotification(108);
            } else if (l <= this.getTokenAvailablePeriod() * 20L / 100L) {
                var1_1.onTokenNotification(109);
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    synchronized void startCountDownTokenAvailableTime(EMAConnectionListener connectionListener) {
        void var1_1;
        Object object = this.getTokenTimeStamp();
        if (!TextUtils.isEmpty((CharSequence)object) && var1_1 != null) {
            TimerTask timerTask;
            EMSessionManager eMSessionManager = this;
            long l = eMSessionManager.getTokenAvailablePeriod();
            Timer timer = eMSessionManager.timer;
            if (timer != null) {
                timer.cancel();
            }
            String string = object;
            this.timer = new Timer();
            object = timerTask;
            timerTask = new TimerTask(this, (EMAConnectionListener)var1_1){
                final /* synthetic */ EMAConnectionListener val$connectionListener;
                final /* synthetic */ EMSessionManager this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$connectionListener = eMAConnectionListener;
                }

                @Override
                public void run() {
                    this.this$0.checkTokenAvailability(this.val$connectionListener);
                }
            };
            long l2 = Long.valueOf(string) - System.currentTimeMillis();
            if (l2 <= 0L) {
                var1_1.onTokenNotification(108);
            } else if (l2 <= (l = l * 20L / 100L)) {
                EMLog.d(TAG, "timer.schedule task1, delay=" + l2);
                this.timer.schedule((TimerTask)object, l2);
                var1_1.onTokenNotification(109);
            } else {
                TimerTask timerTask2;
                EMSessionManager eMSessionManager2 = this;
                EMLog.d(TAG, "timer.schedule task1\u3001task2, delay= " + l2);
                TimerTask timerTask3 = timerTask2;
                timerTask2 = new TimerTask(this, (EMAConnectionListener)var1_1){
                    final /* synthetic */ EMAConnectionListener val$connectionListener;
                    final /* synthetic */ EMSessionManager this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$connectionListener = eMAConnectionListener;
                    }

                    @Override
                    public void run() {
                        this.this$0.checkTokenAvailability(this.val$connectionListener);
                    }
                };
                eMSessionManager2.timer.schedule((TimerTask)object, l2);
                eMSessionManager2.timer.schedule(timerTask3, l2 - l);
            }
            return;
        }
    }

    void clearLoginWithTokenData() {
        block11: {
            EMSessionManager eMSessionManager = this_;
            EMSessionManager eMSessionManager2 = eMSessionManager;
            eMSessionManager.tokenAvailablePeriod = 0L;
            eMSessionManager.tokenTimeStamp = "";
            SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences((Context)eMSessionManager.appContext).edit();
            SharedPreferences.Editor editor2 = editor;
            EMSessionManager eMSessionManager3 = this_;
            EMSessionManager eMSessionManager4 = this_;
            Object this_ = PREF_KEY_TOKEN_AVAILABLE_PERIOD;
            long l = eMSessionManager4.tokenAvailablePeriod;
            editor2.putLong((String)this_, l);
            this_ = PREF_KEY_TOKEN_TIMESTAMP;
            editor.putString((String)this_, eMSessionManager3.tokenTimeStamp);
            editor.putBoolean(PREF_KEY_LOGIN_WITH_TOKEN, false);
            editor.commit();
            this_ = eMSessionManager2.timer;
            if (this_ == null) break block11;
            try {
                ((Timer)this_).cancel();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    byte[] getSecretKey(boolean replace) {
        void var1_1;
        EMSessionManager eMSessionManager = this_;
        String this_ = eMSessionManager.getDeviceId((boolean)var1_1);
        String string = eMSessionManager.getLastLoginUser();
        return eMSessionManager.mSessionManager.getEncryptionKey(string, this_);
    }

    String getDeviceId(boolean replace) {
        String string = new DeviceUuidFactory(((EMSessionManager)((Object)string2)).appContext).getDeviceUuid().toString();
        if (replace) {
            ((EMSessionManager)((Object)string2)).saveDeviceId(string);
        } else {
            String string2 = DeviceUuidFactory.getBakDeviceId(((EMSessionManager)((Object)string2)).appContext);
            if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.equals((CharSequence)string, (CharSequence)string2)) {
                return string2;
            }
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    void saveDeviceId(String deviceId) {
        void var1_1;
        DeviceUuidFactory.saveBakDeviceId(this.appContext, (String)var1_1);
    }
}

