/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.http.X509TrustManagerExtensions;
import android.os.Build;
import android.os.Bundle;
import android.os.PowerManager;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.hyphenate.EMCallBack;
import com.hyphenate.EMConnectionListener;
import com.hyphenate.EMLogListener;
import com.hyphenate.EMMultiDeviceListener;
import com.hyphenate.EMValueCallBack;
import com.hyphenate.chat.EMChatManager;
import com.hyphenate.chat.EMChatRoomManager;
import com.hyphenate.chat.EMChatThreadManager;
import com.hyphenate.chat.EMCheckType;
import com.hyphenate.chat.EMContact;
import com.hyphenate.chat.EMContactManager;
import com.hyphenate.chat.EMConversation;
import com.hyphenate.chat.EMDeviceInfo;
import com.hyphenate.chat.EMEncryptProvider;
import com.hyphenate.chat.EMGroupManager;
import com.hyphenate.chat.EMLoginExtensionInfo;
import com.hyphenate.chat.EMLoginType;
import com.hyphenate.chat.EMOptions;
import com.hyphenate.chat.EMPresenceManager;
import com.hyphenate.chat.EMPushManager;
import com.hyphenate.chat.EMRTCTokenInfo;
import com.hyphenate.chat.EMSessionManager;
import com.hyphenate.chat.EMSmartHeartBeat;
import com.hyphenate.chat.EMStatisticsManager;
import com.hyphenate.chat.EMTimeTag;
import com.hyphenate.chat.EMUserInfoManager;
import com.hyphenate.chat.adapter.EMAChatClient;
import com.hyphenate.chat.adapter.EMAChatManager;
import com.hyphenate.chat.adapter.EMAConnectionListener;
import com.hyphenate.chat.adapter.EMADeviceInfo;
import com.hyphenate.chat.adapter.EMAError;
import com.hyphenate.chat.adapter.EMALogCallbackListener;
import com.hyphenate.chat.adapter.EMALogoutInfo;
import com.hyphenate.chat.adapter.EMAMultiDeviceListener;
import com.hyphenate.chat.adapter.EMANetCallback;
import com.hyphenate.chat.core.EMChatConfigPrivate;
import com.hyphenate.chat.core.a;
import com.hyphenate.cloud.EMHttpClient;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.notification.core.b;
import com.hyphenate.push.EMPushConfig;
import com.hyphenate.push.EMPushHelper;
import com.hyphenate.push.EMPushType;
import com.hyphenate.util.DeviceUuidFactory;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.EasyUtils;
import com.hyphenate.util.NetUtils;
import com.hyphenate.util.PathUtil;
import com.hyphenate.util.Utils;
import internal.com.getkeepsafe.relinker.ReLinker;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import javax.net.ssl.X509TrustManager;
import org.json.JSONException;
import org.json.JSONObject;

public class EMClient {
    public static final String TAG = "EMClient";
    private static volatile EMClient instance;
    static boolean libraryLoaded = false;
    public static final String VERSION = "4.16.1";
    private EMGroupManager groupManager;
    private EMChatRoomManager chatroomManager;
    private EMChatManager chatManager;
    private EMContactManager contactManager;
    private EMUserInfoManager userInfoManager;
    private EMPushManager pushManager;
    private volatile EMPresenceManager presenceManager;
    private EMChatThreadManager threadManager;
    private EMStatisticsManager statisticsManager;
    private EMAChatClient emaObject;
    private Context mContext;
    private ExecutorService executor = null;
    private ExecutorService logQueue = Executors.newSingleThreadExecutor();
    private ExecutorService mainQueue = Executors.newSingleThreadExecutor();
    private ExecutorService sendQueue = Executors.newSingleThreadExecutor();
    private EMEncryptProvider encryptProvider = null;
    private boolean sdkInited = false;
    private EMChatConfigPrivate mChatConfigPrivate;
    private List<EMConnectionListener> connectionListeners = Collections.synchronizedList(new ArrayList());
    private List<EMLogListener> logListeners = Collections.synchronizedList(new ArrayList());
    private ClientLogListener clientLogListener;
    private MyConnectionListener connectionListener;
    private EMSmartHeartBeat smartHeartbeat = null;
    private List<EMMultiDeviceListener> multiDeviceListeners = Collections.synchronizedList(new ArrayList());
    private MyMultiDeviceListener multiDeviceListenerImpl;
    private PowerManager.WakeLock wakeLock;
    private ConnectivityManager connManager;
    private EMAChatClient.EMANetwork currentNetworkType = EMAChatClient.EMANetwork.NETWORK_NONE;
    private boolean mIsLoginWithToken = false;
    private boolean mIsDBOpened = false;
    private BroadcastReceiver connectivityBroadcastReceiver = new BroadcastReceiver(this){
        final /* synthetic */ EMClient this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        public void onReceive(Context context, Intent intent) {
            EMAChatClient.EMANetwork eMANetwork;
            if (!intent.getAction().equals("android.net.conn.CONNECTIVITY_CHANGE")) {
                EMLog.d(EMClient.TAG, "skip no connectivity action");
                return;
            }
            EMLog.d(EMClient.TAG, "connectivity receiver onReceiver");
            switch (14.$SwitchMap$com$hyphenate$util$NetUtils$Types[NetUtils.getNetworkTypes(this.this$0.getContext()).ordinal()]) {
                default: {
                    eMANetwork = EMAChatClient.EMANetwork.NETWORK_NONE;
                    break;
                }
                case 4: {
                    eMANetwork = EMAChatClient.EMANetwork.NETWORK_CABLE;
                    break;
                }
                case 3: {
                    eMANetwork = EMAChatClient.EMANetwork.NETWORK_MOBILE;
                    break;
                }
                case 1: 
                case 2: {
                    eMANetwork = EMAChatClient.EMANetwork.NETWORK_WIFI;
                }
            }
            EMAChatClient.EMANetwork eMANetwork2 = EMAChatClient.EMANetwork.NETWORK_NONE;
            boolean bl = this.this$0.currentNetworkType != eMANetwork2;
            boolean bl2 = eMANetwork != eMANetwork2;
            EMClient.access$1202(this.this$0, eMANetwork);
            if (bl == bl2 && bl2) {
                this.this$0.execute(new Runnable(this){
                    final /* synthetic */ 9 this$1;
                    {
                        void var1_1;
                        this.this$1 = var1_1;
                    }

                    @Override
                    public void run() {
                        if (this.this$1.this$0.smartHeartbeat != null) {
                            EMLog.i(EMClient.TAG, "Network availability no change, just return. " + (Object)((Object)this.this$1.this$0.currentNetworkType) + ", but check ping");
                            this.this$1.this$0.smartHeartbeat.sendPingCheckConnection();
                        }
                    }
                });
                return;
            }
            EMLog.i(EMClient.TAG, "Network availability changed, notify... " + (Object)((Object)this.this$0.currentNetworkType));
            this.this$0.execute(new Runnable(this){
                final /* synthetic */ 9 this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                }

                @Override
                public void run() {
                    this.this$1.this$0.emaObject.onNetworkChanged(this.this$1.this$0.currentNetworkType);
                }
            });
        }
    };
    private AppStateListener appStateListener;
    private List<Activity> resumeActivityList = new ArrayList<Activity>();
    @Deprecated
    private boolean duringChecking = false;

    private EMClient() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static EMClient getInstance() {
        if (instance != null) return instance;
        Class<EMClient> clazz = EMClient.class;
        synchronized (EMClient.class) {
            try {
                if (instance != null) return instance;
                instance = new EMClient();
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
            catch (Throwable throwable) {}
            throw throwable;
        }
    }

    private String getDidInfo() {
        String string = Build.MANUFACTURER;
        String string2 = Build.MODEL;
        String string3 = Build.HARDWARE;
        int n = Build.VERSION.SDK_INT;
        return (String)string + "/" + string2 + "/" + string3 + "/" + n + "/" + Build.VERSION.RELEASE;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void initLoginWithToken(boolean isLoginWithToken, String expireTimestamp, long tokenAvailablePeriod) {
        void var1_1;
        this.mIsLoginWithToken = var1_1;
        if (isLoginWithToken) {
            void var3_3;
            void var2_2;
            EMSessionManager.getInstance().setLoginWithTokenData((boolean)var1_1, (String)var2_2, (long)var3_3);
            EMSessionManager.getInstance().startCountDownTokenAvailableTime(this.connectionListener);
        } else {
            EMSessionManager.getInstance().clearLoginWithTokenData();
        }
    }

    private void initManagers() {
        EMClient eMClient = this;
        EMHttpClient.getInstance().onInit(this.mChatConfigPrivate);
        eMClient.chatManager();
        eMClient.contactManager();
        eMClient.groupManager();
        eMClient.chatroomManager();
        eMClient.presenceManager();
        eMClient.chatThreadManager();
        eMClient.setNatvieNetworkCallback();
        EMClient eMClient2 = this;
        EMSessionManager.getInstance().init(eMClient2, eMClient2.emaObject.getSessionManager());
    }

    private void loadDataFromDb() {
        EMClient eMClient = this;
        eMClient.execute(() -> {
            EMClient eMClient = this;
            eMClient.groupManager().loadAllGroups();
            if (eMClient.getOptions().isAutoLoadAllConversations()) {
                this.chatManager().loadAllConversationsFromDB();
            }
        });
    }

    private void saveToken() {
        EMAError eMAError;
        if (((EMClient)((Object)this_)).emaObject == null) {
            return;
        }
        EMAError eMAError2 = eMAError;
        eMAError2();
        String this_ = ((EMClient)((Object)this_)).emaObject.getUserToken(false, eMAError2);
        if (eMAError.errCode() == 0) {
            EMSessionManager.getInstance().setLastLoginToken(this_);
            EMSessionManager.getInstance().setLastLoginWithToken(true);
            EMSessionManager.getInstance().clearLastLoginPwd();
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean _loadLibrary(String library, boolean trace) {
        try {
            void var1_2;
            ReLinker.loadLibrary((Context)this.mContext, (String)var1_2);
            EMLog.e(TAG, "_loadLibrary: " + (String)var1_2 + " success");
            return true;
        }
        catch (Throwable throwable) {
            void var2_3;
            if (var2_3 != false) {
                throwable.printStackTrace();
            }
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean _loadLibrary(String library) {
        void var1_1;
        return this._loadLibrary((String)var1_1, true);
    }

    private void loadLibrary(EMOptions options) {
        if (!libraryLoaded) {
            String string;
            string = ((EMOptions)((Object)string)).getNativeLibBasePath();
            EMLog.e(TAG, "nativeLibBasePath: " + string);
            if (TextUtils.isEmpty((CharSequence)string)) {
                EMClient eMClient = this;
                eMClient._loadLibrary("cipherdb", false);
                eMClient._loadLibrary("hyphenate", true);
                eMClient._loadLibrary("aosl", false);
            } else {
                EMClient eMClient = this;
                eMClient._loadCustomPathLibrary(string + "/libcipherdb.so");
                eMClient._loadCustomPathLibrary(string + "/libhyphenate.so");
                eMClient._loadCustomPathLibrary(string + "/libaosl.so");
            }
            libraryLoaded = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void _loadCustomPathLibrary(String nativeLibFullPath) {
        try {
            void var1_1;
            System.load(nativeLibFullPath);
            EMLog.e(TAG, "_loadCustomPathLibrary: " + (String)var1_1 + " success");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void releaseWakelock() {
        v0 = this;
        synchronized (v0) {
            block7: {
                block6: {
                    var1_1 = v0.wakeLock;
                    if (var1_1 == null) break block6;
                    {
                        catch (Throwable v1) {
                            break block7;
                        }
                        if (!var1_1.isHeld()) break block6;
                        ** try [egrp 2[TRYBLOCK] [2 : 18->31)] { 
lbl11:
                        // 1 sources

                        this.wakeLock.release();
                    }
lbl13:
                    // 1 sources

                    catch (Exception var1_2) {
                        EMLog.e("EMClient", var1_2.getMessage());
                    }
                    EMLog.d("EMClient", "released the wake lock");
                }
                // ** MonitorExit[this] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            throw v1;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handleError(EMAError error) throws HyphenateException {
        void var1_1;
        if (error.errCode() == 0) {
            return;
        }
        throw new HyphenateException((EMAError)var1_1);
    }

    @TargetApi(value=14)
    private void registerActivityLifecycleCallbacks() {
        if (Utils.isSdk14()) {
            Application.ActivityLifecycleCallbacks activityLifecycleCallbacks;
            Application.ActivityLifecycleCallbacks activityLifecycleCallbacks2 = activityLifecycleCallbacks;
            activityLifecycleCallbacks = new Application.ActivityLifecycleCallbacks(this){
                final /* synthetic */ EMClient this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                public void onActivityStopped(Activity activity) {
                    void var1_1;
                    10 v0 = this;
                    v0.this$0.resumeActivityList.remove(var1_1);
                    if (v0.this$0.resumeActivityList.isEmpty() && this.this$0.appStateListener != null) {
                        this.this$0.appStateListener.onBackground();
                    }
                }

                public void onActivityResumed(Activity activity) {
                }

                public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                }

                /*
                 * WARNING - void declaration
                 */
                public void onActivityStarted(Activity activity) {
                    void var1_1;
                    if (!this.this$0.resumeActivityList.contains(var1_1)) {
                        10 v0 = this;
                        v0.this$0.resumeActivityList.add(var1_1);
                        if (v0.this$0.resumeActivityList.size() == 1 && this.this$0.appStateListener != null) {
                            this.this$0.appStateListener.onForeground();
                        }
                    }
                }

                public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
                }

                public void onActivityPaused(Activity activity) {
                }

                public void onActivityDestroyed(Activity activity) {
                }
            };
            ((Application)this.mContext).registerActivityLifecycleCallbacks(activityLifecycleCallbacks2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    private void checkLogout(CheckResultListener listener) {
        if (!this.isLoggedInBefore()) {
            void var1_1;
            EMClient eMClient = this;
            eMClient.logout();
            eMClient.notifyCheckResult((CheckResultListener)var1_1, 5, 0, "");
        }
        this.duringChecking = false;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    private void notifyCheckResult(CheckResultListener listener, @EMCheckType.CheckType int type, int result, String desc) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        if (listener == null) {
            return;
        }
        var1_1.onResult((int)var2_2, (int)var3_3, (String)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$renewToken$0(String newToken, EMCallBack callback) {
        void var2_4;
        void var1_3;
        EMAError eMAError;
        EMAError eMAError2 = eMAError;
        eMAError2();
        long l = this.emaObject.getTokenExpiredTs((String)var1_3, eMAError2);
        if (eMAError.errCode() == 0) {
            EMClient eMClient = this;
            long l2 = l;
            EMLog.d(TAG, "getTokenExpiredTs success");
            this.emaObject.renewToken((String)var1_3);
            long l3 = l2 - System.currentTimeMillis();
            eMClient.initLoginWithToken(true, String.valueOf(l2), l3);
            eMClient.saveToken();
            var2_4.onSuccess();
            EMLog.d(TAG, "renewToken(): expireTimestamp = " + l + " tokenAvailablePeriod = " + l3);
        } else {
            EMAError eMAError3 = eMAError2;
            int n = eMAError3.errCode();
            var2_4.onError(n, eMAError3.errMsg());
            EMLog.e(TAG, "getChatTokenbyAgoraToken failed error:" + eMAError2.errCode() + "  errorMessage:" + eMAError2.errMsg());
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$500(EMClient x0, boolean x1, String x2, long x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.initLoginWithToken((boolean)var1_1, (String)var2_2, (long)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$602(EMClient x0, boolean x1) {
        void var1_1;
        var0.mIsDBOpened = var1_1;
        return x1;
    }

    static /* synthetic */ EMChatManager access$800(EMClient x0) {
        return x0.chatManager;
    }

    static /* synthetic */ List access$1000(EMClient x0) {
        return x0.logListeners;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ EMAChatClient.EMANetwork access$1202(EMClient x0, EMAChatClient.EMANetwork x1) {
        void var1_1;
        var0.currentNetworkType = var1_1;
        return x1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1600(EMClient x0, CheckResultListener x1, int x2, int x3, String x4) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        x0.notifyCheckResult((CheckResultListener)var1_1, (int)var2_2, (int)var3_3, (String)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$1702(EMClient x0, boolean x1) {
        void var1_1;
        var0.duringChecking = var1_1;
        return x1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1800(EMClient x0, CheckResultListener x1) {
        void var1_1;
        x0.checkLogout((CheckResultListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1900(EMClient x0, EMAError x1) throws HyphenateException {
        void var1_1;
        x0.handleError((EMAError)var1_1);
    }

    public synchronized void init(Context context, EMOptions options) {
        MyMultiDeviceListener myMultiDeviceListener;
        MyConnectionListener myConnectionListener;
        EMPushConfig.Builder builder;
        DeviceUuidFactory deviceUuidFactory;
        EMChatConfigPrivate eMChatConfigPrivate;
        EMTimeTag eMTimeTag;
        EMTimeTag eMTimeTag2;
        Object object;
        if (this.sdkInited) {
            return;
        }
        void v0 = object;
        void v1 = eMTimeTag2;
        this.executor = Executors.newCachedThreadPool();
        eMTimeTag2 = eMTimeTag;
        new EMTimeTag().start();
        this.mContext = v1.getApplicationContext();
        this.connManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        this.registerActivityLifecycleCallbacks();
        this.loadLibrary((EMOptions)object);
        Object object2 = eMChatConfigPrivate;
        this.mChatConfigPrivate = object2;
        new EMChatConfigPrivate().a(this.mContext, (EMOptions)object);
        v0.setConfig(this.mChatConfigPrivate);
        object2 = deviceUuidFactory;
        deviceUuidFactory = new DeviceUuidFactory(this.mContext);
        this.mChatConfigPrivate.c(((DeviceUuidFactory)object2).getDeviceUuid().toString());
        object2 = Build.MANUFACTURER + Build.MODEL;
        EMLog.e(TAG, "system device name :" + (String)object2);
        if (TextUtils.isEmpty((CharSequence)v0.getCustomDeviceName())) {
            this.mChatConfigPrivate.b((String)object2);
        }
        this.mChatConfigPrivate.d(this.getDidInfo());
        this.mChatConfigPrivate.i(UUID.randomUUID().toString());
        object2 = ((EMOptions)object).getPushConfig();
        if (object2 == null) {
            object2 = new EMPushConfig.Builder(this.mContext).build();
        }
        Object object3 = builder;
        builder = new EMPushConfig.Builder(this.mContext, (EMPushConfig)object2);
        object2 = this.mContext;
        EMPushHelper.getInstance().init((Context)object2, ((EMPushConfig.Builder)object3).build());
        this.emaObject = EMAChatClient.create(this.mChatConfigPrivate.a);
        object2 = myConnectionListener;
        myConnectionListener = new MyConnectionListener(this);
        this.connectionListener = object2;
        this.emaObject.addConnectionListener((EMAConnectionListener)object2);
        object2 = myMultiDeviceListener;
        myMultiDeviceListener = new MyMultiDeviceListener(this);
        this.multiDeviceListenerImpl = object2;
        this.emaObject.addMultiDeviceListener((EMAMultiDeviceListener)object2);
        this.initManagers();
        this.mIsLoginWithToken = EMSessionManager.getInstance().isLastLoginWithToken();
        object2 = EMSessionManager.getInstance().getLastLoginUser();
        EMLog.e(TAG, "is autoLogin : " + ((EMOptions)object).getAutoLogin());
        EMLog.e(TAG, "lastLoginUser : " + (String)object2);
        EMLog.e(TAG, "hyphenate SDK is initialized with version : " + this.getChatConfigPrivate().F());
        this.wakeLock = ((PowerManager)this.mContext.getSystemService("power")).newWakeLock(1, "emclient");
        b.a().b(this.mContext);
        this.sdkInited = true;
        this.mContext.registerReceiver(this.connectivityBroadcastReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        this.onNetworkChanged();
        if (((EMOptions)object).getAutoLogin() && this.isLoggedInBefore()) {
            EMCallBack eMCallBack;
            object = EMSessionManager.getInstance().getLastLoginToken();
            object3 = EMSessionManager.getInstance().getLastLoginPwd();
            EMSessionManager.getInstance().currentUser = new EMContact((String)object2);
            EMCallBack eMCallBack2 = eMCallBack;
            eMCallBack = new EMCallBack(){
                final /* synthetic */ String val$lastLoginUser;
                final /* synthetic */ EMTimeTag val$tag;
                final /* synthetic */ EMClient this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$lastLoginUser = string;
                    this.val$tag = eMTimeTag;
                }

                @Override
                public void onSuccess() {
                    EMSessionManager.getInstance().currentUser = new EMContact(this.val$lastLoginUser);
                    EMLog.d(EMClient.TAG, "hyphenate login onSuccess");
                    this.val$tag.stop();
                    EMLog.d(EMClient.TAG, "[Collector][sdk init]login time is : " + this.val$tag.timeStr());
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void onError(int code, String error) {
                    void var2_2;
                    void var1_1;
                    EMLog.d(EMClient.TAG, "hyphenate login onError:" + (int)var1_1 + " error:" + (String)var2_2);
                    this.val$tag.stop();
                    EMLog.d(EMClient.TAG, "[Collector][sdk init]login failed time is : " + this.val$tag.timeStr());
                }

                @Override
                public void onProgress(int progress, String status) {
                }
            };
            boolean bl = this.mIsLoginWithToken;
            if (!bl) {
                object = object3;
            }
            boolean bl2 = bl;
            bl = true;
            object3 = bl2 ? EMLoginType.LOGIN_TOKEN : EMLoginType.LOGIN_PASSWORD;
            this._login((String)object2, (String)object, eMCallBack2, bl, (EMLoginType)((Object)object3));
        } else {
            eMTimeTag2.stop();
            EMLog.d(TAG, "[Collector][sdk init]init time is : " + eMTimeTag2.timeStr());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void createAccount(String username, String password) throws HyphenateException {
        String string = username.toLowerCase();
        if (Pattern.compile("^[a-zA-Z0-9_.-]+$").matcher(string).find()) {
            void var2_2;
            EMClient eMClient = this;
            eMClient.handleError(eMClient.emaObject.createAccount(string, (String)var2_2));
            return;
        }
        throw new HyphenateException(205, "illegal user name");
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void login(String id, String password, @NonNull EMCallBack callback) {
        void var3_3;
        EMLoginType eMLoginType;
        void var2_2;
        if (id != null && var2_2 != null && !((String)((Object)eMLoginType)).equals("") && !var2_2.equals("")) {
            if (TextUtils.isEmpty((CharSequence)((EMClient)((Object)string)).getChatConfigPrivate().c()) && TextUtils.isEmpty((CharSequence)((EMClient)((Object)string)).getChatConfigPrivate().b())) {
                var3_3.onError(110, "please setup your App Key or AppId via Options");
                return;
            }
            if (!((EMClient)((Object)string)).sdkInited) {
                var3_3.onError(1, "sdk not initialized");
                return;
            }
            EMClient eMClient = string;
            String string = ((String)((Object)eMLoginType)).toLowerCase();
            eMClient.initLoginWithToken(false, "", 0L);
            eMLoginType = EMLoginType.LOGIN_PASSWORD;
            eMClient._login(string, (String)var2_2, (EMCallBack)var3_3, false, eMLoginType);
            return;
        }
        var3_3.onError(110, "username or password is null or empty!");
    }

    /*
     * WARNING - void declaration
     */
    public void loginWithToken(String username, String token, @NonNull EMCallBack callback) {
        void var2_2;
        EMLoginType eMLoginType;
        void var3_3;
        if (TextUtils.isEmpty((CharSequence)((EMClient)((Object)this_)).getChatConfigPrivate().c()) && TextUtils.isEmpty((CharSequence)((EMClient)((Object)this_)).getChatConfigPrivate().b())) {
            var3_3.onError(110, "please setup your App Key or AppId via Options");
            return;
        }
        if (eMLoginType != null && var2_2 != null && !((String)((Object)eMLoginType)).equals("") && !var2_2.equals("")) {
            if (!((EMClient)((Object)this_)).sdkInited) {
                var3_3.onError(1, "sdk not initialized");
                return;
            }
            EMClient eMClient = this_;
            String this_ = ((String)((Object)eMLoginType)).toLowerCase();
            eMClient.initLoginWithToken(true, "", 0L);
            eMLoginType = EMLoginType.LOGIN_TOKEN;
            eMClient._login(this_, (String)var2_2, (EMCallBack)var3_3, false, eMLoginType);
            return;
        }
        var3_3.onError(110, "username or token is null or empty!");
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void loginWithAgoraToken(String username, String agoraToken, @NonNull EMCallBack callback) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.loginWithToken((String)var1_1, (String)var2_2, (EMCallBack)var3_3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void notifyTokenExpired(String response) {
        JSONException jSONException2;
        block4: {
            String string;
            if (this.connectionListener == null) return;
            if (!this.mIsLoginWithToken) return;
            try {
                string = new JSONObject(string).optString("error_description");
            }
            catch (JSONException jSONException2) {
                break block4;
            }
            EMLog.e(TAG, "notifyTokenExpired--errorDescription:" + string);
            if (!string.contains("milliseconds ago") && !string.contains("has expired")) {
                if (!string.contains("Unable to authenticate due to expired access Token")) return;
            }
            this.connectionListener.onTokenNotification(401);
            EMLog.e(TAG, "notifyTokenExpired--onTokenNotification(401) ");
            return;
        }
        jSONException2.printStackTrace();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void renewToken(String newAgoraToken) {
        void var1_1;
        this.renewToken((String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void renewToken(String newToken, @NonNull EMCallBack callback) {
        void var1_1;
        void var2_2;
        if (!this.sdkInited) {
            var2_2.onError(1, "SDK not initialized");
            return;
        }
        if (!this.emaObject.isLoggedIn()) {
            var2_2.onError(201, "User has not loggin.");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)var1_1)) {
            var2_2.onError(104, "New token is invalid");
            return;
        }
        EMClient eMClient = this;
        eMClient.execute(() -> eMClient.lambda$renewToken$0((String)var1_1, (EMCallBack)var2_2));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int logout(boolean unbindToken) {
        block4: {
            block5: {
                block6: {
                    if (this.emaObject.isLogout()) break block5;
                    var2_2 = a.l().o();
                    if (TextUtils.isEmpty((CharSequence)a.l().p()) || TextUtils.isEmpty((CharSequence)var2_2)) break block6;
                    if (var1_1 == false) ** GOTO lbl-1000
                    try {
                        this.pushManager().unBindDeviceToken();
                    }
                    catch (Exception v0) {
                        return 212;
                    }
lbl-1000:
                    // 1 sources

                    {
                        EMLog.d("EMClient", "logout: don't unbind token");
                        break block4;
                    }
                }
                if (!EMPushHelper.getInstance().unregister((boolean)var1_1)) {
                    return 212;
                }
                break block4;
            }
            EMPushHelper.getInstance().unregister(false);
            EMLog.e("EMClient", "already logout, skip unbind token");
        }
        this.logout();
        return 0;
    }

    void logout() {
        EMLog.d(TAG, " SDK Logout");
        EMSessionManager.getInstance().clearLastLoginUser();
        EMSessionManager.getInstance().clearLastLoginToken();
        EMSessionManager.getInstance().clearLoginWithTokenData();
        ((EMClient)this).mIsDBOpened = false;
        Object object = ((EMClient)this).smartHeartbeat;
        if (object != null) {
            ((EMSmartHeartBeat)object).stop();
        }
        EMClient eMClient = this;
        eMClient.releaseWakelock();
        object = eMClient.emaObject;
        if (object != null) {
            ((EMAChatClient)object).logout();
        }
        if ((object = ((EMClient)this).chatManager) != null) {
            ((EMChatManager)object).onLogout();
        }
        if ((object = ((EMClient)this).groupManager) != null) {
            ((EMGroupManager)object).onLogout();
        }
        if ((object = ((EMClient)this).contactManager) != null) {
            ((EMContactManager)object).onLogout();
        }
        if ((this = ((EMClient)this).chatroomManager) != null) {
            ((EMChatRoomManager)this).onLogout();
        }
        if (EMChatConfigPrivate.J()) {
            com.hyphenate.monitor.a.d();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logout(boolean unbindToken, EMCallBack callback) {
        void var2_2;
        void var1_1;
        new Thread(this, (boolean)var1_1, (EMCallBack)var2_2){
            final /* synthetic */ boolean val$unbindToken;
            final /* synthetic */ EMCallBack val$callback;
            final /* synthetic */ EMClient this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$unbindToken = bl;
                this.val$callback = eMCallBack;
            }

            @Override
            public void run() {
                Object this_;
                int n = this_.this$0.logout(this_.val$unbindToken);
                if (n != 0) {
                    this_ = this_.val$callback;
                    if (this_ != null) {
                        this_.onError(n, "faild to unbind device token");
                    }
                } else {
                    this_ = this_.val$callback;
                    if (this_ != null) {
                        this_.onSuccess();
                    }
                }
            }
        }.start();
    }

    /*
     * WARNING - void declaration
     */
    void logout(EMCallBack callback) {
        void var1_1;
        Thread thread = new Thread(this, (EMCallBack)var1_1){
            final /* synthetic */ EMCallBack val$callback;
            final /* synthetic */ EMClient this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$callback = eMCallBack;
            }

            @Override
            public void run() {
                EMCallBack eMCallBack = this_.val$callback;
                if (eMCallBack != null) {
                    eMCallBack.onProgress(0, null);
                }
                3 v0 = this_;
                v0.this$0.logout();
                EMCallBack this_ = v0.val$callback;
                if (this_ != null) {
                    this_.onSuccess();
                }
            }
        };
        thread.setPriority(9);
        thread.start();
    }

    /*
     * WARNING - void declaration
     */
    public void changeAppkey(String appkey) throws HyphenateException {
        void var1_1;
        EMAError eMAError = this.emaObject.changeAppkey((String)var1_1);
        if (eMAError.errCode() == 0) {
            this.getOptions().updatePath((String)var1_1, "");
        }
        this.handleError(eMAError);
    }

    /*
     * WARNING - void declaration
     */
    public void changeAppId(String appId) throws HyphenateException {
        void var1_1;
        EMAError eMAError = this.emaObject.changeAppId((String)var1_1);
        if (eMAError.errCode() == 0) {
            this.getOptions().updatePath("", (String)var1_1);
        }
        this.handleError(eMAError);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void addConnectionListener(EMConnectionListener listener) {
        Runnable runnable;
        void var1_1;
        Object object;
        block6: {
            if (listener == null) {
                return;
            }
            EMClient eMClient = this;
            object = eMClient.connectionListeners;
            // MONITORENTER : object
            if (eMClient.connectionListeners.contains(var1_1)) break block6;
            this.connectionListeners.add((EMConnectionListener)var1_1);
        }
        EMClient eMClient = this;
        // MONITOREXIT : object
        object = runnable;
        runnable = new Runnable(){
            final /* synthetic */ EMConnectionListener val$listener;
            final /* synthetic */ EMClient this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$listener = eMConnectionListener;
            }

            @Override
            public void run() {
                if (this.this$0.isConnected()) {
                    this.val$listener.onConnected();
                } else if (this.this$0.isLoggedIn()) {
                    this.val$listener.onDisconnected(2);
                }
            }
        };
        eMClient.execute((Runnable)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void removeConnectionListener(EMConnectionListener listener) {
        if (listener == null) {
            return;
        }
        List<EMConnectionListener> list = this.connectionListeners;
        synchronized (list) {
            void var1_1;
            this.connectionListeners.remove(var1_1);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void addLogListener(EMLogListener listener) {
        ClientLogListener clientLogListener;
        ClientLogListener clientLogListener2;
        block6: {
            if (listener == null) {
                return;
            }
            EMClient eMClient = this;
            List<EMLogListener> list = eMClient.logListeners;
            // MONITORENTER : list
            if (eMClient.logListeners.contains(clientLogListener2)) break block6;
            this.logListeners.add((EMLogListener)((Object)clientLogListener2));
        }
        // MONITOREXIT : list
        if (this.clientLogListener != null) return;
        clientLogListener2 = clientLogListener;
        this.clientLogListener = new ClientLogListener(this);
        this.emaObject.addLogCallbackListener(clientLogListener2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void removeLogListener(EMLogListener listener) {
        if (listener == null) {
            return;
        }
        List<EMLogListener> list = this.logListeners;
        synchronized (list) {
            void var1_1;
            this.logListeners.remove(var1_1);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EMGroupManager groupManager() {
        if (this.groupManager != null) return this.groupManager;
        Class<EMClient> clazz = EMClient.class;
        synchronized (EMClient.class) {
            try {
                if (this.groupManager != null) return this.groupManager;
                EMClient eMClient = this;
                this.groupManager = new EMGroupManager(eMClient, eMClient.emaObject.getGroupManager());
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.groupManager;
            }
            catch (Throwable throwable) {}
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EMPushManager pushManager() {
        if (this.pushManager != null) return this.pushManager;
        Class<EMClient> clazz = EMClient.class;
        synchronized (EMClient.class) {
            try {
                if (this.pushManager != null) return this.pushManager;
                EMClient eMClient = this;
                this.pushManager = new EMPushManager(eMClient, eMClient.emaObject.getPushMnager());
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.pushManager;
            }
            catch (Throwable throwable) {}
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EMChatRoomManager chatroomManager() {
        if (this.chatroomManager != null) return this.chatroomManager;
        Class<EMClient> clazz = EMClient.class;
        synchronized (EMClient.class) {
            try {
                if (this.chatroomManager != null) return this.chatroomManager;
                EMClient eMClient = this;
                this.chatroomManager = new EMChatRoomManager(eMClient, eMClient.emaObject.getChatRoomManager());
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.chatroomManager;
            }
            catch (Throwable throwable) {}
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EMChatManager chatManager() {
        if (this.chatManager != null) return this.chatManager;
        Class<EMClient> clazz = EMClient.class;
        synchronized (EMClient.class) {
            try {
                if (this.chatManager != null) return this.chatManager;
                EMClient eMClient = this;
                EMAChatManager eMAChatManager = eMClient.emaObject.getChatManager();
                this.chatManager = new EMChatManager(eMClient, eMAChatManager, eMClient.emaObject.getReactionManager());
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.chatManager;
            }
            catch (Throwable throwable) {}
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EMUserInfoManager userInfoManager() {
        if (this.userInfoManager != null) return this.userInfoManager;
        Class<EMClient> clazz = EMClient.class;
        synchronized (EMClient.class) {
            try {
                if (this.userInfoManager != null) return this.userInfoManager;
                this.userInfoManager = new EMUserInfoManager(this.emaObject.getUserInfoManager());
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.userInfoManager;
            }
            catch (Throwable throwable) {}
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EMContactManager contactManager() {
        if (this.contactManager != null) return this.contactManager;
        Class<EMClient> clazz = EMClient.class;
        synchronized (EMClient.class) {
            try {
                if (this.contactManager != null) return this.contactManager;
                EMClient eMClient = this;
                this.contactManager = new EMContactManager(eMClient, eMClient.emaObject.getContactManager());
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.contactManager;
            }
            catch (Throwable throwable) {}
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EMPresenceManager presenceManager() {
        if (this.presenceManager != null) return this.presenceManager;
        Class<EMClient> clazz = EMClient.class;
        synchronized (EMClient.class) {
            try {
                if (this.presenceManager != null) return this.presenceManager;
                this.presenceManager = new EMPresenceManager(this.emaObject.getPresenceManager());
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.presenceManager;
            }
            catch (Throwable throwable) {}
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EMChatThreadManager chatThreadManager() {
        if (this.threadManager != null) return this.threadManager;
        Class<EMClient> clazz = EMClient.class;
        synchronized (EMClient.class) {
            try {
                if (this.threadManager != null) return this.threadManager;
                EMClient eMClient = this;
                this.threadManager = new EMChatThreadManager(eMClient, eMClient.emaObject.getThreadManager());
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.threadManager;
            }
            catch (Throwable throwable) {}
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EMStatisticsManager statisticsManager() {
        if (this.statisticsManager != null) return this.statisticsManager;
        Class<EMClient> clazz = EMClient.class;
        synchronized (EMClient.class) {
            try {
                if (this.statisticsManager != null) return this.statisticsManager;
                EMClient eMClient = this;
                this.statisticsManager = new EMStatisticsManager(eMClient, eMClient.emaObject.getStatisticsManager());
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.statisticsManager;
            }
            catch (Throwable throwable) {}
            throw throwable;
        }
    }

    public Context getContext() {
        return this.mContext;
    }

    public synchronized String getCurrentUser() {
        if (EMSessionManager.getInstance().currentUser != null && EMSessionManager.getInstance().currentUser.username != null && !EMSessionManager.getInstance().currentUser.username.equals("")) {
            return EMSessionManager.getInstance().currentUser.username;
        }
        return EMSessionManager.getInstance().getLastLoginUser();
    }

    /*
     * WARNING - void declaration
     */
    public void getUserTokenFromServer(String username, String password, EMValueCallBack<String> callBack) {
        void var3_3;
        void var2_2;
        void var1_1;
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){
            final /* synthetic */ String val$username;
            final /* synthetic */ String val$password;
            final /* synthetic */ EMValueCallBack val$callBack;
            final /* synthetic */ EMClient this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$username = string;
                this.val$password = string2;
                this.val$callBack = eMValueCallBack;
            }

            @Override
            public void run() {
                EMAError eMAError;
                5 v0 = this;
                EMAError eMAError2 = eMAError;
                eMAError = new EMAError();
                5 v2 = this;
                String string = v2.val$username;
                string = v0.this$0.emaObject.getUserTokenFromServer(string, v2.val$password, eMAError2);
                if (v0.val$callBack == null) {
                    return;
                }
                if (eMAError2.errCode() == 0) {
                    this.val$callBack.onSuccess(string);
                } else {
                    EMAError eMAError3 = eMAError2;
                    int n = eMAError3.errCode();
                    this.val$callBack.onError(n, eMAError3.errMsg());
                }
            }
        };
        this.execute(runnable2);
    }

    public boolean isLoggedInBefore() {
        Object object = EMSessionManager.getInstance();
        String string = ((EMSessionManager)object).getLastLoginUser();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        Object object2 = object;
        object = ((EMSessionManager)object2).getLastLoginPwd();
        String string2 = ((EMSessionManager)object2).getLastLoginToken();
        return string != null && !string.isEmpty() && (object != null && !((String)object).isEmpty() || string2 != null && !string2.isEmpty());
    }

    public boolean isConnected() {
        return this.emaObject.isConnected();
    }

    public boolean isLoggedIn() {
        return this.emaObject.isLoggedIn();
    }

    /*
     * WARNING - void declaration
     */
    public void setDebugMode(boolean debugMode) {
        void var1_1;
        EMLog.debugMode = var1_1;
        this.getChatConfigPrivate().i((boolean)var1_1);
    }

    public void uploadLog(EMCallBack callback) {
        this.chatManager().emaObject.uploadLog();
    }

    public EMOptions getOptions() {
        return this.mChatConfigPrivate.s();
    }

    public String compressLogs() throws HyphenateException {
        EMAError eMAError;
        EMAError eMAError2 = eMAError;
        eMAError = new EMAError();
        String string = this.emaObject.compressLogs(eMAError2);
        this.handleError(eMAError2);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public void addMultiDeviceListener(EMMultiDeviceListener listener) {
        void var1_1;
        this.multiDeviceListeners.add((EMMultiDeviceListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void removeMultiDeviceListener(EMMultiDeviceListener listener) {
        void var1_1;
        this.multiDeviceListeners.remove(var1_1);
    }

    public List<EMDeviceInfo> getLoggedInDevicesFromServer(String username, String password) throws HyphenateException {
        ArrayList arrayList;
        EMADeviceInfo eMADeviceInfo2;
        Iterator<EMADeviceInfo> iterator;
        EMAError eMAError;
        EMAError eMAError2 = eMAError;
        eMAError = new EMAError();
        List<EMADeviceInfo> list = ((EMClient)((Object)this_)).emaObject.getLoggedInDevicesFromServer((String)((Object)iterator), (String)((Object)eMADeviceInfo2), eMAError2);
        ((EMClient)((Object)this_)).handleError(eMAError2);
        ArrayList this_ = arrayList;
        arrayList = new ArrayList();
        for (EMADeviceInfo eMADeviceInfo2 : list) {
            this_.add(new EMDeviceInfo(eMADeviceInfo2));
        }
        return this_;
    }

    public List<EMDeviceInfo> getLoggedInDevicesFromServerWithToken(@NonNull String username, @NonNull String token) throws HyphenateException {
        ArrayList arrayList;
        EMADeviceInfo eMADeviceInfo2;
        Iterator<EMADeviceInfo> iterator;
        EMAError eMAError;
        EMAError eMAError2 = eMAError;
        eMAError = new EMAError();
        List<EMADeviceInfo> list = ((EMClient)((Object)this_)).emaObject.getLoggedInDevicesFromServerWithToken((String)((Object)iterator), (String)((Object)eMADeviceInfo2), eMAError2);
        ((EMClient)((Object)this_)).handleError(eMAError2);
        ArrayList this_ = arrayList;
        arrayList = new ArrayList();
        for (EMADeviceInfo eMADeviceInfo2 : list) {
            this_.add(new EMDeviceInfo(eMADeviceInfo2));
        }
        return this_;
    }

    /*
     * WARNING - void declaration
     */
    public void kickDevice(String username, String password, String resource) throws HyphenateException {
        void var3_3;
        void var2_2;
        void var1_1;
        EMAError eMAError;
        EMAError eMAError2 = eMAError;
        eMAError2();
        this.emaObject.kickDevice((String)var1_1, (String)var2_2, (String)var3_3, eMAError2);
        this.handleError(eMAError);
    }

    /*
     * WARNING - void declaration
     */
    public void kickDeviceWithToken(@NonNull String username, @NonNull String token, String resource) throws HyphenateException {
        void var3_3;
        void var2_2;
        void var1_1;
        EMAError eMAError;
        EMAError eMAError2 = eMAError;
        eMAError2();
        this.emaObject.kickDeviceWithToken((String)var1_1, (String)var2_2, (String)var3_3, eMAError2);
        this.handleError(eMAError);
    }

    /*
     * WARNING - void declaration
     */
    public void kickAllDevices(String username, String password) throws HyphenateException {
        void var2_2;
        void var1_1;
        EMAError eMAError;
        EMAError eMAError2 = eMAError;
        eMAError2();
        this.emaObject.kickAllDevices((String)var1_1, (String)var2_2, eMAError2);
        this.handleError(eMAError);
    }

    /*
     * WARNING - void declaration
     */
    public void kickAllDevicesWithToken(@NonNull String username, @NonNull String token) throws HyphenateException {
        void var2_2;
        void var1_1;
        EMAError eMAError;
        EMAError eMAError2 = eMAError;
        eMAError2();
        this.emaObject.kickAllDevicesWithToken((String)var1_1, (String)var2_2, eMAError2);
        this.handleError(eMAError);
    }

    /*
     * WARNING - void declaration
     */
    public void sendFCMTokenToServer(String fcmToken) {
        void var1_1;
        EMLog.d(TAG, "sendFCMTokenToServer: " + (String)var1_1);
        if (TextUtils.isEmpty((CharSequence)fcmToken)) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)object.getCurrentUser())) {
            EMLog.i(TAG, "No user login currently, stop upload the token.");
            return;
        }
        Object object = EMPushHelper.getInstance().getPushType();
        EMLog.i(TAG, "pushType: " + object);
        if (object == EMPushType.FCM) {
            EMPushHelper.getInstance().onReceiveToken((EMPushType)((Object)object), (String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void sendHMSPushTokenToServer(String token) {
        Object object = EMPushType.HMSPUSH;
        if (EMPushHelper.getInstance().getPushType() == object) {
            void var1_1;
            EMPushHelper.getInstance().onReceiveToken((EMPushType)((Object)object), (String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void sendHonorPushTokenToServer(String token) {
        Object object = EMPushType.HONORPUSH;
        if (EMPushHelper.getInstance().getPushType() == object) {
            void var1_1;
            EMPushHelper.getInstance().onReceiveToken((EMPushType)((Object)object), (String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    void _login(String username, String code, EMCallBack callback, boolean autoLogin, EMLoginType loginType) {
        void var3_3;
        if (this.getChatConfigPrivate() != null && this.sdkInited) {
            void var5_5;
            void var4_4;
            void var2_2;
            void var1_1;
            EMLog.e(TAG, "emchat manager login in process:" + Process.myPid());
            this.execute(new Runnable(){
                final /* synthetic */ String val$username;
                final /* synthetic */ EMCallBack val$callback;
                final /* synthetic */ String val$code;
                final /* synthetic */ boolean val$autoLogin;
                final /* synthetic */ EMLoginType val$loginType;
                final /* synthetic */ EMClient this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$username = string;
                    this.val$callback = eMCallBack;
                    this.val$code = string2;
                    this.val$autoLogin = bl;
                    this.val$loginType = eMLoginType;
                }

                @Override
                public void run() {
                    EMAError eMAError;
                    EMLog.e(EMClient.TAG, "emchat manager login in process:" + Process.myPid() + " threadName:" + Thread.currentThread().getName() + " ID:" + Thread.currentThread().getId());
                    if (this.val$username == null) {
                        this.val$callback.onError(101, "Invalid user name");
                        return;
                    }
                    EMAError eMAError2 = eMAError;
                    eMAError2();
                    6 v1 = this;
                    String string = v1.val$username;
                    String string2 = v1.val$code;
                    boolean bl = v1.val$autoLogin;
                    int n = this.val$loginType.ordinal();
                    this.this$0.emaObject.login(string, string2, bl, n, eMAError2);
                    if (eMAError.errCode() == 0) {
                        EMSessionManager.getInstance().setLastLoginUser(this.val$username);
                        if (this.val$loginType == EMLoginType.LOGIN_PASSWORD) {
                            EMSessionManager.getInstance().setLastLoginPwd(this.val$code);
                            EMSessionManager.getInstance().setLastLoginWithToken(false);
                            EMSessionManager.getInstance().clearLastLoginToken();
                        } else {
                            this.this$0.saveToken();
                        }
                        if (this.val$autoLogin) {
                            this.this$0.loadDataFromDb();
                        }
                        6 v2 = this;
                        v2.this$0.onNewLogin();
                        EMPushHelper.getInstance().register();
                        v2.val$callback.onSuccess();
                    } else {
                        EMAError eMAError3 = eMAError2;
                        int n2 = eMAError3.errCode();
                        this.val$callback.onError(n2, eMAError3.errMsg());
                    }
                    if (eMAError2.errCode() == 202) {
                        EMSessionManager.getInstance().clearLastLoginPwd();
                        EMSessionManager.getInstance().clearLastLoginToken();
                        EMSessionManager.getInstance().clearLoginWithTokenData();
                    }
                }
            });
            return;
        }
        var3_3.onError(1, "");
    }

    public boolean isFCMAvailable() {
        return EMPushHelper.getInstance().getPushType() == EMPushType.FCM;
    }

    void onNewLogin() {
        EMLog.d(TAG, "on new login created");
        String string = EMSessionManager.getInstance().getLastLoginUser();
        EMClient eMClient = this;
        String string2 = eMClient.getChatConfigPrivate().c();
        Context context = eMClient.mContext;
        PathUtil.getInstance().initDirs(string2, string, context);
        if (this.smartHeartbeat == null) {
            this.smartHeartbeat = EMSmartHeartBeat.create(this.mContext);
        }
        if (this.getChatConfigPrivate().a.hasHeartBeatCustomizedParams()) {
            this.smartHeartbeat.setCustomizedParams(this.getChatConfigPrivate().a.getWifiHeartBeatCustomizedParams(), this.getChatConfigPrivate().a.getMobileHeartBeatCustomizedParams());
        }
        EMClient eMClient2 = this;
        eMClient2.smartHeartbeat.onInit();
        if (eMClient2.getOptions().getFixedInterval() != -1) {
            this.smartHeartbeat.setFixedInterval(this.getOptions().getFixedInterval());
        }
    }

    public String getAccessToken() {
        return this.getChatConfigPrivate().a();
    }

    public boolean isSdkInited() {
        return this.sdkInited;
    }

    /*
     * WARNING - void declaration
     */
    void execute(Runnable runnable) {
        void var1_1;
        this.executor.execute((Runnable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void executeOnMainQueue(Runnable runnable) {
        void var1_1;
        this.mainQueue.submit((Runnable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void executeOnSendQueue(Runnable runnable) {
        void var1_1;
        this.sendQueue.submit((Runnable)var1_1);
    }

    public EMChatConfigPrivate getChatConfigPrivate() {
        return this.mChatConfigPrivate;
    }

    void setNatvieNetworkCallback() {
        EMANetCallback eMANetCallback;
        EMANetCallback eMANetCallback2 = eMANetCallback;
        eMANetCallback = new EMANetCallback(this){
            final /* synthetic */ EMClient this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public int getNetState() {
                if (!NetUtils.hasDataConnection(this.this$0.mContext)) {
                    return EMAChatClient.EMANetwork.NETWORK_NONE.ordinal();
                }
                if (!NetUtils.isWifiConnected(this.this$0.mContext) && !NetUtils.isOthersConnected(this.this$0.mContext)) {
                    if (NetUtils.isMobileConnected(this.this$0.mContext)) {
                        return EMAChatClient.EMANetwork.NETWORK_MOBILE.ordinal();
                    }
                    if (NetUtils.isEthernetConnected(this.this$0.mContext)) {
                        return EMAChatClient.EMANetwork.NETWORK_CABLE.ordinal();
                    }
                    return EMAChatClient.EMANetwork.NETWORK_NONE.ordinal();
                }
                return EMAChatClient.EMANetwork.NETWORK_WIFI.ordinal();
            }
        };
        this.mChatConfigPrivate.a.setNetCallback(eMANetCallback2);
    }

    /*
     * WARNING - void declaration
     */
    void setEncryptProvider(EMEncryptProvider provider) {
        void var1_1;
        this.encryptProvider = var1_1;
    }

    EMEncryptProvider getEncryptProvider() {
        if (this.encryptProvider == null) {
            EMEncryptProvider eMEncryptProvider;
            EMLog.d(TAG, "encrypt provider is not set, create default");
            EMEncryptProvider eMEncryptProvider2 = eMEncryptProvider;
            eMEncryptProvider = new EMEncryptProvider(this){
                final /* synthetic */ EMClient this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public byte[] encrypt(byte[] input, String username) {
                    String string;
                    void var1_1;
                    8 v0;
                    try {
                        v0 = this_;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return var1_1;
                    }
                    String this_ = string;
                    string = new String((byte[])var1_1);
                    return v0.this$0.emaObject.getSessionManager().encrypt(this_).getBytes();
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public byte[] decrypt(byte[] input, String username) {
                    String string;
                    void var1_1;
                    8 v0;
                    try {
                        v0 = this_;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return var1_1;
                    }
                    String this_ = string;
                    string = new String((byte[])var1_1);
                    return v0.this$0.emaObject.getSessionManager().decrypt(this_).getBytes();
                }
            };
            this.encryptProvider = eMEncryptProvider2;
        }
        return this.encryptProvider;
    }

    /*
     * WARNING - void declaration
     */
    boolean sendPing(boolean waitPong, long timeout) {
        void var2_2;
        void var1_1;
        return this.emaObject.sendPing((boolean)var1_1, (long)var2_2);
    }

    void checkTokenAvailability() {
        if (this.mIsLoginWithToken) {
            EMSessionManager.getInstance().checkTokenAvailability(this.connectionListener);
        }
    }

    void forceReconnect() {
        EMClient eMClient = this;
        EMLog.d(TAG, "forceReconnect");
        eMClient.disconnect();
        eMClient.reconnect();
    }

    void reconnect() {
        EMLog.d(TAG, "reconnect");
        try {
            this.wakeLock.acquire();
        }
        catch (Exception exception) {
            EMLog.e(TAG, exception.getMessage());
        }
        EMClient eMClient = this;
        eMClient.emaObject.reconnect();
        eMClient.releaseWakelock();
    }

    void disconnect() {
        EMLog.d(TAG, "disconnect");
        this.emaObject.disconnect();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void onNetworkChanged() {
        try {
            if (NetUtils.isWifiConnected(this /* !! */ .mContext) || NetUtils.isOthersConnected(this /* !! */ .mContext)) ** GOTO lbl27
            if (NetUtils.isMobileConnected(this /* !! */ .mContext)) {
                v0 /* !! */  = this /* !! */ ;
                EMLog.d("EMClient", "has mobile connection");
                this /* !! */  = EMAChatClient.EMANetwork.NETWORK_MOBILE;
                v0 /* !! */ .currentNetworkType = this /* !! */ ;
                v0 /* !! */ .emaObject.onNetworkChanged((EMAChatClient.EMANetwork)this /* !! */ );
                return;
            }
            if (NetUtils.isEthernetConnected(this /* !! */ .mContext)) {
                v1 /* !! */  = this /* !! */ ;
                EMLog.d("EMClient", "has ethernet connection");
                this /* !! */  = EMAChatClient.EMANetwork.NETWORK_CABLE;
                v1 /* !! */ .currentNetworkType = this /* !! */ ;
                v1 /* !! */ .emaObject.onNetworkChanged((EMAChatClient.EMANetwork)this /* !! */ );
                return;
            }
            v2 /* !! */  = this /* !! */ ;
            v3 /* !! */  = v2 /* !! */ ;
            v4 /* !! */  = v2 /* !! */ ;
            this /* !! */  = EMAChatClient.EMANetwork.NETWORK_NONE;
        }
        catch (Exception v5) {}
        v3 /* !! */ .currentNetworkType = this /* !! */ ;
        EMLog.d("EMClient", "no data connection");
        v4 /* !! */ .emaObject.onNetworkChanged((EMAChatClient.EMANetwork)this /* !! */ );
        return;
lbl27:
        // 1 sources

        v6 = this /* !! */ ;
        v7 = v6;
        v8 = v6;
        EMLog.d("EMClient", "has wifi connection");
        this /* !! */  = EMAChatClient.EMANetwork.NETWORK_WIFI;
        v7.currentNetworkType = this /* !! */ ;
        v8.emaObject.onNetworkChanged((EMAChatClient.EMANetwork)this /* !! */ );
        return;
        v5.printStackTrace();
    }

    /*
     * WARNING - void declaration
     */
    void onNetworkChanged(EMAChatClient.EMANetwork network) {
        void var1_1;
        this.emaObject.onNetworkChanged((EMAChatClient.EMANetwork)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void setAppStateListener(AppStateListener appStateListener) {
        void var1_1;
        this.appStateListener = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void check(String username, String password, CheckResultListener listener) {
        void var3_3;
        Runnable runnable;
        String string;
        String string2;
        if (this.duringChecking) {
            EMLog.i("EMServiceChecker", "During service checking, please hold on...");
            return;
        }
        this.duringChecking = true;
        if (this.isLoggedInBefore()) {
            string2 = this.getCurrentUser();
            string = EMSessionManager.getInstance().getLastLoginPwd();
        }
        Runnable runnable2 = runnable;
        runnable = new Runnable(){
            final /* synthetic */ String val$finalUser;
            final /* synthetic */ String val$finalPwd;
            final /* synthetic */ CheckResultListener val$listener;
            final /* synthetic */ EMClient this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$finalUser = string;
                this.val$finalPwd = string2;
                this.val$listener = checkResultListener;
            }

            @Override
            public void run() {
                EMAChatClient.CheckResultListener checkResultListener;
                11 v0 = this;
                Object object = v0.val$finalUser;
                String string = v0.val$finalPwd;
                String string2 = object;
                object = checkResultListener;
                checkResultListener = new EMAChatClient.CheckResultListener(this){
                    final /* synthetic */ 11 this$1;
                    {
                        void var1_1;
                        this.this$1 = var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public void onResult(int type, int result, String desc) {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        EMLog.i("EMServiceChecker", "type: " + (int)var1_1 + ", result: " + (int)var2_2 + ", desc: " + (String)var3_3);
                        11 var4_4 = this_.this$1;
                        EMClient.access$1600(var4_4.this$0, var4_4.val$listener, (int)var1_1, (int)var2_2, (String)var3_3);
                        if (result != 0) {
                            EMClient.access$1702(this_.this$1.this$0, false);
                            return;
                        }
                        if (var1_1 == 3) {
                            11 this_ = this_.this$1;
                            EMClient.access$1800(this_.this$0, this_.val$listener);
                        }
                    }
                };
                this.this$0.emaObject.check(string2, string, (EMAChatClient.CheckResultListener)object);
            }
        };
        new Thread(runnable2).start();
    }

    boolean isDatabaseOpened() {
        return this.mIsDBOpened;
    }

    /*
     * WARNING - void declaration
     */
    public void asyncGetRTCTokenInfoWithChannelName(@Nullable String channelName, EMValueCallBack<EMRTCTokenInfo> callBack) {
        void var2_2;
        void var1_1;
        EMClient.getInstance().execute(new Runnable(){
            final /* synthetic */ String val$channelName;
            final /* synthetic */ EMValueCallBack val$callBack;
            final /* synthetic */ EMClient this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$channelName = string;
                this.val$callBack = eMValueCallBack;
            }

            @Override
            public void run() {
                block5: {
                    EMAError eMAError;
                    12 v0 = this_;
                    12 v1 = v0;
                    12 v2 = v0;
                    12 v3 = v0;
                    Object object = eMAError;
                    eMAError = new EMAError();
                    EMRTCTokenInfo eMRTCTokenInfo = v2.this$0.emaObject.getRTCTokenInfoWithChannelName(this_.val$channelName, (EMAError)object);
                    EMClient.access$1900(v3.this$0, (EMAError)object);
                    object = v1.val$callBack;
                    if (object == null) break block5;
                    try {
                        object.onSuccess(eMRTCTokenInfo);
                    }
                    catch (HyphenateException hyphenateException) {
                        EMValueCallBack this_ = this_.val$callBack;
                        if (this_ == null) break block5;
                        HyphenateException hyphenateException2 = hyphenateException;
                        int n = hyphenateException2.getErrorCode();
                        this_.onError(n, hyphenateException2.getDescription());
                    }
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public void asyncGetUserIdsWithRTCUids(List<Integer> uIds, EMValueCallBack<Map<Integer, String>> callBack) {
        void var2_2;
        void var1_1;
        EMClient.getInstance().execute(new Runnable(){
            final /* synthetic */ List val$uIds;
            final /* synthetic */ EMValueCallBack val$callBack;
            final /* synthetic */ EMClient this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$uIds = list;
                this.val$callBack = eMValueCallBack;
            }

            @Override
            public void run() {
                block5: {
                    EMAError eMAError;
                    13 v0 = this_;
                    13 v1 = v0;
                    13 v2 = v0;
                    13 v3 = v0;
                    Object object = eMAError;
                    eMAError = new EMAError();
                    Map<Integer, String> map = v2.this$0.emaObject.mapUserIdsWithRTCUids(this_.val$uIds, (EMAError)object);
                    EMClient.access$1900(v3.this$0, (EMAError)object);
                    object = v1.val$callBack;
                    if (object == null) break block5;
                    try {
                        object.onSuccess(map);
                    }
                    catch (HyphenateException hyphenateException) {
                        EMValueCallBack this_ = this_.val$callBack;
                        if (this_ == null) break block5;
                        HyphenateException hyphenateException2 = hyphenateException;
                        int n = hyphenateException2.getErrorCode();
                        this_.onError(n, hyphenateException2.getDescription());
                    }
                }
            }
        });
    }

    @Deprecated
    public static interface CheckResultListener {
        public void onResult(@EMCheckType.CheckType int var1, int var2, String var3);
    }

    static interface AppStateListener {
        public void onForeground();

        public void onBackground();
    }

    class MyConnectionListener
    extends EMAConnectionListener {
        final /* synthetic */ EMClient this$0;

        /*
         * WARNING - void declaration
         */
        MyConnectionListener(EMClient this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public void onConnected() {
            this.this$0.execute(new Runnable(this){
                final /* synthetic */ MyConnectionListener this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                }

                /*
                 * Loose catch block
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    1 v0 = this_;
                    List this_ = v0.this$1.this$0.connectionListeners;
                    synchronized (this_) {
                        Throwable throwable2;
                        block7: {
                            block6: {
                                try {
                                    Iterator iterator = v0.this$1.this$0.connectionListeners.iterator();
                                    while (iterator.hasNext()) {
                                        ((EMConnectionListener)iterator.next()).onConnected();
                                    }
                                    break block6;
                                    catch (Throwable throwable2) {
                                        break block7;
                                    }
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                            return;
                        }
                        throw throwable2;
                    }
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onDisconnected(int errCode, EMALogoutInfo info) {
            EMLoginExtensionInfo eMLoginExtensionInfo;
            String string;
            void var1_1;
            EMLog.e(EMClient.TAG, "onDisconnected errcode = " + (int)var1_1 + ",getDeviceInfo = " + ((EMALogoutInfo)((Object)string)).getDeviceInfo() + ",ext = " + ((EMALogoutInfo)((Object)string)).getDeviceExt());
            EMLoginExtensionInfo eMLoginExtensionInfo2 = eMLoginExtensionInfo;
            void v1 = string;
            string = v1.getDeviceInfo();
            eMLoginExtensionInfo = new EMLoginExtensionInfo(string, v1.getDeviceExt());
            this.this$0.execute(new Runnable(){
                final /* synthetic */ int val$errCode;
                final /* synthetic */ EMLoginExtensionInfo val$logoutInfo;
                final /* synthetic */ MyConnectionListener this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                    this.val$errCode = n;
                    this.val$logoutInfo = eMLoginExtensionInfo;
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    2 v0 = this;
                    List list = v0.this$1.this$0.connectionListeners;
                    synchronized (list) {
                        block15: {
                            Iterator iterator;
                            try {
                                int n;
                                switch (v0.val$errCode) {
                                    default: {
                                        break;
                                    }
                                    case 207: {
                                        EMSessionManager.getInstance().clearLastLoginUser();
                                        EMSessionManager.getInstance().clearLastLoginToken();
                                        EMSessionManager.getInstance().clearLastLoginPwd();
                                        break;
                                    }
                                    case 8: 
                                    case 206: 
                                    case 213: 
                                    case 214: 
                                    case 216: 
                                    case 217: 
                                    case 220: 
                                    case 305: {
                                        EMSessionManager.getInstance().clearLastLoginToken();
                                        EMSessionManager.getInstance().clearLastLoginPwd();
                                        if (!this.this$1.this$0.isSdkInited()) break;
                                        a.l().h("");
                                        a.l().i("");
                                    }
                                }
                                try {
                                    Iterator iterator2 = this.this$1.this$0.connectionListeners.iterator();
                                    while (iterator2.hasNext()) {
                                        ((EMConnectionListener)iterator2.next()).onDisconnected(this.val$errCode);
                                    }
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                                if ((n = this.val$errCode) != 206 && n != 207 && n != 213 && n != 220 && n != 305 && n != 214 && n != 216 && n != 217 && n != 8) break block15;
                                iterator = this.this$1.this$0.connectionListeners.iterator();
                            }
                            catch (Throwable throwable) {}
                            throw throwable;
                            while (iterator.hasNext()) {
                                try {
                                    2 v3 = this;
                                    int n = v3.val$errCode;
                                    ((EMConnectionListener)iterator.next()).onLogout(n, v3.val$logoutInfo);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                        }
                        return;
                    }
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean verifyServerCert(List<String> certschain, String domain) {
            X509TrustManagerExtensions x509TrustManagerExtensions;
            X509TrustManager x509TrustManager;
            void var1_1;
            void var2_2;
            if (certschain == null) {
                EMLog.d(EMClient.TAG, "List<String> certschain : null ");
                return false;
            }
            if (TextUtils.isEmpty((CharSequence)var2_2)) {
                EMLog.d(EMClient.TAG, "domain is empty or null ");
                return false;
            }
            EMLog.d(EMClient.TAG, "domain = " + (String)var2_2);
            X509Certificate[] x509CertificateArray = EasyUtils.convertToCerts((List<String>)var1_1);
            try {
                x509TrustManager = EasyUtils.getSystemDefaultTrustManager();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                EMLog.e(EMClient.TAG, exception.getMessage());
                EMLog.d(EMClient.TAG, "List<String> certschain :" + var1_1.toString());
                return false;
            }
            X509TrustManagerExtensions x509TrustManagerExtensions2 = x509TrustManagerExtensions;
            x509TrustManagerExtensions2(x509TrustManager);
            x509TrustManagerExtensions.checkServerTrusted(x509CertificateArray, x509CertificateArray[0].getType(), (String)var2_2);
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onTokenNotification(int code) {
            void var1_1;
            this.this$0.execute(new Runnable(){
                final /* synthetic */ int val$code;
                final /* synthetic */ MyConnectionListener this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                    this.val$code = n;
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    3 v0 = this;
                    List list = v0.this$1.this$0.connectionListeners;
                    synchronized (list) {
                        Throwable throwable2;
                        block10: {
                            block12: {
                                Exception exception2;
                                block11: {
                                    block9: {
                                        block8: {
                                            try {
                                                int n = v0.val$code;
                                                if (n != 108 && n != 401) break block8;
                                                break block9;
                                            }
                                            catch (Throwable throwable2) {
                                                break block10;
                                            }
                                            catch (Exception exception2) {
                                                break block11;
                                            }
                                        }
                                        for (EMConnectionListener eMConnectionListener : this.this$1.this$0.connectionListeners) {
                                            EMLog.d(EMClient.TAG, "MyConnectionListener onToken will expire, code: " + this.val$code);
                                            eMConnectionListener.onTokenWillExpire();
                                        }
                                        break block12;
                                    }
                                    3 v3 = this;
                                    v3.this$1.this$0.logout();
                                    for (EMConnectionListener eMConnectionListener : v3.this$1.this$0.connectionListeners) {
                                        EMLog.d(EMClient.TAG, "MyConnectionListener onToken has expired, code: " + this.val$code);
                                        eMConnectionListener.onTokenExpired();
                                    }
                                    break block12;
                                }
                                exception2.printStackTrace();
                                EMLog.e(EMClient.TAG, "MyConnectionListener onTokenNotification Exception: " + exception2.getMessage());
                            }
                            return;
                        }
                        throw throwable2;
                    }
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onReceiveToken(String token, long expireTimestamp) {
            void var1_2;
            void var2_3;
            if (!TextUtils.isEmpty((CharSequence)token) && var2_3 > 0L) {
                void var4_4 = var2_3 - System.currentTimeMillis();
                EMClient eMClient = ((MyConnectionListener)((Object)eMClient)).this$0;
                boolean bl = eMClient.mIsLoginWithToken;
                EMClient.access$500(eMClient, bl, String.valueOf((long)var2_3), (long)var4_4);
                EMLog.d(EMClient.TAG, "onReceiveToken: token: " + (String)var1_2 + " expireTimestamp: " + (long)var2_3 + " tokenAvailablePeriod: " + (long)var4_4);
                return;
            }
            EMLog.e(EMClient.TAG, "onReceiveToken: params received is invalid token: " + (String)var1_2 + " expireTimestamp: " + (long)var2_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onDatabaseOpened(int errCode) {
            void var1_1;
            EMLog.e(EMClient.TAG, "onDatabaseOpened: errCode: " + (int)var1_1);
            EMClient.access$602(this.this$0, true);
        }

        @Override
        public void onOfflineMessageSyncStart() {
            EMLog.e(EMClient.TAG, "MyConnectionListener onOfflineMessageSyncStart()");
            this.this$0.execute(new Runnable(this){
                final /* synthetic */ MyConnectionListener this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                }

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    v0 = this;
                    this = EMClient.access$300(v0.this$1.this$0);
                    synchronized (this) {
                        block10: {
                            block9: {
                                try lbl-1000:
                                // 3 sources

                                {
                                    for (EMConnectionListener v1 : EMClient.access$300(v0.this$1.this$0)) {
                                        ** GOTO lbl-1000
                                    }
                                    break block9;
                                }
                                catch (Throwable v2) {
                                    try {
                                        break block10;
                                    }
                                    catch (Exception v3) {
                                        var2_2 = v3;
                                        try {}
                                        catch (Throwable v2) {
                                            // empty catch block
                                            break block10;
                                        }
                                        v3.printStackTrace();
                                        EMLog.e("EMClient", "MyConnectionListener onOfflineMessageSyncStart Exception: " + var2_2.getMessage());
                                    }
                                }
lbl-1000:
                                // 1 sources

                                {
                                    v1.onOfflineMessageSyncStart();
                                }
                                ** GOTO lbl-1000
                            }
                            return;
                        }
                        throw v2;
                    }
                }
            });
        }

        @Override
        public void onOfflineMessageSyncFinish() {
            EMLog.e(EMClient.TAG, "MyConnectionListener onOfflineMessageSyncFinish()");
            this.this$0.execute(new Runnable(this){
                final /* synthetic */ MyConnectionListener this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                }

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    v0 = this;
                    this = EMClient.access$300(v0.this$1.this$0);
                    synchronized (this) {
                        block10: {
                            block9: {
                                try lbl-1000:
                                // 3 sources

                                {
                                    for (EMConnectionListener v1 : EMClient.access$300(v0.this$1.this$0)) {
                                        ** GOTO lbl-1000
                                    }
                                    break block9;
                                }
                                catch (Throwable v2) {
                                    try {
                                        break block10;
                                    }
                                    catch (Exception v3) {
                                        var2_2 = v3;
                                        try {}
                                        catch (Throwable v2) {
                                            // empty catch block
                                            break block10;
                                        }
                                        v3.printStackTrace();
                                        EMLog.e("EMClient", "MyConnectionListener onOfflineMessageSyncFinish Exception: " + var2_2.getMessage());
                                    }
                                }
lbl-1000:
                                // 1 sources

                                {
                                    v1.onOfflineMessageSyncFinish();
                                }
                                ** GOTO lbl-1000
                            }
                            return;
                        }
                        throw v2;
                    }
                }
            });
        }
    }

    class MyMultiDeviceListener
    extends EMAMultiDeviceListener {
        final /* synthetic */ EMClient this$0;

        /*
         * WARNING - void declaration
         */
        MyMultiDeviceListener(EMClient this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * Exception decompiling
         */
        private /* synthetic */ void lambda$onConversationEvent$1(int event, String conversationId, EMConversation.EMConversationType cType) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [5 : 58->69)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        private /* synthetic */ void lambda$onThreadEvent$0(int event, String target, List username) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [5 : 58->69)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onContactEvent(int event, String target, String ext) {
            void var3_3;
            void var2_2;
            void var1_1;
            EMLog.d(EMClient.TAG, "onContactEvent:" + (int)var1_1 + " target:" + (String)var2_2 + " ext:" + (String)var3_3);
            this.this$0.execute(new Runnable(){
                final /* synthetic */ int val$event;
                final /* synthetic */ String val$target;
                final /* synthetic */ String val$ext;
                final /* synthetic */ MyMultiDeviceListener this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                    this.val$event = n;
                    this.val$target = string;
                    this.val$ext = string2;
                }

                /*
                 * Loose catch block
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    1 v0 = this;
                    List list = v0.this$1.this$0.multiDeviceListeners;
                    synchronized (list) {
                        Throwable throwable2;
                        block7: {
                            block6: {
                                try {
                                    Iterator iterator = v0.this$1.this$0.multiDeviceListeners.iterator();
                                    while (iterator.hasNext()) {
                                        1 v1 = this;
                                        int n = v1.val$event;
                                        String string = v1.val$target;
                                        String string2 = v1.val$ext;
                                        ((EMMultiDeviceListener)iterator.next()).onContactEvent(n, string, string2);
                                    }
                                    break block6;
                                    catch (Throwable throwable2) {
                                        break block7;
                                    }
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                            return;
                        }
                        throw throwable2;
                    }
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onGroupEvent(int event, String target, List<String> usernames) {
            void var3_3;
            void var2_2;
            void var1_1;
            EMLog.d(EMClient.TAG, "onGroupEvent:" + (int)var1_1 + " target:" + (String)var2_2 + " usernames:" + var3_3);
            this.this$0.execute(new Runnable(){
                final /* synthetic */ int val$event;
                final /* synthetic */ String val$target;
                final /* synthetic */ List val$usernames;
                final /* synthetic */ MyMultiDeviceListener this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                    this.val$event = n;
                    this.val$target = string;
                    this.val$usernames = list;
                }

                /*
                 * Loose catch block
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    2 v0 = this;
                    List list = v0.this$1.this$0.multiDeviceListeners;
                    synchronized (list) {
                        Throwable throwable2;
                        block7: {
                            block6: {
                                try {
                                    Iterator iterator = v0.this$1.this$0.multiDeviceListeners.iterator();
                                    while (iterator.hasNext()) {
                                        2 v1 = this;
                                        int n = v1.val$event;
                                        String string = v1.val$target;
                                        List list2 = v1.val$usernames;
                                        ((EMMultiDeviceListener)iterator.next()).onGroupEvent(n, string, list2);
                                    }
                                    break block6;
                                    catch (Throwable throwable2) {
                                        break block7;
                                    }
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                            return;
                        }
                        throw throwable2;
                    }
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onRoamDeleteEvent(String conversation, List<String> msgIdList, String deviceId, long beforeTimeStamp) {
            void var4_4;
            void var2_2;
            void var3_3;
            void var1_1;
            EMLog.d(EMClient.TAG, "onRoamDeleteEvent:" + (String)var1_1 + " " + (String)var3_3);
            if (TextUtils.isEmpty((CharSequence)conversation)) {
                return;
            }
            this.this$0.execute(new Runnable(){
                final /* synthetic */ List val$msgIdList;
                final /* synthetic */ String val$conversation;
                final /* synthetic */ long val$beforeTimeStamp;
                final /* synthetic */ String val$deviceId;
                final /* synthetic */ MyMultiDeviceListener this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                    this.val$msgIdList = list;
                    this.val$conversation = string;
                    this.val$beforeTimeStamp = l;
                    this.val$deviceId = string2;
                }

                /*
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    v0 = this;
                    var1_1 = EMClient.access$700(v0.this$1.this$0);
                    synchronized (var1_1) {
                        block10: {
                            block12: {
                                block11: {
                                    try {
                                        var2_2 = v0.val$msgIdList;
                                        if (var2_2 != null) {
                                        }
                                        ** GOTO lbl-1000
                                    }
                                    catch (Throwable v1) {
                                        break block10;
                                    }
                                    catch (Exception v2) {
                                        break block11;
                                    }
                                    if (var2_2.size() > 0) {
                                        v3 = this;
                                        var2_2 = v3.val$conversation;
                                        EMClient.access$800(this.this$1.this$0).clearCaches((String)var2_2, v3.val$msgIdList);
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        v4 = this;
                                        var2_2 = v4.val$conversation;
                                        var3_3 = v4.val$beforeTimeStamp;
                                        EMClient.access$800(this.this$1.this$0).clearCaches((String)var2_2, var3_3);
                                    }
                                    var2_2 = EMClient.access$700(this.this$1.this$0).iterator();
                                    while (var2_2.hasNext()) {
                                        v5 = this;
                                        var3_4 = v5.val$conversation;
                                        ((EMMultiDeviceListener)var2_2.next()).onMessageRemoved(var3_4, v5.val$deviceId);
                                    }
                                    break block12;
                                }
                                v2.printStackTrace();
                            }
                            return;
                        }
                        throw v1;
                    }
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onThreadEvent(int event, String target, List<String> username) {
            void var3_3;
            void var2_2;
            void var1_1;
            EMLog.d(EMClient.TAG, "onThreadEvent:" + (int)var1_1 + " target:" + (String)var2_2 + " usernames:" + var3_3);
            this.this$0.execute(() -> this.lambda$onThreadEvent$0((int)var1_1, (String)var2_2, (List)var3_3));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onConversationEvent(int event, String conversationId, int type) {
            void var3_3;
            void var2_2;
            void var1_1;
            EMLog.d(EMClient.TAG, "onConversationEvent: " + (int)var1_1 + " conversationId: " + (String)var2_2 + " type: " + (int)var3_3);
            EMConversation.EMConversationType eMConversationType = EMConversation.EMConversationType.GroupChat;
            if (type != eMConversationType.ordinal()) {
                eMConversationType = EMConversation.EMConversationType.Chat;
            }
            this.this$0.execute(() -> this.lambda$onConversationEvent$1((int)var1_1, (String)var2_2, eMConversationType));
        }
    }

    class ClientLogListener
    extends EMALogCallbackListener {
        final /* synthetic */ EMClient this$0;

        /*
         * WARNING - void declaration
         */
        ClientLogListener(EMClient this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * Exception decompiling
         */
        private /* synthetic */ void lambda$onLogCallback$0(String log) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [5 : 53->64)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onLogCallback(String log) {
            void var1_1;
            this.this$0.logQueue.submit(() -> this.lambda$onLogCallback$0((String)var1_1));
        }
    }
}

