/************************************************************
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material is strictly forbidden unless prior written permission is obtained from EaseMob Technologies.
 */
package com.hyphenate.chat;

import android.os.Parcelable;

import com.hyphenate.chat.adapter.message.EMAMessageBody;

/**
 * \~chinese
 * 消息体基类。
 *
 * \~english
 * The message body base class.
 */
public abstract class EMMessageBody extends EMBase<EMAMessageBody> implements Parcelable {

    //public MimeType mimeType;
    /*
    public enum MimeType {
        TEXT_PLAIN, IMAGE, VIDEO, LOCATION, VOICE
    }*/

    /**
     * \~chinese
     * 获取最后一次消息修改的时间戳，单位为毫秒。
     * 
     * @return 消息最后一次修改的 UNIX 时间戳。
     *
     * \~english
     * Gets the UNIX timestamp of the last message modification, in milliseconds.
     * 
     * @return The UNIX timestamp of the last message modification.
     */
    public long operationTime() {
        if (emaObject != null) {
            return emaObject.operationTime();
        }
        return 0;
    }

    /**
     * \~chinese
     * 获取最后一次消息修改的操作者的用户 ID。
     * 
     * @return 最后一次消息修改的操作者的用户 ID。
     *
     * \~english
     * Gets the user ID of the operator that modified the message last time.
     * 
     * @return The user ID of the operator that modified the message last time.
     */
    public String operatorId() {
        if (emaObject != null) {
            return emaObject.operatorId();
        }
        return "";
    }

    /**
     * \~chinese
     * 获取消息修改次数。
     * 
     * 一条消息最多可以修改 5 次。
     * 
     * @return 消息修改次数。
     *
     * \~english
     * Gets the number of times a message is modified.
     * 
     * A message can be modified at most five times.
     * 
     * @return The number of times a message is modified.
     */
    public int operationCount() {
        if (emaObject != null) {
            return emaObject.operationCount();
        }
        return 0;
    }
}