package com.hyphenate.chat;

import android.support.annotation.NonNull;

import com.hyphenate.chat.EMConversation.EMMarkType;
import com.hyphenate.chat.adapter.EMAConversationFilter;

/**
 *  \~chinese
 * 会话过滤类。
 *
 *  \~english
 *  The conversation filter class.
 */
public class EMConversationFilter extends EMBase<EMAConversationFilter>{

    /**
     *  \~chinese
     *
     * 构造函数。
     *
     * @param markType 会话标记。
     *
     * @param pageSize 每页拉取的会话数。取值范围为 [1,10]。
     *
     *  \~english
     *
     * Constructor.
     *
     * @param markType The conversation mark.
     * @param pageSize The number of conversations to retrieve on each page. The value range is [1,10].
     */
    public EMConversationFilter(@NonNull EMMarkType markType,int pageSize) {
        emaObject =new EMAConversationFilter();
        setMarkType(markType);
        setPageSize(pageSize);
    }

    /**
     *  \~chinese
     *
     * 获取会话标记。
     *
     * @return 会话标记。
     *
     *  \~english
     *
     *  Gets the conversation mark.
     *
     *  @return The conversation mark.
     */
    public EMMarkType getMarkType() {
        return EMMarkType.values()[emaObject.getMarkType()];
    }

    /**
     *  \~chinese
     *
     * 设置会话标记。
     *
     * @param mMark 会话标记。
     *
     * \~english
     *
     *  Sets the conversation mark.
     *
     * @param mMark The conversation mark.
     */
    public void setMarkType(EMMarkType mMark) {
        emaObject.setMarkType(mMark.ordinal());
    }

    /**
     *  \~chinese
     *
     * 获取每页拉取的会话数。
     *
     * @return 每页拉取的会话数。
     *
     * \~english
     *
     * Gets the number of conversations to retrieve on each page.
     *
     * @return The number of conversations to retrieve on each page.
     *
     */
    public int getPageSize() {
        return emaObject.getPageSize();
    }

    /**
     *  \~chinese
     *
     * 设置每页拉取的会话数。
     *
     * @param mPageSize 每页拉取的会话数。取值范围为 [1,10]。
     *
     * \~english
     *
     * Sets the number of conversations to retrieve on each page.
     *
     * @param mPageSize The number of conversations to retrieve on each page. The value range is [1,10].
     */
    public void setPageSize(int mPageSize) {
        emaObject.setPageSize(mPageSize);
    }

}
