package com.hyphenate.chat;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;

import com.hyphenate.chat.adapter.message.EMACombineMessageBody;
import com.hyphenate.chat.adapter.message.EMAMessageBody;

import java.util.List;

public class EMCombineMessageBody extends EMFileMessageBody{

    public EMCombineMessageBody() {
        super(Uri.parse(""), EMAMessageBody.EMAMessageBodyTYPE_COMBINE);
        emaObject = new EMACombineMessageBody();
    }

    public EMCombineMessageBody(String title, String summary, String compatibleText, List<String> messageIdList) {
        this();
        ((EMACombineMessageBody)emaObject).setTitle(title);
        ((EMACombineMessageBody)emaObject).setSummary(summary);
        ((EMACombineMessageBody)emaObject).setCompatibleText(compatibleText);
        ((EMACombineMessageBody)emaObject).setMessageList(messageIdList);
    }

    public EMCombineMessageBody(EMACombineMessageBody body) {
        super(body);
    }

    /**
     * \~chinese
     * 设置合并消息的标题。
     * @param title 合并消息的标题。
     *
     * \~english
     * Sets the title of the combined message.
     * @param The title of the combined message.
     */
    public void setTitle(String title) {
        ((EMACombineMessageBody)emaObject).setTitle(title);
    }

    /**
     * \~chinese
     * 获取合并消息的标题。
     * @return  合并消息的标题。
     *
     * \~english
     * Gets the title of the combined message.
     * @return  The title of the combined message.
     */
    public String getTitle() {
        return ((EMACombineMessageBody)emaObject).getTitle();
    }

    /**
     * \~chinese
     * 设置合并消息的概要。
     * @param summary 概要
     *
     * \~english
     * Sets the summary of the combined message.
     * @param summary
     */
    public void setSummary(String summary) {
        ((EMACombineMessageBody)emaObject).setSummary(summary);
    }

    /**
     * \~chinese
     * 获取合并消息的概要。
     * @return 概要
     *
     * \~english
     * Gets the summary of the combined message.
     * @return The summary of the combined message.
     */
    public String getSummary() {
        return ((EMACombineMessageBody)emaObject).getSummary();
    }

    /**
     * \~chinese
     * 设置合并消息的兼容文本。
     *
     * 兼容文本起到向下兼容不支持消息合并转发的版本的作用。当支持合并消息的高版本 SDK 向不支持合并消息的低版本 SDK 发送消息时，低版本的 SDK 会将该属性解析为文本消息的消息内容。
     *
     * @param compatibleText 兼容低版本的文本内容。
     *
     * \~english
     * Sets the compatible text of the combined message.
     *
     * The compatible text is used to be compatible with versions that do not support combined messages. 
     * Specifically, when an SDK sends a combined message to an SDK that does not support this feature, 
     * the latter SDK will parse the compatible text as the content of a text message when receiving the combined message.
     *
     * @param compatibleText The compatible text of the combined message.
     */
    public void setCompatibleText(String compatibleText) {
        ((EMACombineMessageBody)emaObject).setCompatibleText(compatibleText);
    }

    /**
     * \~chinese
     * 获取兼容文本内容。
     * @return 兼容低版本的文本内容。
     *
     * \~english
     * Gets the compatible text of the combined message.
     * @return The compatible text of the combined message.
     */
    public String getCompatibleText() {
        return ((EMACombineMessageBody)emaObject).getCompatibleText();
    }

    /**
     * \~chinese
     * 设置要合并的消息列表。
     * @param messageList 消息 ID 列表。列表不可为 `null` 或者空, 最多可包含 300 个消息 ID。
     *
     * \~english
     * Sets the list of IDs of messages to be combined.
     * @param messageList A list of IDs of messages to be combined. The list cannot be `null` or empty. It can contain a maximum of 300 message IDs.
     */
    public void setMessageList(List<String> messageList) {
        ((EMACombineMessageBody)emaObject).setMessageList(messageList);
    }

    @Override
    public String toString() {
        return "combine: " + ((EMACombineMessageBody)emaObject).getTitle() +
                ", summary: " + ((EMACombineMessageBody)emaObject).getSummary() +
                ", compatibleText: " + ((EMACombineMessageBody)emaObject).getCompatibleText() +
                ", localurl: " + ((EMACombineMessageBody)emaObject).getLocalUrl() +
                ", remoteurl: " + ((EMACombineMessageBody)emaObject).getRemoteUrl();
    }

    public static final Parcelable.Creator<EMCombineMessageBody> CREATOR
            = new Parcelable.Creator<EMCombineMessageBody>() {
        public EMCombineMessageBody createFromParcel(Parcel in) {
            return new EMCombineMessageBody(in);
        }

        public EMCombineMessageBody[] newArray(int size) {
            return new EMCombineMessageBody[size];
        }
    };

    private EMCombineMessageBody(Parcel in) {
        super((Uri) null, EMAMessageBody.EMAMessageBodyTYPE_COMBINE);
        ((EMACombineMessageBody)emaObject).setDisplayName(in.readString());
        ((EMACombineMessageBody)emaObject).setLocalPath(in.readString());
        ((EMACombineMessageBody)emaObject).setRemotePath(in.readString());
        ((EMACombineMessageBody)emaObject).setSecretKey(in.readString());

        ((EMACombineMessageBody) emaObject).setTitle(in.readString());
        ((EMACombineMessageBody) emaObject).setSummary(in.readString());
        ((EMACombineMessageBody) emaObject).setCompatibleText(in.readString());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(((EMACombineMessageBody)emaObject).displayName());
        dest.writeString(((EMACombineMessageBody)emaObject).getLocalUrl());
        dest.writeString(((EMACombineMessageBody)emaObject).getRemoteUrl());
        dest.writeString(((EMACombineMessageBody)emaObject).getSecret());

        dest.writeString(((EMACombineMessageBody)emaObject).getTitle());
        dest.writeString(((EMACombineMessageBody)emaObject).getSummary());
        dest.writeString(((EMACombineMessageBody)emaObject).getCompatibleText());
    }
}
