/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.hyphenate.util.EMLog;
import java.util.Map;
import java.util.UUID;

public class DeviceUuidFactory {
    protected static final String PREFS_FILE = "device_id.xml";
    protected static final String PREFS_DEVICE_ID = "device_id";
    protected static final String PREFS_DEVICE_ID_BAK_FILE = "prefs_device_id_bak";
    protected static final String PREFS_DEVICE_ID_BAK = "device_id_bak";
    protected static UUID uuid;

    /*
     * WARNING - void declaration
     */
    public DeviceUuidFactory(Context context) {
        if (uuid == null) {
            void var1_1;
            SharedPreferences sharedPreferences = var1_1.getSharedPreferences(PREFS_FILE, 0);
            String string = sharedPreferences.getString(PREFS_DEVICE_ID, null);
            if (string != null) {
                uuid = UUID.fromString(string);
            } else {
                EMLog.e("DeviceUuidFactory", "Need to generate device uuid");
                uuid = this.generateDeviceUuid((Context)var1_1);
                sharedPreferences.edit().putString(PREFS_DEVICE_ID, uuid.toString()).commit();
            }
        }
    }

    private UUID generateDeviceUuid(Context context) {
        return UUID.randomUUID();
    }

    private static boolean isEmpty(Object s) {
        Object object;
        if (s == null) {
            return true;
        }
        if (object instanceof String && ((String)object).trim().length() == 0) {
            return true;
        }
        if (object instanceof Map) {
            return ((Map)object).isEmpty();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static void saveBakDeviceId(Context context, String deviceId) {
        void var1_1;
        if (context != null && !TextUtils.isEmpty((CharSequence)var1_1)) {
            Context context2;
            EMLog.e("DeviceUuidFactory", "saveBakDeviceId");
            context2.getSharedPreferences(PREFS_DEVICE_ID_BAK_FILE, 0).edit().putString(PREFS_DEVICE_ID_BAK, (String)var1_1).commit();
            return;
        }
    }

    public static String getBakDeviceId(Context context) {
        Context context2;
        if (context == null) {
            return "";
        }
        return context2.getSharedPreferences(PREFS_DEVICE_ID_BAK_FILE, 0).getString(PREFS_DEVICE_ID_BAK, "");
    }

    public UUID getDeviceUuid() {
        return uuid;
    }
}

