/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat.adapter.message;

import java.util.List;
import java.util.Map;

public class EMATextMessageBody extends EMAMessageBody {
	
	public String text() {
		return nativeText();
	}

	public void setText(String text) {
		nativeSetText(text);
	}


	public EMATextMessageBody(String text) {
		nativeInit(text);
	}
	
	public EMATextMessageBody(EMATextMessageBody body) {
		nativeInit(body);
	}
	
	// used by jni_util.cpp: getJObject
	private EMATextMessageBody() {
		nativeInit("");
	}
	
	@Override
	public void finalize() throws Throwable {
		nativeFinalize();
		super.finalize();
	}
	
	native String nativeText();

	native void nativeSetText(String text);
	native void nativeInit(String text);
	native void nativeInit(EMATextMessageBody body);
	native void nativeFinalize();

	public void setTargetLanguages(List<String> list){
		nativeSetTargetLanguages(list); ;
	}
	native void nativeSetTargetLanguages(List<String> list);

	public List<String> getTargetLanguages(){
		return nativeGetTargetLanguages();
	}
	native List<String> nativeGetTargetLanguages();

	public Map<String, String> getTranslations(){

		return nativeGetTranslations();
	}
	native Map<String, String> nativeGetTranslations();
}
