/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat.adapter;

import java.util.List;
import java.util.Map;

/**
 * Created by wei on 2016/12/1.
 */

public class EMAPushManager extends EMABase{
    public void enableOfflineNotification(EMAError error){
        nativeEnableOfflineNotification(error);
    }
    public void disableOfflineNotification(int start, int end, EMAError error){
        nativeDisableOfflineNotification(start, end, error);
    }

    public void updatePushServiceForGroup(List<String> groupIds, boolean noPush, EMAError error){
        nativeUpdatePushServiceForGroup(groupIds, noPush, error);
    }
    public void updatePushServiceForUsers(List<String> userIds, boolean noPush, EMAError error) {
         nativeUpdatePushServiceForUsers(userIds,noPush,error);
    }

    public List<String> getNoPushGroups(){
        return nativeGetNoPushGroups();
    }

    public List<String> getNoPushUsers() {
        return nativeGetNoPushUsers();
    }

    public EMAPushConfigs getPushConfigs(){
        return nativeGetPushConfigs();
    }

    public EMAPushConfigs getPushConfigsFromServer(EMAError error){
        return nativeGetPushConfigsFromServer(error);
    }

    public void updatePushNickname(String nickname, EMAError error) {
        nativeUpdatePushNickname(nickname, error);
    }

    public void updatePushDisplayStyle(int style, EMAError error) {
        nativeUpdatePushDisplayStyle(style, error);
    }

    public void reportPushAction(String parameters, EMAError error) {
        nativeReportPushAction(parameters, error);
    }

    native void nativeEnableOfflineNotification(EMAError error);
    native void nativeDisableOfflineNotification(int start, int end, EMAError error);

    native void nativeUpdatePushServiceForGroup(List<String> groupIds, boolean disable, EMAError error);
    native List<String> nativeGetNoPushGroups();

    native  void nativeUpdatePushServiceForUsers(List<String> userIds, boolean noPush, EMAError error);
    native List<String> nativeGetNoPushUsers();

    native EMAPushConfigs nativeGetPushConfigs();
    native EMAPushConfigs nativeGetPushConfigsFromServer(EMAError error);

    native void nativeUpdatePushNickname(String nickname, EMAError error);
    native void nativeUpdatePushDisplayStyle(int style, EMAError error);
    native void nativeReportPushAction(String style, EMAError error);

    public EMASilentModeItem setSilentModeForAll(EMASilentModeParam param, EMAError error){
        return nativeSetSilentModeForAll(param, error);
    }
    native EMASilentModeItem nativeSetSilentModeForAll(EMASilentModeParam param, EMAError error);

    public EMASilentModeItem getSilentModeForAll(EMAError error){
        return nativeGetSilentModeForAll(error);
    }
    native EMASilentModeItem nativeGetSilentModeForAll(EMAError error);

    public EMASilentModeItem setSilentModeForConversation(String conversationId, int conversationType, EMASilentModeParam param, EMAError error){
        return nativeSetSilentModeForConversation(conversationId, conversationType, param, error);
    }
    native EMASilentModeItem nativeSetSilentModeForConversation(String conversationId, int conversationType, EMASilentModeParam param, EMAError error);

    public void clearRemindTypeForConversation(String conversationId, int conversationType, EMAError error){
        nativeClearRemindTypeForConversation(conversationId, conversationType, error);
    }
    native void nativeClearRemindTypeForConversation(String conversationId, int conversationType, EMAError error);

    public EMASilentModeItem getSilentModeForConversation(String conversationId, int conversationType, EMAError error){
        return nativeGetSilentModeForConversation(conversationId, conversationType, error);
    }
    native EMASilentModeItem nativeGetSilentModeForConversation(String conversationId, int conversationType, EMAError error);


    public List<EMASilentModeItem> getSilentModeForConversations(Map<String, String> idMap, EMAError error){
        return nativeGetSilentModeForConversations(idMap, error);
    }
    native List<EMASilentModeItem> nativeGetSilentModeForConversations(Map<String, String> idMap, EMAError error);

    public void setPushPerformLanguage(String languageCode, EMAError error){
        nativeSetPushPerformLanguage(languageCode, error);
    }
    native void nativeSetPushPerformLanguage(String languageCode, EMAError error);

    public String getPushPerformLanguage(EMAError error){
        return nativeGetPushPerformLanguage(error);
    }
    native String nativeGetPushPerformLanguage(EMAError error);

    public void setPushTemplate(String templateName, EMAError error){
        nativeSetPushTemplate(templateName, error);
    }
    native void nativeSetPushTemplate(String templateName, EMAError error);

    public String getPushTemplate(EMAError error){
        return nativeGetPushTemplate(error);
    }
    native String nativeGetPushTemplate(EMAError error);

    public void syncSilentModeConversationsFromServer(EMAError error) {
        nativeSyncSilentModeConversationsFromServer(error);
    }

    native void nativeSyncSilentModeConversationsFromServer(EMAError error) ;
}
