/************************************************************
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat;

import android.os.Parcel;
import android.os.Parcelable;

import com.hyphenate.chat.adapter.message.EMATextMessageBody;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * \~chinese
 * 文本消息体。
 * 
 * ```java
 *     EMTextMessageBody body = new EMTextMessageBody("hello hyphenate chat sdk!");
 * ```
 *
 * \~english
 * The text message body.
 * 
 * ```java
 *     EMTextMessageBody body = new EMTextMessageBody("hello hyphenate chat sdk!");
 * ```
 */
public class EMTextMessageBody extends EMMessageBody implements Parcelable {

    /**
     * \~chinese
     * 创建一个文本消息体。
     *
     * @param msg 消息内容。
     *
     * \~english
     * Creates a text message body.
     *
     * @param msg The text content.
     */
    public EMTextMessageBody(String msg) {
        emaObject = new EMATextMessageBody(msg);
    }

    EMTextMessageBody(EMATextMessageBody body) {
        emaObject = body;
    }

    /**
     * \~chinese
     * 获取文本消息内容。
     *
     * @return  消息内容。
     *
     * \~english
     * Gets the text message body.
     *
     * @return  The text content.
     */
    public String getMessage() {
        return ((EMATextMessageBody) emaObject).text();
    }

    /**
     * \~chinese
     * 设置文本消息内容。
     * 注：只能修改本地数据。
     *
     * @param message 消息内容。
     *
     * \~english
     * Sets the text message body's content.
     * @Note: you can only modify the local data.
     *
     * @param message The text content.
     */
    public void setMessage(String message) {
        ((EMATextMessageBody) emaObject).setText(message);
    }

    public String toString() {
        return "txt:\"" + ((EMATextMessageBody) emaObject).text() + "\"";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(((EMATextMessageBody) emaObject).text());
    }

    public static final Parcelable.Creator<EMTextMessageBody> CREATOR
            = new Parcelable.Creator<EMTextMessageBody>() {
        public EMTextMessageBody createFromParcel(Parcel in) {
            return new EMTextMessageBody(in);
        }

        public EMTextMessageBody[] newArray(int size) {
            return new EMTextMessageBody[size];
        }
    };

    private EMTextMessageBody(Parcel in) {
        emaObject = new EMATextMessageBody(in.readString());
    }

    /**
     * \~chinese
     * 译文结构体
     *
     * \~english
     * Translation structure
     *
     */
    public static class EMTranslationInfo{
        public String languageCode; /** \~chinese 译文语种  \~english The languages */
        public String translationText; /** \~chinese 译文文本  \~english The translation text */

        public EMTranslationInfo(String languageCode, String translationText){
            this.languageCode = languageCode;
            this.translationText = translationText;
        }
    }


    /**
     * \~chinese
     * 设置翻译的目标语言
     * @param languageList 语言代码列表
     *
     * \~english
     * Set the target language for translation
     * @param languageList Language code list
     *
     */
    public void setTargetLanguages(List<String> languageList){
        ((EMATextMessageBody)emaObject).setTargetLanguages(languageList);
    }

    /**
     * \~chinese
     * 获取翻译的目标语言
     * @return 语言code列表
     *
     * \~english
     * Get the target language for translation
     * @return Language code list
     *
     */
    public List<String> getTargetLanguages(){
        return ((EMATextMessageBody)emaObject).getTargetLanguages();
    }

    /**
     * \~chinese
     * 获取译文列表
     *
     * @return 译文信息列表
     *
     * \~english
     * Get the translation list
     *
     * @return Translation information list
     */
    public List<EMTranslationInfo> getTranslations(){
        Map<String, String> result = ((EMATextMessageBody)emaObject).getTranslations();
        List<EMTranslationInfo> translations = new ArrayList<>();
        for(String key : result.keySet()){
            translations.add(new EMTranslationInfo(key, result.get(key)));
        }
        return translations;
    }

}
