/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat;

import com.hyphenate.EMValueCallBack;
import com.hyphenate.chat.adapter.EMAPushConfigs;

/**
 * \~chinese
 * 推送配置信息类。
 * 
 * \~english
 * The push configuration class.
 */
public class EMPushConfigs extends EMBase<EMAPushConfigs>{

    public EMPushConfigs(EMAPushConfigs pushConfigs){
        emaObject = pushConfigs;
    }


    /**
     * \~chinese
     * 获取通知栏中显示的推送昵称。
     * 
     * @return  推送昵称。
     *
     * \~english
     * Gets the nickname of the notification sender displayed in the notification bar.
     * 
     * @return The nickname of the notification sender displayed in the notification bar.
     */
    public String getDisplayNickname() {
        return emaObject.getDisplayNickname();
    }

    /**
     * \~chinese
     * 获取离线推送展示类型。
     * 
     * @return  离线推送展示类型。
     *
     * \~english
     * Gets the display style of offline push notifications.
     * 
     * @return The display style of offline push notifications.
     */
    public EMPushManager.DisplayStyle getDisplayStyle() {
        return EMPushManager.DisplayStyle.values()[emaObject.getDisplayStyle()];
    }
}
