/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate;

import com.hyphenate.chat.EMChatThreadEvent;

/**
 * \~chinese
 * 子区事件监听接口，监听子区相关事件，例如子区的创建及退出等事件。
 * <pre>
 *     注册子区事件监听器：
 *     EMClient.getInstance().chatThreadManager().addChatThreadChangeListener(mChatThreadChangeListener);
 *
 *     移除子区事件监听器：
 *     EMClient.getInstance().chatThreadManager().removeChatThreadChangeListener(mChatThreadChangeListener);
 * </pre>
 *
 * \~english
 * The message thread listener interface, which listens for message thread events such as creating or leaving a message thread.
 *
 * <pre>
 *     Adds a message thread event listener:
 *     EMClient.getInstance().chatThreadManager().addChatThreadChangeListener(mChatThreadChangeListener);
 *
 *     Removes a message thread event listener:
 *     EMClient.getInstance().chatThreadManager().removeChatThreadChangeListener(mChatThreadChangeListener);
 * </pre>
 */
public interface EMChatThreadChangeListener {

	/**
	 * \~chinese
	 * 子区创建回调。
	 *
	 * 子区所属群组的所有成员均可收到该回调。
	 *
	 * \~english
	 * Occurs when a message thread is created.
	 *
	 * Each member of the group to which the message thread belongs can receive the callback.
	 */
	void onChatThreadCreated(EMChatThreadEvent event);

	/**
	 * \~chinese
	 * 子区更新回调。
	 *
	 * 修改子区名称或子区中添加或撤销回复消息时会触发该回调。
	 *
	 * 子区所属群组的所有成员均可收到该回调。
	 *
	 * \~english
	 * Occurs when a message thread is updated.
	 *
	 * This callback is triggered when the message thread name is changed or a threaded reply is added or recalled.
	 *
	 * Each member of the group to which the message thread belongs can receive the callback.
	 */
	void onChatThreadUpdated(EMChatThreadEvent event);

	/**
	 * \~chinese
	 * 子区解散回调。
	 *
	 * 子区所属群组的所有成员均可收到该回调。
	 *
	 * \~english
	 * Occurs when a message thread is destroyed.
	 *
	 * Each member of the group to which the message thread belongs can receive the callback.
	 */
	void onChatThreadDestroyed(EMChatThreadEvent event);

	/**
	 * \~chinese
	 * 当前登录用户被群主或群管理员移出子区。
	 *
	 * \~english
	 * Occurs when the current user is removed from the message thread by the group owner or a group admin to which the message thread belongs.
	 */
	void onChatThreadUserRemoved(EMChatThreadEvent event);

}