package com.hyphenate.notification.core;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.support.v4.app.NotificationManagerCompat;

import com.hyphenate.util.EMLog;

class EMNotificationCancelReceiver extends BroadcastReceiver {
    @Override
    public void onReceive(Context context, Intent intent) {
        EMLog.d("cancelReceiver", "onReceive");
        if (intent == null) {
            return;
        }
        int notifyId = intent.getIntExtra("notifyId", -1);
        if (notifyId > -1) {
            final NotificationManagerCompat notificationManager = NotificationManagerCompat.from(context.getApplicationContext());
            notificationManager.cancel(String.valueOf(notifyId), notifyId);
        }
    }
}
