/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat.adapter.message;

public class EMALocationMessageBody extends EMAMessageBody {
	public double latitude;
	public double longitude;
	public String address;
	public String buildingName;

	public EMALocationMessageBody(double latitude, double longitude, String address, String buildingName) {
		nativeInit(latitude, longitude, address, buildingName);
	}
	
	public  EMALocationMessageBody( EMALocationMessageBody body) {
		nativeInit(body);
	}
	
	// used by jni_util.cpp: getJObject
	private EMALocationMessageBody() {
		nativeInit(0.0f, 0.0f, "", "");
	}

	/**
	 * \brief Get latitude.
	 *
	 * @param  NA
	 * @return The latitude.
	 */
	public double latitude() {
		return nativelatitude();
	}
	native double nativelatitude();

	/**
	 * \brief Get longitude.
	 *
	 * @param  NA
	 * @return The longitude.
	 */
	public double longitude() {
		return nativelongitude();
	}
	native double nativelongitude();

	/**
	 * \brief Get address.
	 *
	 * @param  NA
	 * @return The address.
	 */
	public String address() {
		return nativeaddress();
	}
	native String nativeaddress();

	/**
	 * \brief Get buildingName.
	 *
	 * @param  NA
	 * @return The buildingName.
	 */
	public String buildingName(){
		return nativebuildingName();
	}
	native String nativebuildingName();

	/**
	 * \brief Set latitude.
	 *
	 * @param latitude
	 * @return NA
	 */
	public void setLatitude(double val) {
		nativesetLatitude(val);
	}
	native void nativesetLatitude(double val);

	/**
	 * \brief Set longitude.
	 *
	 * @param longitude
	 * @return NA
	 */
	public void setLongitude(double val) {
		nativesetLongitude(val);
	}
	native void nativesetLongitude(double val);

	/**
	 * \brief Set address.
	 *
	 * @param address
	 * @return NA
	 */
	public void setAddress(String val) {
		nativesetAddress(val);
	}
	native void nativesetAddress(String val);

	/**
	 * \brief Set buildingName.
	 *
	 * @param buildingName
	 * @return NA
	 */
	public void setBuildingName(String val){
		nativesetBuildingName(val);
	}
	native void nativesetBuildingName(String val);

	@Override
	public void finalize() throws Throwable {
		nativeFinalize();
		super.finalize();
	}

	native void nativeInit(double latitude, double longtitude, String address, String buildingName);
	native void nativeInit(EMALocationMessageBody body);
	native void nativeFinalize();
}
