/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat.adapter;

import com.hyphenate.chat.EMConversation;
import com.hyphenate.chat.EMCursorResult;
import com.hyphenate.chat.adapter.message.EMAMessage;
import com.hyphenate.chat.adapter.message.EMAMessageBody;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EMAChatManager extends EMABase {
	
	// used to keep reference of listener, JNI part will not track the reference
	// that's to avoid GC listeners.
	private Set<EMAChatManagerListener> listeners = new HashSet<EMAChatManagerListener>();
	
    public void sendMessage(EMAMessage msg) {
    	nativeSendMessage(msg);	
    }
    
    public void recallMessage(EMAMessage msg, String ext, EMAError error)
    {
        nativeRecallMessage(msg,ext,error);
    }

    public void sendReadAckForConversation(String conversationId, EMAError error) {
        nativeSendReadAckForConversation(conversationId, error);
    }

    public void sendReadAckForMessage(EMAMessage msg)
    {
    	nativeSendReadAckForMessage(msg);
    }
    public void sendReadAckForGroupMessage(EMAMessage msg, String ext) {nativeSendReadAckForGroupMessage(msg, ext); }

    public void resendMessage(EMAMessage msg)
    {
    	 nativeResendMessage(msg);
    }
    
    public void downloadMessageThumbnail(EMAMessage msg)
    {
    	nativeDownloadMessageThumbnail(msg);
    }
    
    public void downloadMessageAttachments(EMAMessage msg)
    {
    	nativeDownloadMessageAttachments(msg);
    }
 
    public void removeConversation(String conversationId, boolean isRemoveMessages, boolean isThread)
    {
    	nativeRemoveConversation(conversationId, isRemoveMessages, isThread);
    }

    public EMAError deleteConversationFromServer(String conversationId,EMAConversation.EMAConversationType type, boolean isDeleteServerMessages)
    {
        return nativeDeleteConversationFromServer(conversationId, type.ordinal(), isDeleteServerMessages);
    }

    public EMAConversation conversationWithType(String conversationId,
    		EMAConversation.EMAConversationType type, boolean createIfNotExist, boolean isThread)
    {
    	return nativeConversationWithType(conversationId, type.ordinal(), createIfNotExist, isThread);
    }
    
    public List<EMAConversation> getConversations()
    {
    	return nativeGetConversations();
    }

    public List<EMAConversation> fetchConversationsFromServer(EMAError error) {
        return nativeFetchConversationsFromServer(error);
    }

    public List<EMAConversation> fetchConversationsFromServerWithPage(EMAError error, int pageNum, int pageSize) {
        return nativeFetchConversationsFromServerWithPage(error, pageNum, pageSize);
    }

    public List<EMAConversation> loadAllConversationsFromDB()
    {
    	return nativeLoadAllConversationsFromDB();
    }
    
    public void addListener(EMAChatManagerListener listener)
    {
    	listeners.add(listener);
    	nativeAddListener(listener);
    }
    
    public void removeListener(EMAChatManagerListener listener)
    {
    	listeners.remove(listener);
    	nativeRemoveListener(listener);
    }
    
    public void clearListeners()
    {
    	listeners.clear();
    	nativeClearListeners();
    }
    
    public void setEncryptProvider(EMAEncryptProviderInterface provider)
    {
    	nativeSetEncryptProvider(provider);
    }
    
    public EMAEncryptProviderInterface getEncryptProvider(boolean createIfNotExist)
    {
    	return nativeGetEncryptProvider(createIfNotExist);
    }
    
    public EMAMessage getMessage(final String messageId) {
    	return nativeGetMessage(messageId);
    }

    public EMAMessage getMessage(final long nativeHandler) {
        return nativeGetMessageByHandler(nativeHandler);
    }
    
    public void uploadLog() {
        nativeUploadLog();
    }

    public EMAError deleteRoamMsgFromServerById(String conversationId, EMConversation.EMConversationType type, List<String> msgIdList)
    {
        return nativeDeleteRoamMsgFromServerById(conversationId, type.ordinal(), msgIdList);
    }

    public EMAError deleteRoamMsgFromServerByTime(String conversationId, EMConversation.EMConversationType type, long startTimeStamp)
    {
        return nativeDeleteRoamMsgFromServerByTime(conversationId, type.ordinal(), startTimeStamp);
    }

    native void nativeSendMessage(EMAMessage msg);

    native void nativeRecallMessage(EMAMessage msg, String ext, EMAError error);

    native void nativeSendReadAckForConversation(String conversationId, EMAError error);
    
    native void nativeSendReadAckForMessage(EMAMessage msg);

    native void nativeSendReadAckForGroupMessage(EMAMessage msg, String ext);

    native void nativeResendMessage(EMAMessage msg);
    
    native void nativeDownloadMessageThumbnail(EMAMessage msg);
    
    native void nativeDownloadMessageAttachments(EMAMessage msg);
 
    native void nativeRemoveConversation(String conversationId, boolean isRemoveMessages, boolean isThread);

    native EMAError nativeDeleteConversationFromServer(String conversationId,int conversationType, boolean isDeleteServerMessages);

    native EMAConversation nativeConversationWithType(String conversationId,
    		int conversationType, boolean createIfNotExist, boolean isThread);
    
    native List<EMAConversation> nativeGetConversations();

    native List<EMAConversation> nativeFetchConversationsFromServer(EMAError error);

    native List<EMAConversation> nativeFetchConversationsFromServerWithPage(EMAError error, int pageNum, int pageSize);
    
    native List<EMAConversation> nativeLoadAllConversationsFromDB();
    
    native void nativeAddListener(EMAChatManagerListener listener);
    
    native void nativeRemoveListener(EMAChatManagerListener listener);
    
    native void nativeClearListeners();
    
    native void nativeSetEncryptProvider(EMAEncryptProviderInterface provider);
    
    native EMAEncryptProviderInterface nativeGetEncryptProvider(boolean createIfNotExist);
    
    native EMAMessage nativeGetMessage(String messageId);

    native EMAMessage nativeGetMessageByHandler(long nativeHandler);

    native void nativeUploadLog();
    
    protected EMAChatManager() {}
    
    protected EMAChatManager(EMAChatManager manager) {
        nativeInit(manager);
    }
    native void nativeInit(EMAChatManager manager);

    public boolean updateParticipant(String from, String changeTo) {
        return nativeUpdateParticipant(from, changeTo);
    }
    native boolean nativeUpdateParticipant(String from, String changeTo);

    public EMCursorResult<EMAGroupReadAck> fetchGroupReadAcks(String msgId, String groupId, EMAError error, int pageSize, String startAckId) {
        return nativeFetchGroupReadAcks(msgId, groupId, error, pageSize, startAckId);
    }

    public EMCursorResult<EMAMessage> fetchHistoryMessages(String conversationId, int type, int pageSize,
                                     String startMsgId, EMAConversation.EMASearchDirection direction, EMAError error) {
        return nativeFetchHistoryMessages(conversationId, type, pageSize, startMsgId, direction.ordinal(), error);
    }

    public EMCursorResult<EMAMessage> fetchHistoryMessages(String conversationId, int type, int pageSize, String cursor,
                                                           EMAFetchMessageOption option, EMAError error) {
        return nativeFetchHistoryMessagesByOption(conversationId, type, pageSize, cursor,option, error);
    }

    native EMCursorResult<EMAGroupReadAck> nativeFetchGroupReadAcks(String msgId, String groupId, EMAError error, int pageSize, String startAckId);

    native EMCursorResult<EMAMessage> nativeFetchHistoryMessages(String conversationId, int type, int pageSize,
                                                                 String startMsgId, int direction, EMAError error);

    native EMCursorResult<EMAMessage> nativeFetchHistoryMessagesByOption(String conversationId, int type, int pageSize, String cursor,
                                                                 EMAFetchMessageOption option, EMAError error);
    public List<EMAMessage> searchMessages(int type, long timeStamp, int maxCount, String from, EMAConversation.EMASearchDirection direction) {
        return nativeSearchMessages(type, timeStamp, maxCount, from, direction.ordinal());
    }
    public List<EMAMessage> searchMessages(String keywords, long timeStamp, int maxCount, String from, EMAConversation.EMASearchDirection direction) {
        return nativeSearchMessages(keywords, timeStamp, maxCount, from, direction.ordinal());
    }
    public List<EMAMessage> searchMessages(String keywords, long timeStamp, int maxCount, String from, int direction,int scope) {
        return nativeSearchMessages(keywords, timeStamp, maxCount, from, direction,scope);
    }
    native List<EMAMessage> nativeSearchMessages(int type, long timeStamp, int count, String from, int direction);
    native List<EMAMessage> nativeSearchMessages(String keywords, long timeStamp, int count, String from, int direction);
    native List<EMAMessage> nativeSearchMessages(String keywords, long timeStamp, int count, String from, int direction,int scope);

    public boolean removeMessagesBeforeTimestamp(long timeStamp){
        return nativeRemoveMessagesBeforeTimestamp(timeStamp);
    }
    native boolean nativeRemoveMessagesBeforeTimestamp(long timeStamp);

    public void reportMessage(String msgId, String reportTarget, String reportReason, EMAError error){
        nativeReportMessage(msgId, reportTarget, reportReason, error);
    }
    native void nativeReportMessage(String msgId, String reportTarget, String reportReason, EMAError error);

    public List<List<String>> fetchSupportLanguages(EMAError error){

        return nativeFetchSupportLanguages(error);
    }
    native List<List<String>> nativeFetchSupportLanguages(EMAError error);

    public EMAMessage translateMessage(EMAMessage msg, List<String> languages, EMAError error){

        return nativeTranslateMessage(msg, languages, error);
    }
    native EMAMessage nativeTranslateMessage(EMAMessage msg, List<String> languages, EMAError error);
    native EMAError nativeDeleteRoamMsgFromServerById(String conversationId,int conversationType,List<String> msgIdList);
    native EMAError nativeDeleteRoamMsgFromServerByTime(String conversationId,int conversationType,long startTimeStamp);
    public EMAMessage modifyMessage(String messageId, EMAMessageBody body,EMAError error) {
       return nativeModifyMessage(messageId,body,error);
    }
    native EMAMessage nativeModifyMessage(String messageId, EMAMessageBody body,EMAError error);

    public EMCursorResult<EMAConversation> fetchPinnedConversationsFromServer(int limit, String cursor, EMAError error) {
        return nativeFetchPinnedConversationsFromServer(limit, cursor, error);
    }
    native EMCursorResult<EMAConversation> nativeFetchPinnedConversationsFromServer(int limit, String cursor, EMAError error);


    public EMCursorResult<EMAConversation> fetchConversationsFromServerWithCursor(int limit, String cursor, EMAError error) {
        return nativeFetchConversationsFromServerWithCursor(limit, cursor, error);
    }
    native EMCursorResult<EMAConversation> nativeFetchConversationsFromServerWithCursor(int limit, String cursor, EMAError error);

    public void pinConversation(String conversationId, boolean isPinned, EMAError error) {
        nativePinConversation(conversationId, isPinned, error);
    }
    native void nativePinConversation(String conversationId, boolean isPinned, EMAError error);

    public List<EMAConversation> getAllConversationsBySort() {
        return nativeGetAllConversationsBySort();
    }
    native List<EMAConversation> nativeGetAllConversationsBySort();

    public List<EMAMessage> downloadCombineMessages(EMAMessage message, EMAError error) {
        return nativeDownloadCombineMessages(message, error);
    }
    native List<EMAMessage> nativeDownloadCombineMessages(EMAMessage message, EMAError error);

    public void addConversationMark(List<String> conversationIds, int ordinal, EMAError error) {
        nativeAddConversationMark(conversationIds, ordinal, error);
    }

    native void nativeAddConversationMark(List<String> conversationIds, int ordinal, EMAError error) ;

    public void removeConversationMark(List<String> conversationIds, int ordinal, EMAError error) {
        nativeRemoveConversationMark(conversationIds, ordinal, error);
    }

    native void nativeRemoveConversationMark(List<String> conversationIds, int ordinal, EMAError error) ;

    public EMCursorResult<EMAConversation> getConversationsFromServerWithCursor(String cursor, EMAConversationFilter filter, EMAError error) {
      return nativeGetConversationsFromServerWithCursor(cursor,filter,error);
    }

    native EMCursorResult<EMAConversation> nativeGetConversationsFromServerWithCursor(String cursor, EMAConversationFilter filter, EMAError error) ;

    public void asyncDeleteAllMsgsAndConversations(boolean clearSeverData, EMAError error) {
        nativeAsyncDeleteAllMsgsAndConversations(clearSeverData,error);
    }
    native void nativeAsyncDeleteAllMsgsAndConversations(boolean clearSeverData, EMAError error);

    public void pinMessage(String messageId, boolean isPinned, EMAError error) {
         nativePinMessage(messageId, isPinned, error);
    }

    native void nativePinMessage(String messageId, boolean isPinned, EMAError error);

    public List<EMAMessage> getPinnedMessagesFromServer(String conversationId, EMAError error) {
        return nativeGetPinnedMessagesFromServer(conversationId,error);
    }

    native List<EMAMessage> nativeGetPinnedMessagesFromServer(String conversationId, EMAError error);

    public void markAllConversationsAsRead(EMAError error) {
        nativeMarkAllConversationsAsRead(error);
    }

    native void nativeMarkAllConversationsAsRead(EMAError error) ;

    public List<EMAConversation> loadConversationsWithFilter(EMACustomConversationFilter filter,boolean releaseConversationsCache) {
        return  nativeLoadConversationsWithFilter(filter, releaseConversationsCache);
    }

    native List<EMAConversation> nativeLoadConversationsWithFilter(EMACustomConversationFilter filter, boolean releaseConversationsCache);

    public void cleanConversationsMemoryCache() {
        nativeReleaseConversationsCache();
    }
    native void nativeReleaseConversationsCache() ;

    public int getMessageCount(){
        return nativeGetMessageCount();
    }
    native int nativeGetMessageCount();
}

