package com.hyphenate.chat;

public class EMLoginExtensionInfo {

   /**
    * \~chinese
    * 设备信息。
    * <p>
    * \~english
    * The device information.
    */
   protected String deviceInfo;

   /**
    * \~chinese
    * 设备扩展信息。
    * 
    * 多设备登录场景下，若因达到了登录设备数量限制而导致在已登录的设备上强制退出时（错误码 为 206，USER_LOGIN_ANOTHER_DEVICE），
    * 
    * 被踢设备收到的 `EMConnectionListener#onLogout` 回调会包含导致该设备被踢下线的新登录设备的自定义扩展信息（若设备设置了该信息）。
    * 
    * <p>
    * \~english
    * The custom device extension information.
    *
    * In a multi-device login scenario, if the new login device kicked the current device offline (error code is 206，USER_LOGIN_ANOTHER_DEVICE) because the maximum number of devices allowed for login is exceeded,
    * 
    * the device that is kicked offline receives the custom device extension information (if any) of the new login device via the `EMConnectionListener#onLogout` event.
    */
   protected String deviceExt;


   EMLoginExtensionInfo(String deviceInfo, String ext){
         this.deviceInfo = deviceInfo;
         this.deviceExt = ext;
   }

   /**
    * \~chinese
    * 获取设备信息。
    * <p>
    * \~english
    * Gets device information.
    */
   public String getDeviceInfo() {
      return deviceInfo;
   }

   /**
    * \~chinese
    * 获取扩展信息。
    * <p>
    * \~english
    * Gets device extension information.
    */
   public String getDeviceExt() {
      return deviceExt;
   }

}