/*
 * Decompiled with CFR 0.152.
 */
package internal.com.getkeepsafe.relinker.elf;

import internal.com.getkeepsafe.relinker.elf.Elf;
import internal.com.getkeepsafe.relinker.elf.Elf32Header;
import internal.com.getkeepsafe.relinker.elf.Elf64Header;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ElfParser
implements Closeable,
Elf {
    private final int MAGIC;
    private final FileChannel channel;

    /*
     * WARNING - void declaration
     */
    public ElfParser(File file) throws FileNotFoundException {
        void var1_1;
        this.MAGIC = 1179403647;
        if (file != null && var1_1.exists()) {
            this.channel = new FileInputStream((File)var1_1).getChannel();
            return;
        }
        throw new IllegalArgumentException("File is null or does not exist");
    }

    /*
     * WARNING - void declaration
     */
    private long offsetFromVma(Elf.Header header, long numEntries, long vma) throws IOException {
        void var2_2;
        for (long i = 0L; i < var2_2; ++i) {
            void var4_3;
            long l;
            void var1_1;
            Elf.ProgramHeader programHeader = var1_1.getProgramHeader(i);
            if (programHeader.type != 1L || (l = programHeader.vaddr) > var4_3 || var4_3 > l + programHeader.memsz) continue;
            return (long)(var4_3 - l + programHeader.offset);
        }
        throw new IllegalStateException("Could not map vma to file offset!");
    }

    public Elf.Header parseHeader() throws IOException {
        ElfParser elfParser = this;
        elfParser.channel.position(0L);
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        if (elfParser.readWord(byteBuffer, 0L) == 1179403647L) {
            short s = this.readByte(byteBuffer, 4L);
            boolean bl = this.readByte(byteBuffer, 5L) == 2;
            if (s == 1) {
                return new Elf32Header(bl, this);
            }
            if (s == 2) {
                return new Elf64Header(bl, this);
            }
            throw new IllegalStateException("Invalid class type!");
        }
        throw new IllegalArgumentException("Invalid ELF Magic!");
    }

    public List<String> parseNeededDependencies() throws IOException {
        Elf.DynamicStructure dynamicStructure;
        ArrayList<Long> arrayList;
        ArrayList<String> arrayList2;
        ElfParser elfParser = this;
        elfParser.channel.position(0L);
        ArrayList<String> arrayList3 = arrayList2;
        arrayList2 = new ArrayList<String>();
        Object object = elfParser.parseHeader();
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        ByteOrder byteOrder = ((Elf.Header)object).bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        byteBuffer.order(byteOrder);
        long l = ((Elf.Header)object).phnum;
        if (l == 65535L) {
            l = ((Elf.Header)object).getSectionHeader((int)0).info;
        }
        long l2 = 0L;
        for (long i = 0L; i < l; ++i) {
            Elf.ProgramHeader programHeader = ((Elf.Header)object).getProgramHeader(i);
            if (programHeader.type != 2L) continue;
            l2 = programHeader.offset;
            break;
        }
        if (l2 == 0L) {
            return Collections.unmodifiableList(arrayList3);
        }
        int n = 0;
        ArrayList<Long> arrayList4 = arrayList;
        arrayList = new ArrayList<Long>();
        long l3 = 0L;
        do {
            dynamicStructure = ((Elf.Header)object).getDynamicStructure(l2, n);
            long l4 = dynamicStructure.tag;
            if (l4 == 1L) {
                arrayList4.add(dynamicStructure.val);
            } else if (l4 == 5L) {
                l3 = dynamicStructure.val;
            }
            ++n;
        } while (dynamicStructure.tag != 0L);
        if (l3 != 0L) {
            l = this.offsetFromVma((Elf.Header)object, l, l3);
            object = arrayList4.iterator();
            while (object.hasNext()) {
                arrayList3.add(this.readString(byteBuffer, l + (Long)object.next()));
            }
            return arrayList3;
        }
        throw new IllegalStateException("String table offset not found!");
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    /*
     * WARNING - void declaration
     */
    protected String readString(ByteBuffer buffer, long offset) throws IOException {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        while (true) {
            void var1_1;
            void var2_2;
            void var5_5 = var2_2 + 1L;
            short s = this.readByte((ByteBuffer)var1_1, (long)var2_2);
            if (s == 0) break;
            stringBuilder2.append((char)s);
            var2_2 = var5_5;
        }
        return stringBuilder2.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected long readLong(ByteBuffer buffer, long offset) throws IOException {
        void var2_2;
        void var1_1;
        this.read((ByteBuffer)var1_1, (long)var2_2, 8);
        return buffer.getLong();
    }

    /*
     * WARNING - void declaration
     */
    protected long readWord(ByteBuffer buffer, long offset) throws IOException {
        void var2_2;
        void var1_1;
        this.read((ByteBuffer)var1_1, (long)var2_2, 4);
        return (long)buffer.getInt() & 0xFFFFFFFFL;
    }

    /*
     * WARNING - void declaration
     */
    protected int readHalf(ByteBuffer buffer, long offset) throws IOException {
        void var2_2;
        void var1_1;
        this.read((ByteBuffer)var1_1, (long)var2_2, 2);
        return buffer.getShort() & 0xFFFF;
    }

    /*
     * WARNING - void declaration
     */
    protected short readByte(ByteBuffer buffer, long offset) throws IOException {
        void var2_2;
        void var1_1;
        this.read((ByteBuffer)var1_1, (long)var2_2, 1);
        return (short)(buffer.get() & 0xFF);
    }

    /*
     * WARNING - void declaration
     */
    protected void read(ByteBuffer buffer, long offset, int length) throws IOException {
        void var1_1;
        int n;
        void var4_3;
        ByteBuffer byteBuffer = buffer;
        byteBuffer.position(0);
        byteBuffer.limit((int)var4_3);
        for (long i = 0L; i < (long)var4_3; i += (long)n) {
            void var2_2;
            n = this.channel.read((ByteBuffer)var1_1, (long)(var2_2 + i));
            if (n != -1) {
                continue;
            }
            throw new EOFException();
        }
        var1_1.position(0);
    }
}

