/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.push;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Pair;
import com.hyphenate.chat.EMClient;
import com.hyphenate.cloud.EMHttpClient;
import com.hyphenate.push.EMPushConfig;
import com.hyphenate.push.EMPushType;
import com.hyphenate.push.PushListener;
import com.hyphenate.push.platform.mi.a;
import com.hyphenate.util.DeviceUuidFactory;
import com.hyphenate.util.EMLog;
import java.util.ArrayList;
import java.util.Random;
import org.json.JSONObject;

public class EMPushHelper {
    private static final String a = "EMPushHelper";
    private static final int b = 3;
    private static final int c = 0;
    private static final int d = 1;
    private static final int e = 2;
    private Context f;
    private EMPushConfig g;
    private com.hyphenate.push.platform.a h;
    private Handler i;
    private EMPushType j;
    private String k;
    private boolean l;
    private final Object m = new Object();
    private final Object n = new Object();
    private PushListener o;
    private boolean p = false;

    private EMPushHelper() {
        HandlerThread handlerThread = new HandlerThread("token-uploader");
        handlerThread.start();
        this.i = new Handler(handlerThread.getLooper()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 0: {
                        Object object = EMPushHelper.this.m;
                        synchronized (object) {
                            boolean bl;
                            String string = (String)msg.obj;
                            boolean bl2 = EMPushHelper.this.a(EMPushHelper.this.h.a(), string);
                            if (bl2) {
                                this.removeMessages(0);
                                return;
                            }
                            boolean bl3 = bl = !this.hasMessages(0);
                            if (bl) {
                                EMPushHelper.this.onErrorResponse(EMPushHelper.this.j, 1501L);
                                EMPushHelper.this.a(EMPushType.NORMAL);
                            }
                            break;
                        }
                    }
                    case 1: {
                        EMPushHelper.this.l = EMPushHelper.this.a(EMPushHelper.this.h.a(), "");
                        if (!EMPushHelper.this.l) {
                            EMPushHelper.this.onErrorResponse(EMPushHelper.this.j, 1502L);
                        }
                        Object object = EMPushHelper.this.n;
                        synchronized (object) {
                            EMPushHelper.this.n.notifyAll();
                            break;
                        }
                    }
                    case 2: {
                        Bundle bundle = msg.getData();
                        if (bundle == null) {
                            return;
                        }
                        String string = bundle.getString("type", "");
                        if (TextUtils.isEmpty((CharSequence)string)) {
                            return;
                        }
                        EMPushType eMPushType = EMPushType.getType(string);
                        EMPushHelper.this.c(eMPushType, (String)msg.obj);
                        break;
                    }
                    default: {
                        super.handleMessage(msg);
                    }
                }
            }
        };
    }

    public static EMPushHelper getInstance() {
        return InstanceHolder.a;
    }

    public void setPushListener(PushListener callback) {
        this.o = callback;
    }

    public void init(Context context, EMPushConfig config) {
        EMLog.e(a, "EMPushHelper init, config: " + config.toString());
        if (context == null || config == null) {
            throw new IllegalArgumentException("Null parameters, context=" + context + ", config=" + config);
        }
        this.f = context.getApplicationContext();
        this.g = config;
    }

    public void register() {
        if (this.f == null || this.g == null) {
            EMLog.e(a, "EMPushHelper#init(Context, EMPushConfig) method not call previously.");
            return;
        }
        EMPushType eMPushType = this.a(this.g);
        EMLog.e(a, "EMPushHelper register, prefer push type: " + (Object)((Object)eMPushType));
        this.a(eMPushType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregister(boolean unbindToken) {
        EMLog.e(a, "EMPushHelper unregister, unbind token: " + unbindToken);
        if (!this.p) {
            EMLog.e(a, "EMPushHelper is not registered previously, return true directly.");
            return true;
        }
        this.p = false;
        this.h.a(this.f);
        this.i.removeMessages(2);
        this.i.removeMessages(0);
        if (!unbindToken) {
            this.j = null;
            return true;
        }
        if (this.j != null && this.j != EMPushType.NORMAL) {
            this.a();
            Object object = this.n;
            synchronized (object) {
                try {
                    this.n.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.l) {
                this.j = null;
            }
        } else {
            this.l = true;
            this.j = null;
        }
        EMLog.e(a, "Push type after unregister is " + (Object)((Object)this.j));
        return this.l;
    }

    private boolean a(EMPushType eMPushType, String string) {
        String string2 = EMPushHelper.getInstance().getPushTokenWithType(eMPushType);
        return string2 == null || !string2.equals(string);
    }

    public void onReceiveToken(EMPushType type, String token) {
        EMLog.e(a, "onReceiveToken: " + (Object)((Object)type) + " - " + token);
        if (!this.p) {
            EMLog.e(a, "EMPushHelper is not registered, abort token upload action.");
            return;
        }
        this.k = token;
        if (this.a(type, token)) {
            EMLog.d(a, "push token changed, upload to server");
            this.b(type, token);
            return;
        }
        if (EMClient.getInstance().getChatConfigPrivate().J()) {
            EMLog.d(a, "push token not change, but last login is not on this device, upload to server");
            this.b(type, token);
        } else {
            EMLog.e(a, "EMPushHelper not first login, ignore token upload action.");
        }
    }

    public void onErrorResponse(EMPushType type, long resultCode) {
        EMLog.e(a, "onErrorResponse: " + (Object)((Object)type) + " - " + resultCode);
        if (!this.p) {
            EMLog.e(a, "EMPushHelper is not registered, abort error response action.");
            return;
        }
        if (resultCode == 1500L) {
            this.a(EMPushType.NORMAL);
        }
        if (this.o != null) {
            this.o.onError(type, resultCode);
        }
    }

    public EMPushType getPushType() {
        return this.j;
    }

    public String getPushToken() {
        return this.k;
    }

    public String getFCMPushToken() {
        return com.hyphenate.chat.core.a.a().m();
    }

    public void setFCMPushToken(String token) {
        com.hyphenate.chat.core.a.a().d(token);
    }

    public String getPushTokenWithType(EMPushType type) {
        return com.hyphenate.chat.core.a.a().a(type);
    }

    public void setPushTokenWithType(EMPushType type, String token) {
        com.hyphenate.chat.core.a.a().a(type, token);
    }

    private void a(@NonNull EMPushType eMPushType, boolean bl) {
        if (this.j == eMPushType) {
            EMLog.e(a, "Push type " + (Object)((Object)eMPushType) + " no change, return. ");
            return;
        }
        if (this.h != null) {
            EMLog.e(a, (Object)((Object)this.h.b()) + " push already exists, unregister it and change to " + (Object)((Object)eMPushType) + " push.");
            this.h.a(this.f);
        }
        this.j = eMPushType;
        switch (eMPushType) {
            case FCM: {
                this.h = new com.hyphenate.push.platform.a.a();
                break;
            }
            case MIPUSH: {
                this.h = new a();
                break;
            }
            case OPPOPUSH: {
                this.h = new com.hyphenate.push.platform.oppo.a();
                break;
            }
            case VIVOPUSH: {
                this.h = new com.hyphenate.push.platform.vivo.a();
                break;
            }
            case MEIZUPUSH: {
                this.h = new com.hyphenate.push.platform.meizu.a();
                break;
            }
            case HMSPUSH: {
                this.h = new com.hyphenate.push.platform.b.a();
                break;
            }
            case HONORPUSH: {
                this.h = new com.hyphenate.push.platform.c.a();
                break;
            }
            default: {
                this.h = new com.hyphenate.push.platform.d.a();
            }
        }
        this.p = true;
        if (bl) {
            return;
        }
        this.h.a(this.f, this.g, this.o);
    }

    private void a(@NonNull EMPushType eMPushType) {
        this.a(eMPushType, false);
    }

    private void b(EMPushType eMPushType, String string) {
        Message message = this.i.obtainMessage(2, (Object)string);
        Bundle bundle = new Bundle();
        bundle.putString("type", eMPushType.getName());
        message.setData(bundle);
        this.i.sendMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void c(EMPushType eMPushType, String string) {
        Object object = this.m;
        synchronized (object) {
            this.i.removeMessages(0);
            this.a(eMPushType, true);
            for (int i = -1; i < 3; ++i) {
                Message message = this.i.obtainMessage(0, (Object)string);
                if (i == -1) {
                    this.i.sendMessage(message);
                    continue;
                }
                int n = this.randomDelay(i);
                EMLog.i(a, "Retry upload after " + n + "s if failed.");
                this.i.sendMessageDelayed(message, (long)(n * 1000));
            }
        }
    }

    private void a() {
        this.i.obtainMessage(1).sendToTarget();
    }

    private boolean a(String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            EMLog.e(a, "uploadTokenInternal notifierName is null, return. current push type: " + (Object)((Object)this.j));
            return false;
        }
        String string3 = EMClient.getInstance().getChatConfigPrivate().a(true, false) + "/users/" + EMClient.getInstance().getCurrentUser() + "/push/binding";
        DeviceUuidFactory deviceUuidFactory = new DeviceUuidFactory(EMClient.getInstance().getContext());
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("device_token", (Object)string2);
            jSONObject.put("notifier_name", (Object)string);
            jSONObject.put("device_id", (Object)deviceUuidFactory.getDeviceUuid().toString());
        }
        catch (Exception exception) {
            EMLog.e(a, "uploadTokenInternal put json exception: " + exception.toString());
        }
        int n = 2;
        do {
            try {
                EMLog.e(a, "uploadTokenInternal, token=" + string2 + ", url=" + string3 + ", notifier name=" + string);
                Pair<Integer, String> pair = EMHttpClient.getInstance().sendRequestWithToken(string3, jSONObject.toString(), EMHttpClient.PUT);
                int n2 = (Integer)pair.first;
                String string4 = (String)pair.second;
                if (n2 == 200) {
                    EMLog.e(a, "uploadTokenInternal success.");
                    EMPushHelper.getInstance().setPushTokenWithType(this.j, string2);
                    return true;
                }
                EMLog.e(a, "uploadTokenInternal failed: " + string4);
                string3 = EMClient.getInstance().getChatConfigPrivate().a(true, true) + "/users/" + EMClient.getInstance().getCurrentUser();
            }
            catch (Exception exception) {
                EMLog.e(a, "uploadTokenInternal exception: " + exception.toString());
                string3 = EMClient.getInstance().getChatConfigPrivate().a(true, true) + "/users/" + EMClient.getInstance().getCurrentUser();
            }
        } while (--n > 0);
        return false;
    }

    private EMPushType a(EMPushConfig eMPushConfig) {
        EMPushType[] eMPushTypeArray = new EMPushType[]{EMPushType.FCM, EMPushType.MIPUSH, EMPushType.HMSPUSH, EMPushType.MEIZUPUSH, EMPushType.OPPOPUSH, EMPushType.VIVOPUSH, EMPushType.HONORPUSH};
        ArrayList<EMPushType> arrayList = eMPushConfig.getEnabledPushTypes();
        for (EMPushType eMPushType : eMPushTypeArray) {
            if (!arrayList.contains((Object)eMPushType) || !this.a(eMPushType, eMPushConfig)) continue;
            return eMPushType;
        }
        return EMPushType.NORMAL;
    }

    private boolean a(EMPushType eMPushType, EMPushConfig eMPushConfig) {
        boolean bl = this.o != null ? this.o.isSupportPush(eMPushType, eMPushConfig) : com.hyphenate.push.a.a.a(eMPushType, eMPushConfig);
        EMLog.i(a, "isSupportPush: " + (Object)((Object)eMPushType) + " - " + bl);
        return bl;
    }

    public int randomDelay(int attempts) {
        if (attempts == 0) {
            return new Random().nextInt(5) + 1;
        }
        if (attempts == 1) {
            return new Random().nextInt(54) + 6;
        }
        return new Random().nextInt(540) + 60;
    }

    private static class InstanceHolder {
        static EMPushHelper a = new EMPushHelper();

        private InstanceHolder() {
        }
    }
}

