/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.push;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import com.hyphenate.push.EMPushType;
import com.hyphenate.util.EMLog;
import java.util.ArrayList;

public class EMPushConfig {
    private static final String a = "EMPushConfig";
    private String b;
    private String c;
    private String d;
    private String e;
    private String f;
    private String g;
    private String h;
    private String i;
    private String j;
    private String k;
    private String l;
    private ArrayList<EMPushType> m;

    private EMPushConfig() {
    }

    public String getFcmSenderId() {
        return this.b;
    }

    public String getHwAppId() {
        return this.c;
    }

    public String getHonorAppId() {
        return this.d;
    }

    public String getMiAppId() {
        return this.e;
    }

    public String getMiAppKey() {
        return this.f;
    }

    public String getMzAppId() {
        return this.g;
    }

    public String getMzAppKey() {
        return this.h;
    }

    public String getOppoAppKey() {
        return this.i;
    }

    public String getOppoAppSecret() {
        return this.j;
    }

    public String getVivoAppId() {
        return this.k;
    }

    public String getVivoAppKey() {
        return this.l;
    }

    public ArrayList<EMPushType> getEnabledPushTypes() {
        return this.m;
    }

    public String toString() {
        return "EMPushConfig{fcmSenderId='" + this.b + '\'' + ", hwAppId='" + this.c + '\'' + ", honorAppId='" + this.d + '\'' + ", miAppId='" + this.e + '\'' + ", miAppKey='" + this.f + '\'' + ", mzAppId='" + this.g + '\'' + ", mzAppKey='" + this.h + '\'' + ", oppoAppKey='" + this.i + '\'' + ", oppoAppSecret='" + this.j + '\'' + ", vivoAppId='" + this.k + '\'' + ", vivoAppKey='" + this.l + '\'' + ", enabledPushTypes=" + this.m + '}';
    }

    public static class Builder {
        private Context a;
        private String b;
        private String c;
        private String d;
        private String e;
        private String f;
        private String g;
        private String h;
        private String i;
        private String j;
        private String k;
        private String l;
        private ArrayList<EMPushType> m = new ArrayList();

        public Builder(Context context) {
            this.a = context.getApplicationContext();
        }

        public Builder(Context context, EMPushConfig config) {
            this(context);
            if (config == null) {
                return;
            }
            if (config.m.contains((Object)EMPushType.MIPUSH)) {
                this.enableMiPush(config.e, config.f);
            }
            if (config.m.contains((Object)EMPushType.HMSPUSH)) {
                this.enableHWPush();
            }
            if (config.m.contains((Object)EMPushType.VIVOPUSH)) {
                this.enableVivoPush();
            }
            if (config.m.contains((Object)EMPushType.OPPOPUSH)) {
                this.enableOppoPush(config.i, config.j);
            }
            if (config.m.contains((Object)EMPushType.MEIZUPUSH)) {
                this.enableMeiZuPush(config.g, config.h);
            }
            if (config.m.contains((Object)EMPushType.FCM)) {
                this.enableFCM(config.b);
            }
            if (config.m.contains((Object)EMPushType.HONORPUSH)) {
                this.enableHonorPush();
            }
        }

        public Builder enableMiPush(String appId, String appKey) {
            if (!TextUtils.isEmpty((CharSequence)appId) && !TextUtils.isEmpty((CharSequence)appKey)) {
                this.e = appId;
                this.f = appKey;
                this.m.add(EMPushType.MIPUSH);
                return this;
            }
            EMLog.e(EMPushConfig.a, "appId or appKey can't be empty when enable MI push !");
            return this;
        }

        public Builder enableHWPush() {
            try {
                ApplicationInfo applicationInfo = this.a.getPackageManager().getApplicationInfo(this.a.getPackageName(), 128);
                this.c = applicationInfo.metaData.getString("com.huawei.hms.client.appid");
                if (this.c != null && this.c.contains("=")) {
                    this.c = this.c.split("=")[1];
                } else {
                    int n = applicationInfo.metaData.getInt("com.huawei.hms.client.appid");
                    this.c = String.valueOf(n);
                }
                this.m.add(EMPushType.HMSPUSH);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                nameNotFoundException.printStackTrace();
            }
            catch (NullPointerException nullPointerException) {
                EMLog.e(EMPushConfig.a, "Huawei push must config meta-data: com.huawei.hms.client.appid in AndroidManifest.xml.");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                EMLog.e(EMPushConfig.a, "Huawei push meta-data: com.huawei.hms.client.appid value must be like this 'appid=xxxxxx'.");
            }
            return this;
        }

        public Builder enableFCM(String senderId) {
            if (!TextUtils.isEmpty((CharSequence)senderId)) {
                this.b = senderId;
                this.m.add(EMPushType.FCM);
                return this;
            }
            EMLog.e(EMPushConfig.a, "senderId can't be empty when enable FCM push !");
            return this;
        }

        public Builder enableMeiZuPush(String appId, String appKey) {
            if (!TextUtils.isEmpty((CharSequence)appId) && !TextUtils.isEmpty((CharSequence)appKey)) {
                this.g = appId;
                this.h = appKey;
                this.m.add(EMPushType.MEIZUPUSH);
                return this;
            }
            EMLog.e(EMPushConfig.a, "appId or appKey can't be empty when enable MEIZU push !");
            return this;
        }

        public Builder enableOppoPush(String appKey, String appSecret) {
            if (!TextUtils.isEmpty((CharSequence)appKey) && !TextUtils.isEmpty((CharSequence)appSecret)) {
                this.i = appKey;
                this.j = appSecret;
                this.m.add(EMPushType.OPPOPUSH);
                return this;
            }
            EMLog.e(EMPushConfig.a, "appKey or appSecret can't be empty when enable OPPO push !");
            return this;
        }

        public Builder enableVivoPush() {
            try {
                ApplicationInfo applicationInfo = this.a.getPackageManager().getApplicationInfo(this.a.getPackageName(), 128);
                this.k = applicationInfo.metaData.getInt("com.vivo.push.app_id") + "";
                this.l = applicationInfo.metaData.getString("com.vivo.push.api_key");
                this.m.add(EMPushType.VIVOPUSH);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                EMLog.e(EMPushConfig.a, "NameNotFoundException: " + nameNotFoundException.getMessage());
            }
            return this;
        }

        public Builder enableHonorPush() {
            ApplicationInfo applicationInfo = null;
            try {
                applicationInfo = this.a.getPackageManager().getApplicationInfo(this.a.getPackageName(), 128);
                int n = applicationInfo.metaData.getInt("com.hihonor.push.app_id");
                this.d = String.valueOf(n);
                this.m.add(EMPushType.HONORPUSH);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                nameNotFoundException.printStackTrace();
            }
            catch (NullPointerException nullPointerException) {
                EMLog.e(EMPushConfig.a, "Honor push must config meta-data: com.hihonor.push.app_id in AndroidManifest.xml.");
            }
            return this;
        }

        public EMPushConfig build() {
            EMPushConfig eMPushConfig = new EMPushConfig();
            eMPushConfig.b = this.b;
            eMPushConfig.c = this.c;
            eMPushConfig.d = this.d;
            eMPushConfig.e = this.e;
            eMPushConfig.f = this.f;
            eMPushConfig.g = this.g;
            eMPushConfig.h = this.h;
            eMPushConfig.i = this.i;
            eMPushConfig.j = this.j;
            eMPushConfig.k = this.k;
            eMPushConfig.l = this.l;
            eMPushConfig.m = this.m;
            return eMPushConfig;
        }
    }
}

