/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat.adapter.message;

import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.adapter.EMABase;
import com.hyphenate.chat.adapter.EMACallback;
import com.hyphenate.chat.adapter.EMAMessageReaction;
import com.hyphenate.chat.adapter.EMAThreadInfo;
import com.hyphenate.chat.adapter.message.EMAMessageBody;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class EMAMessage
extends EMABase {
    public static final int EMAChatType_SINGLE = 0;
    public static final int EMAChatType_GROUP = 1;
    public static final int EMAChatType_CHATROOM = 2;
    public static final int EMAMessageStatus_NEW = 0;
    public static final int EMAMessageStatus_DELIVERING = 1;
    public static final int EMAMessageStatus_SUCCESS = 2;
    public static final int EMAMessageStatus_FAIL = 3;

    public EMAMessage(EMAMessage message) {
        this.nativeInit(message);
    }

    public EMAMessageStatus _status() {
        int n = this.nativeStatus();
        switch (n) {
            case 0: {
                return EMAMessageStatus.NEW;
            }
            case 1: {
                return EMAMessageStatus.DELIVERING;
            }
            case 2: {
                return EMAMessageStatus.SUCCESS;
            }
            case 3: {
                return EMAMessageStatus.FAIL;
            }
        }
        return EMAMessageStatus.FAIL;
    }

    public String msgId() {
        return this.nativeMsgId();
    }

    public String from() {
        return this.nativeFrom();
    }

    public String getRecaller() {
        return this.nativeGetRecaller();
    }

    public String to() {
        return this.nativeTo();
    }

    public String conversationId() {
        return this.nativeConversationId();
    }

    public void setMsgId(String msgId) {
        this.nativeSetMsgId(msgId);
    }

    public void setFrom(String from) {
        this.nativeSetFrom(from);
    }

    public void setTo(String to) {
        this.nativeSetTo(to);
    }

    public void setConversationId(String conversationId) {
        this.nativeSetConversationId(conversationId);
    }

    public void setStatus(int status) {
        this.nativeSetStatus(status);
    }

    public boolean isRead() {
        return this.nativeIsRead();
    }

    public boolean isAcked() {
        return this.nativeIsAcked();
    }

    public boolean isDeliverAcked() {
        return this.nativeIsDeliverAcked();
    }

    public long timeStamp() {
        return this.nativeTimeStamp();
    }

    public void setIsRead(boolean isRead) {
        this.nativeSetIsRead(isRead);
    }

    public void setIsAcked(boolean isAcked) {
        this.nativeSetIsAcked(isAcked);
    }

    public boolean isListened() {
        return this.nativeIsListened();
    }

    native boolean nativeIsListened();

    public void setListened(boolean listened) {
        this.nativeSetListened(listened);
    }

    native void nativeSetListened(boolean var1);

    public void setIsDeliverAcked(boolean isDeliverAcked) {
        this.nativeSetIsDeliverAcked(isDeliverAcked);
    }

    public static EMAMessage createReceiveMessage(String from, String to, EMAMessageBody body, int chatType) {
        return EMAMessage.nativeCreateReceiveMessage(from, to, body, chatType);
    }

    public static EMAMessage createSendMessage(String from, String to, EMAMessageBody body, int chatType) {
        return EMAMessage.nativeCreateSendMessage(from, to, body, chatType);
    }

    public void setAttribute(String attr, int val) {
        this.nativeSetAttribute(attr, val);
    }

    public void setAttribute(String attr, long val) {
        this.nativeSetAttribute(attr, val);
    }

    public void setAttribute(String attr, float val) {
        this.nativeSetAttribute(attr, val);
    }

    public void setAttribute(String attr, double val) {
        this.nativeSetAttribute(attr, val);
    }

    public void setAttribute(String attr, String val) {
        this.nativeSetAttribute(attr, val);
    }

    public void setAttribute(String attr, boolean val) {
        this.nativeSetAttribute(attr, val);
    }

    public void setJsonAttribute(String attr, String val) {
        this.nativeSetJsonAttribute(attr, val);
    }

    public boolean getJsonAttribute(String attr, String defaultValue, StringBuilder val) {
        return this.nativeGetJsonAttribute(attr, defaultValue, val);
    }

    public boolean getIntAttribute(String attr, int defaultValue, AtomicInteger val) {
        return this.nativeGetIntAttribute(attr, defaultValue, val);
    }

    public boolean getLongAttribute(String attr, long defaultValue, AtomicLong val) {
        return this.nativeGetLongAttribute(attr, defaultValue, val);
    }

    public boolean getFloatAttribute(String attr, float defaultValue, AtomicReference val) {
        return this.nativeGetFloatAttribute(attr, defaultValue, val);
    }

    public boolean getDoubleAttribute(String attr, double defaultValue, AtomicReference val) {
        return this.nativeGetDoubleAttribute(attr, defaultValue, val);
    }

    public boolean getStringAttribute(String attr, String defaultValue, StringBuilder val) {
        return this.nativeGetStringAttribute(attr, defaultValue, val);
    }

    public boolean getBooleanAttribute(String attr, boolean defaultValue, AtomicBoolean val) {
        return this.nativeGetBooleanAttribute(attr, defaultValue, val);
    }

    public List<EMAMessageBody> bodies() {
        return this.nativeBodies();
    }

    public void addBody(EMAMessageBody body) {
        this.nativeAddBody(body);
    }

    public void clearBodies() {
        this.nativeClearBodies();
    }

    public EMAChatType chatType() {
        int n = this.nativeChatType();
        EMAChatType eMAChatType = EMAChatType.SINGLE;
        eMAChatType = n == EMAChatType.SINGLE.ordinal() ? EMAChatType.SINGLE : (n == EMAChatType.GROUP.ordinal() ? EMAChatType.GROUP : EMAChatType.CHATROOM);
        return eMAChatType;
    }

    public void setChatType(EMAChatType type) {
        this.nativeSetChatType(type.ordinal());
    }

    public void setTimeStamp(long time) {
        this.nativeSetTimeStamp(time);
    }

    public int progress() {
        return this.nativeProgress();
    }

    public void setProgress(int progress) {
        this.nativeSetProgress(progress);
    }

    public void setCallback(EMACallback callback) {
        this.nativeSetCallback(callback);
    }

    public EMADirection direction() {
        int n = this.nativeDirection();
        if (n == EMADirection.SEND.ordinal()) {
            return EMADirection.SEND;
        }
        return EMADirection.RECEIVE;
    }

    public void setDirection(int dir) {
        this.nativeSetDirection(dir);
    }

    public long getLocalTime() {
        return this.nativeGetLocalTime();
    }

    public void setLocalTime(long time) {
        this.nativeSetLocalTime(time);
    }

    public Map ext() {
        return this.nativeExt();
    }

    public boolean isNeedGroupAck() {
        return this.nativeIsNeedGroupAck();
    }

    public void setIsNeedGroupAck(boolean need) {
        this.nativeSetIsNeedGroupAck(need);
    }

    public int groupAckCount() {
        return this.nativeGroupAckCount();
    }

    public void setGroupAckCount(int count) {
        this.nativeSetGroupAckCount(count);
    }

    public List<EMAMessageReaction> reactionList() {
        return this.nativeReactionList();
    }

    public void setIsChatThreadMessage(boolean isThread) {
        this.nativeSetIsThread(isThread);
    }

    public boolean isChatThreadMessage() {
        return this.nativeIsThread();
    }

    public EMAThreadInfo getChatThread() {
        return this.nativeGetChatThread();
    }

    public boolean isOnlineState() {
        return this.nativeIsOnlineState();
    }

    public void setPriority(EMMessage.EMChatRoomMessagePriority priority) {
        this.nativeSetPriority(priority.ordinal());
    }

    public Map<String, Object> getAttributes() {
        return this.nativeGetAttributes();
    }

    public native String nativeMsgId();

    public native String nativeFrom();

    public native String nativeGetRecaller();

    public native String nativeTo();

    public native String nativeConversationId();

    public native int nativeStatus();

    public native void nativeSetMsgId(String var1);

    public native void nativeSetFrom(String var1);

    public native void nativeSetTo(String var1);

    public native void nativeSetConversationId(String var1);

    public native void nativeSetStatus(int var1);

    public native boolean nativeIsRead();

    public native boolean nativeIsAcked();

    public native boolean nativeIsDeliverAcked();

    public native long nativeTimeStamp();

    public native void nativeSetIsRead(boolean var1);

    public native void nativeSetIsAcked(boolean var1);

    public native void nativeSetIsDeliverAcked(boolean var1);

    public static native EMAMessage nativeCreateReceiveMessage(String var0, String var1, EMAMessageBody var2, int var3);

    public static native EMAMessage nativeCreateSendMessage(String var0, String var1, EMAMessageBody var2, int var3);

    public native void nativeSetAttribute(String var1, int var2);

    public native void nativeSetAttribute(String var1, String var2);

    public native void nativeSetAttribute(String var1, boolean var2);

    public native void nativeSetAttribute(String var1, long var2);

    public native void nativeSetAttribute(String var1, float var2);

    public native void nativeSetAttribute(String var1, double var2);

    native void nativeSetJsonAttribute(String var1, String var2);

    public native boolean nativeGetIntAttribute(String var1, int var2, AtomicInteger var3);

    public native boolean nativeGetLongAttribute(String var1, long var2, AtomicLong var4);

    public native boolean nativeGetFloatAttribute(String var1, float var2, AtomicReference var3);

    public native boolean nativeGetDoubleAttribute(String var1, double var2, AtomicReference var4);

    public native boolean nativeGetStringAttribute(String var1, String var2, StringBuilder var3);

    public native boolean nativeGetBooleanAttribute(String var1, boolean var2, AtomicBoolean var3);

    native boolean nativeGetJsonAttribute(String var1, String var2, StringBuilder var3);

    public native List<EMAMessageBody> nativeBodies();

    public native void nativeAddBody(EMAMessageBody var1);

    public native void nativeClearBodies();

    native int nativeDirection();

    native void nativeSetDirection(int var1);

    native int nativeChatType();

    native void nativeSetChatType(int var1);

    native void nativeSetTimeStamp(long var1);

    native int nativeProgress();

    native void nativeSetProgress(int var1);

    native void nativeSetCallback(EMACallback var1);

    native long nativeGetLocalTime();

    native void nativeSetLocalTime(long var1);

    native Map<String, Object> nativeExt();

    public native boolean nativeIsNeedGroupAck();

    public native void nativeSetIsNeedGroupAck(boolean var1);

    public native int nativeGroupAckCount();

    public native void nativeSetGroupAckCount(int var1);

    native void nativeSetIsThread(boolean var1);

    native boolean nativeIsThread();

    native EMAThreadInfo nativeGetChatThread();

    public boolean isDeliverOnlineOnly() {
        return this.nativeIsDeliverOnlineOnly();
    }

    public void deliverOnlineOnly(boolean onlineOnly) {
        this.nativeDeliverOnlineOnly(onlineOnly);
    }

    public EMAMessage() {
        this.nativeInit();
    }

    public void setReceiverList(List<String> receiverList) {
        this.nativeSetReceiverList(receiverList);
    }

    public List<String> receiverList() {
        return this.nativeReceiverList();
    }

    public void finalize() throws Throwable {
        this.nativeFinalize();
        super.finalize();
    }

    native void nativeInit();

    native void nativeInit(EMAMessage var1);

    native void nativeFinalize();

    native List<EMAMessageReaction> nativeReactionList();

    native boolean nativeIsOnlineState();

    native void nativeSetPriority(int var1);

    native boolean nativeIsDeliverOnlineOnly();

    native void nativeDeliverOnlineOnly(boolean var1);

    native void nativeSetReceiverList(List<String> var1);

    native List<String> nativeReceiverList();

    native Map<String, Object> nativeGetAttributes();

    public static enum EMADirection {
        SEND,
        RECEIVE;

    }

    public static enum EMAMessageStatus {
        NEW,
        DELIVERING,
        SUCCESS,
        FAIL;

    }

    public static enum EMAChatType {
        SINGLE,
        GROUP,
        CHATROOM;

    }
}

