/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat.adapter;

import android.util.Base64;
import com.hyphenate.util.EMLog;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class EMAREncryptUtils {
    public static final String TAG = "EMAREncryptUtils";
    private Cipher gcmEncryptCipher;

    public static byte[] generateAESKey(int keyLen) {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(keyLen * 8);
            SecretKey secretKey = keyGenerator.generateKey();
            return secretKey.getEncoded();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            return null;
        }
    }

    public static byte[] generateAESKey256() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(256);
            SecretKey secretKey = keyGenerator.generateKey();
            return secretKey.getEncoded();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            return null;
        }
    }

    public static String b64Encode(byte[] data, int b64Flag) {
        return Base64.encodeToString((byte[])data, (int)0, (int)data.length, (int)(b64Flag == B64_ENCODE_FLAG.ONESDK_B64_NO_WRAP.ordinal() ? 2 : 0));
    }

    public static byte[] b64Decode(String encryptedMsg) {
        return Base64.decode((String)encryptedMsg, (int)0);
    }

    public static byte[] b64Decode(String encryptedMsg, int b64Flag) {
        return Base64.decode((String)encryptedMsg, (int)(b64Flag == B64_ENCODE_FLAG.ONESDK_B64_NO_WRAP.ordinal() ? 2 : 0));
    }

    public void initAESgcm(byte[] keyBytes) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(keyBytes, "AES");
            SecureRandom secureRandom = new SecureRandom();
            byte[] byArray = new byte[12];
            secureRandom.nextBytes(byArray);
            GCMParameterSpec gCMParameterSpec = new GCMParameterSpec(128, byArray);
            this.gcmEncryptCipher = Cipher.getInstance("AES/GCM/NoPadding");
            this.gcmEncryptCipher.init(1, (Key)secretKeySpec, gCMParameterSpec);
            EMLog.d("encrypt", "init for AES gcm");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            EMLog.d(TAG, Arrays.toString(exception.getStackTrace()));
        }
    }

    public String aesGcmEncrypt(String plainMsg, int b64Flag) {
        try {
            byte[] byArray = plainMsg.getBytes("UTF-8");
            byte[] byArray2 = this.gcmEncryptCipher.doFinal(byArray);
            byte[] byArray3 = this.gcmEncryptCipher.getIV();
            ByteBuffer byteBuffer = ByteBuffer.allocate(1 + byArray3.length + byArray2.length);
            byteBuffer.put((byte)byArray3.length);
            byteBuffer.put(byArray3);
            byteBuffer.put(byArray2);
            return EMAREncryptUtils.b64Encode(byteBuffer.array(), b64Flag);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            EMLog.d(TAG, Arrays.toString(exception.getStackTrace()));
            return null;
        }
    }

    public String aesGcmDecrypt(String encryptedMsg, byte[] keyBytes, int b64Flag) {
        try {
            byte[] byArray = EMAREncryptUtils.b64Decode(encryptedMsg, b64Flag);
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byte[] byArray2 = new byte[byteBuffer.get()];
            byteBuffer.get(byArray2);
            byte[] byArray3 = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray3);
            GCMParameterSpec gCMParameterSpec = new GCMParameterSpec(128, byArray2);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(2, (Key)new SecretKeySpec(keyBytes, "AES"), gCMParameterSpec);
            byte[] byArray4 = cipher.doFinal(byArray3);
            return new String(byArray4);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            EMLog.d(TAG, Arrays.toString(exception.getStackTrace()));
            return null;
        }
    }

    public static byte[] encryptByRSAPublicKey(String key_, byte[] data, AtomicBoolean success) {
        String string = key_;
        string = string.replace("-----BEGIN PUBLIC KEY-----", "");
        string = string.replace("-----END PUBLIC KEY-----", "");
        string = string.replace("\n", "");
        byte[] byArray = Base64.decode((byte[])string.getBytes(), (int)2);
        try {
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            EMLog.d(TAG, "publicKey.getFormat:" + publicKey.getFormat());
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(1, publicKey);
            byte[] byArray2 = cipher.doFinal(data);
            success.set(true);
            return byArray2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            EMLog.d(TAG, Arrays.toString(exception.getStackTrace()));
            return null;
        }
    }

    public static String messageDigest(int type, byte[] data) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = type == 1 ? MessageDigest.getInstance("SHA-256") : MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        byte[] byArray = null;
        if (messageDigest != null) {
            byArray = messageDigest.digest(data);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (byArray != null) {
            for (int i = 0; i < byArray.length; ++i) {
                int n = byArray[i] & 0xFF;
                if (n < 16) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(Integer.toHexString(n));
            }
        }
        return stringBuffer.toString();
    }

    static enum B64_ENCODE_FLAG {
        ONESDK_B64_DEFAULT,
        ONESDK_B64_NO_WRAP;

    }
}

