/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.os.AsyncTask;
import com.hyphenate.EMValueCallBack;
import com.hyphenate.chat.CacheManager;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMLanguage;
import com.hyphenate.chat.EMTranslateParams;
import com.hyphenate.chat.EMTranslationResult;
import com.hyphenate.chat.EMTranslator;
import com.hyphenate.chat.adapter.EMATranslateManager;
import com.hyphenate.chat.adapter.EMATranslateResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

@Deprecated
public class EMTranslationManager {
    private static final String TAG = EMTranslationManager.class.getSimpleName();
    public static final int MaxTranslationTextSize = 5000;
    private static EMTranslationManager instance = null;
    private EMTranslator mTranslator;
    private AtomicBoolean mInitializing = new AtomicBoolean(false);
    private AtomicBoolean mInitialized = new AtomicBoolean(false);
    private List<EMLanguage> mLanguageList;
    EMATranslateManager emaObject;
    static final int MaxCacheSize = 10000;
    private CacheManager mCacheManager;

    EMTranslationManager(EMATranslateManager translateManager) {
        this.emaObject = translateManager;
        this.mLanguageList = new ArrayList<EMLanguage>();
        this.mCacheManager = new CacheManager(10000);
    }

    public void init(final EMTranslateParams params) {
        if (!EMClient.getInstance().isLoggedInBefore()) {
            return;
        }
        if (this.mInitializing.compareAndSet(false, true)) {
            AsyncTask.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    EMTranslationManager.this.cleanCache();
                    EMTranslationManager.this.loadIds(params.LoadCount);
                    EMTranslationManager.this.mInitialized.set(true);
                    EMTranslationManager.this.mTranslator = new EMTranslator(params);
                    EMTranslationManager.this.mLanguageList = EMTranslationManager.this.mTranslator.getSupportedLanguages();
                }
            });
        }
    }

    public boolean isInitialized() {
        return this.mInitialized.get();
    }

    public List<EMLanguage> getSupportedLanguages() {
        if (!this.mInitialized.get()) {
            return new ArrayList<EMLanguage>();
        }
        return this.mLanguageList;
    }

    public void translate(String messageId, String conversationId, String messageText, String targetLanguageCode, EMValueCallBack<EMTranslationResult> callback) {
        EMTranslationResult eMTranslationResult;
        if (!this.mInitializing.get()) {
            callback.onError(905, "EMTranslationManager is not initialized");
            return;
        }
        if (messageText.length() > 5000) {
            callback.onError(903, "Text exceeds limit");
            return;
        }
        if (this.isTranslationResultForMessage(messageId)) {
            eMTranslationResult = this.getTranslationResult(messageId);
        } else {
            eMTranslationResult = new EMTranslationResult(messageId);
            eMTranslationResult.setConversationId(conversationId);
        }
        this.mTranslator.translate(messageText, targetLanguageCode, (TranslationText, ErrorText) -> {
            if (!TranslationText.isEmpty()) {
                eMTranslationResult.setShowTranslation(true);
                eMTranslationResult.setTranslatedText(TranslationText);
                eMTranslationResult.setTranslateCount(eMTranslationResult.translateCount() + 1);
                this.updateTranslationResult(eMTranslationResult);
                callback.onSuccess(eMTranslationResult);
            } else {
                callback.onError(904, ErrorText);
            }
        });
    }

    public void removeTranslationResult(String messageId) {
        this.removeTranslationResults(Arrays.asList(messageId));
    }

    public void removeTranslationResults(List<String> messageIds) {
        if (!this.mInitializing.get()) {
            return;
        }
        this.deleteTranslationResults(messageIds);
    }

    public void clearTranslations() {
        if (!this.mInitializing.get()) {
            return;
        }
        this.deleteAll();
    }

    public void removeResultsByConversationId(String conversationId) {
        if (!this.mInitializing.get()) {
            return;
        }
        this.removeTranslationsByConversationId(conversationId);
        this.mCacheManager.removeByConversationId(conversationId);
    }

    public EMTranslationResult getTranslationResult(String messageId) {
        if (!this.mInitializing.get()) {
            return null;
        }
        if (!this.mCacheManager.check(messageId)) {
            return null;
        }
        if (this.mCacheManager.get(messageId) != null) {
            return this.mCacheManager.get(messageId);
        }
        EMTranslationResult eMTranslationResult = this.getTranslationResultByMsgId(messageId);
        return eMTranslationResult;
    }

    public boolean isTranslationResultForMessage(String messageId) {
        if (!this.mInitialized.get()) {
            return false;
        }
        return this.isMessageResult(messageId);
    }

    public void logout() {
        if (!this.mInitialized.get()) {
            return;
        }
        this.mInitializing.set(false);
        this.mInitialized.set(false);
        this.cleanCache();
        this.mLanguageList.clear();
    }

    private void loadIds(int loadCount) {
        List<EMTranslationResult> list = this.loadTranslateResults(loadCount);
        if (list.size() > 0) {
            for (EMTranslationResult eMTranslationResult : list) {
                this.mCacheManager.add(eMTranslationResult);
            }
        }
    }

    public void updateTranslationResult(EMTranslationResult result) {
        String string = result.msgId();
        if (this.mCacheManager.check(string)) {
            this.removeTranslationResult(string);
        }
        this.mCacheManager.add(result);
        this.updateTranslate(result);
    }

    private void deleteTranslationResults(List<String> messageIds) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : messageIds) {
            if (!this.mCacheManager.check(string)) continue;
            arrayList.add(string);
        }
        this.removeTranslationsByMsgId(arrayList);
        this.mCacheManager.removeByMsgIds(arrayList);
    }

    private void deleteAll() {
        this.removeAllTranslations();
        this.mCacheManager.clear();
    }

    private boolean isMessageResult(String messageId) {
        return this.mCacheManager.check(messageId);
    }

    private void cleanCache() {
        this.mCacheManager.clear();
    }

    private boolean updateTranslate(EMTranslationResult result) {
        return this.emaObject.updateTranslation((EMATranslateResult)result.emaObject);
    }

    private EMTranslationResult getTranslationResultByMsgId(String msgId) {
        EMATranslateResult eMATranslateResult = this.emaObject.getTranslationResultByMsgId(msgId);
        if (eMATranslateResult == null) {
            return new EMTranslationResult(msgId);
        }
        return new EMTranslationResult(eMATranslateResult);
    }

    private List<EMTranslationResult> loadTranslateResults(int count) {
        List<EMATranslateResult> list = this.emaObject.loadTranslateResults(count);
        ArrayList<EMTranslationResult> arrayList = new ArrayList<EMTranslationResult>();
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                EMATranslateResult eMATranslateResult = list.get(i);
                EMTranslationResult eMTranslationResult = new EMTranslationResult(eMATranslateResult);
                arrayList.add(eMTranslationResult);
            }
            return arrayList;
        }
        return arrayList;
    }

    private boolean removeTranslationsByMsgId(List<String> msgIds) {
        return this.emaObject.removeTranslationsByMsgId(msgIds);
    }

    private boolean removeTranslationsByConversationId(String conversationId) {
        return this.emaObject.removeTranslationsByConversationId(conversationId);
    }

    private boolean removeAllTranslations() {
        return this.emaObject.removeAllTranslations();
    }
}

