/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import com.hyphenate.EMCallBack;
import com.hyphenate.EMPresenceListener;
import com.hyphenate.EMValueCallBack;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMPresence;
import com.hyphenate.chat.adapter.EMAError;
import com.hyphenate.chat.adapter.EMAPresence;
import com.hyphenate.chat.adapter.EMAPresenceManager;
import com.hyphenate.chat.adapter.EMAPresenceManagerListener;
import com.hyphenate.util.EMLog;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class EMPresenceManager {
    private final String TAG = this.getClass().getSimpleName();
    EMAPresenceManager emaObject;
    private List<EMPresenceListener> listeners = new CopyOnWriteArrayList<EMPresenceListener>();
    private EMAPresenceManagerListener listenerImpl = new EMAPresenceManagerListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPresenceUpdated(List<EMAPresence> presences) {
            List list = EMPresenceManager.this.listeners;
            synchronized (list) {
                for (EMPresenceListener eMPresenceListener : EMPresenceManager.this.listeners) {
                    try {
                        eMPresenceListener.onPresenceUpdated(EMPresenceManager.this.convertToEMPresence(presences));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        EMLog.e(EMPresenceManager.this.TAG, "EMPresenceManager->listenerImpl:onPresenceUpdated() Error:" + exception.getMessage());
                    }
                }
            }
        }
    };

    public EMPresenceManager(EMAPresenceManager presenceManager) {
        this.emaObject = presenceManager;
        this.emaObject.addListener(this.listenerImpl);
    }

    public void publishPresence(final String ext, final EMCallBack callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                EMPresenceManager.this.emaObject.publishPresence(ext, eMAError);
                if (eMAError.errCode() == 0) {
                    callBack.onSuccess();
                } else {
                    callBack.onError(eMAError.errCode(), eMAError.errMsg());
                }
            }
        });
    }

    public void subscribePresences(final List<String> members, final long expiry, final EMValueCallBack<List<EMPresence>> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                List<EMAPresence> list = EMPresenceManager.this.emaObject.subscribePresences(members, expiry, eMAError);
                if (eMAError.errCode() == 0) {
                    callBack.onSuccess(EMPresenceManager.this.convertToEMPresence(list));
                } else {
                    callBack.onError(eMAError.errCode(), eMAError.errMsg());
                }
            }
        });
    }

    public void unsubscribePresences(final List<String> members, final EMCallBack callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                EMPresenceManager.this.emaObject.unsubscribePresences(members, eMAError);
                if (eMAError.errCode() == 0) {
                    callBack.onSuccess();
                } else {
                    callBack.onError(eMAError.errCode(), eMAError.errMsg());
                }
            }
        });
    }

    public void fetchSubscribedMembers(final int pageNum, final int pageSize, final EMValueCallBack<List<String>> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                List<String> list = EMPresenceManager.this.emaObject.fetchSubscribedMembers(pageNum, pageSize, eMAError);
                if (eMAError.errCode() == 0) {
                    callBack.onSuccess(list);
                } else {
                    callBack.onError(eMAError.errCode(), eMAError.errMsg());
                }
            }
        });
    }

    public void fetchPresenceStatus(final List<String> members, final EMValueCallBack<List<EMPresence>> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                List<EMAPresence> list = EMPresenceManager.this.emaObject.fetchPresenceStatus(members, eMAError);
                if (eMAError.errCode() == 0) {
                    callBack.onSuccess(EMPresenceManager.this.convertToEMPresence(list));
                } else {
                    callBack.onError(eMAError.errCode(), eMAError.errMsg());
                }
            }
        });
    }

    public void addListener(EMPresenceListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(EMPresenceListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public void clearListeners() {
        this.listeners.clear();
    }

    private List<EMPresence> convertToEMPresence(List<EMAPresence> presences) {
        ArrayList<EMPresence> arrayList = new ArrayList<EMPresence>();
        for (int i = 0; i < presences.size(); ++i) {
            arrayList.add(new EMPresence(presences.get(i)));
        }
        return arrayList;
    }
}

