/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.util.Base64;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMEncryptProvider;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.EasyUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;

public class EMEncryptUtils {
    private static final String TAG = "encrypt";

    static String encryptMessage(String plainMsg, String toUserName) {
        try {
            EMEncryptProvider eMEncryptProvider = EMClient.getInstance().getEncryptProvider();
            byte[] byArray = plainMsg.getBytes("UTF-8");
            EMLog.d(TAG, "utf-8 bytes:" + EasyUtils.convertByteArrayToString(byArray));
            byte[] byArray2 = eMEncryptProvider.encrypt(byArray, toUserName);
            EMLog.d(TAG, "encrypted bytes:" + EasyUtils.convertByteArrayToString(byArray2));
            byte[] byArray3 = Base64.encode((byte[])byArray2, (int)0);
            EMLog.d(TAG, "base64 bytes:" + EasyUtils.convertByteArrayToString(byArray3));
            String string = new String(byArray3);
            EMLog.d(TAG, "encrypted str:" + string);
            return string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            EMLog.e(TAG, "encryption error, send plain msg");
            return plainMsg;
        }
    }

    static String decryptMessage(String encryptedMsg, String fromUserName) {
        try {
            EMLog.d(TAG, "encrypted str:" + encryptedMsg);
            byte[] byArray = Base64.decode((String)encryptedMsg, (int)0);
            EMLog.d(TAG, "base64 decode bytes:" + EasyUtils.convertByteArrayToString(byArray));
            EMEncryptProvider eMEncryptProvider = EMClient.getInstance().getEncryptProvider();
            byte[] byArray2 = eMEncryptProvider.decrypt(byArray, fromUserName);
            EMLog.d(TAG, "decrypt bytes:" + EasyUtils.convertByteArrayToString(byArray2));
            String string = new String(byArray2, "UTF-8");
            EMLog.d(TAG, "descripted str:" + string);
            return string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return encryptedMsg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encryptFile(String filePath, String toUserName) {
        String string;
        Object object;
        RandomAccessFile randomAccessFile = null;
        FileOutputStream fileOutputStream = null;
        try {
            EMLog.d(TAG, "try to encrypt file:" + filePath);
            randomAccessFile = new RandomAccessFile(filePath, "r");
            int n = (int)randomAccessFile.length();
            EMLog.d(TAG, "try to encrypt file:" + filePath + " original len:" + n);
            object = new byte[n];
            int n2 = randomAccessFile.read((byte[])object);
            if (n2 != n) {
                EMLog.e(TAG, "error read file, file len:" + n + " readLen:" + n2);
                randomAccessFile.close();
                String string2 = filePath;
                return string2;
            }
            EMEncryptProvider eMEncryptProvider = EMClient.getInstance().getEncryptProvider();
            byte[] byArray = eMEncryptProvider.encrypt((byte[])object, toUserName);
            String string3 = null;
            int n3 = filePath.lastIndexOf(46);
            if (n3 >= 0) {
                string3 = filePath.substring(n3);
            }
            File file = File.createTempFile("encrypted", string3);
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
            String string4 = file.getAbsolutePath();
            EMLog.d(TAG, "generated encrypted file:" + string4);
            string = string4;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            object = filePath;
            return object;
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (Exception exception) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decryptFile(String filePath, String fromUserName) {
        RandomAccessFile randomAccessFile = null;
        FileOutputStream fileOutputStream = null;
        try {
            EMLog.d(TAG, "decrypt file:" + filePath);
            randomAccessFile = new RandomAccessFile(filePath, "r");
            int n = (int)randomAccessFile.length();
            byte[] byArray = new byte[n];
            int n2 = randomAccessFile.read(byArray);
            if (n2 != n) {
                EMLog.e(TAG, "error read file, file len:" + n + " readLen:" + n2);
                return;
            }
            EMEncryptProvider eMEncryptProvider = EMClient.getInstance().getEncryptProvider();
            byte[] byArray2 = eMEncryptProvider.decrypt(byArray, fromUserName);
            fileOutputStream = new FileOutputStream(filePath, false);
            fileOutputStream.write(byArray2);
            EMLog.d(TAG, "decrypted file:" + filePath);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (Exception exception) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

