/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.http.X509TrustManagerExtensions;
import android.os.Build;
import android.os.Bundle;
import android.os.PowerManager;
import android.os.Process;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.hyphenate.EMCallBack;
import com.hyphenate.EMConnectionListener;
import com.hyphenate.EMLogListener;
import com.hyphenate.EMMultiDeviceListener;
import com.hyphenate.EMValueCallBack;
import com.hyphenate.chat.EMChatManager;
import com.hyphenate.chat.EMChatRoomManager;
import com.hyphenate.chat.EMChatThreadManager;
import com.hyphenate.chat.EMCheckType;
import com.hyphenate.chat.EMContact;
import com.hyphenate.chat.EMContactManager;
import com.hyphenate.chat.EMConversation;
import com.hyphenate.chat.EMDeviceInfo;
import com.hyphenate.chat.EMEncryptProvider;
import com.hyphenate.chat.EMGroupManager;
import com.hyphenate.chat.EMLoginType;
import com.hyphenate.chat.EMOptions;
import com.hyphenate.chat.EMPresenceManager;
import com.hyphenate.chat.EMPushManager;
import com.hyphenate.chat.EMSessionManager;
import com.hyphenate.chat.EMSmartHeartBeat;
import com.hyphenate.chat.EMStatisticsManager;
import com.hyphenate.chat.EMTimeTag;
import com.hyphenate.chat.EMTranslationManager;
import com.hyphenate.chat.EMUserInfoManager;
import com.hyphenate.chat.adapter.EMAChatClient;
import com.hyphenate.chat.adapter.EMAConnectionListener;
import com.hyphenate.chat.adapter.EMADeviceInfo;
import com.hyphenate.chat.adapter.EMAError;
import com.hyphenate.chat.adapter.EMALogCallbackListener;
import com.hyphenate.chat.adapter.EMAMultiDeviceListener;
import com.hyphenate.chat.adapter.EMANetCallback;
import com.hyphenate.chat.core.EMChatConfigPrivate;
import com.hyphenate.chat.core.a;
import com.hyphenate.cloud.EMHttpClient;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.notification.core.b;
import com.hyphenate.push.EMPushConfig;
import com.hyphenate.push.EMPushHelper;
import com.hyphenate.push.EMPushType;
import com.hyphenate.util.DeviceUuidFactory;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.EasyUtils;
import com.hyphenate.util.NetUtils;
import com.hyphenate.util.PathUtil;
import com.hyphenate.util.Utils;
import internal.com.getkeepsafe.relinker.ReLinker;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import javax.net.ssl.X509TrustManager;
import org.json.JSONException;
import org.json.JSONObject;

public class EMClient {
    public static final String TAG = "EMClient";
    private static EMClient instance = null;
    static boolean libraryLoaded = false;
    private EMGroupManager groupManager;
    private EMChatRoomManager chatroomManager;
    private EMChatManager chatManager;
    private EMContactManager contactManager;
    private EMUserInfoManager userInfoManager;
    private EMPushManager pushManager;
    private EMTranslationManager translationManager;
    private volatile EMPresenceManager presenceManager;
    private EMChatThreadManager threadManager;
    private EMStatisticsManager statisticsManager;
    private EMAChatClient emaObject;
    private Context mContext;
    private ExecutorService executor = null;
    private ExecutorService logQueue = Executors.newSingleThreadExecutor();
    private ExecutorService mainQueue = Executors.newSingleThreadExecutor();
    private ExecutorService sendQueue = Executors.newSingleThreadExecutor();
    private EMEncryptProvider encryptProvider = null;
    private boolean sdkInited = false;
    private EMChatConfigPrivate mChatConfigPrivate;
    private List<EMConnectionListener> connectionListeners = Collections.synchronizedList(new ArrayList());
    private List<EMLogListener> logListeners = Collections.synchronizedList(new ArrayList());
    private ClientLogListener clientLogListener;
    private MyConnectionListener connectionListener;
    private EMSmartHeartBeat smartHeartbeat = null;
    private List<EMMultiDeviceListener> multiDeviceListeners = Collections.synchronizedList(new ArrayList());
    private MyMultiDeviceListener multiDeviceListenerImpl;
    private PowerManager.WakeLock wakeLock;
    private ConnectivityManager connManager;
    private EMAChatClient.EMANetwork currentNetworkType = EMAChatClient.EMANetwork.NETWORK_NONE;
    private boolean mIsLoginWithAgoraToken = false;
    public static final String VERSION = "4.1.2";
    private BroadcastReceiver connectivityBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            EMAChatClient.EMANetwork eMANetwork;
            String string = intent.getAction();
            if (!string.equals("android.net.conn.CONNECTIVITY_CHANGE")) {
                EMLog.d(EMClient.TAG, "skip no connectivity action");
                return;
            }
            EMLog.d(EMClient.TAG, "connectivity receiver onReceiver");
            NetUtils.Types types = NetUtils.getNetworkTypes(EMClient.this.getContext());
            switch (types) {
                case WIFI: 
                case OTHERS: {
                    eMANetwork = EMAChatClient.EMANetwork.NETWORK_WIFI;
                    break;
                }
                case MOBILE: {
                    eMANetwork = EMAChatClient.EMANetwork.NETWORK_MOBILE;
                    break;
                }
                case ETHERNET: {
                    eMANetwork = EMAChatClient.EMANetwork.NETWORK_CABLE;
                    break;
                }
                default: {
                    eMANetwork = EMAChatClient.EMANetwork.NETWORK_NONE;
                }
            }
            boolean bl = EMClient.this.currentNetworkType != EMAChatClient.EMANetwork.NETWORK_NONE;
            boolean bl2 = eMANetwork != EMAChatClient.EMANetwork.NETWORK_NONE;
            EMClient.this.currentNetworkType = eMANetwork;
            if (bl == bl2 && bl2) {
                EMClient.this.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (EMClient.this.smartHeartbeat != null) {
                            EMLog.i(EMClient.TAG, "Network availability no change, just return. " + (Object)((Object)EMClient.this.currentNetworkType) + ", but check ping");
                            EMClient.this.smartHeartbeat.sendPingCheckConnection();
                        }
                    }
                });
                return;
            }
            EMLog.i(EMClient.TAG, "Network availability changed, notify... " + (Object)((Object)EMClient.this.currentNetworkType));
            EMClient.this.execute(new Runnable(){

                @Override
                public void run() {
                    EMClient.this.emaObject.onNetworkChanged(EMClient.this.currentNetworkType);
                }
            });
        }
    };
    private AppStateListener appStateListener;
    private List<Activity> resumeActivityList = new ArrayList<Activity>();
    private boolean duringChecking = false;

    private EMClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EMClient getInstance() {
        if (instance != null) return instance;
        Class<EMClient> clazz = EMClient.class;
        synchronized (EMClient.class) {
            if (instance != null) return instance;
            instance = new EMClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void init(Context context, EMOptions options) {
        if (this.sdkInited) {
            return;
        }
        this.executor = Executors.newCachedThreadPool();
        final EMTimeTag eMTimeTag = new EMTimeTag();
        eMTimeTag.start();
        this.mContext = context.getApplicationContext();
        this.connManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        this.registerActivityLifecycleCallbacks();
        this.loadLibrary();
        this.mChatConfigPrivate = new EMChatConfigPrivate();
        this.mChatConfigPrivate.a(this.mContext, options);
        options.setConfig(this.mChatConfigPrivate);
        DeviceUuidFactory deviceUuidFactory = new DeviceUuidFactory(this.mContext);
        this.mChatConfigPrivate.f(deviceUuidFactory.getDeviceUuid().toString());
        String string = Build.MANUFACTURER + Build.MODEL;
        EMLog.e(TAG, "system device name :" + string);
        if (TextUtils.isEmpty((CharSequence)options.getCustomDeviceName())) {
            this.mChatConfigPrivate.i(string);
        }
        this.mChatConfigPrivate.g(this.getDidInfo());
        this.mChatConfigPrivate.h(UUID.randomUUID().toString());
        EMPushConfig eMPushConfig = options.getPushConfig();
        if (eMPushConfig == null) {
            eMPushConfig = new EMPushConfig.Builder(this.mContext).build();
        }
        EMPushConfig.Builder builder = new EMPushConfig.Builder(this.mContext, eMPushConfig);
        EMPushHelper.getInstance().init(this.mContext, builder.build());
        this.emaObject = EMAChatClient.create(this.mChatConfigPrivate.a);
        this.connectionListener = new MyConnectionListener();
        this.emaObject.addConnectionListener(this.connectionListener);
        this.multiDeviceListenerImpl = new MyMultiDeviceListener();
        this.emaObject.addMultiDeviceListener(this.multiDeviceListenerImpl);
        this.initManagers();
        this.mIsLoginWithAgoraToken = EMSessionManager.getInstance().getIsLoginWithAgoraToken();
        final String string2 = EMSessionManager.getInstance().getLastLoginUser();
        EMLog.e(TAG, "is autoLogin : " + options.getAutoLogin());
        EMLog.e(TAG, "lastLoginUser : " + string2);
        EMLog.e(TAG, "hyphenate SDK is initialized with version : " + this.getChatConfigPrivate().e());
        PowerManager powerManager = (PowerManager)this.mContext.getSystemService("power");
        this.wakeLock = powerManager.newWakeLock(1, "emclient");
        b.a().a(this.mContext);
        this.sdkInited = true;
        this.mContext.registerReceiver(this.connectivityBroadcastReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        this.onNetworkChanged();
        if (options.getAutoLogin() && this.isLoggedInBefore()) {
            String string3 = EMSessionManager.getInstance().getLastLoginToken();
            String string4 = EMSessionManager.getInstance().getLastLoginPwd();
            EMSessionManager.getInstance().currentUser = new EMContact(string2);
            EMCallBack eMCallBack = new EMCallBack(){

                @Override
                public void onSuccess() {
                    EMSessionManager.getInstance().currentUser = new EMContact(string2);
                    Log.d((String)EMClient.TAG, (String)"hyphenate login onSuccess");
                    eMTimeTag.stop();
                    EMLog.d(EMClient.TAG, "[Collector][sdk init]init time is : " + eMTimeTag.timeStr());
                }

                @Override
                public void onError(int code, String error) {
                    Log.d((String)EMClient.TAG, (String)"hyphenate login onError");
                    eMTimeTag.stop();
                    EMLog.d(EMClient.TAG, "[Collector][sdk init]init time is : " + eMTimeTag.timeStr());
                }

                @Override
                public void onProgress(int progress, String status) {
                }
            };
            this._login(string2, EMSessionManager.getInstance().isLastLoginWithToken() ? string3 : string4, eMCallBack, true, EMSessionManager.getInstance().isLastLoginWithToken() ? EMLoginType.LOGIN_TOKEN : EMLoginType.LOGIN_PASSWORD);
        } else {
            eMTimeTag.stop();
            EMLog.d(TAG, "[Collector][sdk init]init time is : " + eMTimeTag.timeStr());
        }
    }

    private String getDidInfo() {
        String string = Build.MANUFACTURER;
        String string2 = Build.MODEL;
        String string3 = Build.HARDWARE;
        int n = Build.VERSION.SDK_INT;
        String string4 = Build.VERSION.RELEASE;
        String string5 = string + "/" + string2 + "/" + string3 + "/" + n + "/" + string4;
        return string5;
    }

    public void createAccount(String username, String password) throws HyphenateException {
        username = username.toLowerCase();
        Pattern pattern = Pattern.compile("^[a-zA-Z0-9_.-]+$");
        boolean bl = pattern.matcher(username).find();
        if (!bl) {
            throw new HyphenateException(205, "illegal user name");
        }
        EMAError eMAError = this.emaObject.createAccount(username, password);
        this.handleError(eMAError);
    }

    public void login(String id, String password, @NonNull EMCallBack callback) {
        if (id == null || password == null || id.equals("") || password.equals("")) {
            callback.onError(110, "username or password is null or empty!");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.getChatConfigPrivate().k())) {
            callback.onError(110, "please setup your App Key  either in AndroidManifest.xml or through the EMOptions");
            return;
        }
        if (!this.sdkInited) {
            callback.onError(1, "sdk not initialized");
            return;
        }
        id = id.toLowerCase();
        this.initLoginWithAgoraData(false, "", 0L);
        this._login(id, password, callback, false, EMLoginType.LOGIN_PASSWORD);
    }

    public void loginWithToken(String username, String token, @NonNull EMCallBack callback) {
        if (TextUtils.isEmpty((CharSequence)this.getChatConfigPrivate().k())) {
            callback.onError(110, "please setup your App Key  either in AndroidManifest.xml or through the EMOptions");
            return;
        }
        if (username == null || token == null || username.equals("") || token.equals("")) {
            callback.onError(110, "username or token is null or empty!");
            return;
        }
        if (!this.sdkInited) {
            callback.onError(1, "sdk not initialized");
            return;
        }
        username = username.toLowerCase();
        this.initLoginWithAgoraData(false, "", 0L);
        this._login(username, token, callback, false, EMLoginType.LOGIN_TOKEN);
    }

    public void loginWithAgoraToken(String username, String agoraToken, @NonNull EMCallBack callback) {
        if (TextUtils.isEmpty((CharSequence)this.getChatConfigPrivate().k())) {
            callback.onError(110, "please setup your App Key  either in AndroidManifest.xml or through the EMOptions");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)username) || TextUtils.isEmpty((CharSequence)agoraToken)) {
            callback.onError(110, "username or agoraToken is null or empty!");
            return;
        }
        if (!this.sdkInited) {
            callback.onError(1, "sdk not initialized");
            return;
        }
        this._login(username.toLowerCase(), agoraToken, callback, false, EMLoginType.LOGIN_AGORA_TOKEN);
    }

    private synchronized void getChatToken(String username, String agoraToken, EMCallBack callback) {
        EMAError eMAError = new EMAError();
        String string = this.emaObject.getChatTokenbyAgoraToken(agoraToken, eMAError);
        if (eMAError.errCode() == 0) {
            EMLog.d(TAG, "getChatTokenbyAgoraToken success");
            if (string != null && string.length() > 0) {
                try {
                    JSONObject jSONObject = new JSONObject(string);
                    if (jSONObject != null) {
                        String string2 = jSONObject.optString("access_token");
                        String string3 = jSONObject.optString("expire_timestamp");
                        long l = Long.valueOf(string3) - System.currentTimeMillis();
                        if (TextUtils.isEmpty((CharSequence)string2)) {
                            throw new Exception("chatToken  is null or empty!");
                        }
                        this.initLoginWithAgoraData(true, string3, l);
                        this._login(username.toLowerCase(), string2, callback, false, EMLoginType.LOGIN_AGORA_TOKEN);
                    }
                }
                catch (Exception exception) {
                    EMLog.e(TAG, "getChatTokenbyAgoraToken Exception:" + exception.getMessage());
                    callback.onError(1, "getChatTokenbyAgoraToken Exception:" + exception.getMessage());
                }
            } else {
                EMLog.e(TAG, "getChatTokenbyAgoraToken response is null");
                callback.onError(1, "getChatTokenbyAgoraToken response is null or empty!");
            }
        } else {
            callback.onError(eMAError.errCode(), eMAError.errMsg());
            EMLog.e(TAG, "getChatTokenbyAgoraToken failed error:" + eMAError.errCode() + "  errorMessage:" + eMAError.errMsg());
        }
    }

    private void initLoginWithAgoraData(boolean isLoginWithAgoraToken, String expireTimestamp, long tokenAvailablePeriod) {
        this.mIsLoginWithAgoraToken = isLoginWithAgoraToken;
        if (isLoginWithAgoraToken) {
            EMSessionManager.getInstance().setLoginWithAgoraData(isLoginWithAgoraToken, expireTimestamp, tokenAvailablePeriod);
        } else {
            EMSessionManager.getInstance().clearLoginWithAgoraTokenData();
        }
    }

    public void notifyTokenExpired(String response) {
        if (this.connectionListener != null && this.mIsLoginWithAgoraToken) {
            try {
                JSONObject jSONObject = new JSONObject(response);
                if (jSONObject != null) {
                    String string = jSONObject.optString("error_description");
                    EMLog.e(TAG, "notifyTokenExpired--errorDescription:" + string);
                    if (string.contains("milliseconds ago") || string.contains("has expired") || string.contains("Unable to authenticate due to expired access Token")) {
                        this.connectionListener.onTokenNotification(401);
                        EMLog.e(TAG, "notifyTokenExpired--onTokenNotification(401) ");
                    }
                }
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
    }

    public void renewToken(final String newAgoraToken) {
        if (this.mIsLoginWithAgoraToken && this.emaObject.isLoggedIn()) {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    EMClient.this.getChatToken(EMClient.this.getCurrentUser(), newAgoraToken, new EMCallBack(){

                        @Override
                        public void onSuccess() {
                        }

                        @Override
                        public void onError(int code, String error) {
                        }

                        @Override
                        public void onProgress(int progress, String status) {
                        }
                    });
                }
            });
        } else {
            EMLog.e(TAG, "the method  excepted to be called when login by agoraToken and login state is loggeIn");
        }
    }

    public int logout(boolean unbindToken) {
        if (!this.emaObject.isLogout()) {
            String string = a.a().q();
            String string2 = a.a().r();
            if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2)) {
                try {
                    this.pushManager().unBindDeviceToken();
                }
                catch (Exception exception) {
                    return 212;
                }
            } else {
                boolean bl = EMPushHelper.getInstance().unregister(unbindToken);
                if (!bl) {
                    return 212;
                }
            }
        } else {
            EMPushHelper.getInstance().unregister(false);
            EMLog.e(TAG, "already logout, skip unbind token");
        }
        this.logout();
        return 0;
    }

    void logout() {
        EMLog.d(TAG, " SDK Logout");
        try {
            if (this.connectivityBroadcastReceiver != null) {
                this.mContext.unregisterReceiver(this.connectivityBroadcastReceiver);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        EMSessionManager.getInstance().clearLastLoginUser();
        EMSessionManager.getInstance().clearLastLoginToken();
        EMSessionManager.getInstance().clearLoginWithAgoraTokenData();
        if (this.smartHeartbeat != null) {
            this.smartHeartbeat.stop();
        }
        this.releaseWakelock();
        if (this.emaObject != null) {
            this.emaObject.logout();
        }
        if (this.chatManager != null) {
            this.chatManager.onLogout();
        }
        if (this.groupManager != null) {
            this.groupManager.onLogout();
        }
        if (this.contactManager != null) {
            this.contactManager.onLogout();
        }
        if (this.chatroomManager != null) {
            this.chatroomManager.onLogout();
        }
        if (EMChatConfigPrivate.a()) {
            com.hyphenate.a.a.c();
        }
    }

    public void logout(final boolean unbindToken, final EMCallBack callback) {
        new Thread(){

            @Override
            public void run() {
                int n = EMClient.this.logout(unbindToken);
                if (n != 0) {
                    if (callback != null) {
                        callback.onError(n, "faild to unbind device token");
                    }
                } else if (callback != null) {
                    callback.onSuccess();
                }
            }
        }.start();
    }

    void logout(final EMCallBack callback) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                if (callback != null) {
                    callback.onProgress(0, null);
                }
                EMClient.this.logout();
                if (callback != null) {
                    callback.onSuccess();
                }
            }
        };
        thread.setPriority(9);
        thread.start();
    }

    public void changeAppkey(String appkey) throws HyphenateException {
        EMAError eMAError = this.emaObject.changeAppkey(appkey);
        if (eMAError.errCode() == 0) {
            this.getOptions().updatePath(appkey);
        }
        this.handleError(eMAError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(final EMConnectionListener listener) {
        if (listener == null) {
            return;
        }
        List<EMConnectionListener> list = this.connectionListeners;
        synchronized (list) {
            if (!this.connectionListeners.contains(listener)) {
                this.connectionListeners.add(listener);
            }
        }
        this.execute(new Runnable(){

            @Override
            public void run() {
                if (EMClient.this.isConnected()) {
                    listener.onConnected();
                } else if (EMClient.this.isLoggedIn()) {
                    listener.onDisconnected(2);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(EMConnectionListener listener) {
        if (listener == null) {
            return;
        }
        List<EMConnectionListener> list = this.connectionListeners;
        synchronized (list) {
            this.connectionListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogListener(EMLogListener listener) {
        if (listener == null) {
            return;
        }
        List<EMLogListener> list = this.logListeners;
        synchronized (list) {
            if (!this.logListeners.contains(listener)) {
                this.logListeners.add(listener);
            }
        }
        if (this.clientLogListener == null) {
            this.clientLogListener = new ClientLogListener();
            this.emaObject.addLogCallbackListener(this.clientLogListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLogListener(EMLogListener listener) {
        if (listener == null) {
            return;
        }
        List<EMLogListener> list = this.logListeners;
        synchronized (list) {
            this.logListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EMGroupManager groupManager() {
        if (this.groupManager != null) return this.groupManager;
        Class<EMClient> clazz = EMClient.class;
        synchronized (EMClient.class) {
            if (this.groupManager != null) return this.groupManager;
            this.groupManager = new EMGroupManager(this, this.emaObject.getGroupManager());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.groupManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EMPushManager pushManager() {
        if (this.pushManager != null) return this.pushManager;
        Class<EMClient> clazz = EMClient.class;
        synchronized (EMClient.class) {
            if (this.pushManager != null) return this.pushManager;
            this.pushManager = new EMPushManager(this, this.emaObject.getPushMnager());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.pushManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EMChatRoomManager chatroomManager() {
        if (this.chatroomManager != null) return this.chatroomManager;
        Class<EMClient> clazz = EMClient.class;
        synchronized (EMClient.class) {
            if (this.chatroomManager != null) return this.chatroomManager;
            this.chatroomManager = new EMChatRoomManager(this, this.emaObject.getChatRoomManager());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.chatroomManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EMChatManager chatManager() {
        if (this.chatManager != null) return this.chatManager;
        Class<EMClient> clazz = EMClient.class;
        synchronized (EMClient.class) {
            if (this.chatManager != null) return this.chatManager;
            this.chatManager = new EMChatManager(this, this.emaObject.getChatManager(), this.emaObject.getReactionManager());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.chatManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EMUserInfoManager userInfoManager() {
        if (this.userInfoManager != null) return this.userInfoManager;
        Class<EMClient> clazz = EMClient.class;
        synchronized (EMClient.class) {
            if (this.userInfoManager != null) return this.userInfoManager;
            this.userInfoManager = new EMUserInfoManager(this.emaObject.getUserInfoManager());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.userInfoManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EMContactManager contactManager() {
        if (this.contactManager != null) return this.contactManager;
        Class<EMClient> clazz = EMClient.class;
        synchronized (EMClient.class) {
            if (this.contactManager != null) return this.contactManager;
            this.contactManager = new EMContactManager(this, this.emaObject.getContactManager());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.contactManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EMTranslationManager translationManager() {
        if (this.translationManager != null) return this.translationManager;
        Class<EMClient> clazz = EMClient.class;
        synchronized (EMClient.class) {
            if (this.translationManager != null) return this.translationManager;
            this.translationManager = new EMTranslationManager(this.emaObject.getTranslateManager());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.translationManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EMPresenceManager presenceManager() {
        if (this.presenceManager != null) return this.presenceManager;
        Class<EMClient> clazz = EMClient.class;
        synchronized (EMClient.class) {
            if (this.presenceManager != null) return this.presenceManager;
            this.presenceManager = new EMPresenceManager(this.emaObject.getPresenceManager());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.presenceManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EMChatThreadManager chatThreadManager() {
        if (this.threadManager != null) return this.threadManager;
        Class<EMClient> clazz = EMClient.class;
        synchronized (EMClient.class) {
            if (this.threadManager != null) return this.threadManager;
            this.threadManager = new EMChatThreadManager(this, this.emaObject.getThreadManager());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.threadManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EMStatisticsManager statisticsManager() {
        if (this.statisticsManager != null) return this.statisticsManager;
        Class<EMClient> clazz = EMClient.class;
        synchronized (EMClient.class) {
            if (this.statisticsManager != null) return this.statisticsManager;
            this.statisticsManager = new EMStatisticsManager(this, this.emaObject.getStatisticsManager());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.statisticsManager;
        }
    }

    public Context getContext() {
        return this.mContext;
    }

    public synchronized String getCurrentUser() {
        if (EMSessionManager.getInstance().currentUser == null || EMSessionManager.getInstance().currentUser.username == null || EMSessionManager.getInstance().currentUser.username.equals("")) {
            return EMSessionManager.getInstance().getLastLoginUser();
        }
        return EMSessionManager.getInstance().currentUser.username;
    }

    public void getUserTokenFromServer(final String username, final String password, final EMValueCallBack<String> callBack) {
        this.execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                String string = EMClient.this.emaObject.getUserTokenFromServer(username, password, eMAError);
                if (callBack == null) {
                    return;
                }
                if (eMAError.errCode() == 0) {
                    callBack.onSuccess(string);
                } else {
                    callBack.onError(eMAError.errCode(), eMAError.errMsg());
                }
            }
        });
    }

    public boolean isLoggedInBefore() {
        EMSessionManager eMSessionManager = EMSessionManager.getInstance();
        String string = eMSessionManager.getLastLoginUser();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        String string2 = eMSessionManager.getLastLoginPwd();
        String string3 = eMSessionManager.getLastLoginToken();
        return string != null && !string.isEmpty() && (string2 != null && !string2.isEmpty() || string3 != null && !string3.isEmpty());
    }

    public boolean isConnected() {
        return this.emaObject.isConnected();
    }

    public boolean isLoggedIn() {
        return this.emaObject.isLoggedIn();
    }

    public void setDebugMode(boolean debugMode) {
        EMLog.debugMode = debugMode;
        this.getChatConfigPrivate().c(debugMode);
    }

    public void uploadLog(EMCallBack callback) {
        this.chatManager().emaObject.uploadLog();
    }

    public EMOptions getOptions() {
        return this.mChatConfigPrivate.b();
    }

    public String compressLogs() throws HyphenateException {
        EMAError eMAError = new EMAError();
        String string = this.emaObject.compressLogs(eMAError);
        this.handleError(eMAError);
        return string;
    }

    public void addMultiDeviceListener(EMMultiDeviceListener listener) {
        this.multiDeviceListeners.add(listener);
    }

    public void removeMultiDeviceListener(EMMultiDeviceListener listener) {
        this.multiDeviceListeners.remove(listener);
    }

    public List<EMDeviceInfo> getLoggedInDevicesFromServer(String username, String password) throws HyphenateException {
        EMAError eMAError = new EMAError();
        List<EMADeviceInfo> list = this.emaObject.getLoggedInDevicesFromServer(username, password, eMAError);
        this.handleError(eMAError);
        ArrayList<EMDeviceInfo> arrayList = new ArrayList<EMDeviceInfo>();
        for (EMADeviceInfo eMADeviceInfo : list) {
            arrayList.add(new EMDeviceInfo(eMADeviceInfo));
        }
        return arrayList;
    }

    public List<EMDeviceInfo> getLoggedInDevicesFromServerWithToken(@NonNull String username, @NonNull String token) throws HyphenateException {
        EMAError eMAError = new EMAError();
        List<EMADeviceInfo> list = this.emaObject.getLoggedInDevicesFromServerWithToken(username, token, eMAError);
        this.handleError(eMAError);
        ArrayList<EMDeviceInfo> arrayList = new ArrayList<EMDeviceInfo>();
        for (EMADeviceInfo eMADeviceInfo : list) {
            arrayList.add(new EMDeviceInfo(eMADeviceInfo));
        }
        return arrayList;
    }

    public void kickDevice(String username, String password, String resource) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.kickDevice(username, password, resource, eMAError);
        this.handleError(eMAError);
    }

    public void kickDeviceWithToken(@NonNull String username, @NonNull String token, String resource) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.kickDeviceWithToken(username, token, resource, eMAError);
        this.handleError(eMAError);
    }

    public void kickAllDevices(String username, String password) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.kickAllDevices(username, password, eMAError);
        this.handleError(eMAError);
    }

    public void kickAllDevicesWithToken(@NonNull String username, @NonNull String token) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.kickAllDevicesWithToken(username, token, eMAError);
        this.handleError(eMAError);
    }

    public void sendFCMTokenToServer(String fcmToken) {
        EMLog.d(TAG, "sendFCMTokenToServer: " + fcmToken);
        if (TextUtils.isEmpty((CharSequence)fcmToken)) {
            return;
        }
        String string = this.getCurrentUser();
        if (TextUtils.isEmpty((CharSequence)string)) {
            EMLog.i(TAG, "No user login currently, stop upload the token.");
            return;
        }
        EMPushType eMPushType = EMPushHelper.getInstance().getPushType();
        EMLog.i(TAG, "pushType: " + (Object)((Object)eMPushType));
        if (eMPushType == EMPushType.FCM) {
            EMPushHelper.getInstance().onReceiveToken(eMPushType, fcmToken);
        }
    }

    public void sendHMSPushTokenToServer(String token) {
        if (EMPushHelper.getInstance().getPushType() == EMPushType.HMSPUSH) {
            EMPushHelper.getInstance().onReceiveToken(EMPushType.HMSPUSH, token);
        }
    }

    public void sendHonorPushTokenToServer(String token) {
        if (EMPushHelper.getInstance().getPushType() == EMPushType.HONORPUSH) {
            EMPushHelper.getInstance().onReceiveToken(EMPushType.HONORPUSH, token);
        }
    }

    private void initManagers() {
        EMHttpClient.getInstance().onInit(this.mChatConfigPrivate);
        this.chatManager();
        this.contactManager();
        this.groupManager();
        this.chatroomManager();
        this.presenceManager();
        this.chatThreadManager();
        this.setNatvieNetworkCallback();
        EMSessionManager.getInstance().init(this, this.emaObject.getSessionManager());
    }

    void _login(final String username, final String code, final EMCallBack callback, final boolean autoLogin, final EMLoginType loginType) {
        if (this.getChatConfigPrivate() == null || !this.sdkInited) {
            callback.onError(1, "");
            return;
        }
        EMLog.e(TAG, "emchat manager login in process:" + Process.myPid());
        this.execute(new Runnable(){

            @Override
            public void run() {
                EMLog.e(EMClient.TAG, "emchat manager login in process:" + Process.myPid() + " threadName:" + Thread.currentThread().getName() + " ID:" + Thread.currentThread().getId());
                if (username == null) {
                    callback.onError(101, "Invalid user name");
                    return;
                }
                EMAError eMAError = new EMAError();
                EMClient.this.emaObject.login(username, code, autoLogin, loginType.ordinal(), eMAError);
                if (eMAError.errCode() == 0) {
                    EMSessionManager.getInstance().setLastLoginUser(username);
                    if (loginType == EMLoginType.LOGIN_TOKEN || loginType == EMLoginType.LOGIN_AGORA_TOKEN) {
                        EMClient.this.saveToken();
                    } else {
                        EMSessionManager.getInstance().setLastLoginPwd(code);
                        EMSessionManager.getInstance().setLastLoginWithToken(false);
                        EMSessionManager.getInstance().clearLastLoginToken();
                    }
                    if (autoLogin) {
                        EMClient.this.loadDataFromDb();
                    }
                    EMClient.this.onNewLogin();
                    EMPushHelper.getInstance().register();
                    callback.onSuccess();
                } else {
                    callback.onError(eMAError.errCode(), eMAError.errMsg());
                    if (eMAError.errCode() == 200 && EMClient.this.mIsLoginWithAgoraToken) {
                        EMClient.this.emaObject.renewToken(code);
                        EMSessionManager.getInstance().setLastLoginToken(code);
                        EMSessionManager.getInstance().startCountDownTokenAvailableTime(EMClient.this.connectionListener);
                    }
                }
                if (eMAError.errCode() == 202) {
                    EMSessionManager.getInstance().clearLastLoginPwd();
                    EMSessionManager.getInstance().clearLastLoginToken();
                }
            }
        });
    }

    private void loadDataFromDb() {
        this.execute(() -> {
            this.groupManager().loadAllGroups();
            this.chatManager().loadAllConversationsFromDB();
        });
    }

    private void saveToken() {
        if (this.emaObject == null) {
            return;
        }
        EMAError eMAError = new EMAError();
        String string = this.emaObject.getUserToken(false, eMAError);
        if (eMAError.errCode() == 0) {
            EMSessionManager.getInstance().setLastLoginToken(string);
            EMSessionManager.getInstance().setLastLoginWithToken(true);
            EMSessionManager.getInstance().clearLastLoginPwd();
            if (this.mIsLoginWithAgoraToken) {
                EMSessionManager.getInstance().startCountDownTokenAvailableTime(this.connectionListener);
            }
        }
    }

    public boolean isFCMAvailable() {
        return EMPushHelper.getInstance().getPushType() == EMPushType.FCM;
    }

    void onNewLogin() {
        EMLog.d(TAG, "on new login created");
        String string = EMSessionManager.getInstance().getLastLoginUser();
        PathUtil.getInstance().initDirs(this.getChatConfigPrivate().k(), string, this.mContext);
        if (this.smartHeartbeat == null) {
            this.smartHeartbeat = EMSmartHeartBeat.create(this.mContext);
        }
        if (this.getChatConfigPrivate().a.hasHeartBeatCustomizedParams()) {
            this.smartHeartbeat.setCustomizedParams(this.getChatConfigPrivate().a.getWifiHeartBeatCustomizedParams(), this.getChatConfigPrivate().a.getMobileHeartBeatCustomizedParams());
        }
        this.smartHeartbeat.onInit();
        if (this.getOptions().getFixedInterval() != -1) {
            this.smartHeartbeat.setFixedInterval(this.getOptions().getFixedInterval());
        }
    }

    public String getAccessToken() {
        return this.getChatConfigPrivate().m();
    }

    public boolean isSdkInited() {
        return this.sdkInited;
    }

    private boolean _loadLibrary(String library, boolean trace) {
        try {
            ReLinker.loadLibrary(this.mContext, library);
            return true;
        }
        catch (Throwable throwable) {
            if (trace) {
                throwable.printStackTrace();
            }
            return false;
        }
    }

    private boolean _loadLibrary(String library) {
        return this._loadLibrary(library, true);
    }

    private void loadLibrary() {
        if (!libraryLoaded) {
            this._loadLibrary("cipherdb", false);
            ReLinker.loadLibrary(this.mContext, "hyphenate");
            libraryLoaded = true;
        }
    }

    void execute(Runnable runnable) {
        this.executor.execute(runnable);
    }

    void executeOnMainQueue(Runnable runnable) {
        this.mainQueue.submit(runnable);
    }

    void executeOnSendQueue(Runnable runnable) {
        this.sendQueue.submit(runnable);
    }

    public EMChatConfigPrivate getChatConfigPrivate() {
        return this.mChatConfigPrivate;
    }

    void setNatvieNetworkCallback() {
        EMANetCallback eMANetCallback = new EMANetCallback(){

            @Override
            public int getNetState() {
                if (!NetUtils.hasDataConnection(EMClient.this.mContext)) {
                    return EMAChatClient.EMANetwork.NETWORK_NONE.ordinal();
                }
                if (NetUtils.isWifiConnected(EMClient.this.mContext) || NetUtils.isOthersConnected(EMClient.this.mContext)) {
                    return EMAChatClient.EMANetwork.NETWORK_WIFI.ordinal();
                }
                if (NetUtils.isMobileConnected(EMClient.this.mContext)) {
                    return EMAChatClient.EMANetwork.NETWORK_MOBILE.ordinal();
                }
                if (NetUtils.isEthernetConnected(EMClient.this.mContext)) {
                    return EMAChatClient.EMANetwork.NETWORK_CABLE.ordinal();
                }
                return EMAChatClient.EMANetwork.NETWORK_NONE.ordinal();
            }
        };
        this.mChatConfigPrivate.a.setNetCallback(eMANetCallback);
    }

    void setEncryptProvider(EMEncryptProvider provider) {
        this.encryptProvider = provider;
    }

    EMEncryptProvider getEncryptProvider() {
        if (this.encryptProvider == null) {
            EMLog.d(TAG, "encrypt provider is not set, create default");
            this.encryptProvider = new EMEncryptProvider(){

                @Override
                public byte[] encrypt(byte[] input, String username) {
                    try {
                        String string = new String(input);
                        return EMClient.this.emaObject.getSessionManager().encrypt(string).getBytes();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return input;
                    }
                }

                @Override
                public byte[] decrypt(byte[] input, String username) {
                    try {
                        String string = new String(input);
                        return EMClient.this.emaObject.getSessionManager().decrypt(string).getBytes();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return input;
                    }
                }
            };
        }
        return this.encryptProvider;
    }

    boolean sendPing(boolean waitPong, long timeout) {
        return this.emaObject.sendPing(waitPong, timeout);
    }

    void checkTokenAvailability() {
        if (this.mIsLoginWithAgoraToken) {
            EMSessionManager.getInstance().checkTokenAvailability(this.connectionListener);
        }
    }

    void forceReconnect() {
        EMLog.d(TAG, "forceReconnect");
        this.disconnect();
        this.reconnect();
    }

    void reconnect() {
        EMLog.d(TAG, "reconnect");
        try {
            this.wakeLock.acquire();
        }
        catch (Exception exception) {
            EMLog.e(TAG, exception.getMessage());
        }
        this.emaObject.reconnect();
        this.releaseWakelock();
    }

    void disconnect() {
        EMLog.d(TAG, "disconnect");
        this.emaObject.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseWakelock() {
        EMClient eMClient = this;
        synchronized (eMClient) {
            if (this.wakeLock != null && this.wakeLock.isHeld()) {
                try {
                    this.wakeLock.release();
                }
                catch (Exception exception) {
                    EMLog.e(TAG, exception.getMessage());
                }
                EMLog.d(TAG, "released the wake lock");
            }
        }
    }

    private void handleError(EMAError error) throws HyphenateException {
        if (error.errCode() != 0) {
            throw new HyphenateException(error);
        }
    }

    void onNetworkChanged() {
        try {
            if (NetUtils.isWifiConnected(this.mContext) || NetUtils.isOthersConnected(this.mContext)) {
                EMLog.d(TAG, "has wifi connection");
                this.currentNetworkType = EMAChatClient.EMANetwork.NETWORK_WIFI;
                this.emaObject.onNetworkChanged(EMAChatClient.EMANetwork.NETWORK_WIFI);
                return;
            }
            if (NetUtils.isMobileConnected(this.mContext)) {
                EMLog.d(TAG, "has mobile connection");
                this.currentNetworkType = EMAChatClient.EMANetwork.NETWORK_MOBILE;
                this.emaObject.onNetworkChanged(EMAChatClient.EMANetwork.NETWORK_MOBILE);
                return;
            }
            if (NetUtils.isEthernetConnected(this.mContext)) {
                EMLog.d(TAG, "has ethernet connection");
                this.currentNetworkType = EMAChatClient.EMANetwork.NETWORK_CABLE;
                this.emaObject.onNetworkChanged(EMAChatClient.EMANetwork.NETWORK_CABLE);
                return;
            }
            this.currentNetworkType = EMAChatClient.EMANetwork.NETWORK_NONE;
            EMLog.d(TAG, "no data connection");
            this.emaObject.onNetworkChanged(EMAChatClient.EMANetwork.NETWORK_NONE);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    void onNetworkChanged(EMAChatClient.EMANetwork network) {
        this.emaObject.onNetworkChanged(network);
    }

    void setAppStateListener(AppStateListener appStateListener) {
        this.appStateListener = appStateListener;
    }

    @TargetApi(value=14)
    private void registerActivityLifecycleCallbacks() {
        if (Utils.isSdk14()) {
            Application.ActivityLifecycleCallbacks activityLifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){

                public void onActivityStopped(Activity activity) {
                    EMClient.this.resumeActivityList.remove(activity);
                    if (EMClient.this.resumeActivityList.isEmpty() && EMClient.this.appStateListener != null) {
                        EMClient.this.appStateListener.onBackground();
                    }
                }

                public void onActivityResumed(Activity activity) {
                }

                public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                }

                public void onActivityStarted(Activity activity) {
                    if (!EMClient.this.resumeActivityList.contains(activity)) {
                        EMClient.this.resumeActivityList.add(activity);
                        if (EMClient.this.resumeActivityList.size() == 1 && EMClient.this.appStateListener != null) {
                            EMClient.this.appStateListener.onForeground();
                        }
                    }
                }

                public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
                }

                public void onActivityPaused(Activity activity) {
                }

                public void onActivityDestroyed(Activity activity) {
                }
            };
            ((Application)this.mContext).registerActivityLifecycleCallbacks(activityLifecycleCallbacks);
        }
    }

    public void check(String username, String password, CheckResultListener listener) {
        Object object;
        if (this.duringChecking) {
            EMLog.i("EMServiceChecker", "During service checking, please hold on...");
            return;
        }
        this.duringChecking = true;
        if (this.isLoggedInBefore()) {
            username = this.getCurrentUser();
            object = EMSessionManager.getInstance();
            password = ((EMSessionManager)object).getLastLoginPwd();
        }
        object = username;
        String string = password;
        new Thread(new Runnable((String)object, string, listener){
            final /* synthetic */ String val$finalUser;
            final /* synthetic */ String val$finalPwd;
            final /* synthetic */ CheckResultListener val$listener;
            {
                this.val$finalUser = string;
                this.val$finalPwd = string2;
                this.val$listener = checkResultListener;
            }

            @Override
            public void run() {
                EMClient.this.emaObject.check(this.val$finalUser, this.val$finalPwd, new EMAChatClient.CheckResultListener(){

                    @Override
                    public void onResult(int type, int result, String desc) {
                        EMLog.i("EMServiceChecker", "type: " + type + ", result: " + result + ", desc: " + desc);
                        EMClient.this.notifyCheckResult(val$listener, type, result, desc);
                        if (result != 0) {
                            EMClient.this.duringChecking = false;
                            return;
                        }
                        if (type == 3) {
                            EMClient.this.checkLogout(val$listener);
                        }
                    }
                });
            }
        }).start();
    }

    private void checkLogout(CheckResultListener listener) {
        if (!this.isLoggedInBefore()) {
            this.logout();
            this.notifyCheckResult(listener, 5, 0, "");
        }
        this.duringChecking = false;
    }

    private void notifyCheckResult(CheckResultListener listener, @EMCheckType.CheckType int type, int result, String desc) {
        if (listener == null) {
            return;
        }
        listener.onResult(type, result, desc);
    }

    public static interface CheckResultListener {
        public void onResult(@EMCheckType.CheckType int var1, int var2, String var3);
    }

    static interface AppStateListener {
        public void onForeground();

        public void onBackground();
    }

    class ClientLogListener
    extends EMALogCallbackListener {
        ClientLogListener() {
        }

        @Override
        public void onLogCallback(String log) {
            EMClient.this.logQueue.submit(() -> {
                List list = EMClient.this.logListeners;
                synchronized (list) {
                    for (EMLogListener eMLogListener : EMClient.this.logListeners) {
                        try {
                            eMLogListener.onLog(log);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }
    }

    class MyMultiDeviceListener
    extends EMAMultiDeviceListener {
        MyMultiDeviceListener() {
        }

        @Override
        public void onContactEvent(final int event, final String target, final String ext) {
            EMLog.d(EMClient.TAG, "onContactEvent:" + event + " target:" + target + " ext:" + ext);
            EMClient.this.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List list = EMClient.this.multiDeviceListeners;
                    synchronized (list) {
                        try {
                            for (EMMultiDeviceListener eMMultiDeviceListener : EMClient.this.multiDeviceListeners) {
                                eMMultiDeviceListener.onContactEvent(event, target, ext);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }

        @Override
        public void onGroupEvent(final int event, final String target, final List<String> usernames) {
            EMLog.d(EMClient.TAG, "onGroupEvent:" + event + " target:" + target + " usernames:" + usernames);
            EMClient.this.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List list = EMClient.this.multiDeviceListeners;
                    synchronized (list) {
                        try {
                            for (EMMultiDeviceListener eMMultiDeviceListener : EMClient.this.multiDeviceListeners) {
                                eMMultiDeviceListener.onGroupEvent(event, target, usernames);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }

        @Override
        public void onRoamDeleteEvent(final String conversation, final List<String> msgIdList, final String deviceId, final long beforeTimeStamp) {
            EMLog.d(EMClient.TAG, "onRoamDeleteEvent:" + conversation + " " + deviceId);
            if (TextUtils.isEmpty((CharSequence)conversation)) {
                return;
            }
            EMClient.this.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List list = EMClient.this.multiDeviceListeners;
                    synchronized (list) {
                        try {
                            if (msgIdList != null && msgIdList.size() > 0) {
                                EMClient.this.chatManager.clearCaches(conversation, msgIdList);
                            } else {
                                EMClient.this.chatManager.clearCaches(conversation, beforeTimeStamp);
                            }
                            for (EMMultiDeviceListener eMMultiDeviceListener : EMClient.this.multiDeviceListeners) {
                                eMMultiDeviceListener.onMessageRemoved(conversation, deviceId);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }

        @Override
        public void onThreadEvent(int event, String target, List<String> username) {
            EMLog.d(EMClient.TAG, "onThreadEvent:" + event + " target:" + target + " usernames:" + username);
            EMClient.this.execute(() -> {
                List list = EMClient.this.multiDeviceListeners;
                synchronized (list) {
                    for (EMMultiDeviceListener eMMultiDeviceListener : EMClient.this.multiDeviceListeners) {
                        try {
                            eMMultiDeviceListener.onChatThreadEvent(event, target, username);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }

        @Override
        public void onConversationEvent(int event, String conversationId, int type) {
            EMLog.d(EMClient.TAG, "onConversationEvent: " + event + " conversationId: " + conversationId + " type: " + type);
            EMConversation.EMConversationType eMConversationType = type == EMConversation.EMConversationType.GroupChat.ordinal() ? EMConversation.EMConversationType.GroupChat : EMConversation.EMConversationType.Chat;
            EMClient.this.execute(() -> {
                List list = EMClient.this.multiDeviceListeners;
                synchronized (list) {
                    for (EMMultiDeviceListener eMMultiDeviceListener : EMClient.this.multiDeviceListeners) {
                        try {
                            eMMultiDeviceListener.onConversationEvent(event, conversationId, eMConversationType);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }
    }

    class MyConnectionListener
    extends EMAConnectionListener {
        MyConnectionListener() {
        }

        @Override
        public void onConnected() {
            EMClient.this.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List list = EMClient.this.connectionListeners;
                    synchronized (list) {
                        try {
                            for (EMConnectionListener eMConnectionListener : EMClient.this.connectionListeners) {
                                eMConnectionListener.onConnected();
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }

        @Override
        public void onDisconnected(final int errCode, final String info) {
            EMLog.e(EMClient.TAG, "onDisconnected errcode = " + errCode + ",info = " + info);
            EMClient.this.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List list = EMClient.this.connectionListeners;
                    synchronized (list) {
                        switch (errCode) {
                            case 207: {
                                EMSessionManager.getInstance().clearLastLoginUser();
                                EMSessionManager.getInstance().clearLastLoginToken();
                                EMSessionManager.getInstance().clearLastLoginPwd();
                                break;
                            }
                            case 8: 
                            case 206: 
                            case 213: 
                            case 214: 
                            case 216: 
                            case 217: 
                            case 220: 
                            case 305: {
                                EMSessionManager.getInstance().clearLastLoginToken();
                                EMSessionManager.getInstance().clearLastLoginPwd();
                                if (!EMClient.this.isSdkInited()) break;
                                a.a().i("");
                                a.a().h("");
                            }
                        }
                        try {
                            for (EMConnectionListener eMConnectionListener : EMClient.this.connectionListeners) {
                                eMConnectionListener.onDisconnected(errCode);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (errCode == 206 || errCode == 207 || errCode == 213 || errCode == 220 || errCode == 305 || errCode == 214 || errCode == 216 || errCode == 217 || errCode == 8) {
                            for (EMConnectionListener eMConnectionListener : EMClient.this.connectionListeners) {
                                try {
                                    eMConnectionListener.onLogout(errCode, info);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                        }
                    }
                }
            });
        }

        @Override
        public boolean verifyServerCert(List<String> certschain, String domain) {
            if (certschain == null) {
                EMLog.d(EMClient.TAG, "List<String> certschain : null ");
                return false;
            }
            if (TextUtils.isEmpty((CharSequence)domain)) {
                EMLog.d(EMClient.TAG, "domain is empty or null ");
                return false;
            }
            EMLog.d(EMClient.TAG, "domain = " + domain);
            X509Certificate[] x509CertificateArray = EasyUtils.convertToCerts(certschain);
            try {
                X509TrustManager x509TrustManager = EasyUtils.getSystemDefaultTrustManager();
                X509TrustManagerExtensions x509TrustManagerExtensions = new X509TrustManagerExtensions(x509TrustManager);
                x509TrustManagerExtensions.checkServerTrusted(x509CertificateArray, x509CertificateArray[0].getType(), domain);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                EMLog.e(EMClient.TAG, exception.getMessage());
                EMLog.d(EMClient.TAG, "List<String> certschain :" + certschain.toString());
                return false;
            }
            return true;
        }

        @Override
        public void onTokenNotification(final int code) {
            EMClient.this.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List list = EMClient.this.connectionListeners;
                    synchronized (list) {
                        try {
                            if (code == 108 || code == 401) {
                                EMClient.this.logout();
                                for (EMConnectionListener eMConnectionListener : EMClient.this.connectionListeners) {
                                    EMLog.d(EMClient.TAG, "MyConnectionListener onTokenExpired code: " + code);
                                    eMConnectionListener.onTokenExpired();
                                }
                            } else {
                                for (EMConnectionListener eMConnectionListener : EMClient.this.connectionListeners) {
                                    EMLog.d(EMClient.TAG, "MyConnectionListener onTokenWillExpire code: " + code);
                                    eMConnectionListener.onTokenWillExpire();
                                }
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            EMLog.e(EMClient.TAG, "MyConnectionListener onTokenNotification Exception: " + exception.getMessage());
                        }
                    }
                }
            });
        }

        @Override
        public void onReceiveToken(String token, long expireTimestamp) {
            if (TextUtils.isEmpty((CharSequence)token) || expireTimestamp <= 0L) {
                EMLog.e(EMClient.TAG, "onReceiveToken: params received is invalid");
                return;
            }
            long l = expireTimestamp - System.currentTimeMillis();
            EMClient.this.initLoginWithAgoraData(true, String.valueOf(expireTimestamp), l);
            EMClient.this.saveToken();
        }

        @Override
        public void onDatabaseOpened(int errCode) {
            EMLog.e(EMClient.TAG, "onDatabaseOpened: errCode: " + errCode);
        }
    }
}

