package com.hyphenate.push;

import com.hyphenate.push.common.PushUtil;

/**
 * \~chinese
 * 用于设置自定义的推送设置。
 *
 * \~english
 * The push settings class for customized push.
 */
public abstract class PushListener {
    public abstract void onError(EMPushType pushType, long errorCode);

    public boolean isSupportPush(EMPushType pushType, EMPushConfig pushConfig) {
        return PushUtil.isSupportPush(pushType, pushConfig);
    }

    /**
     * \~chinese
     * 获取 FCM 设备 token。
     * @param pushType      推送类型。
     * @param pushConfig    推送配置。
     * @return              返回要注册的设备 token。
     *
     * \~english
     * Gets the FCM device token.
     * @param pushType      The push type.
     * @param pushConfig    The push configs.
     * @return              Returns the device token to register.
     */
    public String getPushToken(EMPushType pushType,EMPushConfig pushConfig) {
        return "";
    }
}
