package com.hyphenate.chat;

/**
     * \~chinese
     * 用户属性类，包含用户属性信息。
     * 
     * \~english
     * The user attribute class that contains user attributes.
     */
public class EMUserInfo {
    /**
     * \~chinese
     * 用户昵称。
     * 
     * \~english
     * The user's nickname.
     */
    private String nickname;

    /**
     * \~chinese
     * 用户的头像 URL。
     * 
     * \~english
     * The avatar URL of the user.
     */
    private String avatarUrl;

     /**
     * \~chinese
     * 用户的邮箱地址。
     * 
     * \~english
     * The email address of the user.
     */
    private String email;

    /**
     * \~chinese
     * 用户的电话号码。
     * 
     * \~english
     * The phone number of the user.
     */
    private String phoneNumber;

    /**
     * \~chinese
     * 用户的性别。取值如下：0：未知，默认值；1：男性；2：女性。其他值无效。
     * 
     * \~english
     * The user's gender. The value can only be 0, 1, or 2. 0: default; 1: male; 2: female. Other values are invalid.
     */
    private int gender = 0;

    /**
     * \~chinese
     * 用户签名。
     * 
     * \~english
     * The user's signature.
     */
    private String signature;

    /**
     * \~chinese
     * 用户的生日。
     * 
     * \~english
     * The user's birthday.
     */
    private String birth;

    /**
     * \~chinese
     * 用户 ID。
     * 
     * \~english
     * The user ID.
     */
    private String userId;

    /**
     * \~chinese
     * 用户的扩展信息（用户可自行扩展，建议封装成 JSON 字符串，也可设置为空字符串)。
     * 
     * \~english
     * The user's extension information. You can set it to an empty string or type custom information and encapsulate them as a JSON string.
     */
    private String ext;

    public EMUserInfo(){
    }

    public enum EMUserInfoType {
    /**
     * \~chinese
     * 用户昵称。
     * 
     * \~english
     * The user's nickname.
     */
        NICKNAME(0,"nickname"),
        
      /**
     * \~chinese
     * 用户的头像 URL。
     * 
     * \~english
     * The avatar URL of the user.
     */   
        AVATAR_URL(1,"avatarurl"),

      /**
     * \~chinese
     * 用户的邮箱地址。
     * 
     * \~english
     * The email address of the user.
     */  
        EMAIL(2,"mail"),

      /**
     * \~chinese
     * 用户的电话号码。
     * 
     * \~english
     * The phone number of the user.
     */  
        PHONE(3,"phone"),

     /**
     * \~chinese
     * 用户的性别。
     * 
     * \~english
     * The user's gender.
     */   
        GENDER(4,"gender"),

    /**
     * \~chinese
     * 用户签名。
     * 
     * \~english
     * The user's signature.
     */
        SIGN(5,"sign"),

      /**
     * \~chinese
     * 用户的生日。
     * 
     * \~english
     * The user's birthday.
     */  
        BIRTH(6,"birth"),

     /**
     * \~chinese
     * 用户的扩展信息（用户可自行扩展，建议封装成 JSON 字符串，也可设置为空字符串)。
     * 
     * \~english
     * The user's extension information. You can set it to an empty string or type custom information and encapsulate them as a JSON string.
     */   
        EXT(100,"ext");

        private int value;
        private String desc;

        public int getValue() {
            return value;
        }
        public void setValue(int value) {
            this.value = value;
        }
        public String getDesc() {
            return desc;
        }
        public void setDesc(String desc) {
            this.desc = desc;
        }
        private EMUserInfoType(int value, String desc) {
            this.value = value;
            this.desc = desc;
        }
    }

    /**
     * \~chinese
     * 获取用户昵称。
     * @return  用户昵称。
     * @deprecated 已废弃，请用 {@link EMUserInfo#getNickname()} 代替。
     *
     * \~english
     * Gets the user's nickname.
     * @return  The user's nickname.
     * @deprecated Deprecated. Please use {@link EMUserInfo#getNickname()} instead.
     */
    @Deprecated
    public String getNickName() {
        return getNickname();
    }
    /**
     * \~chinese
     * 获取用户昵称。
     * @return  用户昵称。
     *
     * \~english
     * Gets the user's nickname.
     * @return  The user's nickname.
     */
    public String getNickname() {
        return nickname;
    }

    /**
     * \~chinese
     * 设置用户昵称。
     * @param nickname 用户昵称。
     * @deprecated 已废弃，请用 {@link EMUserInfo#setNickname(java.lang.String)} 代替。
     *
     * \~english
     * Sets the user's nickname.
     * @param nickname The user's nickname.
     * @deprecated Deprecated. Please use {@link EMUserInfo#setNickname(java.lang.String)} instead.
     */
    @Deprecated
    public void setNickName(String nickname) {
        setNickname(nickname);
    }

    /**
     * \~chinese
     * 设置用户昵称。
     * @param nickname 用户昵称。
     *
     * \~english
     * Sets the user's nickname.
     * @param nickname The user's nickname.
     */
    public void setNickname(String nickname) {
        this.nickname = nickname;
    }
    /**
     * \~chinese
     * 获取用户头像地址。
     * @return  用户头像地址。
     *
     * \~english
     * Gets the user's avatar URL.
     * @return  The user's avatar URL.
     */
    public String getAvatarUrl() {
        return avatarUrl;
    }

    /**
     * \~chinese
     * 设置用户头像地址。
     * @param avatarUrl 用户头像地址。
     *
     * \~english
     * Sets the user's avatar URL.
     * @param avatarUrl The user's avatar URL.
     */
    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    /**
     * \~chinese
     * 获取用户邮箱地址。
     * @return  用户邮箱地址。
     *
     * \~english
     * Gets the user's email address.
     * @return  The user's email address.
     */
    public String getEmail() {
        return email;
    }

    /**
     * \~chinese
     * 设置用户邮箱地址。
     * @param email 用户邮箱地址。 
     *
     * \~english
     * Sets the user's email address.
     * @param email The user's email address.
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /**
     * \~chinese
     * 获取用户电话号码。
     * @return  用户电话号码。
     *
     * \~english
     * Gets the user's phone number.
     * @return  The user's phone number.
     */
    public String getPhoneNumber() {
        return phoneNumber;
    }

    /**
     * \~chinese
     * 设置用户电话号码。
     * @param phoneNumber 用户电话号码。
     *
     * \~english
     * Sets the user's phone number.
     * @param phoneNumber The user's phone number.
     */
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    /**
     * \~chinese
     * 获取用户性别。
     * @return  用户性别。
     *
     * \~english
     * Gets the user's gender.
     * @return  The user's gender.
     */
    public int getGender() {
        return gender;
    }

    /**
     * \~chinese
     * 设置用户性别。
     * @param gender 用户性别。
     *
     * \~english
     * Sets the user's gender.
     * @param gender The user's gender.
     */
    public void setGender(int gender) {
        this.gender = gender;
    }

    /**
     * \~chinese
     * 获取用户签名。
     * @return  用户签名。
     *
     * \~english
     * Gets the user's signature.
     * @return  The user's signature.
     */
    public String getSignature() {
        return signature;
    }

    /**
     * \~chinese
     * 设置用户签名。
     * @param signature 用户签名。
     *
     * \~english
     * Sets the user's signature.
     * @param signature The user's signature.
     */
    public void setSignature(String signature) {
        this.signature = signature;
    }

    /**
     * \~chinese
     * 获取用户生日。
     * @return  用户生日。
     *
     * \~english
     * Gets the user's birthday.
     * @return  The user's birthday.
     */
    public String getBirth() {
        return birth;
    }

    /**
     * \~chinese
     * 设置用户生日。
     * @param birth 用户生日。
     *
     * \~english
     * Sets the user's birthday.
     * @param birth The user's birthday.
     */
    public void setBirth(String birth) {
        this.birth = birth;
    }

    /**
     * \~chinese
     * 获取用户 ID。
     * @return  用户 ID。
     *
     * \~english
     * Gets the user ID.
     * @return  The user ID.
     */
    public String getUserId() { return userId; }

    /**
     * \~chinese
     * 设置用户 ID。
     * @param userId 用户 ID。
     *
     * \~english
     * Sets the user ID.
     * @param userId The user ID.
     */
    public void setUserId(String userId) { this.userId = userId;}

    /**
     * \~chinese
     * 获取用户扩展信息。
     * @return  用户扩展信息。
     *
     * \~english
     * Gets the user's extension information.
     * @return  The user's extension information.
     */
    public String getExt() {
        return ext;
    }

    /**
     * \~chinese
     * 设置用户扩展信息。
     * @param ext 用户扩展信息。
     *
     * \~english
     * Sets the user's extension information.
     * @param ext The user's extension information.
     */
    public void setExt(String ext) {
        this.ext = ext;
    }
}
