package com.hyphenate.chat;

import com.hyphenate.chat.adapter.EMASilentModeTime;

/**
 * \~chinese
 * 离线推送免打扰时间类，需创建开始时间和结束时间配合使用。
 *
 * \~english
 * For offline push DND time class, you need to create the start time and end time together.
 *
 */
public class EMSilentModeTime extends EMBase<EMASilentModeTime> {

    public EMSilentModeTime(int hour, int minute){
        emaObject = new EMASilentModeTime(hour, minute);
    }

    public EMSilentModeTime(EMASilentModeTime time){
        emaObject = time;
    }

    /**
     * \~chinese
     * 设置小时数，24 小时制。
     * @param hour 小时数。
     *
     * \~english
     * Set the number of hours to 24 hours.
     * @param hour Hours.
     */
    public void setHour(int hour){
        emaObject.setHour(hour);
    }

    /**
     * \~chinese
     * 获取小时数，24 小时制。
     * @return 小时数。
     *
     * \~english
     * Get the number of hours in 24 hour format.
     * @return Number of hours.
     */
    public int getHour(){
        if(emaObject != null){
            return emaObject.getHour();
        }
        return 0;
    }

    /**
     * \~chinese
     * 设置分钟数。
     * @param minute 分钟数。
     *
     * \~english
     * Set minutes.
     * @param minute Minutes.
     *
     */
    public void setMinute(int minute){
        emaObject.setMinute(minute);
    }

    /**
     * \~chinese
     * 获取分钟数。
     * @return 分钟数。
     *
     * \~english
     * Get minutes.
     * @return minutes.
     *
     */
    public int getMinute(){
        if(emaObject != null) {
            return emaObject.getMinute();
        }
        return 0;
    }
}
