/************************************************************
 *  * EaseMob CONFIDENTIAL 
 * __________________ 
 * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
 *  
 * NOTICE: All information contained herein is, and remains 
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material 
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat;

import com.hyphenate.chat.core.EMChatConfigPrivate;
import com.hyphenate.push.EMPushConfig;

/**
 * \~chinese
 * 提供 SDK 聊天相关的设置。
 * 用户可以用来配置 SDK 的各种参数、选项，
 * 比如，发送消息加密，是否自动接受加好友邀请。
 * 
 * \~english
 * The settings of the chat SDK.
 * You can set parameters and options of the SDK.
 * For example, whether to encrypt the messages before sending, whether to automatically accept the friend invitations.
 */
public class EMOptions {

	public static class AreaCode {
		public static final int AREA_CODE_CN = 1;
		public static final int AREA_CODE_NA = 2;
		public static final int AREA_CODE_EU = 4;
		public static final int AREA_CODE_AS = 8;
		public static final int AREA_CODE_JP = 16;
		public static final int AREA_CODE_IN = 32;
		public static final int AREA_CODE_GLOB = -1;

		public AreaCode() {
		}
	}

	private int areaCode = AreaCode.AREA_CODE_GLOB;

	/**
	 * \~chinese
	 * 是否自动接受加好友邀请。
	 * - （默认）`true`：自动接受好友申请；
	 * - `false`：不会自动接受好友申请。
	 *
	 * \~english
	 * Whether to accept friend invitations from other users automatically. 
	 * - (Default)`true`: Accepts friend invitations automatically;
	 * - `false`: Do not accept friend invitations automatically.
	 */
	private boolean acceptInvitationAlways = true;
	
	/**
	 * \~chinese
	 * 是否自动接受群组邀请。
	 * - （默认）`true`：自动接受群组申请；
	 * - `false`：不会自动接受群组申请。
	 *
	 * \~english
	 * Whether to accept group invitations automatically. 
	 * - (Default)`true`: Accepts group invitations automatically;
	 * - `false`: Do not accept group invitations automatically.
	 */
	private boolean autoAcceptGroupInvitation = true;
	
	/**
	 * \~chinese
	 * 是否对发送消息进行加密。
	 * - （默认）`false`：不加密；
	 * - `true`：加密。
	 *
	 * \~english
	 * Whether to encrypt the messages. 
	 * - (Default)`false`: Do not encrypt the messages;
	 * - `true`: Encrypt the messages.
	 */
	private boolean useEncryption = false;

	/**
	 * \~chinese
	 * 是否发送消息已读回执.
	 * - （默认）`true`：发送已读回执；
	 * - `false`：不发送已读回执。
	 *
	 * \~english
	 * Whether the message read receipt is required. 
	 * - (Default)`true`: The message read receipt is required. 
	 * - `false`: The message read receipt is NOT required.
	 */
	private boolean requireReadAck = true;
	
	/**
	 * \~chinese
	 * 是否发送消息已送达回执。
	 * - （默认）`false`：不发送已送达回执，SDK 收到单聊消息时不会自动发送送达回执。
	 * - `true`：发送已送达回执。
	 *
	 * \~english
	 * Whether to send the message delivery receipt. 
	 * - (Default)`false`: The SDK does not automatically send the delivery receipt when you receive a chat message;
	 * - `true`: The SDK automatically sends the delivery receipt when you receive a chat message.
	 */
	private boolean requireDeliveryAck = false;
	/**
	 * \~chinese
	 * 是否开启fpa。
	 * - （默认）`false`：不开启。
	 * - `true`：开启。
	 *
	 * \~english
	 * Whether to use fpa function.
	 * - (Default)`false`: not use fpa function;
	 * - `true`: use fpa function.
	 */
	private boolean fpaEnable = false;

    /**
	 * \~chinese
	 * 离开群组时是否删除消息。
	 * - （默认）`true`：离开群组时删除群组消息；
	 * - `false`：离开群组时不删除群组消息。
	 *
	 * \~english
	 * Whether to delete all of the group messages when leaving the group.
	 * - (Default)`true`: Deletes all of the group messages when leaving the group. 
	 * - `false`: Do not delete all of the group messages when leaving the group.
	 */
	private boolean deleteMessagesAsExitGroup = true;
	
    /**
	 * \~chinese
	 * 是否允许聊天室所有者离开并删除会话记录。
	 * - （默认）`true`：允许聊天室所有者离开；
	 * - `false`：不允许聊天室所有者离开。
	 * 
	 * \~english
	 * Whether to allow the chat room owner to leave the chat room.
	 * - (Default)`true`: Allow the chat room owner to leave the chat room. 
	 * - `false`: Do not allow the chat room owner to leave the chat room.
	 */

	private boolean isChatroomOwnerLeaveAllowed = true;

	/**
	 * \~chinese
	 * 离开聊天室是否删除消息。
	 * -（默认）`true`：离开聊天室删除聊天室消息；
	 * - `false`：离开聊天室不删除聊天室消息。
	 *
	 * \~english
	 * Whether to delete all of the chat room messages when leaving the chat room.
	 * - (Default)`true`: Deletes all of the chat room messages when leaving the chat room. 
	 * - `false`: Do not delete all of the chat room messages when leaving the chat room.
	 */
	private boolean deleteMessagesAsExitChatRoom = true;
	
	private String appkey = "";
	
	private EMChatConfigPrivate config = null;
	
	private boolean enableAutoLogin = true;

	private String fcmNumber = null;
	private boolean useFCM = true;

	private boolean enableDNSConfig = true;
	
	private boolean sortMessageByServerTime = true;

	private boolean useHttps = false;
	private String dnsUrl = "";

	private String restServer;
	private String reportServer;
	private String imServer;
	private int imPort;

	private boolean usingHttpsOnly = true;
	private boolean serverTransfer = true;
	private boolean isAutodownload = true;
	private boolean useStereoInput = false;
	private boolean enableStatistics = true;
	private boolean enableUseRtcConfig = false;
	private String  rtcConfigUrl;
	private EMPushConfig pushConfig;

	/**
	 * \~chinese
	 * 获取是否需要消息接收方发送已读回执的设置。
	 *
	 * @return 是否要求消息的接收方发送已读回执。
	 * - （默认）`true`：需要已读回执；
	 * - `false：不需要已读回执。
	 * 
	 * \~english
	 * Gets whether the read receipt is required by the message receiver. 
	 * 
	 * @return Whether the read receipt is required.
	 * - (Default) `true`: The read receipt is required;
	 * - `false`: The read receipt is not required.
	 */
	public boolean getRequireAck() {
		
		if(config == null){
			return requireReadAck;
		}
		return  config.getRequireReadAck();
	}

	/**
	 * \~chinese
	 * 设置是否需要接受方发送已读回执。
	 *
	 * @param requireAck 是否需要接收方发送已读回执。
	 * - （默认）`true`：需要发送已读回执；
	 * - `false`：不需要发送已读回执。
	 * 
	 * \~english
	 * Sets whether to require the read receipt. 
	 *
	 * @param requireAck Whether the read receipt is required.
	 * - (Default) `true`: The read receipt is required; 
	 * - `false`: The read receipt is not required.
	 */
	public void setRequireAck(boolean requireAck) {
		this.requireReadAck = requireAck;

		if (config == null) {
			return;
		}
		config.setRequireReadAck(requireAck);
	}
	
	/**
	 * \~chinese
	 * 获取送达回执设置。
	 * 
	 * @return 是否需要送达回执。
	 * - （默认）`true`：要求消息的接受方发送送达回执；
	 * - `false`： 不要求消息的接受方发送送达回执。
	 * 
	 * \~english
	 * Gets whether the delivery receipt is required.
	 *
	 * @return Whether the delivery receipt is required.
	 * - (Default)`true`: The read receipt is required; 
	 * - `false`: The read receipt is not required.
	 */
	public boolean getRequireDeliveryAck() {
		if (config == null) {
			return requireDeliveryAck;
		}
		return config.getRequireDeliveryAck();
	}
	/**
	 * \~chinese
	 * 获取是否开启fpa。
	 *
	 * @return 是否开启fpa。
	 * - （默认）`false`： 没有开启fpa。
	 * - `true`：已经开启fpa；
	 *
	 * \~english
	 * Gets whether the fpa function is used.
	 *
	 * @return whether the fpa function is used.
	 * - (Default)`false`: the fpa function is not used.
	 * - `true`: the fpa function is used;
	 */
	public boolean getFpaEnable() {
		if (config == null) {
			return fpaEnable;
		}
		return config.getFpaEnable();
	}
	/**
	 * \~chinese
	 * 设置是否开启fpa。
	 * @param fpaEnable 是否开启fpa。
	 * - （默认）`false`：不开启。
	 * - `true`：开启。
	 *
	 * \~english
	 * sets Whether to use fpa function.
	 * @param fpaEnable Whether to use fpa function.
	 * - (Default)`false`: not use fpa function;
	 * - `true`: use fpa function.
	 */
	public void setFpaEnable(boolean fpaEnable) {
		this.fpaEnable = fpaEnable;
		if (config == null) {
			return;
		}
		config.setFpaEnable(fpaEnable);
	}

	/**
	 * \~chinese
	 * 设置是否需要接受方发送送达回执。
	 *
	 * @param requireDeliveryAck 是否需要送达回执。
	 * - （默认）`true`：需要送达回执。
	 * - `false`：不需要发送送达回执。
	 * 
	 * \~english
	 * Sets whether the delivery receipt is required.
	 * 
	 * @param requireDeliveryAck Whether the delivery receipt is required.
	 * - (Default)`true`: The delivery receipt is required; 
	 * - `false`: The delivery receipt is not required.
	 */
	public void setRequireDeliveryAck(boolean requireDeliveryAck) {
		this.requireDeliveryAck = requireDeliveryAck;
		
		if (config == null) {
			return;
		}
		config.setRequireDeliveryAck(requireDeliveryAck);
	}

	/**
	 * \~chinese
	 * 获取是否自动接受加好友邀请。
	 * 
	 * @return 是否自动接受加好友邀请。
	 * - （默认）`true`：自动接受好友邀请。
	 * - `false`：不自动接收好友邀请。
	 * 
	 * \~english
	 * Gets whether to accept other user's friend invitations automatically.
	 *
	 * @return Whether to accept friend invitation automatically.
	 * - (Default)`true`: Accepting friend invitation automatically.
	 * - `false`: Do not accepting friend invitation automatically.
	 */
	public boolean getAcceptInvitationAlways() {
		if (config == null) {
			return acceptInvitationAlways;
		}
		return config.getAutoAccept();
	}

	/**
	 * \~chinese
	 * 设置是否自动接受加好友邀请。
	 * 
	 * @param value 是否自动接受加好友邀请。
	 * - （默认）`true`：自动接受好友邀请。
	 * - `false`：不自动接收好友邀请。
	 * 
	 * \~english
	 * Sets whether to accept the friend invitation automatically. 
	 * @param value Whether to accept the friend invitation automatically.
	 * - (Default)`true`: Accepting friend invitation automatically.
	 * - `false`: Do not accepting friend invitation automatically.
	 */
	public void setAcceptInvitationAlways(boolean value) {
		if (config == null) {
			acceptInvitationAlways = value;
			return;
		}
		config.setAutoAccept(value);
	}

	/**
	 * \~chinese
     * 设置退出(主动和被动退出)群组时是否删除聊天消息。
	 *
     * @param delete 
	 * - （默认）`true`: 退出群组时删除群组消息。
     * - `false`: 退出群组时不删除群组消息。 
     * 
     * \~english
	 * Sets whether to delete the group messages when leaving the group.
	 *
     * @param delete  
	 * - (Default)`true`: Delete the messages when leaving the group.
	 * - `false`: Do not delete the messages when leaving a group.
     */
    public void setDeleteMessagesAsExitGroup(boolean delete){
		if (config == null) {
			deleteMessagesAsExitGroup = delete;
			return;
		}
		
		config.setDeleteMessageAsExitGroup(delete);
    }
    
    /**
	 * \~chinese
     * 获取退出(主动和被动退出)群组时是否删除聊天消息。
	 * 
     * @return  - （默认）`true`: 退出群组时删除群组消息。
     * - `false`: 退出群组时不删除群组消息。
	 * 
	 * @deprecated 使用 {@link EMOptions#deleteMessagesOnLeaveGroup()} 替代。
     * 
     * \~english
	 * Gets whether to delete the group message when leaving a group.
	 * 
     * @return - (Default)`true`: Delete the messages when leaving a group.
     * - `false`: Do not delete the messages when leaving a group.
	 * 
	 * @deprecated Use {@link EMOptions#deleteMessagesOnLeaveGroup()} instead.
     */
    @Deprecated
    public boolean isDeleteMessagesAsExitGroup() {
		return deleteMessagesOnLeaveGroup();
    }

	/**
	 * \~chinese
	 * 获取退出(主动和被动退出)群组时是否删除聊天消息。
	 * 
     * @return  - （默认）`true`: 退出群组时删除群组消息。
     * - `false`: 退出群组时不删除群组消息。
	 *
	 * \~english
	 * Gets whether to delete the group message when leaving a group.
     * @return - (Default)`true`: Delete the messages when leaving a group.
     * - `false`: Do not delete the messages when leaving a group.
	 */
	public boolean deleteMessagesOnLeaveGroup() {
		if (config == null) {
			return deleteMessagesAsExitGroup;
		}

		return config.getDeleteMessageAsExitGroup();

	}
    
    /**
     * \~chinese
     * 设置是否自动接受加群邀请。
	 * 
     * @param value 是否自动接受加群邀请。
	 * - （默认）`true`：自动接受加群申请；
     * - `false`: 不自动接受加群申请。
     * 
     * \~english
     * Sets whether to accept a group invitation automatically. 
	 * 
     * @param value Whether to accept group invitation automatically.
	 * - (Default)`true`: Accept group invitations automatically；
	 * - `false`: Do not accept group invitations automatically.
     */
    public void setAutoAcceptGroupInvitation(boolean value) {
        if (config == null) {
            autoAcceptGroupInvitation = value;
            return;
        }
        config.setAutoAcceptGroupInvitation(value);
    }
    
    /**
     * \~chinese
     * 获取是否自动接受加群邀请。
	 * 
     * @return 返回是否自动接受加群邀请。
	 * - （默认） `true`：自动接受加群邀请；
	 * - `false`：不自动接受加群邀请。
	 * 
	 * @deprecated 使用 {@link EMOptions#autoAcceptGroupInvitations()} 替代。
     * 
     * \~english
     * Gets whether to accept a group invitation automatically.
	 * 
     * @return	Returns the result of whether to accept group invitation automatically.
	 * - (Default)`true`: Accept group invitations automatically；
	 * - `false`: Do not accept group invitations automatically.
	 * 
	 * @deprecated Use {@link EMOptions#autoAcceptGroupInvitations()} instead.
     */
    @Deprecated
    public boolean isAutoAcceptGroupInvitation() {
        return autoAcceptGroupInvitations();
    }

	/**
	 * \~chinese
	 * 获取是否自动接受加群邀请。
	 * 
	 * @return 返回是否自动接受加群邀请。
	 * - （默认） `true`：自动接受加群邀请；
	 * - `false`：不自动接受加群邀请。
	 *
	 * \~english
	 * Gets whether to accept group invitations automatically.
	 * 
	 * @return	Returns the result of whether to accept group invitation automatically. 
	 * - (Default)`true`: Accept group invitations automatically.
	 * - `false`: Do not accept group invitations automatically.
	 */
	public boolean autoAcceptGroupInvitations() {
		if (config == null) {
			return autoAcceptGroupInvitation;
		}
		return config.isAutoAcceptGroupInvitation();
	}

	/**
	 * \~chinese
	 * 设置是否允许聊天室所有者离开并删除会话记录。
	 * 
	 * @param allowed 是否允许聊天室所有者离开。
	 * - （默认） `true`：允许聊天室所有者离开；
	 * - `false`：不允许聊天室所有者离开，聊天室所有者离开时不再接收任何消息并删除会话记录。
	 * 
	 * \~english
	 * Sets whether to allow the chat room owner to leave the chat room.
	 * @param allowed Whether to allow the owner of chat room to leave.
	 * - (Default)`true`: : When the owner leave, do not keep the conversation; 
	 * - `false`: When the owner leave do keep the conversation.
	 */
    public void allowChatroomOwnerLeave(boolean allowed){
		if (config == null) {
			this.isChatroomOwnerLeaveAllowed = allowed;
			return;
		}
		
		config.setIsChatroomOwnerLeaveAllowed(allowed);
	}
	
	/**
	 * \~chinese
	 * 获取是否允许聊天室所有者离开。
	 * @return - （默认）`true`：离开时不保留会话；
	 * - `false`：离开保留会话。
	 * @deprecated 使用 {@link EMOptions#canChatroomOwnerLeave()} 代替。
	 * 
	 * \~english
	 * Gets whether to allow the owner of chat room to leave.
	 * @return - (Default)`true`: When the owner leave, do not keep the conversation; 
	 * - `false`: When the owner leave do keep the conversation.
	 *  @deprecated Use {@link EMOptions#canChatroomOwnerLeave()} instead.
	 */
	@Deprecated
	public boolean isChatroomOwnerLeaveAllowed(){

		return canChatroomOwnerLeave();
	}

	/**
	 * \~chinese
	 * 获取是否允许聊天室所有者离开。
	 * @return - （默认）`true`：离开并不保留会话记录；
	 * - `false`：离开保留会话记录。
	 *
	 * \~english
	 * Gets whether to allow owner of chat room to leave.
	 * @return - (Default)`true`: When the owner leave, do not keep the conversation;
	 * - `false`: When the owner leave, do keep the conversation.
	 */
	public boolean canChatroomOwnerLeave(){
		if (config == null) {
			return isChatroomOwnerLeaveAllowed;
		}
		return config.getIsChatroomOwnerLeaveAllowed();
	}

	/**
	 * \~chinese
	 * 设置退出(主动和被动退出)聊天室时是否删除聊天消息。
	 * 
	 * @param delete - （默认）`true`：退出聊天室时删除聊天室相关消息记录。
	 * - `false`：离开聊天室时保留会话记录。
	 *
	 * \~english
	 * Sets whether to delete the chat room message when leaving the chat room.
	 * 
	 * @param delete -(Default)`true`: Delete the chat room related message record when leaving the chat room.
	 * - `false`: Do not delete the chat room related message record when leaving the chat room.
	 */
	public void setDeleteMessagesAsExitChatRoom(boolean delete){
		if (config == null) {
			deleteMessagesAsExitChatRoom = delete;
			return;
		}

		config.setDeleteMessageAsExitChatRoom(delete);
	}

	/**
	 * \~chinese
	 * 获取退出(主动和被动退出)聊天室时是否删除聊天消息。
	 * 
	 * @return  - （默认）`true`：退出聊天室时删除聊天室相关消息记录。
	 * - `false`：离开聊天室时保留会话记录。
	 * 
	 * @deprecated 使用 {@link EMOptions#deleteMessagesOnLeaveChatroom()} 替代。
	 *
	 * \~english
	 * Gets whether to delete the chat room message when leaving the chat room.
	 * 
	 * @return  - (Default)`true`: Delete the chat room related message record when leaving the chat room.
	 * - `false`: Do not delete the chat room related message record when leaving the chat room.
	 * 
	 * @deprecated Use {@link EMOptions#deleteMessagesOnLeaveChatroom()} instead.
	 */
	@Deprecated
	public boolean isDeleteMessagesAsExitChatRoom() {

		return deleteMessagesOnLeaveChatroom();

	}
	/**
	 * \~chinese
	 * 获取退出(主动和被动退出)聊天室时是否删除聊天消息。
	 * @return  -（默认）`true`：退出聊天室时删除聊天室相关消息记录。
	 * - `false`：离开聊天室时保留会话记录。
	 *
	 * \~english
	 * Gets whether to delete the chat room message when leaving the chat room.
	 * @return  - (Default)`true`: Delete the chat room related message record when leaving the chat room.
	 * - `false`: Do not delete the chat room related message record when leaving the chat room.
	 */
	public boolean deleteMessagesOnLeaveChatroom() {
		if (config == null) {
			return deleteMessagesAsExitChatRoom;
		}

		return config.getDeleteMessageAsExitChatRoom();

	}
	 
	/**
	 * \~chinese
	 * 获取是否按照服务器收到时间进行排序。
	 * @return 返回是否按照服务器收到的时间排序。
	 * - （默认）`true`：按服务器收到消息时间进行排序；
	 * - `false`：不按服务器收到消息时间进行排序。
	 * 
	 * \~english
	 * Gets whether to sort messages by the server received time.
	 * @return Returns the result of whether sort message by the server received time.
	 * - (Default)`true`: Sort messages by the server received time;
	 * - `false`: Do not sort messages by the server received time.
	 */
    public boolean isSortMessageByServerTime() {
        if (config == null) {
            return sortMessageByServerTime;
        }
        return config.getSortMessageByServerTime();
    }

	/**
	 * \~chinese
	 * 设置是否按照服务器收到的时间对消息进行排序。
	 * @param sortByServerTime 是否按照服务器收到的时间对消息进行排序。
	 * - （默认）`true`：按服务器收到消息时间进行排序；
	 * - `false`：不按服务器收到消息时间进行排序。
	 *
	 * \~english
	 * Sets whether to sort messages by server received time. 
	 * @param sortByServerTime
	 * - (Default)`true`: Sort messages by the server received time.
	 * - `false`: Do not sort messages by the server received time.
	 */
	public void setSortMessageByServerTime(boolean sortByServerTime) {
        if (config == null) {
            this.sortMessageByServerTime = sortByServerTime;
            return;
        }
        
        config.setSortMessageByServerTime(sortByServerTime);
    }
	
	/**
	 * \~chinese
	 * 设置 app key。
	 * @param appkey 创建 app 时在 console 后台上注册的 app 唯一识别符。
	 * 
	 * \~english
	 * Sets the app key.
	 * @param appkey The app key you got from the console when creating a chat app.
	 */
	void updatePath(String appkey){
		if(config != null) {
            config.updatePath(appkey);
		}
	}

	/**
	 * \~chinese
	 * 设置 app key。
	 * @param appkey 创建 app 时在 console 后台上注册的 app 唯一识别符。
	 *
	 * \~english
	 * Sets the app key.
	 * @param appkey The app key you got from the console when create an app.
	 */
	public void setAppKey(String appkey) {
		this.appkey = appkey;
		updatePath(appkey);
	}
	
	/**
	 * \~chinese
	 * 获取 app key。
	 *
	 * \~english
	 * Gets the app key.
	 */
	public String getAppKey(){
		if(config == null){
			return appkey;
		}
		
		return config.getAppKey();
	}

	/**
	 * \~chinese
	 * 设置 im 消息服务器地址，一般为私有部署服务，在开发者想实现数据隔离、特别注重数据安全时使用，如有需求请联系商务。
	 * @param imServer im 消息服务器地址。
	 *
	 * \~english
	 * Sets the custom im message server url.
	 * @param imServer The im message server url.
     */
	public void setIMServer(String imServer){
		if(imServer == null){
			return;
		}

		this.imServer = imServer;
		if(config == null){
			return;
		}
		config.setChatServer(imServer);
	}

	/**
	 * \~chinese
	 * 获取设置的 im 消息服务器地址，一般为私有部署服务，在开发者想实现数据隔离、特别注重数据安全时使用，如有需求请联系商务。
	 * @return im 消息服务器地址。
	 *
	 * \~english
	 * Gets the im server url.
	 * @return The im server url.
	 */
	public String getImServer(){
		return imServer;
	}

	/**
	 * \~chinese
	 * 设置 im 消息服务器端口号，一般为私有部署服务，在开发者想实现数据隔离、特别注重数据安全时使用，如有需求请联系商务。
	 * @param imPort 端口号。
	 *
	 * \~english
	 * Sets the custom im server port.
	 * @param imPort The im server port.
	 */
	public void setImPort(int imPort){
		this.imPort = imPort;
		if(config == null){
			return;
		}
		config.setChatPort(imPort);
	}

	/**
	 * \~chinese
	 * 获取设置的 im 消息服务器端口号，一般为私有部署服务，在开发者想实现数据隔离、特别注重数据安全时使用，如有需求请联系商务。
	 * @return 端口号。
	 *
	 * \~english
	 * Gets the im server port.
	 * @return The im server port.
	 */
	public int getImPort(){
		return imPort;
	}

	/**
	 * \~chinese
	 * 设置 REST 服务器地址，一般在开发者想实现数据隔离、特别注重数据安全时使用，如有需求请联系商务获取指定的服务器地址。
	 * @param restServer REST 服务器地址。
	 *
	 * \~english
	 * Sets the custom REST server.
	 * @param restServer The REST server url.
	 */
	public void setRestServer(String restServer){
		if(restServer == null)
			return;

		this.restServer = restServer;
		if(config == null){
			return;
		}
		config.setRestServer(restServer);
	}

	/**
	 * \~chinese
	 * 获取设置的 REST 服务器地址，一般为私有部署服务，在开发者想实现数据隔离、特别注重数据安全时使用，如有需求请联系商务。
	 * @return REST 服务器地址。
	 *
	 * \~english
	 * Gets the REST server.
	 * @return The REST server url.
	 */
	public String getRestServer(){
		return restServer;
	}


	/**
	 * \~chinese
	 * 获取设置的数据上报服务器地址，一般为私有部署服务，在开发者想实现数据隔离、特别注重数据安全时使用，如有需求请联系商务。
	 * @return 数据上报服务器地址，有可能为空。
	 *
	 * \~english
	 * Gets the report server.
	 * @return The report server url, may be null.
     */
	public String getReportServer(){
		return reportServer;
	}


	/**
	 * \~chinese
	 * 设置数据上报服务器地址，一般为私有部署服务，在开发者想实现数据隔离、特别注重数据安全时使用，如有需求请联系商务。
	 * @param reportServer 数据上报服务器地址。
	 *
	 * \~english
	 * Sets the custom report server.
	 * @param reportServer The report server url.
	 */
	public void setReportServer(String reportServer){
		if(reportServer == null)
			return;
		this.reportServer = reportServer;
	}

	/**
	 * \~chinese
	 * 开启/关闭自动登录。
	 * @param autoLogin 
	 * - （默认）`true`：自动登录；
	 * - `false`：不自动登录。
	 * 
	 * \~english
	 * Enables/Disables automatic login.
	 * @param autoLogin 
	 * - (Default)`true`: Enables automatic login;
	 * - `false`: Disables automatic login.
	 */
	public void setAutoLogin(boolean autoLogin){
		enableAutoLogin = autoLogin;
	}
	
	/**
	 * \~chinese
	 * 获取是否开启了自动登录。
	 * @return - （默认）`true`：已设置为自动登录；
	 * - `false`：未设置为自动登录。
	 * 
	 * \~english
	 * Checks whether the automatic login is enabled.
	 * @return - (Default)`true`: Automatic login is enabled;
	 * - `false`: Automatic login is disabled.
	 */
	public boolean getAutoLogin(){
		return enableAutoLogin;
	}

	void setConfig(EMChatConfigPrivate config){
		this.config = config;
	}

	/**
	 * \~chinese
	 * 设置是否关闭 DNS。
	 * 
	 * @param enable 是否关闭 DNS。
	 * - （默认）`true`：关闭 DNS，私有云部署需要关闭；
	 * - `false`：不关闭 DNS。
	 *
	 * \~english
	 * Sets whether to disable DNS.
	 * - (Default)`true`: Disable DNS;
	 * - `false`: Do not disable DNS.
	 */
	public void enableDNSConfig(boolean enable) {
		enableDNSConfig = enable;
        if (config == null) {
            return;
        }
	    config.enableDnsConfig(enable);
	}

	/**
	 * \~chinese
	 * 获取是否关闭 DNS。
	 *
	 * @return 返回是否关闭 DNS。
	 * - （默认）`true`：关闭 DNS。
	 * - `false`：不关闭 DNS。
	 *
	 * \~english
	 * Gets whether to disable DNS. 
	 * - (Default) `true`: Disable DNS;
	 * - `false`: Do not disable DNS.
	 *
	 * @return Returns whether to disable DNS.
	 */
	public boolean getEnableDNSConfig() {
	    return enableDNSConfig;
	}

	/**
	 * \~chinese
	 * 设置只使用 HTTPS 进行 REST 操作。
	 * @param _usingHttpsOnly 是否只使用 HTTPS。
	 * - （默认）`true`：只使用 HTTPS 进行 REST 操作；
	 * - `false`：可以使用 HTTPS 和 HTTP 进行 REST 操作。
	 *
	 * \~english
	 * Sets whether only HTTPS is used for REST operation.
	 * @param _usingHttpsOnly Whether only HTTPS is used.
	 * - (Default)`true`: Only HTTPS is used;
	 * - `false`: Both HTTP and HTTPS can be used. 
	 */
	public void setUsingHttpsOnly(boolean _usingHttpsOnly) {
        usingHttpsOnly = _usingHttpsOnly;
		if (config == null) {
			return;
		}
		config.setUsingHttpsOnly(_usingHttpsOnly);
	}

	/**
	 * \~chinese
	 * 获取是否只使用 HTTPS 进行 REST 操作。
	 *
	 * @return 是否只使用 HTTPS。
	 * - （默认）`true` 只使用 HTTPS 进行 REST 操作；
	 * - `false` 可以使用 HTTPS 和 HTTP 进行 REST 操作。
	 * 
	 * \~english
	 * Gets whether only HTTPS is used for REST operations. 
	 *
	 * @return Whether only HTTPS is used for REST operations. 
	 * - (Default) `true`: Only HTTPS is used;
	 * - `false`: Both HTTP and HTTPS can be used. 
	 */
	public boolean getUsingHttpsOnly() {
		if (config != null) {
			return config.getUsingHttpsOnly();
		}
		return usingHttpsOnly;
	}
	/**
	 * \~chinese
	 * 设置是否自动将消息附件上传到 Chat 服务器。
	 * 
	 * @param transfer 是否自动上传到 Chat 服务器。
	 * - （默认）`true`：自动使用 Chat 服务器上传下载；
	 * - `false`：不自动使用 Chat 服务器上传下载，自定义上传下载路径。
	 *
	 * \~english
	 * Sets whether to upload the message attachments automatically to the chat server.
	 * 
	 * @param transfer Whether to upload the message attachments to the chat server.
	 * - (Default)`true`: Use the default way to upload and download the message attachments by chat server;
	 * - `false`: Do not use the default way to upload and download the message attachments by chat server, using a customized path instead.
	 */
	public void setAutoTransferMessageAttachments(boolean transfer) {
		if (config == null) {
			serverTransfer = transfer;
			return;
		}
		config.setAutoTransferMessageAttachments(transfer);
	}
	/**
	 * \~chinese
	 * 获取是否使用 Chat 服务器进行上传下载。
	 *
	 * @return 是否自动使用 Chat 服务器进行上传下载。
	 * - （默认）`true`：自动使用 Chat 服务器进行上传下载；
	 * - `false`：不自动使用 Chat 服务器上传下载，自定义上传下载路径。
	 *
	 * \~english
	 * Gets whether to upload the message attachments automatically to the chat server.
	 *
	 * @return Whether to upload the message attachments automatically to the chat server.
	 * - (Default)`true`: Use the default way to upload and download the message attachments by chat server;
	 * - `false`: Do not use the default way to upload and download the message attachments by chat server, using a customized path instead.
	 */
	public boolean getAutoTransferMessageAttachments() {
		if (config == null) {
			return serverTransfer;
		}
		return config.getAutoTransferMessageAttachments();
	}
	/**
	 * \~chinese
	 * 是否自动下载缩略图。
	 * 
	 * @param autodownload 是否自动下载缩略图。
	 * - （默认）`true`：自动下载；
	 * - `false`：不自动下载。
	 *
	 * \~english
	 * Sets whether to auto download the thumbnail.
	 *
	 * @param autodownload Whether to download the thumbnail automatically.
	 * - (Default)`true`: Download the thumbnail automatically;
	 * - `false`: Do not download the thumbnail automatically.
	 * 
	 */
	public void setAutoDownloadThumbnail(boolean autodownload) {
		if (config == null) {
			isAutodownload = autodownload;
			return;
		}
		config.setAutodownloadThumbnail(autodownload);
	}
	/**
	 * \~chinese
	 * 获取是否自动下载缩略图。
	 * 
	 * @return 是否自动下载缩略图。
	 * - （默认）`true`：自动下载；
	 * - `false`：不自动下载。
	 *
	 * \~english
	 * Gets whether to download the thumbnail automatically. 
	 * 
	 * @return Whether to download the thumbnail automatically.
	 * - (Default)`true`: Download the thumbnail automatically;
	 * - `false`: Do not download the thumbnail automatically.
	 */
	public boolean getAutodownloadThumbnail() {
		if (config == null) {
			return isAutodownload;
		}
		return config.getAutodownloadThumbnail();
	}


	private int fixedInterval = -1;

	/**
	 * \~chinese
	 * 设置固定的心跳间隔，不设置时会自动探测最佳心跳间隔。
	 * @param interval 心跳时间间隔，单位为秒，建议范围为 30s~300s 之间。
	 *
	 * \~english
	 * Sets a fixed heartbeat interval. If not set, the optimal heartbeat interval is automatically detected.
	 * @param interval  The interval of heart beat, in seconds (30~300).
	 */
	public void setFixedHBInterval(int interval) {
		if (interval < 10) this.fixedInterval = 10;
		if (interval > 300) this.fixedInterval = 300;
		this.fixedInterval = interval;
	}

	/**
	 * \~chinese
	 * 获取固定的心跳间隔。
	 * @return 心跳时间间隔，单位为秒。
	 *
	 * \~english
	 * Gets the fixed heart beat interval.
	 * @return The heartbeat interval, in seconds. We recommend setting this value between 30 to 300.
	 */
	public int getFixedInterval() {
		return this.fixedInterval;
	}


	/**
	 * \~chinese
	 * 获取 SDK 版本号。
	 * @return SDK 版本号。
	 *
	 * \~english
	 * Gets the SDK version.
	 * @return The SDK version.
	 */
	public String getVersion() {
		return config.getVersion();
	}

	/**
	 * \~chinese
	 * 获取本地保存的访问 token。
	 *
	 * @return 访问 token。
	 *
	 * \~english
	 * Gets the access token from the local database.
	 *
	 * @return The access token.
	 */
	public String getAccessToken() {
		return config.getAccessToken();
	}

	/**
	 * \~chinese
	 * 是否从服务器获取访问 token。
	 * @param b 是否从服务器获取。
	 * - `true`：从服务器获取访问 token；
	 * - `false`：不从服务器获取访问 token。
	 * @return 访问 token。
	 *
	 * \~english
	 * Whether to get the access token from the server.
	 * @param b Whether to get the access token from server.
	 * - (Default) `true`: Get the access token from server.
	 * - `false`: Do not get the access token from server.
	 * @return The access token.
	 */
	public String getAccessToken(boolean b) {
		return config.getAccessToken(b);
	}

	/**
	 * \~chinese
	 * 设置 DNS 地址。
	 * @param dnsUrl DNS 地址。
	 *
	 * \~english
	 * Sets the DNS url.
	 * @param dnsUrl The DNS url.
	 */
	public void setDnsUrl(String dnsUrl) {
		this.dnsUrl = dnsUrl;
		if (config == null) {
			return;
		}
		config.setDnsUrl(dnsUrl);
	}

	/**
	 * \~chinese
	 * 获取 DNS 地址。
	 * @return  DNS 地址。
	 *
	 * \~english
	 * Gets the DNS url.
	 * @return  The DNS url.
	 */
	public String getDnsUrl() {
		if (config != null) {
			return config.getDnsUrl();
		}
		return dnsUrl;
	}

	/**
	 * \~chinese
	 * 获取用户设置的推送相关配置。
	 *
	 * @return 推送配置。
	 *
	 * \~english
	 * Gets the push configuration setting options by user.
	 */
	public EMPushConfig getPushConfig() {
		return pushConfig;
	}

	/**
	 * \~chinese
	 * 设置推送相关配置。
	 *
	 * @param pushConfig 推送相关配置。
	 *
	 * \~english
	 * Sets the push configuration.
	 *
	 * @param pushConfig  The push configuration.
	 */
	public void setPushConfig(EMPushConfig pushConfig) {
		this.pushConfig = pushConfig;
	}

	/**
	 * \~chinese
	 * 获取是否启动统计。
	 *
	 * @return - （默认）`true`：启用统计； 
	 * - `false`：不启用统计。
	 *
	 * \~english
	 * Gets whether to enable the statistics.
	 *
	 * @return - (Default)`true`: Enable statistics; 
	 * - `false`: Do not enable statistics.
	 */
	public boolean isEnableStatistics() {
		return enableStatistics;
	}

	/**
	 * \~chinese
	 * 设置是否启用统计。
	 *
	 * @param enableStatistics 是否启用统计。
	 * - （默认）`true`：启用统计； 
	 * - `false`：不启用统计。
	 *
	 * \~english
	 * Sets whether to enable statistics. 
	 * 
	 * @param enableStatistics Whether to enable statistics. 
	 * - (Default)`true`: Enable statistics; 
	 * - `false`: Do not enable statistics.
	 */
	public void setEnableStatistics(boolean enableStatistics) {
		this.enableStatistics = enableStatistics;
	}


	/**
	 * \~chinese
	 * 设置区域代号，使用边缘节点时遵循区域限制
	 * @param code 区域代号。
	 * - （默认）`AREA_CODE_GLOB`：不限制区域。
	 *
	 * \~english
	 * sets area code, will follow the area when using edge node.
	 * @param code area code.
	 * - (Default)`AREA_CODE_GLOB`: No limit when try to access server node;
	 *
	 */
	public void setAreaCode(int code) {
		this.areaCode = code;
		if (config == null) {
			return;
		}
		config.setAreaCode(code);
	}

	public int getAreaCode() {
		return areaCode;
	}
}
