package com.hyphenate.chat;


import com.hyphenate.chat.adapter.EMAMessageReaction;
import com.hyphenate.chat.adapter.EMAMessageReactionChange;

import java.util.ArrayList;
import java.util.List;

/**
 * \~chinese
 * 消息 Reaction 变更实体类，有如下属性：
 *
 *  ConversionID：会话 ID。
 *  MessageId：消息 ID。
 *  MessageReactionList：消息 Reaction 列表。
 *
 * \~english
 * The message reaction change entity class, which has the following attributes:
 *
 *  ConversionID: The conversion ID.
 *  MessageId: The message ID.
 *  MessageReactionList: The list of Reactions.
 */
public class EMMessageReactionChange extends EMBase<EMAMessageReactionChange> {

    public EMMessageReactionChange(EMAMessageReactionChange reactionChange) {
        emaObject = reactionChange;
    }

    /**
     * \~chinese
     * 获取会话 ID。
     * @return 会话 ID。
     *
     * \~english
     * Gets the conversion ID.
     * @return  The conversion ID.
     */
    public String getConversionID() {
        if (EMClient.getInstance().getCurrentUser().equals(emaObject.getTo())) {
            return emaObject.getFrom();
        }
        return emaObject.getTo();
    }

    /**
     * \~chinese
     * 获取消息 ID。
     * @return 消息 ID。
     *
     * \~english
     * Gets the message ID.
     * @return  The message ID.
     */
    public String getMessageId() {
        return emaObject.getMessageId();
    }

    /**
     * \~chinese
     * 获取 Reaction 列表。
     * @return Reaction 列表。
     *
     * \~english
     * Gets the list of Reactions.
     * @return  The list of Reactions.
     */
    public List<EMMessageReaction> getMessageReactionList() {
        List<EMAMessageReaction> list = emaObject.getMessageReactionList();
        List<EMMessageReaction> messageReactionList = new ArrayList<>(list.size());
        for (EMAMessageReaction reaction : list) {
            messageReactionList.add(new EMMessageReaction(reaction));
        }
        return messageReactionList;
    }

}