/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat;

import java.util.List;

class EMResult<TList> {
    private TList data;
    
    /*
     * return TList value
     */
    public TList getData(){
    	return data;
    }
    
    public void setData(TList data){
    	this.data = data;
    }
}

/**
 * \~chinese
 * 带游标及分页获取结果的泛型类。
 * 做为分页获取且含有游标的返回对象。
 * 
 * 例如：
 * ```java
 *	   EMCursorResult<EMGroupInfo> result = EMClient.getInstance().groupManager().getPublicGroupsFromServer(pageSize, cursor);
 * 	   List<EMGroupInfo> groupList = result.getData();
 * 	   String cursor = result.getCursor();
 * ```
 *
 * \~english
 * This is a generic class with cursors and paging to get results.
 * 
 * Returns an instance with the list and the cursor.
 * 
 * For example:
 * ```java
 *     EMCursorResult<EMGroupInfo> result = EMClient.getInstance().groupManager().getPublicGroupsFromServer(pageSize, cursor);
 * 	   List<EMGroupInfo> groupList = result.getData();
 * 	   String cursor = result.getCursor();
 * ```
 */
public class EMCursorResult<T> extends EMResult<List<T>>{
	private String cursor = "";
	
	void setCursor(String cursor){
		this.cursor = cursor;
	}

	/**
	 * \~chinese
	 * 获取游标。
	 * @return	游标。
	 *
	 * \~english
	 * Gets the cursor.
	 * @return	The cursor.
	 */
	public String getCursor(){
		return cursor;
	}
}
