/************************************************************
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat;

import com.hyphenate.EMValueCallBack;
import com.hyphenate.chat.adapter.EMAThreadInfo;

/**
 *  \~chinese
 *  子区对象类。
 *
 *  \~english
 *  The message thread object class.
 */
public class EMChatThread extends EMBase<EMAThreadInfo> {

    public EMChatThread(EMAThreadInfo thread) {
        emaObject = thread;
    }

    /**
     * \~chinese
     * 获取子区 ID。
     *
     * @return 子区 ID。
     *
     * \~english
     * Gets the message thread ID.
     *
     * @return The message thread ID.
     */
    public String getChatThreadId() {
        return emaObject.getThreadId();
    }

    /**
     * \~chinese
     * 获取子区名称。
     *
     * @return 子区名称。
     *
     * \~english
     * Gets the message thread name.
     *
     * @return The message thread name.
     */
    public String getChatThreadName() {
        return emaObject.getThreadName();
    }

    /**
     * \~chinese
     * 获取子区创建者。
     * 
     * 获取子区详情和子区列表的时候返回此属性值。
     *
     * @return 子区创建者的用户 ID。
     *
     * \~english
     * Gets the message thread creator.
     * 
     * This message thread creator is returned when you get the message thread details and message thread list.
     *
     * @return The user ID of the message thread creator.
     */
    public String getOwner() {
        return emaObject.getOwner();
    }

    /**
     * \~chinese
     * 获取子区所在的群组 ID。
     *
     * @return  群组 ID。
     *
     * \~english
     * Gets the group ID to which the message thread belongs.
     *
     * @return The group ID.
     */
    public String getParentId() {
        return emaObject.getParentId();
    }

    /**
     * \~chinese
     * 获取父消息 ID。
     *
     * @return 父消息 ID。
     *
     * \~english
     * Gets the ID of the parent message.
     *
     * @return The ID of the parent message.
     */
    public String getMessageId() {
        return emaObject.getMessageId();
    }

    /**
     * \~chinese
     * 获取子区成员数量。
     *
     * 获取子区成员数量之前，需先调用 {@link EMChatThreadManager#getChatThreadFromServer(String, EMValueCallBack)} 方法获取子区详情。
     *
     * @return 子区成员数量。
     *
     * \~english
     * Gets the number of members in the message thread.
     *
     * To get the member count, you need to first call {@link EMChatThreadManager#getChatThreadFromServer(String, EMValueCallBack)} to get details of the message thread.
     *
     * @return  The number of members in the message thread.
     */
    public int getMemberCount() {
        return emaObject.getMemberCount();
    }

    /**
     * \~chinese
     * 获取子区的消息数。
     * 
     * 获取子区的消息数之前，需先调用 {@link EMMessage#getChatThread()} 方法获取子区详情。
     * 
     * @return 消息数。
     *
     * \~english
     * Get the number of messages in a message thread.
     * 
     * To get the number of messages in a message thread, you need to first call {@link EMMessage#getChatThread()} to get details of the message thread.
     * 
     * @return The message count.
     */
    public int getMessageCount() {
        return emaObject.getMessageCount();
    }

    /**
     * \~chinese
     * 获取子区创建的 Unix 时间戳，单位为毫秒。
     *
     * @return  子区创建的 Unix 时间戳。
     *
     * \~english
     * Gets the Unix timestamp when the message thread is created. The unit is millisecond.
     *
     * @return The Unix timestamp when the message thread is created.
     */
    public long getCreateAt() {
        return emaObject.getCreateAt();
    }

    /**
     * \~chinese
     * 获取最近的子区消息。
     * 
     * 获取该属性的值之前，需先调用 {@link EMMessage#getChatThread()} 方法获取子区详情。
     * 
     * @return 最近的子区消息。
     *
     * \~english
     * Get the last reply in the message thread.
     * 
     * To get the last reply in the message thread, you need to first call {@link EMMessage#getChatThread()} to get details of the message thread.
     * 
     * @return The last reply in the message thread.
     */
    public EMMessage getLastMessage() {
        if(emaObject.getLastMessage() == null) {
            return null;
        }
        return new EMMessage(emaObject.getLastMessage());
    }

    /**
     * \~chinese
     * 获取子区名称或者子区 ID。
     *
     * 该方法可用于适配器排序。
     *
     * @return  子区名称或者子区 ID。
     *
     * \~english
     * Gets the message thread name or ID.
     *
     * This method can be used for adapter sorting.
     *
     * @return  The message thread name or ID.
     */
    public String toString() {
        String str = getChatThreadName();
        return str != null ? str : getChatThreadId();
    }

}
