/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate;

/**
 * \~chinese
 * 聊天会话变更及收到会话已读的监听器。
 *
 * \~english
 * The listener when conversation changed or received the conversation receipt.
 */
public interface EMConversationListener {

	/**
     * \~chinese
	 * 会话变更回调。
     *
     * \~english
	 * Occurs when the conversation updated.
	 */
    void onCoversationUpdate();

	/**
	 * \~chinese
	 * 收到会话已读回调。
	 *
	 * 回调此方法的场景：
	 * （1）消息被接收方阅读（发送了会话已读回执）。
	 * SDK 在接收到此事件时，会将本地数据库中该会话中消息的 `isAcked` 属性置为 `true`。
	 * （2）多端多设备登录场景下，一端发送会话已读回执（conversation ack），服务器端会将会话的未读消息数置为 0，
	 * 同时其他端会回调此方法，并将本地数据库中该会话中消息的 `isRead` 属性置为 `true`。
	 * @param from 发送 read receipt 方。
	 * @param to   接收 read receipt 方。
	 *
	 * \~english
	 * Occurs when received conversation read receipt.
	 *
	 * Occurs in the following scenarios:
	 * (1) The message is read by the receiver (The conversation receipt is sent).
	 * Upon receiving this event, the SDK sets the `isAcked` property of the message in the conversation to `true` in the local database.
	 * (2) In the multi-device login scenario, when one device sends a Conversation receipt,
	 * the server will set the number of unread messages to 0, and the callback occurs on the other devices.
	 * and sets the `isRead` property of the message in the conversation to `true` in the local database.
	 * @param from The user who sends the read receipt.
	 * @param to   The user who receives the read receipt.
	 */
	void onConversationRead(String from, String to);
}
