/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.notification.core;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import com.hyphenate.EMCallBack;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMPushManager;
import com.hyphenate.notification.EMNotificationMessage;
import com.hyphenate.util.EMLog;
import java.util.Iterator;
import org.json.JSONObject;

public class EMNotificationIntentReceiver
extends BroadcastReceiver {
    private static final String TAG = "em_notification";

    public final void onReceive(Context context, Intent intent) {
        EMLog.d(TAG, "onReceive");
        if (intent == null) {
            return;
        }
        try {
            Bundle bundle = intent.getExtras();
            if (bundle != null) {
                int n = bundle.getInt("event_type");
                String string = bundle.getString("task_id");
                EMNotificationMessage eMNotificationMessage = (EMNotificationMessage)bundle.getParcelable("message");
                if (n == 0) {
                    this.onNotifyMessageArrived(context, eMNotificationMessage);
                }
                if (n == 1) {
                    EMClient.getInstance().pushManager().asyncReportPushAction(string, "EASEMOB", EMPushManager.EMPushAction.CLICK, new EMCallBack(){

                        @Override
                        public void onSuccess() {
                            EMLog.d(EMNotificationIntentReceiver.TAG, "report success");
                        }

                        @Override
                        public void onError(int n, String string) {
                            EMLog.d(EMNotificationIntentReceiver.TAG, "report failed: " + n + " : " + string);
                        }

                        @Override
                        public void onProgress(int n, String string) {
                        }
                    });
                    this.onNotificationClick(context, eMNotificationMessage);
                }
            }
        }
        catch (Exception exception) {
            EMLog.d(TAG, exception.getMessage());
        }
    }

    public void onNotifyMessageArrived(Context context, EMNotificationMessage eMNotificationMessage) {
        EMLog.d(TAG, "onNotifyMessageArrived");
    }

    public void onNotificationClick(Context context, EMNotificationMessage eMNotificationMessage) {
        try {
            Intent intent = null;
            if (eMNotificationMessage.getOpenType() == 1) {
                if (!TextUtils.isEmpty((CharSequence)eMNotificationMessage.getOpenUrl()) && (eMNotificationMessage.getOpenUrl().startsWith("http:") || eMNotificationMessage.getOpenUrl().startsWith("https:"))) {
                    intent = new Intent("android.intent.action.VIEW", Uri.parse((String)eMNotificationMessage.getOpenUrl()));
                }
            } else if (eMNotificationMessage.getOpenType() == 2) {
                if (!TextUtils.isEmpty((CharSequence)eMNotificationMessage.getOpenAction())) {
                    intent = eMNotificationMessage.getOpenAction().contains("://") ? new Intent("android.intent.action.VIEW", Uri.parse((String)eMNotificationMessage.getOpenAction())) : new Intent(eMNotificationMessage.getOpenAction());
                } else if (!TextUtils.isEmpty((CharSequence)eMNotificationMessage.getOpenActivity())) {
                    intent = new Intent();
                    intent.setComponent(new ComponentName(context, eMNotificationMessage.getOpenActivity()));
                }
            } else {
                intent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
            }
            if (!TextUtils.isEmpty((CharSequence)eMNotificationMessage.getExtras()) && intent != null) {
                JSONObject jSONObject = new JSONObject(eMNotificationMessage.getExtras());
                Iterator iterator = jSONObject.keys();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    intent.putExtra(string, jSONObject.getString(string));
                }
            }
            if (intent != null) {
                intent.setFlags(337641472);
                context.startActivity(intent);
            }
        }
        catch (Exception exception) {
            EMLog.d(TAG, "onNotificationClick:" + exception.getMessage());
        }
    }
}

