/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat.adapter;

import android.util.Base64;
import com.hyphenate.util.EMLog;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class EMAREncryptUtils {
    public static final String TAG = "EMAREncryptUtils";
    private Cipher gcmEncryptCipher;

    public static byte[] generateAESKey() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(128);
            SecretKey secretKey = keyGenerator.generateKey();
            return secretKey.getEncoded();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            return null;
        }
    }

    public static byte[] generateAESKey256() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(256);
            SecretKey secretKey = keyGenerator.generateKey();
            return secretKey.getEncoded();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            return null;
        }
    }

    public static String b64Encode(byte[] byArray, int n) {
        return Base64.encodeToString((byte[])byArray, (int)0, (int)byArray.length, (int)(n == B64_ENCODE_FLAG.ONESDK_B64_NO_WRAP.ordinal() ? 2 : 0));
    }

    public static byte[] b64Decode(String string) {
        return Base64.decode((String)string, (int)0);
    }

    public static byte[] b64Decode(String string, int n) {
        return Base64.decode((String)string, (int)(n == B64_ENCODE_FLAG.ONESDK_B64_NO_WRAP.ordinal() ? 2 : 0));
    }

    public void initAESgcm(byte[] byArray) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
            SecureRandom secureRandom = new SecureRandom();
            byte[] byArray2 = new byte[12];
            secureRandom.nextBytes(byArray2);
            GCMParameterSpec gCMParameterSpec = new GCMParameterSpec(128, byArray2);
            this.gcmEncryptCipher = Cipher.getInstance("AES/GCM/NoPadding");
            this.gcmEncryptCipher.init(1, (Key)secretKeySpec, gCMParameterSpec);
            EMLog.d("encrypt", "init for AES gcm");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            EMLog.d(TAG, Arrays.toString(exception.getStackTrace()));
        }
    }

    public String aesGcmEncrypt(String string, int n) {
        try {
            byte[] byArray = string.getBytes("UTF-8");
            byte[] byArray2 = this.gcmEncryptCipher.doFinal(byArray);
            byte[] byArray3 = this.gcmEncryptCipher.getIV();
            ByteBuffer byteBuffer = ByteBuffer.allocate(1 + byArray3.length + byArray2.length);
            byteBuffer.put((byte)byArray3.length);
            byteBuffer.put(byArray3);
            byteBuffer.put(byArray2);
            return EMAREncryptUtils.b64Encode(byteBuffer.array(), n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            EMLog.d(TAG, Arrays.toString(exception.getStackTrace()));
            return null;
        }
    }

    public String aesGcmDecrypt(String string, byte[] byArray, int n) {
        try {
            byte[] byArray2 = EMAREncryptUtils.b64Decode(string, n);
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
            byte[] byArray3 = new byte[byteBuffer.get()];
            byteBuffer.get(byArray3);
            byte[] byArray4 = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray4);
            GCMParameterSpec gCMParameterSpec = new GCMParameterSpec(128, byArray3);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(2, (Key)new SecretKeySpec(byArray, "AES"), gCMParameterSpec);
            byte[] byArray5 = cipher.doFinal(byArray4);
            return new String(byArray5);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            EMLog.d(TAG, Arrays.toString(exception.getStackTrace()));
            return null;
        }
    }

    public static byte[] encryptByRSAPublicKey(String string, byte[] byArray, AtomicBoolean atomicBoolean) {
        String string2 = string;
        string2 = string2.replace("-----BEGIN PUBLIC KEY-----", "");
        string2 = string2.replace("-----END PUBLIC KEY-----", "");
        string2 = string2.replace("\n", "");
        byte[] byArray2 = Base64.decode((byte[])string2.getBytes(), (int)2);
        try {
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray2);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            EMLog.d(TAG, "publicKey.getFormat:" + publicKey.getFormat());
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(1, publicKey);
            byte[] byArray3 = cipher.doFinal(byArray);
            atomicBoolean.set(true);
            return byArray3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            EMLog.d(TAG, Arrays.toString(exception.getStackTrace()));
            return null;
        }
    }

    public static String messageDigest(int n, byte[] byArray) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = n == 1 ? MessageDigest.getInstance("SHA-256") : MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        byte[] byArray2 = null;
        if (messageDigest != null) {
            byArray2 = messageDigest.digest(byArray);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (byArray2 != null) {
            for (int i = 0; i < byArray2.length; ++i) {
                int n2 = byArray2[i] & 0xFF;
                if (n2 < 16) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(Integer.toHexString(n2));
            }
        }
        return stringBuffer.toString();
    }

    static enum B64_ENCODE_FLAG {
        ONESDK_B64_DEFAULT,
        ONESDK_B64_NO_WRAP;

    }
}

