/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import com.hyphenate.EMValueCallBack;
import com.hyphenate.chat.EMUserInfo;
import com.hyphenate.chat.adapter.EMAError;
import com.hyphenate.chat.adapter.EMAUserInfoManager;
import com.hyphenate.util.EMLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONException;
import org.json.JSONObject;

public class EMUserInfoManager {
    static final String TAG = "EMUserInfoManager";
    EMAUserInfoManager emaObject;
    private ExecutorService executorService;

    protected EMUserInfoManager(EMAUserInfoManager eMAUserInfoManager) {
        this.emaObject = eMAUserInfoManager;
        this.executorService = Executors.newCachedThreadPool();
    }

    public void updateOwnInfo(final EMUserInfo eMUserInfo, final EMValueCallBack<String> eMValueCallBack) {
        EMLog.d(TAG, "start updateOwnInfo");
        if (eMUserInfo == null) {
            EMLog.d(TAG, "fetchUserInfoByUserId userInfo is empty");
            eMValueCallBack.onError(205, "userInfo is empty");
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                JSONObject jSONObject = new JSONObject();
                try {
                    if (eMUserInfo != null) {
                        jSONObject.putOpt(EMUserInfo.EMUserInfoType.NICKNAME.getDesc(), (Object)eMUserInfo.getNickName());
                        jSONObject.putOpt(EMUserInfo.EMUserInfoType.AVATAR_URL.getDesc(), (Object)eMUserInfo.getAvatarUrl());
                        jSONObject.putOpt(EMUserInfo.EMUserInfoType.EMAIL.getDesc(), (Object)eMUserInfo.getEmail());
                        jSONObject.putOpt(EMUserInfo.EMUserInfoType.GENDER.getDesc(), (Object)eMUserInfo.getGender());
                        jSONObject.putOpt(EMUserInfo.EMUserInfoType.BIRTH.getDesc(), (Object)eMUserInfo.getBirth());
                        jSONObject.putOpt(EMUserInfo.EMUserInfoType.PHONE.getDesc(), (Object)eMUserInfo.getPhoneNumber());
                        jSONObject.putOpt(EMUserInfo.EMUserInfoType.SIGN.getDesc(), (Object)eMUserInfo.getSignature());
                        jSONObject.putOpt(EMUserInfo.EMUserInfoType.EXT.getDesc(), (Object)eMUserInfo.getExt());
                    }
                    EMLog.d(EMUserInfoManager.TAG, "updateOwnInfo param: " + jSONObject.toString());
                    EMUserInfoManager.this.emaObject.updateOwnInfo(jSONObject.toString(), eMAError);
                    if (eMValueCallBack == null) {
                        return;
                    }
                    if (eMAError.errCode() == 0) {
                        EMLog.d(EMUserInfoManager.TAG, "updateOwnInfo success");
                        eMValueCallBack.onSuccess(eMAError.toString());
                    } else {
                        EMLog.e(EMUserInfoManager.TAG, "updateOwnInfo failed error:" + eMAError.errCode() + "  errorMessage:" + eMAError.errMsg());
                        eMValueCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                    }
                }
                catch (Exception exception) {
                    exception.getStackTrace();
                }
            }
        });
    }

    public void updateOwnInfoByAttribute(final EMUserInfo.EMUserInfoType eMUserInfoType, final String string, final EMValueCallBack<String> eMValueCallBack) {
        EMLog.d(TAG, "start updateOwnInfoByAttribute");
        if (eMUserInfoType == null) {
            EMLog.d(TAG, "fetchUserInfoByUserId attribute is null");
            eMValueCallBack.onError(205, "attribute is null");
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.putOpt(eMUserInfoType.getDesc(), (Object)string);
                    EMLog.d(EMUserInfoManager.TAG, "updateOwnInfoByAttribute param: " + jSONObject.toString());
                    String string2 = EMUserInfoManager.this.emaObject.updateOwnInfo(jSONObject.toString(), eMAError);
                    EMLog.d(EMUserInfoManager.TAG, "updateOwnInfoByAttribute response: " + string2);
                    if (eMValueCallBack == null) {
                        return;
                    }
                    if (eMAError.errCode() == 0) {
                        EMLog.d(EMUserInfoManager.TAG, "updateOwnInfoByAttribute success");
                        eMValueCallBack.onSuccess(string2);
                    } else {
                        EMLog.e(EMUserInfoManager.TAG, "updateOwnInfoByAttribute failed error:" + eMAError.errCode() + "  errorMessage:" + eMAError.errMsg());
                        eMValueCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                    }
                }
                catch (Exception exception) {
                    exception.getStackTrace();
                }
            }
        });
    }

    public void fetchUserInfoByUserId(final String[] stringArray, final EMValueCallBack<Map<String, EMUserInfo>> eMValueCallBack) {
        EMLog.d(TAG, "start fetchUserInfoByUserId");
        if (stringArray == null || stringArray.length == 0) {
            EMLog.d(TAG, "fetchUserInfoByUserId userIds is empty");
            eMValueCallBack.onError(205, "userIds is empty");
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                ArrayList<String> arrayList = new ArrayList<String>();
                Collections.addAll(arrayList, stringArray);
                ArrayList<String> arrayList2 = new ArrayList<String>();
                arrayList2.add(EMUserInfo.EMUserInfoType.NICKNAME.getDesc());
                arrayList2.add(EMUserInfo.EMUserInfoType.EMAIL.getDesc());
                arrayList2.add(EMUserInfo.EMUserInfoType.PHONE.getDesc());
                arrayList2.add(EMUserInfo.EMUserInfoType.GENDER.getDesc());
                arrayList2.add(EMUserInfo.EMUserInfoType.AVATAR_URL.getDesc());
                arrayList2.add(EMUserInfo.EMUserInfoType.SIGN.getDesc());
                arrayList2.add(EMUserInfo.EMUserInfoType.BIRTH.getDesc());
                arrayList2.add(EMUserInfo.EMUserInfoType.EXT.getDesc());
                EMLog.d(EMUserInfoManager.TAG, "fetchUserInfoByUserId param: " + ((Object)arrayList).toString() + "  " + ((Object)arrayList2).toString());
                String string = EMUserInfoManager.this.emaObject.fetchUserInfoByAttribute(arrayList, arrayList2, eMAError);
                if (eMValueCallBack == null) {
                    return;
                }
                EMLog.d(EMUserInfoManager.TAG, "fetchUserInfoByUserId response: " + string);
                if (eMAError.errCode() == 0) {
                    EMLog.d(EMUserInfoManager.TAG, "fetchUserInfoByUserId success");
                    HashMap<String, EMUserInfo> hashMap = new HashMap<String, EMUserInfo>();
                    if (string != null && string.length() > 0) {
                        try {
                            JSONObject jSONObject = new JSONObject(string);
                            for (String string2 : stringArray) {
                                JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
                                if (jSONObject2 == null) continue;
                                EMUserInfo eMUserInfo = new EMUserInfo();
                                eMUserInfo.setNickName(jSONObject2.optString(EMUserInfo.EMUserInfoType.NICKNAME.getDesc()));
                                String string3 = jSONObject2.optString(EMUserInfo.EMUserInfoType.GENDER.getDesc());
                                if (string3 != null && string3.length() > 0) {
                                    try {
                                        eMUserInfo.setGender(Integer.parseInt(string3));
                                    }
                                    catch (Exception exception) {
                                        eMUserInfo.setGender(0);
                                    }
                                }
                                eMUserInfo.setEmail(jSONObject2.optString(EMUserInfo.EMUserInfoType.EMAIL.getDesc()));
                                eMUserInfo.setPhoneNumber(jSONObject2.optString(EMUserInfo.EMUserInfoType.PHONE.getDesc()));
                                eMUserInfo.setSignature(jSONObject2.optString(EMUserInfo.EMUserInfoType.SIGN.getDesc()));
                                eMUserInfo.setAvatarUrl(jSONObject2.optString(EMUserInfo.EMUserInfoType.AVATAR_URL.getDesc()));
                                eMUserInfo.setExt(jSONObject2.optString(EMUserInfo.EMUserInfoType.EXT.getDesc()));
                                eMUserInfo.setBirth(jSONObject2.optString(EMUserInfo.EMUserInfoType.BIRTH.getDesc()));
                                eMUserInfo.setUserId(string2);
                                hashMap.put(string2, eMUserInfo);
                            }
                        }
                        catch (JSONException jSONException) {
                            eMAError.errMsg();
                        }
                        eMValueCallBack.onSuccess(hashMap);
                    } else {
                        EMLog.e(EMUserInfoManager.TAG, "fetchUserInfoByUserId response is null");
                        eMValueCallBack.onSuccess(null);
                    }
                } else {
                    eMValueCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                    EMLog.e(EMUserInfoManager.TAG, "fetchUserInfoByUserId failed error:" + eMAError.errCode() + "  errorMessage:" + eMAError.errMsg());
                }
            }
        });
    }

    public void fetchUserInfoByAttribute(final String[] stringArray, final EMUserInfo.EMUserInfoType[] eMUserInfoTypeArray, final EMValueCallBack<Map<String, EMUserInfo>> eMValueCallBack) {
        EMLog.d(TAG, "start fetchUserInfoByAttribute");
        if (stringArray == null || stringArray.length == 0) {
            EMLog.d(TAG, "fetchUserInfoByUserId userIds is empty");
            eMValueCallBack.onError(205, "userIds is empty");
            return;
        }
        if (eMUserInfoTypeArray == null || eMUserInfoTypeArray.length == 0) {
            EMLog.d(TAG, "fetchUserInfoByUserId attributes is empty");
            eMValueCallBack.onError(205, "attributes is empty");
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                ArrayList<String> arrayList = new ArrayList<String>();
                Collections.addAll(arrayList, stringArray);
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (EMUserInfo.EMUserInfoType stringArray2 : eMUserInfoTypeArray) {
                    arrayList2.add(stringArray2.getDesc());
                }
                EMLog.d(EMUserInfoManager.TAG, "fetchUserInfoByAttribute param: " + ((Object)arrayList).toString() + "  " + ((Object)arrayList2).toString());
                String string = EMUserInfoManager.this.emaObject.fetchUserInfoByAttribute(arrayList, arrayList2, eMAError);
                EMLog.d(EMUserInfoManager.TAG, "fetchUserInfoByAttribute response: " + (String)string);
                if (eMValueCallBack == null) {
                    return;
                }
                if (eMAError.errCode() == 0) {
                    EMLog.d(EMUserInfoManager.TAG, "fetchUserInfoByAttribute success");
                    HashMap<String, EMUserInfo> hashMap = new HashMap<String, EMUserInfo>();
                    if (string != null && string.length() > 0) {
                        try {
                            JSONObject jSONObject = new JSONObject(string);
                            for (String string2 : stringArray) {
                                JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
                                if (jSONObject2 == null) continue;
                                EMUserInfo eMUserInfo = new EMUserInfo();
                                eMUserInfo.setNickName(jSONObject2.optString(EMUserInfo.EMUserInfoType.NICKNAME.getDesc()));
                                String string3 = jSONObject2.optString(EMUserInfo.EMUserInfoType.GENDER.getDesc());
                                if (string3 != null && string3.length() > 0) {
                                    eMUserInfo.setGender(Integer.valueOf(string3));
                                }
                                eMUserInfo.setEmail(jSONObject2.optString(EMUserInfo.EMUserInfoType.EMAIL.getDesc()));
                                eMUserInfo.setPhoneNumber(jSONObject2.optString(EMUserInfo.EMUserInfoType.PHONE.getDesc()));
                                eMUserInfo.setSignature(jSONObject2.optString(EMUserInfo.EMUserInfoType.SIGN.getDesc()));
                                eMUserInfo.setAvatarUrl(jSONObject2.optString(EMUserInfo.EMUserInfoType.AVATAR_URL.getDesc()));
                                eMUserInfo.setExt(jSONObject2.optString(EMUserInfo.EMUserInfoType.EXT.getDesc()));
                                eMUserInfo.setBirth(jSONObject2.optString(EMUserInfo.EMUserInfoType.BIRTH.getDesc()));
                                eMUserInfo.setUserId(string2);
                                hashMap.put(string2, eMUserInfo);
                            }
                        }
                        catch (JSONException jSONException) {
                            eMAError.errMsg();
                        }
                        eMValueCallBack.onSuccess(hashMap);
                    } else {
                        EMLog.d(EMUserInfoManager.TAG, "fetchUserInfoByAttribute response is null ");
                        eMValueCallBack.onSuccess(null);
                    }
                } else {
                    eMValueCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                    EMLog.e(EMUserInfoManager.TAG, "fetchUserInfoByAttribute failed error:" + eMAError.errCode() + "  errorMessage:" + eMAError.errMsg());
                }
            }
        });
    }
}

