/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import com.hyphenate.chat.EMBase;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.adapter.EMAConversation;
import com.hyphenate.chat.adapter.message.EMAMessage;
import com.hyphenate.util.EMLog;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class EMConversation
extends EMBase<EMAConversation> {
    private static final String TAG = "conversation";
    private static final int LIST_SIZE = 512;

    EMConversation(EMAConversation eMAConversation) {
        this.emaObject = eMAConversation;
    }

    public String conversationId() {
        return ((EMAConversation)this.emaObject).conversationId();
    }

    public EMConversationType getType() {
        EMAConversation.EMAConversationType eMAConversationType = ((EMAConversation)this.emaObject)._getType();
        if (eMAConversationType == EMAConversation.EMAConversationType.CHAT) {
            return EMConversationType.Chat;
        }
        if (eMAConversationType == EMAConversation.EMAConversationType.GROUPCHAT) {
            return EMConversationType.GroupChat;
        }
        if (eMAConversationType == EMAConversation.EMAConversationType.CHATROOM) {
            return EMConversationType.ChatRoom;
        }
        if (eMAConversationType == EMAConversation.EMAConversationType.DISCUSSIONGROUP) {
            return EMConversationType.DiscussionGroup;
        }
        if (eMAConversationType == EMAConversation.EMAConversationType.HELPDESK) {
            return EMConversationType.HelpDesk;
        }
        return EMConversationType.Chat;
    }

    public int getUnreadMsgCount() {
        return ((EMAConversation)this.emaObject).unreadMessagesCount();
    }

    public void markAllMessagesAsRead() {
        ((EMAConversation)this.emaObject).markAllMessagesAsRead(true);
    }

    public int getAllMsgCount() {
        return ((EMAConversation)this.emaObject).messagesCount();
    }

    public boolean isChatThread() {
        return ((EMAConversation)this.emaObject).isChatThread();
    }

    public List<EMMessage> loadMoreMsgFromDB(String string, int n) {
        return this.loadMoreMsgFromDB(string, n, EMSearchDirection.UP);
    }

    public List<EMMessage> loadMoreMsgFromDB(String string, int n, EMSearchDirection eMSearchDirection) {
        EMAConversation.EMASearchDirection eMASearchDirection = eMSearchDirection == EMSearchDirection.UP ? EMAConversation.EMASearchDirection.UP : EMAConversation.EMASearchDirection.DOWN;
        List<EMAMessage> list = ((EMAConversation)this.emaObject).loadMoreMessages(string, n, eMASearchDirection);
        ArrayList<EMMessage> arrayList = new ArrayList<EMMessage>();
        for (EMAMessage eMAMessage : list) {
            if (eMAMessage == null) continue;
            arrayList.add(new EMMessage(eMAMessage));
        }
        this.getCache().addMessages(arrayList);
        return arrayList;
    }

    public List<EMMessage> searchMsgFromDB(long l, int n, EMSearchDirection eMSearchDirection) {
        EMAConversation.EMASearchDirection eMASearchDirection = eMSearchDirection == EMSearchDirection.UP ? EMAConversation.EMASearchDirection.UP : EMAConversation.EMASearchDirection.DOWN;
        List<EMAMessage> list = ((EMAConversation)this.emaObject).searchMessages(l, n, eMASearchDirection);
        AbstractList abstractList = list.size() > 512 ? new LinkedList() : new ArrayList();
        for (EMAMessage eMAMessage : list) {
            if (eMAMessage == null) continue;
            abstractList.add((EMMessage)new EMMessage(eMAMessage));
        }
        return abstractList;
    }

    public List<EMMessage> searchMsgFromDB(EMMessage.Type type, long l, int n, String string, EMSearchDirection eMSearchDirection) {
        EMAConversation.EMASearchDirection eMASearchDirection = eMSearchDirection == EMSearchDirection.UP ? EMAConversation.EMASearchDirection.UP : EMAConversation.EMASearchDirection.DOWN;
        List<EMAMessage> list = ((EMAConversation)this.emaObject).searchMessages(type.ordinal(), l, n, string, eMASearchDirection);
        AbstractList abstractList = list.size() > 512 ? new LinkedList() : new ArrayList();
        for (EMAMessage eMAMessage : list) {
            if (eMAMessage == null) continue;
            abstractList.add((EMMessage)new EMMessage(eMAMessage));
        }
        return abstractList;
    }

    public List<EMMessage> searchMsgFromDB(String string, long l, int n, String string2, EMSearchDirection eMSearchDirection) {
        EMAConversation.EMASearchDirection eMASearchDirection = eMSearchDirection == EMSearchDirection.UP ? EMAConversation.EMASearchDirection.UP : EMAConversation.EMASearchDirection.DOWN;
        List<EMAMessage> list = ((EMAConversation)this.emaObject).searchMessages(string, l, n, string2, eMASearchDirection);
        AbstractList abstractList = list.size() > 512 ? new LinkedList() : new ArrayList();
        for (EMAMessage eMAMessage : list) {
            if (eMAMessage == null) continue;
            abstractList.add((EMMessage)new EMMessage(eMAMessage));
        }
        return abstractList;
    }

    public List<EMMessage> searchMsgFromDB(long l, long l2, int n) {
        List<EMAMessage> list = ((EMAConversation)this.emaObject).searchMessages(l, l2, n);
        AbstractList abstractList = list.size() > 512 ? new LinkedList() : new ArrayList();
        for (EMAMessage eMAMessage : list) {
            if (eMAMessage == null) continue;
            abstractList.add((EMMessage)new EMMessage(eMAMessage));
        }
        return abstractList;
    }

    public List<EMMessage> searchCustomMsgFromDB(String string, long l, int n, String string2, EMSearchDirection eMSearchDirection) {
        EMAConversation.EMASearchDirection eMASearchDirection = eMSearchDirection == EMSearchDirection.UP ? EMAConversation.EMASearchDirection.UP : EMAConversation.EMASearchDirection.DOWN;
        List<EMAMessage> list = ((EMAConversation)this.emaObject).searchCustomMessages(string, l, n, string2, eMASearchDirection);
        AbstractList abstractList = list.size() > 512 ? new LinkedList() : new ArrayList();
        for (EMAMessage eMAMessage : list) {
            if (eMAMessage == null) continue;
            abstractList.add((EMMessage)new EMMessage(eMAMessage));
        }
        return abstractList;
    }

    public EMMessage getMessage(String string, boolean bl) {
        EMMessage eMMessage = this.getCache().getMessage(string);
        if (eMMessage == null) {
            EMAMessage eMAMessage = ((EMAConversation)this.emaObject).loadMessage(string);
            if (eMAMessage == null) {
                return null;
            }
            eMMessage = new EMMessage(eMAMessage);
        }
        ((EMAConversation)this.emaObject).markMessageAsRead(string, bl);
        return eMMessage;
    }

    @Deprecated
    public List<EMMessage> loadMessages(List<String> list) {
        ArrayList<EMMessage> arrayList = new ArrayList<EMMessage>();
        for (String string : list) {
            EMAMessage eMAMessage = ((EMAConversation)this.emaObject).loadMessage(string);
            if (eMAMessage == null) continue;
            arrayList.add(new EMMessage(eMAMessage));
        }
        this.getCache().addMessages(arrayList);
        return arrayList;
    }

    public void markMessageAsRead(String string) {
        ((EMAConversation)this.emaObject).markMessageAsRead(string, true);
    }

    public List<EMMessage> getAllMessages() {
        if (this.getCache().isEmpty()) {
            EMAMessage eMAMessage = ((EMAConversation)this.emaObject).latestMessage();
            ArrayList<EMMessage> arrayList = new ArrayList<EMMessage>();
            if (eMAMessage != null) {
                arrayList.add(new EMMessage(eMAMessage));
            }
            this.getCache().addMessages(arrayList);
        }
        return this.getCache().getAllMessages();
    }

    public void removeMessage(String string) {
        EMLog.d(TAG, "remove msg from conversation: " + string);
        ((EMAConversation)this.emaObject)._removeMessage(string);
        this.getCache().removeMessage(string);
    }

    public EMMessage getLastMessage() {
        if (this.getCache().isEmpty()) {
            EMAMessage eMAMessage = ((EMAConversation)this.emaObject).latestMessage();
            EMMessage eMMessage = eMAMessage == null ? null : new EMMessage(eMAMessage);
            this.getCache().addMessage(eMMessage);
            return eMMessage;
        }
        return this.getCache().getLastMessage();
    }

    public EMMessage getLatestMessageFromOthers() {
        EMAMessage eMAMessage = ((EMAConversation)this.emaObject).latestMessageFromOthers();
        EMMessage eMMessage = eMAMessage == null ? null : new EMMessage(eMAMessage);
        this.getCache().addMessage(eMMessage);
        return eMMessage;
    }

    public void clear() {
        this.getCache().clear();
    }

    public void clearAllMessages() {
        ((EMAConversation)this.emaObject).clearAllMessages();
        this.getCache().clear();
    }

    public void setExtField(String string) {
        if (!this.isChatThread()) {
            ((EMAConversation)this.emaObject)._setExtField(string);
        }
    }

    public String getExtField() {
        return ((EMAConversation)this.emaObject).extField();
    }

    public static EMConversationType msgType2ConversationType(String string, EMMessage.ChatType chatType) {
        switch (chatType) {
            case GroupChat: {
                return EMConversationType.GroupChat;
            }
            case ChatRoom: {
                return EMConversationType.ChatRoom;
            }
        }
        return EMConversationType.Chat;
    }

    public boolean isGroup() {
        EMConversationType eMConversationType = this.getType();
        return !this.isChatThread() && (eMConversationType == EMConversationType.GroupChat || eMConversationType == EMConversationType.ChatRoom);
    }

    public boolean insertMessage(EMMessage eMMessage) {
        boolean bl = ((EMAConversation)this.emaObject).insertMessage((EMAMessage)eMMessage.emaObject);
        if (bl) {
            this.getCache().addMessage(eMMessage);
        }
        return bl;
    }

    public boolean appendMessage(EMMessage eMMessage) {
        boolean bl = ((EMAConversation)this.emaObject).appendMessage((EMAMessage)eMMessage.emaObject);
        if (bl) {
            this.getCache().addMessage(eMMessage);
        }
        return bl;
    }

    public boolean updateMessage(EMMessage eMMessage) {
        boolean bl = ((EMAConversation)this.emaObject).updateMessage((EMAMessage)eMMessage.emaObject);
        if (bl) {
            this.getCache().addMessage(eMMessage);
        }
        return bl;
    }

    public String getMessageAttachmentPath() {
        String string = EMClient.getInstance().getChatConfigPrivate().E();
        return string + "/" + EMClient.getInstance().getCurrentUser() + "/" + this.conversationId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MessageCache getCache() {
        MessageCache messageCache;
        Map<String, MessageCache> map = EMClient.getInstance().chatManager().caches;
        synchronized (map) {
            messageCache = EMClient.getInstance().chatManager().caches.get(((EMAConversation)this.emaObject).conversationId());
            if (messageCache == null) {
                messageCache = new MessageCache();
            }
            EMClient.getInstance().chatManager().caches.put(((EMAConversation)this.emaObject).conversationId(), messageCache);
        }
        return messageCache;
    }

    static class MessageCache {
        TreeMap<Long, Object> sortedMessages = new TreeMap(new MessageComparator());
        Map<String, EMMessage> messages = new HashMap<String, EMMessage>();
        Map<String, Long> idTimeMap = new HashMap<String, Long>();
        boolean hasDuplicateTime = false;
        final boolean sortByServerTime = EMClient.getInstance().getChatConfigPrivate().b().isSortMessageByServerTime();

        MessageCache() {
        }

        public synchronized EMMessage getMessage(String string) {
            if (string == null || string.isEmpty()) {
                return null;
            }
            return this.messages.get(string);
        }

        public synchronized void addMessages(List<EMMessage> list) {
            for (EMMessage eMMessage : list) {
                this.addMessage(eMMessage);
            }
        }

        public synchronized void addMessage(EMMessage eMMessage) {
            long l;
            if (eMMessage == null || eMMessage.emaObject == null || eMMessage.getMsgTime() == 0L || eMMessage.getMsgTime() == -1L || eMMessage.getMsgId() == null || eMMessage.getMsgId().isEmpty() || eMMessage.getType() == EMMessage.Type.CMD) {
                return;
            }
            String string = eMMessage.getMsgId();
            if (this.messages.containsKey(string)) {
                l = this.idTimeMap.get(string);
                this.sortedMessages.remove(l);
                this.messages.remove(string);
                this.idTimeMap.remove(string);
            }
            long l2 = l = this.sortByServerTime ? eMMessage.getMsgTime() : eMMessage.localTime();
            if (this.sortedMessages.containsKey(l)) {
                this.hasDuplicateTime = true;
                Object object = this.sortedMessages.get(l);
                if (object != null) {
                    if (object instanceof EMMessage) {
                        LinkedList<EMMessage> linkedList = new LinkedList<EMMessage>();
                        linkedList.add((EMMessage)object);
                        linkedList.add(eMMessage);
                        this.sortedMessages.put(l, linkedList);
                    } else if (object instanceof List) {
                        List list = (List)object;
                        list.add(eMMessage);
                    }
                }
            } else {
                this.sortedMessages.put(l, eMMessage);
            }
            this.messages.put(string, eMMessage);
            this.idTimeMap.put(string, l);
        }

        public synchronized void removeMessage(String string) {
            if (string == null || string.isEmpty()) {
                return;
            }
            EMMessage eMMessage = this.messages.get(string);
            if (eMMessage != null) {
                Long l = this.idTimeMap.get(string);
                if (l != null) {
                    if (this.hasDuplicateTime && this.sortedMessages.containsKey(l)) {
                        Object object = this.sortedMessages.get(l);
                        if (object != null && object instanceof List) {
                            List list = (List)object;
                            for (EMMessage eMMessage2 : list) {
                                if (eMMessage2 == null || eMMessage2.getMsgId() == null || !eMMessage2.getMsgId().equals(string)) continue;
                                list.remove(eMMessage2);
                                break;
                            }
                        } else {
                            this.sortedMessages.remove(l);
                        }
                    } else {
                        this.sortedMessages.remove(l);
                    }
                    this.idTimeMap.remove(string);
                }
                this.messages.remove(string);
            }
        }

        public synchronized List<EMMessage> getAllMessages() {
            ArrayList<EMMessage> arrayList = new ArrayList<EMMessage>();
            if (!this.hasDuplicateTime) {
                for (Object object : this.sortedMessages.values()) {
                    arrayList.add((EMMessage)object);
                }
            } else {
                for (Object object : this.sortedMessages.values()) {
                    if (object == null) continue;
                    if (object instanceof List) {
                        arrayList.addAll((List)object);
                        continue;
                    }
                    arrayList.add((EMMessage)object);
                }
            }
            return arrayList;
        }

        public synchronized EMMessage getLastMessage() {
            if (this.sortedMessages.isEmpty()) {
                return null;
            }
            Object object = this.sortedMessages.lastEntry().getValue();
            if (object == null) {
                return null;
            }
            if (object instanceof EMMessage) {
                return (EMMessage)object;
            }
            if (object instanceof List) {
                List list = (List)object;
                if (list.size() > 0) {
                    return (EMMessage)list.get(list.size() - 1);
                }
                return null;
            }
            return null;
        }

        public synchronized void clear() {
            this.sortedMessages.clear();
            this.messages.clear();
            this.idTimeMap.clear();
        }

        public synchronized boolean isEmpty() {
            return this.sortedMessages.isEmpty();
        }

        class MessageComparator
        implements Comparator<Long> {
            MessageComparator() {
            }

            @Override
            public int compare(Long l, Long l2) {
                long l3 = l - l2;
                if (l3 > 0L) {
                    return 1;
                }
                if (l3 == 0L) {
                    return 0;
                }
                return -1;
            }
        }
    }

    public static enum EMSearchDirection {
        UP,
        DOWN;

    }

    public static enum EMConversationType {
        Chat,
        GroupChat,
        ChatRoom,
        DiscussionGroup,
        HelpDesk;

    }
}

