/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.http.X509TrustManagerExtensions;
import android.os.Build;
import android.os.Bundle;
import android.os.PowerManager;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import com.hyphenate.EMCallBack;
import com.hyphenate.EMConnectionListener;
import com.hyphenate.EMMultiDeviceListener;
import com.hyphenate.EMValueCallBack;
import com.hyphenate.chat.EMChatManager;
import com.hyphenate.chat.EMChatRoomManager;
import com.hyphenate.chat.EMChatThreadManager;
import com.hyphenate.chat.EMCheckType;
import com.hyphenate.chat.EMContact;
import com.hyphenate.chat.EMContactManager;
import com.hyphenate.chat.EMDeviceInfo;
import com.hyphenate.chat.EMEncryptProvider;
import com.hyphenate.chat.EMGroupManager;
import com.hyphenate.chat.EMOptions;
import com.hyphenate.chat.EMPresenceManager;
import com.hyphenate.chat.EMPushManager;
import com.hyphenate.chat.EMSessionManager;
import com.hyphenate.chat.EMSmartHeartBeat;
import com.hyphenate.chat.EMTimeTag;
import com.hyphenate.chat.EMTranslationManager;
import com.hyphenate.chat.EMUserInfoManager;
import com.hyphenate.chat.adapter.EMAChatClient;
import com.hyphenate.chat.adapter.EMAConnectionListener;
import com.hyphenate.chat.adapter.EMADeviceInfo;
import com.hyphenate.chat.adapter.EMAError;
import com.hyphenate.chat.adapter.EMAMultiDeviceListener;
import com.hyphenate.chat.adapter.EMANetCallback;
import com.hyphenate.chat.core.EMAdvanceDebugManager;
import com.hyphenate.chat.core.EMChatConfigPrivate;
import com.hyphenate.chat.core.a;
import com.hyphenate.cloud.EMHttpClient;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.notification.core.b;
import com.hyphenate.push.EMPushConfig;
import com.hyphenate.push.EMPushHelper;
import com.hyphenate.push.EMPushType;
import com.hyphenate.util.DeviceUuidFactory;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.EasyUtils;
import com.hyphenate.util.NetUtils;
import com.hyphenate.util.PathUtil;
import com.hyphenate.util.Utils;
import internal.com.getkeepsafe.relinker.ReLinker;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import javax.net.ssl.X509TrustManager;
import org.json.JSONException;
import org.json.JSONObject;

public class EMClient {
    public static final String TAG = "EMClient";
    private static EMClient instance = null;
    static boolean libraryLoaded = false;
    private EMGroupManager groupManager;
    private EMChatRoomManager chatroomManager;
    private EMChatManager chatManager;
    private EMContactManager contactManager;
    private EMUserInfoManager userInfoManager;
    private EMPushManager pushManager;
    private EMTranslationManager translationManager;
    private volatile EMPresenceManager presenceManager;
    private EMChatThreadManager threadManager;
    private EMAChatClient emaObject;
    private Context mContext;
    private ExecutorService executor = null;
    private ExecutorService mainQueue = Executors.newSingleThreadExecutor();
    private ExecutorService sendQueue = Executors.newSingleThreadExecutor();
    private EMEncryptProvider encryptProvider = null;
    private boolean sdkInited = false;
    private EMChatConfigPrivate mChatConfigPrivate;
    private List<EMConnectionListener> connectionListeners = Collections.synchronizedList(new ArrayList());
    private MyConnectionListener connectionListener;
    private EMSmartHeartBeat smartHeartbeat = null;
    private List<EMMultiDeviceListener> multiDeviceListeners = Collections.synchronizedList(new ArrayList());
    private MyMultiDeviceListener multiDeviceListenerImpl;
    private PowerManager.WakeLock wakeLock;
    private ConnectivityManager connManager;
    private EMAChatClient.EMANetwork currentNetworkType = EMAChatClient.EMANetwork.NETWORK_NONE;
    private boolean mIsLoginWithAgoraToken = false;
    public static final String VERSION = "3.9.4";
    private BroadcastReceiver connectivityBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            EMAChatClient.EMANetwork eMANetwork;
            String string = intent.getAction();
            if (!string.equals("android.net.conn.CONNECTIVITY_CHANGE")) {
                EMLog.d(EMClient.TAG, "skip no connectivity action");
                return;
            }
            EMLog.d(EMClient.TAG, "connectivity receiver onReceiver");
            NetUtils.Types types = NetUtils.getNetworkTypes(EMClient.this.getContext());
            switch (types) {
                case WIFI: 
                case OTHERS: {
                    eMANetwork = EMAChatClient.EMANetwork.NETWORK_WIFI;
                    break;
                }
                case MOBILE: {
                    eMANetwork = EMAChatClient.EMANetwork.NETWORK_MOBILE;
                    break;
                }
                case ETHERNET: {
                    eMANetwork = EMAChatClient.EMANetwork.NETWORK_CABLE;
                    break;
                }
                default: {
                    eMANetwork = EMAChatClient.EMANetwork.NETWORK_NONE;
                }
            }
            boolean bl = EMClient.this.currentNetworkType != EMAChatClient.EMANetwork.NETWORK_NONE;
            boolean bl2 = eMANetwork != EMAChatClient.EMANetwork.NETWORK_NONE;
            EMClient.this.currentNetworkType = eMANetwork;
            if (bl == bl2) {
                EMClient.this.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (EMClient.this.smartHeartbeat != null) {
                            EMLog.i(EMClient.TAG, "Network availability no change, just return. " + (Object)((Object)EMClient.this.currentNetworkType) + ", but check ping");
                            EMClient.this.smartHeartbeat.sendPingCheckConnection();
                        }
                    }
                });
                return;
            }
            EMLog.i(EMClient.TAG, "Network availability changed, notify... " + (Object)((Object)EMClient.this.currentNetworkType));
            EMClient.this.execute(new Runnable(){

                @Override
                public void run() {
                    EMClient.this.emaObject.onNetworkChanged(EMClient.this.currentNetworkType);
                }
            });
        }
    };
    private AppStateListener appStateListener;
    private List<Activity> resumeActivityList = new ArrayList<Activity>();
    private boolean duringChecking = false;

    private EMClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EMClient getInstance() {
        if (instance != null) return instance;
        Class<EMClient> clazz = EMClient.class;
        synchronized (EMClient.class) {
            if (instance != null) return instance;
            instance = new EMClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void init(Context context, EMOptions eMOptions) {
        Object object;
        if (this.sdkInited) {
            return;
        }
        EMTimeTag eMTimeTag = new EMTimeTag();
        eMTimeTag.start();
        this.mContext = context.getApplicationContext();
        this.connManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.registerActivityLifecycleCallbacks();
        this.loadLibrary();
        this.mChatConfigPrivate = new EMChatConfigPrivate();
        this.mChatConfigPrivate.a(context, eMOptions);
        eMOptions.setConfig(this.mChatConfigPrivate);
        DeviceUuidFactory deviceUuidFactory = new DeviceUuidFactory(context);
        this.getChatConfigPrivate().f(deviceUuidFactory.getDeviceUuid().toString());
        this.getChatConfigPrivate().i(Build.MANUFACTURER + Build.MODEL);
        this.getChatConfigPrivate().g(this.getDidInfo());
        this.getChatConfigPrivate().h(UUID.randomUUID().toString());
        EMPushConfig eMPushConfig = eMOptions.getPushConfig();
        if (eMPushConfig == null) {
            eMPushConfig = new EMPushConfig.Builder(this.mContext).build();
        }
        EMPushConfig.Builder builder = new EMPushConfig.Builder(this.mContext, eMPushConfig);
        if (TextUtils.isEmpty((CharSequence)eMPushConfig.getFcmSenderId())) {
            builder.enableFCM(eMOptions.getFCMNumber());
        }
        if ((TextUtils.isEmpty((CharSequence)eMPushConfig.getMiAppId()) || TextUtils.isEmpty((CharSequence)eMPushConfig.getMiAppKey())) && (object = eMOptions.getMipushConfig()) != null) {
            builder.enableMiPush(((EMChatConfigPrivate.a)object).a, ((EMChatConfigPrivate.a)object).b);
        }
        EMPushHelper.getInstance().init(context, builder.build());
        this.emaObject = EMAChatClient.create(this.mChatConfigPrivate.a);
        this.connectionListener = new MyConnectionListener();
        this.emaObject.addConnectionListener(this.connectionListener);
        this.multiDeviceListenerImpl = new MyMultiDeviceListener();
        this.emaObject.addMultiDeviceListener(this.multiDeviceListenerImpl);
        this.executor = Executors.newCachedThreadPool();
        this.initManagers();
        this.mIsLoginWithAgoraToken = EMSessionManager.getInstance().getIsLoginWithAgoraToken();
        object = EMSessionManager.getInstance().getLastLoginUser();
        EMLog.e(TAG, "is autoLogin : " + eMOptions.getAutoLogin());
        EMLog.e(TAG, "lastLoginUser : " + (String)object);
        EMLog.e(TAG, "hyphenate SDK is initialized with version : " + this.getChatConfigPrivate().e());
        PowerManager powerManager = (PowerManager)this.mContext.getSystemService("power");
        this.wakeLock = powerManager.newWakeLock(1, "emclient");
        b.a().a(context);
        this.sdkInited = true;
        this.mContext.registerReceiver(this.connectivityBroadcastReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        this.onNetworkChanged();
        if (eMOptions.getAutoLogin() && this.isLoggedInBefore()) {
            String string = EMSessionManager.getInstance().getLastLoginToken();
            String string2 = EMSessionManager.getInstance().getLastLoginPwd();
            EMSessionManager.getInstance().currentUser = new EMContact((String)object);
            EMCallBack eMCallBack = new EMCallBack((String)object, eMTimeTag){
                final /* synthetic */ String val$lastLoginUser;
                final /* synthetic */ EMTimeTag val$tag;
                {
                    this.val$lastLoginUser = string;
                    this.val$tag = eMTimeTag;
                }

                @Override
                public void onSuccess() {
                    EMSessionManager.getInstance().currentUser = new EMContact(this.val$lastLoginUser);
                    Log.d((String)EMClient.TAG, (String)"hyphenate login onSuccess");
                    this.val$tag.stop();
                    EMLog.d(EMClient.TAG, "[Collector][sdk init]init time is : " + this.val$tag.timeStr());
                }

                @Override
                public void onError(int n, String string) {
                    Log.d((String)EMClient.TAG, (String)"hyphenate login onError");
                    this.val$tag.stop();
                    EMLog.d(EMClient.TAG, "[Collector][sdk init]init time is : " + this.val$tag.timeStr());
                }

                @Override
                public void onProgress(int n, String string) {
                }
            };
            this.execute(new Runnable((String)object, string, string2, eMCallBack){
                final /* synthetic */ String val$lastLoginUser;
                final /* synthetic */ String val$lastLoginToken;
                final /* synthetic */ String val$lastLoginPwd;
                final /* synthetic */ EMCallBack val$callback;
                {
                    this.val$lastLoginUser = string;
                    this.val$lastLoginToken = string2;
                    this.val$lastLoginPwd = string3;
                    this.val$callback = eMCallBack;
                }

                @Override
                public void run() {
                    EMClient.this.getChatConfigPrivate().b(this.val$lastLoginUser);
                    EMClient.this.groupManager().loadAllGroups();
                    EMClient.this.chatManager().loadAllConversationsFromDB();
                    EMClient.this._login(this.val$lastLoginUser, EMSessionManager.getInstance().isLastLoginWithToken() ? this.val$lastLoginToken : this.val$lastLoginPwd, this.val$callback, true, EMSessionManager.getInstance().isLastLoginWithToken());
                }
            });
        } else {
            eMTimeTag.stop();
            EMLog.d(TAG, "[Collector][sdk init]init time is : " + eMTimeTag.timeStr());
        }
    }

    private String getDidInfo() {
        String string = Build.MANUFACTURER;
        String string2 = Build.MODEL;
        String string3 = Build.HARDWARE;
        int n = Build.VERSION.SDK_INT;
        String string4 = Build.VERSION.RELEASE;
        String string5 = string + "/" + string2 + "/" + string3 + "/" + n + "/" + string4;
        return string5;
    }

    public void createAccount(String string, String string2) throws HyphenateException {
        string = string.toLowerCase();
        Pattern pattern = Pattern.compile("^[a-zA-Z0-9_.-]+$");
        boolean bl = pattern.matcher(string).find();
        if (!bl) {
            throw new HyphenateException(205, "illegal user name");
        }
        EMAError eMAError = this.emaObject.createAccount(string, string2);
        this.handleError(eMAError);
    }

    public void login(String string, String string2, EMCallBack eMCallBack) throws IllegalArgumentException {
        if (eMCallBack == null) {
            throw new IllegalArgumentException("callback is null!");
        }
        if (string == null || string2 == null || string.equals("") || string2.equals("")) {
            throw new IllegalArgumentException("username or password is null or empty!");
        }
        if (TextUtils.isEmpty((CharSequence)this.getChatConfigPrivate().k())) {
            throw new IllegalArgumentException("please setup your App Key  either in AndroidManifest.xml or through the EMOptions");
        }
        if (!this.sdkInited) {
            eMCallBack.onError(1, "sdk not initialized");
            return;
        }
        string = string.toLowerCase();
        this.initLoginWithAgoraData(false, "", 0L);
        this._login(string, string2, eMCallBack, false, false);
    }

    public void loginWithToken(String string, String string2, EMCallBack eMCallBack) {
        if (TextUtils.isEmpty((CharSequence)this.getChatConfigPrivate().k())) {
            throw new RuntimeException("please setup your App Ke y either in AndroidManifest.xml or through the EMOptions");
        }
        if (eMCallBack == null) {
            throw new IllegalArgumentException("callback is null!");
        }
        if (string == null || string2 == null || string.equals("") || string2.equals("")) {
            throw new IllegalArgumentException("username or password is null or empty!");
        }
        if (!this.sdkInited) {
            eMCallBack.onError(1, "sdk not initialized");
            return;
        }
        string = string.toLowerCase();
        this.initLoginWithAgoraData(false, "", 0L);
        this._login(string, string2, eMCallBack, false, true);
    }

    public void loginWithAgoraToken(final String string, final String string2, final EMCallBack eMCallBack) {
        if (TextUtils.isEmpty((CharSequence)this.getChatConfigPrivate().k())) {
            throw new RuntimeException("please setup your App Key  either in AndroidManifest.xml or through the EMOptions");
        }
        if (eMCallBack == null) {
            throw new IllegalArgumentException("callback is null!");
        }
        if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("username or agoraToken is null or empty!");
        }
        if (!this.sdkInited) {
            eMCallBack.onError(1, "sdk not initialized");
            return;
        }
        this.execute(new Runnable(){

            @Override
            public void run() {
                EMClient.this.getChatToken(string.toLowerCase(), string2, eMCallBack);
            }
        });
    }

    private synchronized void getChatToken(String string, String string2, EMCallBack eMCallBack) {
        EMAError eMAError = new EMAError();
        String string3 = this.emaObject.getChatTokenbyAgoraToken(string2, eMAError);
        if (eMAError.errCode() == 0) {
            EMLog.d(TAG, "getChatTokenbyAgoraToken success");
            if (string3 != null && string3.length() > 0) {
                try {
                    JSONObject jSONObject = new JSONObject(string3);
                    if (jSONObject != null) {
                        String string4 = jSONObject.optString("access_token");
                        String string5 = jSONObject.optString("expire_timestamp");
                        long l = Long.valueOf(string5) - System.currentTimeMillis();
                        if (TextUtils.isEmpty((CharSequence)string4)) {
                            throw new Exception("chatToken  is null or empty!");
                        }
                        this.initLoginWithAgoraData(true, string5, l);
                        this._login(string.toLowerCase(), string4, eMCallBack, false, true);
                    }
                }
                catch (Exception exception) {
                    EMLog.e(TAG, "getChatTokenbyAgoraToken Exception:" + exception.getMessage());
                    eMCallBack.onError(1, "getChatTokenbyAgoraToken Exception:" + exception.getMessage());
                }
            } else {
                EMLog.e(TAG, "getChatTokenbyAgoraToken response is null");
                eMCallBack.onError(1, "getChatTokenbyAgoraToken response is null or empty!");
            }
        } else {
            eMCallBack.onError(eMAError.errCode(), eMAError.errMsg());
            EMLog.e(TAG, "getChatTokenbyAgoraToken failed error:" + eMAError.errCode() + "  errorMessage:" + eMAError.errMsg());
        }
    }

    private void initLoginWithAgoraData(boolean bl, String string, long l) {
        this.mIsLoginWithAgoraToken = bl;
        if (bl) {
            EMSessionManager.getInstance().setLoginWithAgoraData(bl, string, l);
        } else {
            EMSessionManager.getInstance().clearLoginWithAgoraTokenData();
        }
    }

    public void notifyTokenExpired(String string) {
        if (this.connectionListener != null && this.mIsLoginWithAgoraToken) {
            try {
                JSONObject jSONObject = new JSONObject(string);
                if (jSONObject != null) {
                    String string2 = jSONObject.optString("error_description");
                    EMLog.e(TAG, "notifyTokenExpired--errorDescription:" + string2);
                    if (string2.contains("milliseconds ago") || string2.contains("has expired") || string2.contains("Unable to authenticate due to expired access Token")) {
                        this.connectionListener.onTokenNotification(401);
                        EMLog.e(TAG, "notifyTokenExpired--onTokenNotification(401) ");
                    }
                }
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
    }

    public void renewToken(final String string) {
        if (this.mIsLoginWithAgoraToken && this.emaObject.isLoggedIn()) {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    EMClient.this.getChatToken(EMClient.this.getCurrentUser(), string, new EMCallBack(){

                        @Override
                        public void onSuccess() {
                        }

                        @Override
                        public void onError(int n, String string) {
                        }

                        @Override
                        public void onProgress(int n, String string) {
                        }
                    });
                }
            });
        } else {
            EMLog.e(TAG, "the method  excepted to be called when login by agoraToken and login state is loggeIn");
        }
    }

    public int logout(boolean bl) {
        if (!this.emaObject.isLogout()) {
            String string = a.a().q();
            String string2 = a.a().r();
            if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2)) {
                try {
                    this.pushManager.unBindDeviceToken();
                }
                catch (HyphenateException hyphenateException) {
                    return 212;
                }
            } else {
                boolean bl2 = EMPushHelper.getInstance().unregister(bl);
                if (!bl2) {
                    return 212;
                }
            }
        } else {
            EMPushHelper.getInstance().unregister(false);
            EMLog.e(TAG, "already logout, skip unbind token");
        }
        this.logout();
        return 0;
    }

    void logout() {
        EMLog.d(TAG, " SDK Logout");
        try {
            if (this.connectivityBroadcastReceiver != null) {
                this.mContext.unregisterReceiver(this.connectivityBroadcastReceiver);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        EMSessionManager.getInstance().clearLastLoginUser();
        EMSessionManager.getInstance().clearLastLoginToken();
        EMSessionManager.getInstance().clearLoginWithAgoraTokenData();
        if (this.smartHeartbeat != null) {
            this.smartHeartbeat.stop();
        }
        if (this.wakeLock.isHeld()) {
            this.wakeLock.release();
        }
        if (this.emaObject != null) {
            this.emaObject.logout();
        }
        if (this.chatManager != null) {
            this.chatManager.onLogout();
        }
        if (this.groupManager != null) {
            this.groupManager.onLogout();
        }
        if (this.contactManager != null) {
            this.contactManager.onLogout();
        }
        if (this.chatroomManager != null) {
            this.chatroomManager.onLogout();
        }
        try {
            EMAdvanceDebugManager.a().f();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (EMChatConfigPrivate.a()) {
            com.hyphenate.a.a.c();
        }
    }

    public void logout(final boolean bl, final EMCallBack eMCallBack) {
        new Thread(){

            @Override
            public void run() {
                int n = EMClient.this.logout(bl);
                if (n != 0) {
                    if (eMCallBack != null) {
                        eMCallBack.onError(n, "faild to unbind device token");
                    }
                } else if (eMCallBack != null) {
                    eMCallBack.onSuccess();
                }
            }
        }.start();
    }

    void logout(final EMCallBack eMCallBack) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                if (eMCallBack != null) {
                    eMCallBack.onProgress(0, null);
                }
                EMClient.this.logout();
                if (eMCallBack != null) {
                    eMCallBack.onSuccess();
                }
            }
        };
        thread.setPriority(9);
        thread.start();
    }

    public void changeAppkey(String string) throws HyphenateException {
        EMAError eMAError = this.emaObject.changeAppkey(string);
        if (eMAError.errCode() == 0) {
            this.getOptions().updatePath(string);
        }
        this.handleError(eMAError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(final EMConnectionListener eMConnectionListener) {
        if (eMConnectionListener == null) {
            return;
        }
        List<EMConnectionListener> list = this.connectionListeners;
        synchronized (list) {
            if (!this.connectionListeners.contains(eMConnectionListener)) {
                this.connectionListeners.add(eMConnectionListener);
            }
        }
        this.execute(new Runnable(){

            @Override
            public void run() {
                if (EMClient.this.isConnected()) {
                    eMConnectionListener.onConnected();
                } else {
                    eMConnectionListener.onDisconnected(2);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(EMConnectionListener eMConnectionListener) {
        if (eMConnectionListener == null) {
            return;
        }
        List<EMConnectionListener> list = this.connectionListeners;
        synchronized (list) {
            this.connectionListeners.remove(eMConnectionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EMGroupManager groupManager() {
        if (this.groupManager != null) return this.groupManager;
        Class<EMClient> clazz = EMClient.class;
        synchronized (EMClient.class) {
            if (this.groupManager != null) return this.groupManager;
            this.groupManager = new EMGroupManager(this, this.emaObject.getGroupManager());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.groupManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EMPushManager pushManager() {
        if (this.pushManager != null) return this.pushManager;
        Class<EMClient> clazz = EMClient.class;
        synchronized (EMClient.class) {
            if (this.pushManager != null) return this.pushManager;
            this.pushManager = new EMPushManager(this, this.emaObject.getPushMnager());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.pushManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EMChatRoomManager chatroomManager() {
        if (this.chatroomManager != null) return this.chatroomManager;
        Class<EMClient> clazz = EMClient.class;
        synchronized (EMClient.class) {
            if (this.chatroomManager != null) return this.chatroomManager;
            this.chatroomManager = new EMChatRoomManager(this, this.emaObject.getChatRoomManager());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.chatroomManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EMChatManager chatManager() {
        if (this.chatManager != null) return this.chatManager;
        Class<EMClient> clazz = EMClient.class;
        synchronized (EMClient.class) {
            if (this.chatManager != null) return this.chatManager;
            this.chatManager = new EMChatManager(this, this.emaObject.getChatManager(), this.emaObject.getReactionManager());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.chatManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EMUserInfoManager userInfoManager() {
        if (this.userInfoManager != null) return this.userInfoManager;
        Class<EMClient> clazz = EMClient.class;
        synchronized (EMClient.class) {
            if (this.userInfoManager != null) return this.userInfoManager;
            this.userInfoManager = new EMUserInfoManager(this.emaObject.getUserInfoManager());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.userInfoManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EMContactManager contactManager() {
        if (this.contactManager != null) return this.contactManager;
        Class<EMClient> clazz = EMClient.class;
        synchronized (EMClient.class) {
            if (this.contactManager != null) return this.contactManager;
            this.contactManager = new EMContactManager(this, this.emaObject.getContactManager());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.contactManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EMTranslationManager translationManager() {
        if (this.translationManager != null) return this.translationManager;
        Class<EMClient> clazz = EMClient.class;
        synchronized (EMClient.class) {
            if (this.translationManager != null) return this.translationManager;
            this.translationManager = new EMTranslationManager(this.emaObject.getTranslateManager());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.translationManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EMPresenceManager presenceManager() {
        if (this.presenceManager != null) return this.presenceManager;
        Class<EMClient> clazz = EMClient.class;
        synchronized (EMClient.class) {
            if (this.presenceManager != null) return this.presenceManager;
            this.presenceManager = new EMPresenceManager(this.emaObject.getPresenceManager());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.presenceManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EMChatThreadManager chatThreadManager() {
        if (this.threadManager != null) return this.threadManager;
        Class<EMClient> clazz = EMClient.class;
        synchronized (EMClient.class) {
            if (this.threadManager != null) return this.threadManager;
            this.threadManager = new EMChatThreadManager(this, this.emaObject.getThreadManager());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.threadManager;
        }
    }

    public Context getContext() {
        return this.mContext;
    }

    public synchronized String getCurrentUser() {
        if (EMSessionManager.getInstance().currentUser == null || EMSessionManager.getInstance().currentUser.username == null || EMSessionManager.getInstance().currentUser.username.equals("")) {
            return EMSessionManager.getInstance().getLastLoginUser();
        }
        return EMSessionManager.getInstance().currentUser.username;
    }

    public void getUserTokenFromServer(final String string, final String string2, final EMValueCallBack<String> eMValueCallBack) {
        this.execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                String string3 = EMClient.this.emaObject.getUserTokenFromServer(string, string2, eMAError);
                if (eMValueCallBack == null) {
                    return;
                }
                if (eMAError.errCode() == 0) {
                    eMValueCallBack.onSuccess(string3);
                } else {
                    eMValueCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                }
            }
        });
    }

    public boolean isLoggedInBefore() {
        EMSessionManager eMSessionManager = EMSessionManager.getInstance();
        String string = eMSessionManager.getLastLoginUser();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        String string2 = eMSessionManager.getLastLoginPwd();
        String string3 = eMSessionManager.getLastLoginToken();
        return string != null && !string.isEmpty() && (string2 != null && !string2.isEmpty() || string3 != null && !string3.isEmpty());
    }

    public boolean isConnected() {
        return this.emaObject.isConnected();
    }

    public boolean isLoggedIn() {
        return this.emaObject.isLoggedIn();
    }

    public void setDebugMode(boolean bl) {
        String string;
        if (this.sdkInited && (string = EMAdvanceDebugManager.a().e()) != null) {
            bl = Boolean.parseBoolean(string);
        }
        EMLog.debugMode = bl;
        this.getChatConfigPrivate().c(bl);
    }

    @Deprecated
    public boolean updateCurrentUserNick(String string) throws IllegalArgumentException, HyphenateException {
        return this.pushManager().updatePushNickname(string);
    }

    public void uploadLog(EMCallBack eMCallBack) {
        this.chatManager().emaObject.uploadLog();
    }

    public EMOptions getOptions() {
        return this.mChatConfigPrivate.b();
    }

    public String compressLogs() throws HyphenateException {
        EMAError eMAError = new EMAError();
        String string = this.emaObject.compressLogs(eMAError);
        this.handleError(eMAError);
        return string;
    }

    public void addMultiDeviceListener(EMMultiDeviceListener eMMultiDeviceListener) {
        this.multiDeviceListeners.add(eMMultiDeviceListener);
    }

    public void removeMultiDeviceListener(EMMultiDeviceListener eMMultiDeviceListener) {
        this.multiDeviceListeners.remove(eMMultiDeviceListener);
    }

    public List<EMDeviceInfo> getLoggedInDevicesFromServer(String string, String string2) throws HyphenateException {
        EMAError eMAError = new EMAError();
        List<EMADeviceInfo> list = this.emaObject.getLoggedInDevicesFromServer(string, string2, eMAError);
        this.handleError(eMAError);
        ArrayList<EMDeviceInfo> arrayList = new ArrayList<EMDeviceInfo>();
        for (EMADeviceInfo eMADeviceInfo : list) {
            arrayList.add(new EMDeviceInfo(eMADeviceInfo));
        }
        return arrayList;
    }

    public void kickDevice(String string, String string2, String string3) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.kickDevice(string, string2, string3, eMAError);
        this.handleError(eMAError);
    }

    public void kickAllDevices(String string, String string2) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.kickAllDevices(string, string2, eMAError);
        this.handleError(eMAError);
    }

    public void sendFCMTokenToServer(String string) {
        EMLog.d(TAG, "sendFCMTokenToServer: " + string);
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        String string2 = this.getCurrentUser();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            EMLog.i(TAG, "No user login currently, stop upload the token.");
            return;
        }
        EMPushType eMPushType = EMPushHelper.getInstance().getPushType();
        EMLog.i(TAG, "pushType: " + (Object)((Object)eMPushType));
        if (eMPushType == EMPushType.FCM) {
            EMPushHelper.getInstance().onReceiveToken(eMPushType, string);
        }
    }

    @Deprecated
    public void sendHMSPushTokenToServer(String string, String string2) {
        this.sendHMSPushTokenToServer(string2);
    }

    public void sendHMSPushTokenToServer(String string) {
        if (EMPushHelper.getInstance().getPushType() == EMPushType.HMSPUSH) {
            EMPushHelper.getInstance().onReceiveToken(EMPushType.HMSPUSH, string);
        }
    }

    private void initManagers() {
        EMHttpClient.getInstance().onInit(this.mChatConfigPrivate);
        this.chatManager();
        this.contactManager();
        this.groupManager();
        this.chatroomManager();
        this.presenceManager();
        this.chatThreadManager();
        this.setNatvieNetworkCallback();
        EMSessionManager.getInstance().init(this, this.emaObject.getSessionManager());
    }

    void _login(final String string, final String string2, final EMCallBack eMCallBack, final boolean bl, final boolean bl2) {
        if (this.getChatConfigPrivate() == null || !this.sdkInited) {
            eMCallBack.onError(1, "");
            return;
        }
        EMLog.e(TAG, "emchat manager login in process:" + Process.myPid());
        this.execute(new Runnable(){

            @Override
            public void run() {
                EMLog.e(EMClient.TAG, "emchat manager login in process:" + Process.myPid() + " threadName:" + Thread.currentThread().getName() + " ID:" + Thread.currentThread().getId());
                if (string == null) {
                    eMCallBack.onError(101, "Invalid user name");
                    return;
                }
                EMAError eMAError = new EMAError();
                EMClient.this.emaObject.login(string, string2, bl, bl2, eMAError);
                if (eMAError.errCode() == 0) {
                    EMSessionManager.getInstance().setLastLoginUser(string);
                    EMAError eMAError2 = new EMAError();
                    if (eMAError2.errCode() == 0) {
                        if (bl2) {
                            String string3 = EMClient.this.emaObject.getUserToken(false, eMAError2);
                            EMSessionManager.getInstance().setLastLoginToken(string3);
                            EMSessionManager.getInstance().setLastLoginWithToken(true);
                            EMSessionManager.getInstance().clearLastLoginPwd();
                            if (EMClient.this.mIsLoginWithAgoraToken) {
                                EMSessionManager.getInstance().startCountDownTokenAvailableTime(EMClient.this.connectionListener);
                            }
                        } else {
                            EMSessionManager.getInstance().setLastLoginPwd(string2);
                            EMSessionManager.getInstance().setLastLoginWithToken(false);
                            EMSessionManager.getInstance().clearLastLoginToken();
                        }
                    }
                    EMClient.this.onNewLogin();
                    EMPushHelper.getInstance().register();
                    eMCallBack.onSuccess();
                } else {
                    eMCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                    if (eMAError.errCode() == 200 && EMClient.this.mIsLoginWithAgoraToken) {
                        EMClient.this.emaObject.renewToken(string2);
                        EMSessionManager.getInstance().setLastLoginToken(string2);
                        EMSessionManager.getInstance().startCountDownTokenAvailableTime(EMClient.this.connectionListener);
                    }
                }
                if (eMAError.errCode() == 0) {
                    if (EMClient.this.getOptions().isEnableStatistics()) {
                        EMClient.this.setPresence(EMClient.this.getLocationString(bl));
                    } else {
                        EMLog.d(EMClient.TAG, "statistics is not enabled");
                    }
                }
                if (eMAError.errCode() == 202) {
                    EMSessionManager.getInstance().clearLastLoginPwd();
                    EMSessionManager.getInstance().clearLastLoginToken();
                }
            }
        });
    }

    public boolean isFCMAvailable() {
        return EMPushHelper.getInstance().getPushType() == EMPushType.FCM;
    }

    void onNewLogin() {
        EMLog.d(TAG, "on new login created");
        String string = EMSessionManager.getInstance().getLastLoginUser();
        PathUtil.getInstance().initDirs(this.getChatConfigPrivate().k(), string, this.mContext);
        EMAdvanceDebugManager.a().a(this.mChatConfigPrivate);
        if (this.smartHeartbeat == null) {
            this.smartHeartbeat = EMSmartHeartBeat.create(this.mContext);
        }
        if (this.getChatConfigPrivate().a.hasHeartBeatCustomizedParams()) {
            this.smartHeartbeat.setCustomizedParams(this.getChatConfigPrivate().a.getWifiHeartBeatCustomizedParams(), this.getChatConfigPrivate().a.getMobileHeartBeatCustomizedParams());
        }
        this.smartHeartbeat.onInit();
        if (this.getOptions().getFixedInterval() != -1) {
            this.smartHeartbeat.setFixedInterval(this.getOptions().getFixedInterval());
        }
    }

    public String getAccessToken() {
        return this.getChatConfigPrivate().m();
    }

    public boolean isSdkInited() {
        return this.sdkInited;
    }

    private boolean _loadLibrary(String string, boolean bl) {
        try {
            ReLinker.loadLibrary(this.mContext, string);
            return true;
        }
        catch (Throwable throwable) {
            if (bl) {
                throwable.printStackTrace();
            }
            return false;
        }
    }

    private boolean _loadLibrary(String string) {
        return this._loadLibrary(string, true);
    }

    private void loadLibrary() {
        if (!libraryLoaded) {
            this._loadLibrary("cipherdb", false);
            ReLinker.loadLibrary(this.mContext, "hyphenate");
            libraryLoaded = true;
        }
    }

    void execute(Runnable runnable) {
        this.executor.execute(runnable);
    }

    void executeOnMainQueue(Runnable runnable) {
        this.mainQueue.submit(runnable);
    }

    void executeOnSendQueue(Runnable runnable) {
        this.sendQueue.submit(runnable);
    }

    public EMChatConfigPrivate getChatConfigPrivate() {
        return this.mChatConfigPrivate;
    }

    void setNatvieNetworkCallback() {
        EMANetCallback eMANetCallback = new EMANetCallback(){

            @Override
            public int getNetState() {
                if (!NetUtils.hasDataConnection(EMClient.this.mContext)) {
                    return EMAChatClient.EMANetwork.NETWORK_NONE.ordinal();
                }
                if (NetUtils.isWifiConnected(EMClient.this.mContext) || NetUtils.isOthersConnected(EMClient.this.mContext)) {
                    return EMAChatClient.EMANetwork.NETWORK_WIFI.ordinal();
                }
                if (NetUtils.isMobileConnected(EMClient.this.mContext)) {
                    return EMAChatClient.EMANetwork.NETWORK_MOBILE.ordinal();
                }
                if (NetUtils.isEthernetConnected(EMClient.this.mContext)) {
                    return EMAChatClient.EMANetwork.NETWORK_CABLE.ordinal();
                }
                return EMAChatClient.EMANetwork.NETWORK_NONE.ordinal();
            }
        };
        this.mChatConfigPrivate.a.setNetCallback(eMANetCallback);
    }

    void setEncryptProvider(EMEncryptProvider eMEncryptProvider) {
        this.encryptProvider = eMEncryptProvider;
    }

    EMEncryptProvider getEncryptProvider() {
        if (this.encryptProvider == null) {
            EMLog.d(TAG, "encrypt provider is not set, create default");
            this.encryptProvider = new EMEncryptProvider(){

                @Override
                public byte[] encrypt(byte[] byArray, String string) {
                    try {
                        String string2 = new String(byArray);
                        return EMClient.this.emaObject.getSessionManager().encrypt(string2).getBytes();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return byArray;
                    }
                }

                @Override
                public byte[] decrypt(byte[] byArray, String string) {
                    try {
                        String string2 = new String(byArray);
                        return EMClient.this.emaObject.getSessionManager().decrypt(string2).getBytes();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return byArray;
                    }
                }
            };
        }
        return this.encryptProvider;
    }

    boolean sendPing(boolean bl, long l) {
        return this.emaObject.sendPing(bl, l);
    }

    void checkTokenAvailability() {
        if (this.mIsLoginWithAgoraToken) {
            EMSessionManager.getInstance().checkTokenAvailability(this.connectionListener);
        }
    }

    void forceReconnect() {
        EMLog.d(TAG, "forceReconnect");
        this.disconnect();
        this.reconnect();
    }

    void reconnect() {
        EMLog.d(TAG, "reconnect");
        this.wakeLock.acquire();
        this.emaObject.reconnect();
        if (this.wakeLock.isHeld()) {
            this.wakeLock.release();
        }
    }

    void disconnect() {
        EMLog.d(TAG, "disconnect");
        this.emaObject.disconnect();
    }

    private void handleError(EMAError eMAError) throws HyphenateException {
        if (eMAError.errCode() != 0) {
            throw new HyphenateException(eMAError);
        }
    }

    void onNetworkChanged() {
        try {
            if (NetUtils.isWifiConnected(this.mContext) || NetUtils.isOthersConnected(this.mContext)) {
                EMLog.d(TAG, "has wifi connection");
                this.currentNetworkType = EMAChatClient.EMANetwork.NETWORK_WIFI;
                this.emaObject.onNetworkChanged(EMAChatClient.EMANetwork.NETWORK_WIFI);
                return;
            }
            if (NetUtils.isMobileConnected(this.mContext)) {
                EMLog.d(TAG, "has mobile connection");
                this.currentNetworkType = EMAChatClient.EMANetwork.NETWORK_MOBILE;
                this.emaObject.onNetworkChanged(EMAChatClient.EMANetwork.NETWORK_MOBILE);
                return;
            }
            if (NetUtils.isEthernetConnected(this.mContext)) {
                EMLog.d(TAG, "has ethernet connection");
                this.currentNetworkType = EMAChatClient.EMANetwork.NETWORK_CABLE;
                this.emaObject.onNetworkChanged(EMAChatClient.EMANetwork.NETWORK_CABLE);
                return;
            }
            this.currentNetworkType = EMAChatClient.EMANetwork.NETWORK_NONE;
            EMLog.d(TAG, "no data connection");
            this.emaObject.onNetworkChanged(EMAChatClient.EMANetwork.NETWORK_NONE);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    void onNetworkChanged(EMAChatClient.EMANetwork eMANetwork) {
        this.emaObject.onNetworkChanged(eMANetwork);
    }

    void setAppStateListener(AppStateListener appStateListener) {
        this.appStateListener = appStateListener;
    }

    @TargetApi(value=14)
    private void registerActivityLifecycleCallbacks() {
        if (Utils.isSdk14()) {
            Application.ActivityLifecycleCallbacks activityLifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){

                public void onActivityStopped(Activity activity) {
                    EMClient.this.resumeActivityList.remove(activity);
                    if (EMClient.this.resumeActivityList.isEmpty() && EMClient.this.appStateListener != null) {
                        EMClient.this.appStateListener.onBackground();
                    }
                }

                public void onActivityResumed(Activity activity) {
                }

                public void onActivityCreated(Activity activity, Bundle bundle) {
                }

                public void onActivityStarted(Activity activity) {
                    if (!EMClient.this.resumeActivityList.contains(activity)) {
                        EMClient.this.resumeActivityList.add(activity);
                        if (EMClient.this.resumeActivityList.size() == 1 && EMClient.this.appStateListener != null) {
                            EMClient.this.appStateListener.onForeground();
                        }
                    }
                }

                public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
                }

                public void onActivityPaused(Activity activity) {
                }

                public void onActivityDestroyed(Activity activity) {
                }
            };
            ((Application)this.mContext).registerActivityLifecycleCallbacks(activityLifecycleCallbacks);
        }
    }

    void setPresence(final String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        this.execute(new Runnable(){

            @Override
            public void run() {
                EMClient.this.emaObject.setPresence(string);
            }
        });
    }

    private String getLocationString(boolean bl) {
        JSONObject jSONObject = null;
        if (!bl) {
            jSONObject = this.getDeviceInfo();
        }
        return jSONObject == null ? "" : jSONObject.toString();
    }

    public JSONObject getDeviceInfo() {
        JSONObject jSONObject = new JSONObject();
        DeviceUuidFactory deviceUuidFactory = new DeviceUuidFactory(this.mContext);
        String string = deviceUuidFactory.getDeviceUuid().toString();
        try {
            jSONObject.put("deviceid", (Object)string);
            jSONObject.put("app-id", (Object)this.mContext.getPackageName());
            jSONObject.put("hid", (Object)EMClient.getInstance().getCurrentUser());
            jSONObject.put("os", (Object)"android");
            jSONObject.put("os-version", (Object)Build.VERSION.RELEASE);
            jSONObject.put("manufacturer", (Object)Build.MANUFACTURER);
            jSONObject.put("model", (Object)Build.MODEL);
        }
        catch (JSONException jSONException) {
            EMLog.d(TAG, jSONException.getMessage());
        }
        return jSONObject;
    }

    public void check(String string, String string2, CheckResultListener checkResultListener) {
        Object object;
        if (this.duringChecking) {
            EMLog.i("EMServiceChecker", "During service checking, please hold on...");
            return;
        }
        this.duringChecking = true;
        if (this.isLoggedInBefore()) {
            string = this.getCurrentUser();
            object = EMSessionManager.getInstance();
            string2 = ((EMSessionManager)object).getLastLoginPwd();
        }
        object = string;
        String string3 = string2;
        new Thread(new Runnable((String)object, string3, checkResultListener){
            final /* synthetic */ String val$finalUser;
            final /* synthetic */ String val$finalPwd;
            final /* synthetic */ CheckResultListener val$listener;
            {
                this.val$finalUser = string;
                this.val$finalPwd = string2;
                this.val$listener = checkResultListener;
            }

            @Override
            public void run() {
                EMClient.this.emaObject.check(this.val$finalUser, this.val$finalPwd, new EMAChatClient.CheckResultListener(){

                    @Override
                    public void onResult(int n, int n2, String string) {
                        EMLog.i("EMServiceChecker", "type: " + n + ", result: " + n2 + ", desc: " + string);
                        EMClient.this.notifyCheckResult(val$listener, n, n2, string);
                        if (n2 != 0) {
                            EMClient.this.duringChecking = false;
                            return;
                        }
                        if (n == 3) {
                            EMClient.this.checkLogout(val$listener);
                        }
                    }
                });
            }
        }).start();
    }

    private void checkLogout(CheckResultListener checkResultListener) {
        if (!this.isLoggedInBefore()) {
            this.logout();
            this.notifyCheckResult(checkResultListener, 5, 0, "");
        }
        this.duringChecking = false;
    }

    private void notifyCheckResult(CheckResultListener checkResultListener, @EMCheckType.CheckType int n, int n2, String string) {
        if (checkResultListener == null) {
            return;
        }
        checkResultListener.onResult(n, n2, string);
    }

    public static interface CheckResultListener {
        public void onResult(@EMCheckType.CheckType int var1, int var2, String var3);
    }

    static interface AppStateListener {
        public void onForeground();

        public void onBackground();
    }

    class MyMultiDeviceListener
    extends EMAMultiDeviceListener {
        MyMultiDeviceListener() {
        }

        @Override
        public void onContactEvent(final int n, final String string, final String string2) {
            EMLog.d(EMClient.TAG, "onContactEvent:" + n + " target:" + string + " ext:" + string2);
            EMClient.this.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List list = EMClient.this.multiDeviceListeners;
                    synchronized (list) {
                        try {
                            for (EMMultiDeviceListener eMMultiDeviceListener : EMClient.this.multiDeviceListeners) {
                                eMMultiDeviceListener.onContactEvent(n, string, string2);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }

        @Override
        public void onGroupEvent(final int n, final String string, final List<String> list) {
            EMLog.d(EMClient.TAG, "onGroupEvent:" + n + " target:" + string + " usernames:" + list);
            EMClient.this.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List list2 = EMClient.this.multiDeviceListeners;
                    synchronized (list2) {
                        try {
                            for (EMMultiDeviceListener eMMultiDeviceListener : EMClient.this.multiDeviceListeners) {
                                eMMultiDeviceListener.onGroupEvent(n, string, list);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }
    }

    class MyConnectionListener
    extends EMAConnectionListener {
        MyConnectionListener() {
        }

        @Override
        public void onConnected() {
            EMClient.this.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List list = EMClient.this.connectionListeners;
                    synchronized (list) {
                        try {
                            for (EMConnectionListener eMConnectionListener : EMClient.this.connectionListeners) {
                                eMConnectionListener.onConnected();
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }

        @Override
        public void onDisconnected(final int n) {
            EMClient.this.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List list = EMClient.this.connectionListeners;
                    synchronized (list) {
                        switch (n) {
                            case 207: {
                                EMSessionManager.getInstance().clearLastLoginUser();
                                EMSessionManager.getInstance().clearLastLoginToken();
                                EMSessionManager.getInstance().clearLastLoginPwd();
                                break;
                            }
                            case 206: 
                            case 213: 
                            case 214: 
                            case 216: 
                            case 217: 
                            case 220: 
                            case 305: {
                                EMSessionManager.getInstance().clearLastLoginToken();
                                EMSessionManager.getInstance().clearLastLoginPwd();
                                if (!EMClient.this.isSdkInited()) break;
                                a.a().i("");
                                a.a().h("");
                            }
                        }
                        try {
                            for (EMConnectionListener eMConnectionListener : EMClient.this.connectionListeners) {
                                eMConnectionListener.onDisconnected(n);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (n == 206 || n == 207 || n == 213 || n == 220 || n == 305 || n == 214 || n == 216 || n == 217) {
                            try {
                                for (EMConnectionListener eMConnectionListener : EMClient.this.connectionListeners) {
                                    eMConnectionListener.onLogout(n);
                                }
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                }
            });
        }

        @Override
        public boolean verifyServerCert(List<String> list, String string) {
            if (list == null) {
                EMLog.d(EMClient.TAG, "List<String> certschain : null ");
                return false;
            }
            if (TextUtils.isEmpty((CharSequence)string)) {
                EMLog.d(EMClient.TAG, "domain is empty or null ");
                return false;
            }
            EMLog.d(EMClient.TAG, "domain = " + string);
            X509Certificate[] x509CertificateArray = EasyUtils.convertToCerts(list);
            try {
                X509TrustManager x509TrustManager = EasyUtils.getSystemDefaultTrustManager();
                X509TrustManagerExtensions x509TrustManagerExtensions = new X509TrustManagerExtensions(x509TrustManager);
                x509TrustManagerExtensions.checkServerTrusted(x509CertificateArray, x509CertificateArray[0].getType(), string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                EMLog.e(EMClient.TAG, exception.getMessage());
                EMLog.d(EMClient.TAG, "List<String> certschain :" + list.toString());
                return false;
            }
            return true;
        }

        @Override
        public void onTokenNotification(final int n) {
            EMClient.this.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List list = EMClient.this.connectionListeners;
                    synchronized (list) {
                        try {
                            if (n == 108 || n == 401) {
                                EMClient.this.logout();
                                for (EMConnectionListener eMConnectionListener : EMClient.this.connectionListeners) {
                                    EMLog.d(EMClient.TAG, "MyConnectionListener onTokenExpired code: " + n);
                                    eMConnectionListener.onTokenExpired();
                                }
                            } else {
                                for (EMConnectionListener eMConnectionListener : EMClient.this.connectionListeners) {
                                    EMLog.d(EMClient.TAG, "MyConnectionListener onTokenWillExpire code: " + n);
                                    eMConnectionListener.onTokenWillExpire();
                                }
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            EMLog.e(EMClient.TAG, "MyConnectionListener onTokenNotification Exception: " + exception.getMessage());
                        }
                    }
                }
            });
        }
    }
}

