/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import com.hyphenate.EMCallBack;
import com.hyphenate.EMChatThreadChangeListener;
import com.hyphenate.EMValueCallBack;
import com.hyphenate.chat.EMChatThread;
import com.hyphenate.chat.EMChatThreadEvent;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMCursorResult;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.adapter.EMAError;
import com.hyphenate.chat.adapter.EMAThreadInfo;
import com.hyphenate.chat.adapter.EMAThreadManager;
import com.hyphenate.chat.adapter.EMAThreadManagerListener;
import com.hyphenate.chat.adapter.message.EMAMessage;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.util.EMLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EMChatThreadManager {
    private static String TAG = EMChatThreadManager.class.getSimpleName();
    EMAThreadManager emaObject;
    EMClient mClient;
    List<EMChatThreadChangeListener> threadChangeListeners;
    private EMAThreadManagerListener listenerImpl = new EMAThreadManagerListener(){

        @Override
        public void onThreadNameUpdated(EMAThreadInfo eMAThreadInfo) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLeaveThread(EMAThreadInfo eMAThreadInfo, int n) {
            List<EMChatThreadChangeListener> list = EMChatThreadManager.this.threadChangeListeners;
            synchronized (list) {
                for (EMChatThreadChangeListener eMChatThreadChangeListener : EMChatThreadManager.this.threadChangeListeners) {
                    try {
                        if (n == EMAThreadInfo.LeaveReason.BE_KICKED.ordinal()) {
                            eMChatThreadChangeListener.onChatThreadUserRemoved(new EMChatThreadEvent(eMAThreadInfo));
                            continue;
                        }
                        eMChatThreadChangeListener.onChatThreadDestroyed(new EMChatThreadEvent(eMAThreadInfo));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }

        @Override
        public void onMemberJoined(EMAThreadInfo eMAThreadInfo) {
        }

        @Override
        public void onMemberExited(EMAThreadInfo eMAThreadInfo) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onThreadNotifyChange(EMAThreadInfo eMAThreadInfo) {
            List<EMChatThreadChangeListener> list = EMChatThreadManager.this.threadChangeListeners;
            synchronized (list) {
                for (EMChatThreadChangeListener eMChatThreadChangeListener : EMChatThreadManager.this.threadChangeListeners) {
                    try {
                        switch (eMAThreadInfo.getType()) {
                            case CREATE: {
                                eMChatThreadChangeListener.onChatThreadCreated(new EMChatThreadEvent(eMAThreadInfo));
                                break;
                            }
                            case UPDATE: 
                            case UPDATE_MSG: {
                                eMChatThreadChangeListener.onChatThreadUpdated(new EMChatThreadEvent(eMAThreadInfo));
                                break;
                            }
                            case DELETE: {
                                eMChatThreadChangeListener.onChatThreadDestroyed(new EMChatThreadEvent(eMAThreadInfo));
                            }
                        }
                    }
                    catch (Exception exception) {
                        EMLog.e(TAG, exception.getMessage());
                    }
                }
            }
        }
    };

    EMChatThreadManager(EMClient eMClient, EMAThreadManager eMAThreadManager) {
        this.emaObject = eMAThreadManager;
        this.mClient = eMClient;
        this.threadChangeListeners = Collections.synchronizedList(new ArrayList());
        this.emaObject.addListener(this.listenerImpl);
        EMClient.getInstance().chatManager();
    }

    public void addChatThreadChangeListener(EMChatThreadChangeListener eMChatThreadChangeListener) {
        if (eMChatThreadChangeListener != null && !this.threadChangeListeners.contains(eMChatThreadChangeListener)) {
            this.threadChangeListeners.add(eMChatThreadChangeListener);
        }
    }

    public void removeChatThreadChangeListener(EMChatThreadChangeListener eMChatThreadChangeListener) {
        if (eMChatThreadChangeListener != null && this.threadChangeListeners.contains(eMChatThreadChangeListener)) {
            this.threadChangeListeners.remove(eMChatThreadChangeListener);
        }
    }

    public void createChatThread(final String string, final String string2, final String string3, final EMValueCallBack<EMChatThread> eMValueCallBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMChatThread eMChatThread = EMChatThreadManager.this.createChatThread(string, string2, string3);
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onSuccess(eMChatThread);
                    }
                }
                catch (HyphenateException hyphenateException) {
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                    }
                    EMLog.e(TAG, "createChatThread error: " + hyphenateException.getErrorCode() + " " + hyphenateException.getDescription());
                }
            }
        });
    }

    private EMChatThread createChatThread(String string, String string2, String string3) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAThreadInfo eMAThreadInfo = this.emaObject.createThread(string, string2, string3, eMAError);
        this.handleError(eMAError);
        return new EMChatThread(eMAThreadInfo);
    }

    public void getChatThreadFromServer(final String string, final EMValueCallBack<EMChatThread> eMValueCallBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMChatThread eMChatThread = EMChatThreadManager.this.getChatThreadFromServer(string);
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onSuccess(eMChatThread);
                    }
                }
                catch (HyphenateException hyphenateException) {
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                    }
                    EMLog.e(TAG, "getChatThreadFromServer error: " + hyphenateException.getErrorCode() + " " + hyphenateException.getDescription());
                }
            }
        });
    }

    private EMChatThread getChatThreadFromServer(String string) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAThreadInfo eMAThreadInfo = this.emaObject.getThreadFromServer(string, eMAError);
        this.handleError(eMAError);
        return new EMChatThread(eMAThreadInfo);
    }

    public void joinChatThread(final String string, final EMValueCallBack<EMChatThread> eMValueCallBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMChatThread eMChatThread = EMChatThreadManager.this.joinChatThread(string);
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onSuccess(eMChatThread);
                    }
                }
                catch (HyphenateException hyphenateException) {
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                    }
                    EMLog.e(TAG, "joinChatThread error: " + hyphenateException.getErrorCode() + " " + hyphenateException.getDescription());
                }
            }
        });
    }

    private EMChatThread joinChatThread(String string) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAThreadInfo eMAThreadInfo = this.emaObject.joinThread(string, eMAError);
        this.handleError(eMAError);
        return new EMChatThread(eMAThreadInfo);
    }

    public void destroyChatThread(final String string, final EMCallBack eMCallBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMChatThreadManager.this.destroyChatThread(string);
                    if (eMCallBack != null) {
                        eMCallBack.onSuccess();
                    }
                }
                catch (HyphenateException hyphenateException) {
                    if (eMCallBack != null) {
                        eMCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                    }
                    EMLog.e(TAG, "destroyChatThread error: " + hyphenateException.getErrorCode() + " " + hyphenateException.getDescription());
                }
            }
        });
    }

    private void destroyChatThread(String string) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.destroyThread(string, eMAError);
        this.handleError(eMAError);
    }

    public void leaveChatThread(final String string, final EMCallBack eMCallBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMChatThreadManager.this.leaveChatThread(string);
                    if (eMCallBack != null) {
                        eMCallBack.onSuccess();
                    }
                }
                catch (HyphenateException hyphenateException) {
                    if (eMCallBack != null) {
                        eMCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                    }
                    EMLog.e(TAG, "leaveChatThread error: " + hyphenateException.getErrorCode() + " " + hyphenateException.getDescription());
                }
            }
        });
    }

    private void leaveChatThread(String string) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.leaveThread(string, eMAError);
        this.handleError(eMAError);
    }

    public void updateChatThreadName(final String string, final String string2, final EMCallBack eMCallBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMChatThreadManager.this.updateChatThreadName(string, string2);
                    if (eMCallBack != null) {
                        eMCallBack.onSuccess();
                    }
                }
                catch (HyphenateException hyphenateException) {
                    if (eMCallBack != null) {
                        eMCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                    }
                    EMLog.e(TAG, "changeChatThreadName error: " + hyphenateException.getErrorCode() + " " + hyphenateException.getDescription());
                }
            }
        });
    }

    private void updateChatThreadName(String string, String string2) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.updateChatThreadName(string, string2, eMAError);
        this.handleError(eMAError);
    }

    public void removeMemberFromChatThread(final String string, final String string2, final EMCallBack eMCallBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMChatThreadManager.this.removeMemberFromChatThread(string, string2);
                    if (eMCallBack != null) {
                        eMCallBack.onSuccess();
                    }
                }
                catch (HyphenateException hyphenateException) {
                    if (eMCallBack != null) {
                        eMCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                    }
                    EMLog.e(TAG, "removeMemberFromThread error: " + hyphenateException.getErrorCode() + " " + hyphenateException.getDescription());
                }
            }
        });
    }

    private void removeMemberFromChatThread(String string, String string2) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.removeMemberFromThread(string, string2, eMAError);
        this.handleError(eMAError);
    }

    public void getChatThreadMembers(final String string, final int n, final String string2, final EMValueCallBack<EMCursorResult<String>> eMValueCallBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMCursorResult eMCursorResult = EMChatThreadManager.this.getChatThreadMembers(string, n, string2);
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onSuccess(eMCursorResult);
                    }
                }
                catch (HyphenateException hyphenateException) {
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                    }
                    EMLog.e(TAG, "getThreadMembers error: " + hyphenateException.getErrorCode() + " " + hyphenateException.getDescription());
                }
            }
        });
    }

    private EMCursorResult<String> getChatThreadMembers(String string, int n, String string2) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMCursorResult<String> eMCursorResult = this.emaObject.fetchThreadMembers(string, n, string2, eMAError);
        this.handleError(eMAError);
        return eMCursorResult;
    }

    public void getJoinedChatThreadsFromServer(final int n, final String string, final EMValueCallBack<EMCursorResult<EMChatThread>> eMValueCallBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMCursorResult eMCursorResult = EMChatThreadManager.this.getJoinedChatThreadsFromServer(n, string);
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onSuccess(eMCursorResult);
                    }
                }
                catch (HyphenateException hyphenateException) {
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                    }
                    EMLog.e(TAG, "getJoinedThreadsFromServer error: " + hyphenateException.getErrorCode() + " " + hyphenateException.getDescription());
                }
            }
        });
    }

    private EMCursorResult<EMChatThread> getJoinedChatThreadsFromServer(int n, String string) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMCursorResult<EMAThreadInfo> eMCursorResult = this.emaObject.getJoinedThreadsFromServer(n, string, eMAError);
        this.handleError(eMAError);
        EMCursorResult<EMChatThread> eMCursorResult2 = new EMCursorResult<EMChatThread>();
        ArrayList<EMChatThread> arrayList = new ArrayList<EMChatThread>();
        List list = (List)eMCursorResult.getData();
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(new EMChatThread((EMAThreadInfo)list.get(i)));
        }
        eMCursorResult2.setData(arrayList);
        eMCursorResult2.setCursor(eMCursorResult.getCursor());
        return eMCursorResult2;
    }

    public void getJoinedChatThreadsFromServer(final String string, final int n, final String string2, final EMValueCallBack<EMCursorResult<EMChatThread>> eMValueCallBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMCursorResult eMCursorResult = EMChatThreadManager.this.getJoinedChatThreadsFromServer(string, n, string2);
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onSuccess(eMCursorResult);
                    }
                }
                catch (HyphenateException hyphenateException) {
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                    }
                    EMLog.e(TAG, "getJoinedThreadsFromServer error: " + hyphenateException.getErrorCode() + " " + hyphenateException.getDescription());
                }
            }
        });
    }

    private EMCursorResult<EMChatThread> getJoinedChatThreadsFromServer(String string, int n, String string2) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMCursorResult<EMAThreadInfo> eMCursorResult = this.emaObject.getJoinedThreadsFromServer(string, n, string2, eMAError);
        this.handleError(eMAError);
        EMCursorResult<EMChatThread> eMCursorResult2 = new EMCursorResult<EMChatThread>();
        ArrayList<EMChatThread> arrayList = new ArrayList<EMChatThread>();
        List list = (List)eMCursorResult.getData();
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(new EMChatThread((EMAThreadInfo)list.get(i)));
        }
        eMCursorResult2.setData(arrayList);
        eMCursorResult2.setCursor(eMCursorResult.getCursor());
        return eMCursorResult2;
    }

    public void getChatThreadsFromServer(final String string, final int n, final String string2, final EMValueCallBack<EMCursorResult<EMChatThread>> eMValueCallBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMCursorResult eMCursorResult = EMChatThreadManager.this.getChatThreadsFromServer(string, n, string2);
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onSuccess(eMCursorResult);
                    }
                }
                catch (HyphenateException hyphenateException) {
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                    }
                    EMLog.e(TAG, "getThreadsFromServer error: " + hyphenateException.getErrorCode() + " " + hyphenateException.getDescription());
                }
            }
        });
    }

    private EMCursorResult<EMChatThread> getChatThreadsFromServer(String string, int n, String string2) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMCursorResult<EMAThreadInfo> eMCursorResult = this.emaObject.getThreadsFromServer(string, n, string2, eMAError);
        this.handleError(eMAError);
        EMCursorResult<EMChatThread> eMCursorResult2 = new EMCursorResult<EMChatThread>();
        ArrayList<EMChatThread> arrayList = new ArrayList<EMChatThread>();
        List list = (List)eMCursorResult.getData();
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(new EMChatThread((EMAThreadInfo)list.get(i)));
        }
        eMCursorResult2.setData(arrayList);
        eMCursorResult2.setCursor(eMCursorResult.getCursor());
        return eMCursorResult2;
    }

    public void getChatThreadLatestMessage(List<String> list, EMValueCallBack<Map<String, EMMessage>> eMValueCallBack) {
        this.mClient.execute(() -> {
            block3: {
                Map<String, EMMessage> map = null;
                try {
                    map = this.getChatThreadLatestMessage(list);
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onSuccess(map);
                    }
                }
                catch (HyphenateException hyphenateException) {
                    if (eMValueCallBack == null) break block3;
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    private Map<String, EMMessage> getChatThreadLatestMessage(List<String> list) throws HyphenateException {
        EMAError eMAError = new EMAError();
        Map<String, EMAMessage> map = this.emaObject.getThreadsLatestMessage(list, eMAError);
        this.handleError(eMAError);
        HashMap<String, EMMessage> hashMap = new HashMap<String, EMMessage>();
        for (Map.Entry<String, EMAMessage> entry : map.entrySet()) {
            String string = entry.getKey();
            EMMessage eMMessage = new EMMessage(entry.getValue());
            hashMap.put(string, eMMessage);
        }
        return hashMap;
    }

    private void handleError(EMAError eMAError) throws HyphenateException {
        if (eMAError.errCode() != 0) {
            throw new HyphenateException(eMAError);
        }
    }
}

