package com.hyphenate.chat;

import com.hyphenate.EMCallBack;
import com.hyphenate.EMValueCallBack;
import com.hyphenate.chat.adapter.EMASilentModeItem;
import com.hyphenate.chat.adapter.EMASilentModeTime;

/**
 * \~chinese
 * 离线推送免打扰结果类。
 *
 * \~english
 * Offline push DND result class.
 */
public class EMSilentModeResult extends EMBase<EMASilentModeItem> {

    public EMSilentModeResult(EMASilentModeItem item){
        emaObject = item;
    }

    /**
     * \~chinese
     * 获取离线推送免打扰过期时间戳。
     * @return 免打扰过期时间戳。
     *
     * \~english
     * Obtain the offline push DND expiration timestamp.
     * @return Do not Disturb expiration timestamp.
     */
    public long getExpireTimestamp(){
        return emaObject.getExpireTimestamp();
    }

    /**
     * \~chinese
     * 获取会话类型。
     * @return 会话类型。
     *
     * \~english
     * Get the Conversation Type.
     * @return The Conversation Type.
     */
    public EMConversation.EMConversationType getConversationType(){
        return EMConversation.EMConversationType.values()[emaObject.getConversationType()];
    }

    /**
     * \~chinese
     * 获取会话id。
     * @return 会话id。
     *
     * \~english
     * Get the Conversation ID.
     * @return The Conversation ID.
     */
    public String getConversationId(){
        return emaObject.getConversationId();
    }

    /**
     * \~chinese
     * 会话是否启用离线推送提醒类型。
     * 调用 {@link EMPushManager#setSilentModeForConversation(String, EMConversation.EMConversationType, EMSilentModeParam, EMValueCallBack)} 设置推送提醒类型后，返回true。
     * 调用 {@link EMPushManager#clearRemindTypeForConversation(String, EMConversation.EMConversationType, EMCallBack)} 清空设置的推送提醒类型后，返回false。
     * @return boolean
     *
     * \~english
     * Whether to enable offline push notification for the conversation.
     * After calling {@link EMPushManager#setSilentModeForConversation(String, EMConversation.EMConversationType, EMSilentModeParam, EMValueCallBack)} set remind type, return true.
     * After calling {@link EMPushManager#clearRemindTypeForConversation(String, EMConversation.EMConversationType, EMCallBack)} clear remind type, return false.
     * @return boolean
     */
    public boolean isConversationRemindTypeEnabled(){
        return emaObject.getRemindType() != 0;
    }

    /**
     * \~chinese
     * 获取离线推送提醒类型。
     * @return 离线推送提醒类型。
     *
     * \~english
     * Get the offline push notification type.
     * @return The offline push notification type.
     */
    public EMPushManager.EMPushRemindType getRemindType(){
        if(emaObject.getRemindType() != 0){
            return EMPushManager.EMPushRemindType.values()[emaObject.getRemindType() - 1];
        } else {
            return EMPushManager.EMPushRemindType.ALL;
        }
    }

    /**
     * \~chinese
     * 获取离线推送免打扰时间段的开始时间。
     * @return 开始时间。
     *
     * \~english
     * Get the start time of offline push DND.
     * @return The start time.
     */
    public EMSilentModeTime getSilentModeStartTime(){
        EMASilentModeTime time = emaObject.getSilentModeStartTime();
        return new EMSilentModeTime(time);
    }

    /**
     * \~chinese
     * 获取离线推送免打扰时间段的结束时间。
     * @return 结束时间。
     *
     * \~english
     * Get the end time of offline push DND.
     * @return The end time.
     */
    public EMSilentModeTime getSilentModeEndTime(){
        EMASilentModeTime time = emaObject.getSilentModeEndTime();
        return new EMSilentModeTime(time);
    }
}
