/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate;

/**
 * \~chinese
 * 即时通讯状态连接监听器。
 * 如果遇到弱网掉线情况，应用收到 onDisconnected，此时不需要处理重连操作，SDK 在底层自动处理重连。
 * 回调函数只有 onConnected 和 onDisconnected 无需考虑连接中，断开中一类的中间状态。
 * 
 * 注意：应用不要在这两个回调函数中更新界面，这两个现成属于工作线程，直接更新界面会导致界面的并发错误。也不要在这两个回调函数中
 * 做大量的耗时操作，这可能会影响其他监听器处理连接事件。
 *
 * 示例代码如下：
 *     注册：
 *     ```java
 *     EMClient.getInstance().addConnectionListener(mConnectionListener);
 *     ```
 * 
 *     解注册：
 *     ```java
 *     EMClient.getInstance().removeConnectionListener(mConnectionListener);
 *     ```
 * 
 * \~english
 * The chat connection listener.
 * 
 * For the occasion of onDisconnected during unstable network condition, you don't need to reconnect manually,
 * the chat SDK will handle it automatically.
 * 
 * There are only two states: onConnected, onDisconnected.
 * 
 * Note: We recommend not to update UI based on those methods, because this method is called on worker thread. If you update UI in those methods, other UI errors might be invoked.
 * Also do not insert heavy computation work here, which might invoke other listeners to handle this connection event.
 *
 *     Register:
 *     ```java
 *     EMClient.getInstance().addConnectionListener(mConnectionListener);
 *     ```
 * 
 *     Unregister:
 *     ```java
 *     EMClient.getInstance().removeConnectionListener(mConnectionListener);
 *     ```
 *
 */
public interface EMConnectionListener {
    /**
     * \~chinese
     * 成功连接到 chat 服务器时触发。
     *
     * \~english
     * Occurs when the SDK connects to the chat server successfully.
     */
    void onConnected();

    /**
     * \~chinese
     * 和 chat 服务器断开连接时触发，注意断开连接时底层不一定会 logout。
     * 
     * 常见错误码有：
     * {@link EMError#USER_REMOVED}，{@link EMError#USER_LOGIN_ANOTHER_DEVICE}，
     * {@link EMError#SERVER_SERVICE_RESTRICTED}，{@link EMError#USER_KICKED_BY_CHANGE_PASSWORD}及
     * {@link EMError#USER_KICKED_BY_OTHER_DEVICE}
     *
     * \~english
     * Occurs when the SDK disconnect from the chat server.
     * 
     * Note that the logout may not be performed at the bottom level when the SDK is disconnected.
     * 
     * Common errors are as follows: 
     * {@link EMError#USER_REMOVED},{@link EMError#USER_LOGIN_ANOTHER_DEVICE},
     * {@link EMError#SERVER_SERVICE_RESTRICTED},{@link EMError#USER_KICKED_BY_CHANGE_PASSWORD} and
     * {@link EMError#USER_KICKED_BY_OTHER_DEVICE}
     */
    void onDisconnected(final int errorCode);

    /**
     * \~chinese
     * token 已过期时触发。
     *
     * \~english
     * Occurs when the token has expired.
     * 
     * Common errors are as follows: 
     * {@link EMError#TOKEN_EXPIRED},{@link EMError#TOKEN_WILL_EXPIRE},
     */

    default void onTokenExpired(){}

    /**
     * \~chinese
     * token 即将过期时触发。
     *
     * \~english
     * Occurs when the token is about to expire.
     */
    default void onTokenWillExpire(){}

    /**
     *\~chinese
     * SDK 退出登陆时触发。
     * 
     * 常见错误码有：
     * {@link EMError#USER_LOGIN_ANOTHER_DEVICE}，{@link EMError#USER_REMOVED}，
     * {@link EMError#USER_BIND_ANOTHER_DEVICE}，{@link EMError#SERVER_SERVICE_RESTRICTED}，
     * {@link EMError#USER_LOGIN_TOO_MANY_DEVICES}，{@link EMError#USER_KICKED_BY_CHANGE_PASSWORD}，
     * {@link EMError#USER_KICKED_BY_OTHER_DEVICE}
     *
     * \~english
     * Occurs when the UNDERLYING SDK logs out.
     * 
     * Common errors are as follows:
     * {@link EMError#USER_LOGIN_ANOTHER_DEVICE}，{@link EMError#USER_REMOVED}，
     * {@link EMError#USER_BIND_ANOTHER_DEVICE}，{@link EMError#SERVER_SERVICE_RESTRICTED}，
     * {@link EMError#USER_LOGIN_TOO_MANY_DEVICES}，{@link EMError#USER_KICKED_BY_CHANGE_PASSWORD}，
     * {@link EMError#USER_KICKED_BY_OTHER_DEVICE}
     * @param errorCode
     */
    default void onLogout(final int errorCode){}
}
