/*
 * Decompiled with CFR 0.152.
 */
package internal.com.getkeepsafe.relinker;

import android.content.Context;
import android.util.Log;
import internal.com.getkeepsafe.relinker.ApkLibraryInstaller;
import internal.com.getkeepsafe.relinker.MissingLibraryException;
import internal.com.getkeepsafe.relinker.ReLinker;
import internal.com.getkeepsafe.relinker.SystemLibraryLoader;
import internal.com.getkeepsafe.relinker.TextUtils;
import internal.com.getkeepsafe.relinker.elf.ElfParser;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class ReLinkerInstance {
    private static final String LIB_DIR = "lib";
    protected final Set<String> loadedLibraries = new HashSet<String>();
    protected final ReLinker.LibraryLoader libraryLoader;
    protected final ReLinker.LibraryInstaller libraryInstaller;
    protected boolean force;
    protected boolean recursive;
    protected ReLinker.Logger logger;

    protected ReLinkerInstance() {
        this(new SystemLibraryLoader(), new ApkLibraryInstaller());
    }

    protected ReLinkerInstance(ReLinker.LibraryLoader libraryLoader, ReLinker.LibraryInstaller libraryInstaller) {
        if (libraryLoader == null) {
            throw new IllegalArgumentException("Cannot pass null library loader");
        }
        if (libraryInstaller == null) {
            throw new IllegalArgumentException("Cannot pass null library installer");
        }
        this.libraryLoader = libraryLoader;
        this.libraryInstaller = libraryInstaller;
    }

    public ReLinkerInstance log(ReLinker.Logger logger) {
        this.logger = logger;
        return this;
    }

    public ReLinkerInstance force() {
        this.force = true;
        return this;
    }

    public ReLinkerInstance recursively() {
        this.recursive = true;
        return this;
    }

    public void loadLibrary(Context context, String string) {
        this.loadLibrary(context, string, null, null);
    }

    public void loadLibrary(Context context, String string, String string2) {
        this.loadLibrary(context, string, string2, null);
    }

    public void loadLibrary(Context context, String string, ReLinker.LoadListener loadListener) {
        this.loadLibrary(context, string, null, loadListener);
    }

    public void loadLibrary(final Context context, final String string, final String string2, final ReLinker.LoadListener loadListener) {
        if (context == null) {
            throw new IllegalArgumentException("Given context is null");
        }
        if (TextUtils.isEmpty(string)) {
            throw new IllegalArgumentException("Given library is either null or empty");
        }
        this.log("Beginning load of %s...", string);
        if (loadListener == null) {
            this.loadLibraryInternal(context, string, string2);
        } else {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ReLinkerInstance.this.loadLibraryInternal(context, string, string2);
                        loadListener.success();
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        loadListener.failure(unsatisfiedLinkError);
                    }
                    catch (MissingLibraryException missingLibraryException) {
                        loadListener.failure(missingLibraryException);
                    }
                }
            }).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLibraryInternal(Context context, String string, String string2) {
        if (this.loadedLibraries.contains(string) && !this.force) {
            this.log("%s already loaded previously!", string);
            return;
        }
        try {
            this.libraryLoader.loadLibrary(string);
            this.loadedLibraries.add(string);
            this.log("%s (%s) was loaded normally!", string, string2);
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            File file;
            block11: {
                this.log("Loading the library normally failed: %s", Log.getStackTraceString((Throwable)unsatisfiedLinkError));
                this.log("%s (%s) was not loaded normally, re-linking...", string, string2);
                file = this.getWorkaroundLibFile(context, string, string2);
                if (!file.exists() || this.force) {
                    if (this.force) {
                        this.log("Forcing a re-link of %s (%s)...", string, string2);
                    }
                    this.cleanupOldLibFiles(context, string, string2);
                    this.libraryInstaller.installLibrary(context, this.libraryLoader.supportedAbis(), this.libraryLoader.mapLibraryName(string), file, this);
                }
                try {
                    List<String> list;
                    if (!this.recursive) break block11;
                    ElfParser elfParser = null;
                    try {
                        elfParser = new ElfParser(file);
                        list = elfParser.parseNeededDependencies();
                    }
                    finally {
                        elfParser.close();
                    }
                    for (String string3 : list) {
                        this.loadLibrary(context, this.libraryLoader.unmapLibraryName(string3));
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.libraryLoader.loadPath(file.getAbsolutePath());
            this.loadedLibraries.add(string);
            this.log("%s (%s) was re-linked!", string, string2);
            return;
        }
    }

    protected File getWorkaroundLibDir(Context context) {
        return context.getDir(LIB_DIR, 0);
    }

    protected File getWorkaroundLibFile(Context context, String string, String string2) {
        String string3 = this.libraryLoader.mapLibraryName(string);
        if (TextUtils.isEmpty(string2)) {
            return new File(this.getWorkaroundLibDir(context), string3);
        }
        return new File(this.getWorkaroundLibDir(context), string3 + "." + string2);
    }

    protected void cleanupOldLibFiles(Context context, String string, String string2) {
        File file = this.getWorkaroundLibDir(context);
        File file2 = this.getWorkaroundLibFile(context, string, string2);
        final String string3 = this.libraryLoader.mapLibraryName(string);
        File[] fileArray = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.startsWith(string3);
            }
        });
        if (fileArray == null) {
            return;
        }
        for (File file3 : fileArray) {
            if (!this.force && file3.getAbsolutePath().equals(file2.getAbsolutePath())) continue;
            file3.delete();
        }
    }

    public void log(String string, Object ... objectArray) {
        this.log(String.format(Locale.US, string, objectArray));
    }

    public void log(String string) {
        if (this.logger != null) {
            this.logger.log(string);
        }
    }
}

